<?php
/******************************************************************************
 * 
 * common_function.php
 *   
 * Gemeinsame Funktionen fuer das Admidio-Plugin formfiller
 * 
 *  
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);
 
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_category.php');

// Funktion prueft, ob ein User die uebergebene Rolle besitzt
// $role_id   - ID der zu pruefenden Rolle
// $user_id   - ID des Users, fuer den die Mitgliedschaft geprueft werden soll
function hasRole_IDPFF($role_id, $user_id = 0)
{
    global $gCurrentUser, $gDb, $gCurrentOrganization;

    if($user_id == 0)
    {
        $user_id = $gCurrentUser->getValue('usr_id');
    }
    elseif(is_numeric($user_id) == false)
    {
        return -1;
    }

    $sql    = 'SELECT mem_id
                FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                WHERE mem_usr_id = '.$user_id.'
                AND mem_begin <= \''.DATE_NOW.'\'
                AND mem_end    > \''.DATE_NOW.'\'
                AND mem_rol_id = rol_id
                AND rol_id   = \''.$role_id.'\'
                AND rol_valid  = 1 
                AND rol_cat_id = cat_id
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
    $result = $gDb->query($sql);

    $user_found = $gDb->num_rows($result);

    if($user_found == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Funktion liest die Role-ID einer Rolle aus
// $role_name: Name der zu pruefenden Rolle
function getRole_IDPFF($role_name)
{
    global $gDb, $gCurrentOrganization;
	
    $sql    = 'SELECT rol_id
                 FROM '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                 WHERE rol_name   = \''.$role_name.'\'
                 AND rol_valid  = 1 
                 AND rol_cat_id = cat_id
                 AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR cat_org_id IS NULL ) ';
                      
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    return $row->rol_id ;
}

// Funktion prueft, ob der Nutzer, aufgrund seiner Rollenzugehoerigkeiten berechtigt ist, das Plugin aufzurufen
// Parameter: Array mit Rollen-IDs
// entweder $config_ini['Pluginfreigabe']['freigabe'] oder $config_ini['Pluginfreigabe']['freigabe_config']
function check_showpluginPFF($array)
{
    $showPlugin = false;

    foreach ($array AS $i)
    {
        if(hasRole_IDPFF($i))
        {
            $showPlugin = true;
        } 
    } 
    return $showPlugin;
}

// Funktion überprüft den übergebenen Namen, ob er gemaess den Namenskonventionen für
// Profilfelder und Kategorien zum Uebersetzen durch eine Sprachdatei geeignet ist
// Bsp: SYS_COMMON --> Rueckgabe true
// Bsp: Mitgliedsbeitrag --> Rueckgabe false
function check_languagePFF($field_name)
{
    $ret = false;
 
    //prüfen, ob die ersten 3 Zeichen von $field_name Grußbuchstaben sind
    //prüfen, ob das vierte Zeichen von $field_name ein _ ist
    //prüfen, ob die restlichen Zeichen von $field_name Grußbuchstaben sind
    if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')  && (ctype_upper(substr($field_name,4)))   )
    {
    	$ret = true;
    }
    return $ret;
}

//Diese Funktion überprüft die Länge von $tmpString für die Anzeige in Select-Boxen
//Autor: guenter47
//$tmpString = zu überprüfender String
//$maxStrLength = maximale Länge, die noch in die Selectbox passt
//Beispiel: Das ist ein sehr langer Text
//Rückgabe: Das ist ein se ... Text
function checkStringLengthPFF($tmpString, $maxStrLength)
{
	// Mindestlaenge vorgeben, ansonsten gibt es Ueberlappungen im neuen String 
	if ($maxStrLength<20)
	{
		$maxStrLength=20;
	}
    if(strlen($tmpString)>$maxStrLength)
    {
        $strPart1=substr($tmpString,0,$maxStrLength-20);
        $strPart2=substr($tmpString,strlen($tmpString)-15);
        $newString=$strPart1."...".$strPart2;
    }
    else
    {
        $newString=$tmpString;
    }
    return $newString;
}

// prüft, ob die Konfigurationstabelle existiert und legt sie ggf. an
function initConfigTablePFF()
{
	global $gL10n, $gDb, $gCurrentOrganization, $g_tbl_praefix, $gProfileFields;
	
	$config_ini =array();
	$table_name = $g_tbl_praefix.'_plugin_preferences';
	
	// pruefen, ob es die Tabelle bereits gibt
	$sql = 'SHOW TABLES LIKE \''.$table_name.'\' ';
    $result = $gDb->query($sql);
    
    // Tabelle anlegen, wenn es sie noch nicht gibt
    if (!$gDb->num_rows($result))
    {
    	// Tabelle ist nicht vorhanden --> anlegen
        $sql = 'CREATE TABLE '.$table_name.' (
            plp_id 		integer     unsigned not null AUTO_INCREMENT,
            plp_org_id 	integer   	unsigned not null,
    		plp_name 	varchar(255) not null,
            plp_value  	text, 
            primary key (plp_id) )
            engine = InnoDB
         	auto_increment = 1
          	default character set = utf8
         	collate = utf8_unicode_ci';
    	$gDb->query($sql);
    } 
		
	// Konfiguration einlesen
	$config_ini = readConfigTablePFF();
		
    // überprüfen, ob bereits Konfigurationsdaten gesetzt sind, wenn nicht: vorbelegen
    if (!isset($config_ini['Pluginfreigabe']['freigabe']))
    {
    	$config_ini['Pluginfreigabe']['freigabe'] = array(getRole_IDPFF($gL10n->get('SYS_WEBMASTER')),getRole_IDPFF($gL10n->get('SYS_MEMBER')));
    }
    if (!isset($config_ini['Pluginfreigabe']['freigabe_config']))
    {
		$config_ini['Pluginfreigabe']['freigabe_config'] = array(getRole_IDPFF($gL10n->get('SYS_WEBMASTER')),getRole_IDPFF($gL10n->get('SYS_MEMBER')));
    } 
    if (!isset($config_ini['Optionen']['formularanzahl']))
    { 
    	$config_ini['Optionen']['formularanzahl'] = 1;
    }   
    if (!isset($config_ini['Optionen']['select_maxlength']))
    {
    	$config_ini['Optionen']['select_maxlength'] = 30;
    }   
    if (!isset($config_ini['Optionen']['dbtoken']))
    {
    	$config_ini['Optionen']['dbtoken'] = '#_#';
    }	
    if (!isset($config_ini['Optionen']['maxpdfview']))
    { 
    	$config_ini['Optionen']['maxpdfview'] = 10;
    }     
    if (!isset($config_ini['Formular']))
    {
 		$config_ini['Formular'] = array('form_desc' 	=> array($gL10n->get('PFF_PATTERN')),
 										'form_font' 	=> array('Courier'), 
 										'form_style'	=> array('B'),
 										'form_size'		=> array(10),
 		 								'form_color'	=> array('0,0,0'),
 										'labels'		=> array(''),
 										'profile_photo'	=> array(''),
 										'date'			=> array(''),
 										'form_pdfid'	=> array('0'),
 										'form_pdfname'	=> array('')  ); 
    	
 		foreach($gProfileFields->mProfileFields as $field )
    	{ 
			$config_ini['Formular']['form_usfid-'.$field->getValue('usf_id')] = array(''); 												
    	}
    }    		    

    // $config_ini in die DB schreiben
  	writeConfigTablePFF($config_ini);
     
    return;
}

// Funktion schreibt die $config_ini in die Datenbank
function writeConfigTablePFF($config_ini)
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
    $preferences = array();
 	$table_name = $g_tbl_praefix.'_plugin_preferences';

     foreach($config_ini as $section => $sectiondata)
     {
        foreach($sectiondata as $key => $value)
        {
            if (is_array($value))
            {
                // um diesen Datensatz in der Datenbank als Array zu kennzeichnen, wird er von Doppelklammern eingeschlossen 
            	$value = '(('.implode($config_ini['Optionen']['dbtoken'],$value).'))';
            } 
            
  			$plp_name = 'PFF__'.$section.'__'.$key;

            $sql = ' SELECT plp_id 
            		FROM '.$table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
            $result = $gDb->query($sql);
            $row = $gDb->fetch_object($result);

            // Gibt es den Datensatz bereits?
            // wenn ja: UPDATE des bestehende Datensatzes  
            if(strlen($row->plp_id) > 0)
            {
                $sql = 'UPDATE '.$table_name.' 
                		SET plp_value = \''.$value.'\' 
                		WHERE plp_id = '.$row->plp_id;   
                    
                $gDb->query($sql);           
            }
            // wenn nicht: INSERT eines neuen Datensatzes 
            else
            {
  				$sql = 'INSERT INTO '.$table_name.' (plp_org_id, plp_name, plp_value) 
  						VALUES (\''.$gCurrentOrganization->getValue('org_id').'\' ,\'PFF__'.$section.'__'.$key.'\' ,\''.$value.'\')'; 
            	$gDb->query($sql); 
            }
        } 
    }
    
    //diese Routine ist erforderlich, da es vorkommen kann, dass Profilfelder gelöscht werden
    //in diesem Fall besteht nämlich ein Eintrag im Format PFF__Formular__form_usfid-..
    //     in der ..._plugin_preferences weiterhin
    //deshalb diese verwaisten Einträge suchen und löschen
    
    //zuerst alle betreffenden Einträge einlesen
	$sql = ' SELECT plp_id, plp_name, plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PFF__Formular__form_usfid-%\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
	$result = $gDb->query($sql);
  			$result = $gDb->query($sql);

	while ($row = $gDb->fetch_array($result))
	{
		$preferences[$row['plp_id']] = substr($row['plp_name'],(strrpos($row['plp_name'],'-'))+1);
	}
    
	//jetzt suchen, ob es in der Tabelle adm_user_fields einen Eintrag gibt
	// wenn nicht, den verwaisten Eintrag in plugin_preferences löschen
	foreach($preferences as $key => $data)
	{
		$sql = ' SELECT usf_id 
            		FROM '.TBL_USER_FIELDS.' , '. TBL_CATEGORIES. '
            		WHERE usf_id = \''.$data.'\' 
            		AND usf_cat_id = cat_id
            		AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
            			OR cat_org_id IS NULL ) ';
        $result = $gDb->query($sql);
        $row = $gDb->fetch_object($result);
     
        // Gibt es einen dazugehörigen Datensatz?
        // wenn nicht: den Eintrag in plugin_preferences löschen
        if( !isset($row->usf_id) && !(strlen($row->usf_id) > 0) )
        {
        	//löschen
            $sql = 'DELETE FROM '.$table_name.'
         			WHERE plp_id = '.$key;
    		$gDb->query($sql);
        }     
	}    
    return ;
}

// Funktion liest die Konfigurationsdaten aus der Datenbank
function readConfigTablePFF()
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
    $config_ini =array();
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
 	
 	// im ersten Schritt das Token einlesen
 	$sql = ' SELECT plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PFF__Optionen__dbtoken\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
 	$result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);
    $dbtoken =  $row->plp_value ;
     
	$sql = ' SELECT plp_id, plp_name, plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PFF__%\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
	$result = $gDb->query($sql);
	
	while($row = $gDb->fetch_array($result))
	{
		$array = explode('__',$row['plp_name']);
		
		// wenn plp_value von ((  )) eingeschlossen ist, dann ist es als Array einzulesen
		if ((substr($row['plp_value'],0,2)=='((' ) && (substr($row['plp_value'],-2)=='))' ))
        {
        	$row['plp_value'] = substr($row['plp_value'],2,-2);
        	$config_ini[$array[1]] [$array[2]] = explode($dbtoken,$row['plp_value']); 
        }
        else 
		{
            $config_ini[$array[1]] [$array[2]] = $row['plp_value'];
        }
	}
    return $config_ini;
}

// Funktion überprüft, ob jeder einzelne Wert von $needle in $heystack enthalten ist
function strstr_multiple($haystack, $needle )
{
	for ($i=0;$i<strlen($needle);$i++)
	{
		if (!(strstr($haystack,substr($needle,$i,1))))
		{
			return false;
		}
	}
	return true;		
}


?>