<?php
/******************************************************************************
 * FormFiller
 *
 * Version 1.0.3
 *
 * Dieses Plugin für Admidio ermöglicht das Ausfüllen von PDF-Formularen sowie das Erstellen von Etiketten.
 *
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * Author		: rmb 
 * 
 * Libraries 	: FormFiller verwendet die externen PHP-Klassen FPDF, FPDI und FPDF_TPL
 * 
 * Version		: 1.0.0
 * Datum        : 14.04.2014
 * 
 * Version 		: 1.0.1 
 * Datum        : 30.04.2014
 * Änderung     : Aufruf des Plugins über die Klasse Menu realisiert
 * 				  (Systemanforderung jetzt Admidio Version 2.4.4 oder höher)
 * 
 * Version 		: 1.0.2
 * Datum        : 07.05.2014
 * Änderung     : Erzeugung von Mehrfachdokumenten über neues Modul Listenwahl realisiert
 * 
 * Version      : 1.0.3
 * Datum        : 04.12.2014
 * Änderung     : Druckmöglichkeit von Profilfoto und aktuellem Datum
 *                  
 *****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);
 
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(dirname(__FILE__).'/common_function.php');

// DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
$gDb->setCurrentDB();

// Einbinden der Sprachdatei
$gL10n->addLanguagePath($plugin_path.'/'.$plugin_folder.'/languages');

// prüfen, ob die Konfigurationstabelle existiert und ggf. anlegen
initConfigTablePFF();

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

//$url und $user_id einlesen, falls von der Proilanzeige aufgerufen wurde
$url = $_SERVER['REQUEST_URI'];
$user_id = (isset($_REQUEST['user_id']) ? $_REQUEST['user_id'] : '');

//Zeige das Menue
if(check_showpluginPFF($config_ini['Pluginfreigabe']['freigabe']) || check_showpluginPFF($config_ini['Pluginfreigabe']['freigabe_config']))
{
	$formfillerMenu = new Menu('formfiller', $gL10n->get('PFF_FORMFILLER'));

	if(strstr($url, 'adm_program/modules/profile/profile.php?user_id=')!=null )
	{
		foreach($config_ini['Formular']['form_desc'] as $key => $data)
		{		
			$formfillerMenu->addItem($data, '/adm_plugins/'.$plugin_folder.'/createpdf.php?user_id='.$user_id.'&form_id='.$key,
				$data, '/icons/page_white_acrobat.png');
		}
	}
	
	$formfillerMenu->addItem('listselection', '/adm_plugins/'.$plugin_folder.'/listselection.php',
			$gL10n->get('PFF_LISTSELECTION'), '/icons/lists.png');
	
	if(check_showpluginPFF($config_ini['Pluginfreigabe']['freigabe_config']))
	{
		$formfillerMenu->addItem('settings', '/adm_plugins/'.$plugin_folder.'/settings.php',
			$gL10n->get('PFF_SETTINGS'), '/icons/options.png');
	}
	$formfillerMenu->show();
}

?>