<?php
/******************************************************************************
 * get_pdf.php
 *
 * Download Script
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Parameters:
 *
 * file_id :  Die Id der Datei, welche heruntergeladen werden soll
 * form_id :  interne Nummer des verwendeten PDF-Formulars
 *
 * Hinweis :  get_pdf.php ist eine modifizierte get_file.php
 * 
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_file.php');

require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

// Initialize and check the parameters
$getFileId = admFuncVariableIsValid($_GET, 'file_id', 'numeric', null, true);
$getFormID = admFuncVariableIsValid($_GET, 'form_id', 'numeric', 0);

//pruefen ob das Modul ueberhaupt aktiviert ist
if ($gPreferences['enable_download_module'] != 1)
{
    // das Modul ist deaktiviert
    $gMessage->show($gL10n->get('SYS_MODULE_DISABLED'));
}

//nur von eigentlicher OrgaHompage erreichbar
if($gCurrentOrganization->getValue('org_shortname')!= $g_organization)
{
    // das Modul ist deaktiviert
    $gMessage->show($gL10n->get('SYS_MODULE_ACCESS_FROM_HOMEPAGE_ONLY', $gHomepage));
}

try
{
    // get recordset of current file from databse
    $file = new TableFile($gDb);
    $file->getFileForDownload($getFileId);
}
catch(AdmException $e)
{
	$e->showHtml();
}

//kompletten Pfad der Datei holen
$completePath = $file->getCompletePathOfFile();


//pruefen ob File ueberhaupt physikalisch existiert
if (!file_exists($completePath))
{
    $gMessage->show($gL10n->get('SYS_FILE_NOT_EXIST'));
}

//Dateigroese ermitteln
$fileSize   = filesize($completePath);
$filename   = $file->getValue('fil_name');

// for IE the filename must have special chars in hexadecimal 
if (preg_match('/MSIE/', $_SERVER['HTTP_USER_AGENT']))
{
    $filename = urlencode($filename);
}

$config_ini['Formular']['form_pdfid'][$getFormID]=$getFileId;
$config_ini['Formular']['form_pdfname'][$getFormID]=$filename;

writeConfigTablePFF($config_ini);
  	
while($gNavigation->count() > 1)
{
	$gNavigation->deleteLastUrl();
} 	

// zur Ausgangsseite zurueck
$gMessage->setForwardUrl($gNavigation->getUrl(), 2000);
$gMessage->show($gL10n->get('PFF_PDF_FILE_IS_CHANGED'));
     
    
?>