<?php
/******************************************************************************
 * 
 * listselection.php
 *    
 * Erzeugt eine Auswahl aus Listenkonfiguration, Rollen und Formularkonfiguration
 * 	um Mehrfachdokumente zu erzeugen
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *  
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/module_lists.php');
require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

// Navigation faengt hier im Modul an
$gNavigation->clear();
$gNavigation->addUrl('http://'.$_SERVER["SERVER_NAME"].'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

//New Modulelist object
$lists = new ModuleLists();

//Get list configurations
$listConfigurations = $lists->getListConfigurations();

// Html-Kopf ausgeben
$gLayout['title']  = $gL10n->get('PFF_FORMFILLER').' - '.$gL10n->get('PFF_LISTSELECTION');
    
require(SERVER_PATH. '/adm_program/system/overall_header.php');

// Html des Modules ausgeben
echo '

<div class="formLayout" id="listselection_form">
    <div class="formHead">'.$gLayout['title'].'</div>
	<form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/createpdf.php" method="post" enctype="multipart/form-data">    
    <div class="formBody">
    	<ul class="formFieldList">
    		<p>
       		<li><b>1.</b> '.$gL10n->get('PFF_CHOOSE_LISTSELECTION').':</li>
			<li>
				<dl>
					<dt>
						<b>'.$gL10n->get('LST_CONFIGURATION_LIST').':</b>
					</dt>
					<dd>
                		<select class="lst_id" id="lst_id" name="lst_id">
                    		<option value="" selected="selected">- '.$gL10n->get('SYS_PLEASE_CHOOSE').' -</option>';
                    
                    		// alle globalen Listenkonfigurationen auflisten
                    		$list_global_flag = '';
                    
                    		foreach($listConfigurations as $rowConfigurations)
                    		{
                        		if($list_global_flag != $rowConfigurations['lst_global'])
                        		{
                            		if($rowConfigurations['lst_global'] == 0)
                            		{
                                		echo '<optgroup label="'.$gL10n->get('LST_YOUR_LISTS').'">';
                            		}
                            		else
                            		{
                                		if($list_global_flag > 0)
                                		{
                                    		echo '</optgroup>';
                                		}
                                		echo '<optgroup label="'.$gL10n->get('LST_GENERAL_LISTS').'">';
                            		}
                            		$list_global_flag = $rowConfigurations['lst_global'];
                        		}
                        		echo '<option value="'.$rowConfigurations['lst_id'].'">'.$rowConfigurations['lst_name'].'</option>';
                    		}
                		echo'</select>
                	</dd>
                </li>
                <p>
                <li><b>2.</b> '.$gL10n->get('PFF_CHOOSE_ROLESELECTION').':</li>
       			<li>
       				<dl>
       					<dt>
        					<b>'.$gL10n->get('SYS_ROLE').' :</b>
        				</dt>
        				<dd>';
        					// Combobox mit allen Rollen ausgeben
        					echo FormElements::generateRoleSelectBox();

        					// Auswahlbox, ob aktive oder ehemalige Mitglieder angezeigt werden sollen
            				$selected[0] = '';
            				$selected[1] = '';
            				$selected[2] = '';
            				echo '&nbsp;&nbsp;&nbsp;
            				<select size="1" id="show_members" name="show_members">
                				<option '.$selected[0].' value="0">'.$gL10n->get('LST_ACTIVE_MEMBERS').'</option>
                				<option '.$selected[1].' value="1">'.$gL10n->get('LST_FORMER_MEMBERS').'</option>
                				<option '.$selected[2].' value="2">'.$gL10n->get('LST_ACTIVE_FORMER_MEMBERS').'</option>
            				</select>';
        				echo '</dd>
        			</dl>
        		</li>
        		<p>   
				<li><b>3.</b> '.$gL10n->get('PFF_CHOOSE_FORMSELECTION').':</li>
        		<li>
        			<dl>
        				<dt>
        					<b>'.$gL10n->get('PFF_FORM_CONFIG').' :</b>&nbsp;&nbsp;
        				</dt>
        				<dd>';
							// Auswahlbox mit den Formularkonfigurationen
        					echo FormElements::generateDynamicSelectBox($config_ini['Formular']['form_desc'],'','form_id',true);    
    					echo '</dd>
    				</dl>
    			</li>
    			<div class="formSubmit">	
        			<button id="btnSave" type="submit" name="listselection_save"><img src="'. THEME_PATH. '/icons/page_white_acrobat.png" alt="'.$gL10n->get('PFF_PDF_FILE_GENERATE').'" />&nbsp;'.$gL10n->get('PFF_PDF_FILE_GENERATE').'</button>
        		</div>
        	</ul>
    	</div>
	</form>
</div>

<ul class="iconTextLinkList">
    <li>
        <span class="iconTextLink">
            <a href="'.$g_root_path.'/adm_program/system/back.php"><img
            src="'.THEME_PATH.'/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
            <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
        </span>
    </li>
</ul>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>