<?php
/******************************************************************************
 * select_pdf.php
 *
 * Show a list of all downloads
 *
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Parameters:
 *
 * folder_id :  akutelle OrdnerId
 * form_id   :  interne Nummer des verwendeten PDF-Formulars
 *
 * Hinweis :  select_pdf.php ist eine modifizierte downloads.php
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/module_menu.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_folder.php');
require_once(SERVER_PATH. '/adm_program/system/file_extension_icons.php');
require_once(dirname(__FILE__).'/common_function.php');

unset($_SESSION['download_request']);

// Initialize and check the parameters
$getFolderId = admFuncVariableIsValid($_GET, 'folder_id', 'numeric', 0);

$getFormID = admFuncVariableIsValid($_GET, 'form_id', 'numeric', 0);

// pruefen ob das Modul ueberhaupt aktiviert ist
if ($gPreferences['enable_download_module'] != 1)
{
    // das Modul ist deaktiviert
    $gMessage->show($gL10n->get('SYS_MODULE_DISABLED'));
}

//nur von eigentlicher OrgaHompage erreichbar
if($gCurrentOrganization->getValue('org_shortname')!= $g_organization)
{
    // das Modul ist deaktiviert
    $gMessage->show($gL10n->get('SYS_MODULE_ACCESS_FROM_HOMEPAGE_ONLY', $gHomepage));
}

//Verwaltung der Session
$gNavigation->addUrl(CURRENT_URL);

try
{
    // get recordset of current folder from databse
    $currentFolder = new TableFolder($gDb);
    $currentFolder->getFolderForDownload($getFolderId);
}
catch(AdmException $e)
{
	$e->showHtml();
}

$getFolderId = $currentFolder->getValue('fol_id');

//Ordnerinhalt zur Darstellung auslesen
$folderContent = $currentFolder->getFolderContentsForDownload();

//NavigationsLink erhalten
$navigationBar = $currentFolder->getNavigationForDownload();

// in der Original TableFolder-Klasse sind bestimmte Werte fest kodiert
// diese Werte werden hiermit ersetzt
$navigationBar = str_ireplace('adm_program/modules/downloads/downloads','adm_plugins/'.$plugin_folder.'/select_pdf',$navigationBar);
$navigationBar = str_ireplace('?folder_id','?form_id='.$getFormID.'&folder_id',$navigationBar);

// Html-Kopf ausgeben
$gLayout['title']  = $gL10n->get('PFF_PDF_FILE');
$gLayout['header'] = '
    <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/tooltip/text_tooltip.js"></script>
    <script type="text/javascript"><!--
        $(document).ready(function() 
        {
            $("a[rel=\'lnkDelete\']").colorbox({rel:\'nofollow\', scrolling:false, onComplete:function(){$("#admButtonNo").focus();}});
        }); 
    //--></script>';
require(SERVER_PATH. '/adm_program/system/overall_header.php');

// Html des Modules ausgeben
echo '<h1 class="moduleHeadline">'.$gLayout['title'].'</h1>';

echo $navigationBar;

//Anlegen der Tabelle
echo '
<table class="tableList" cellspacing="0">
        <thead>
            <tr>
                <th style="width: 25px;"><img class="iconInformation"
                    src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('SYS_FOLDER').' / '.$gL10n->get('DOW_FILE_TYPE').'" title="'.$gL10n->get('SYS_FOLDER').' / '.$gL10n->get('DOW_FILE_TYPE').'" />
                </th>
                <th>'.$gL10n->get('SYS_NAME').'</th>
                <th>'.$gL10n->get('SYS_DATE_MODIFIED').'</th>
                <th>'.$gL10n->get('SYS_SIZE').'</th>';
        echo '</tr></thead>';

//falls der Ordner leer ist
if (count($folderContent) == 0)
{
    $colspan = '4';
    echo'<tr>
       <td colspan="'.$colspan.'">'.$gL10n->get('DOW_FOLDER_NO_FILES').'</td>
    </tr>';
}
else
{
    //Ordnerinhalt ausgeben
    if (isset($folderContent['folders'])) {
        //als erstes die Unterordner
        for($i=0; $i<count($folderContent['folders']); $i++) {

            $nextFolder = $folderContent['folders'][$i];

            echo '
            <tr class="tableMouseOver" id="row_folder_'.$nextFolder['fol_id'].'">
                <td>
                      <a class="iconLink" href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/select_pdf.php?folder_id='. $nextFolder['fol_id'].'&form_id='.$getFormID.'">
                    <img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('SYS_FOLDER').'" title="'.$gL10n->get('SYS_FOLDER').'" /></a>
                </td>
                <td><a href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/select_pdf.php?folder_id='. $nextFolder['fol_id']. '&form_id='.$getFormID.'">'. $nextFolder['fol_name']. '</a>';
                if($nextFolder['fol_description']!="")
                {
                    echo '<span class="iconLink" ><a class="textTooltip" title="'.$nextFolder['fol_description'].'" href="#"><img src="'. THEME_PATH. '/icons/info.png" alt="'.$gL10n->get('SYS_FOLDER').'"/></a></span>';
                }
                echo'</td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>';
            echo '</tr>';
        }
    }

    //als naechstes werden die enthaltenen Dateien ausgegeben
    if (isset($folderContent['files'])) {
        for($i=0; $i<count($folderContent['files']); $i++) {

            $nextFile = $folderContent['files'][$i];

            //Ermittlung der Dateiendung
            $fileExtension  = admStrToLower(substr($nextFile['fil_name'], strrpos($nextFile['fil_name'], '.')+1));

            //Auszugebendes Icon ermitteln
            $iconFile = 'page_white_question.png';
            if(array_key_exists($fileExtension, $icon_file_extension))
            {
                $iconFile = $icon_file_extension[$fileExtension];
            }
            
            // Zeitstempel formatieren
            $timestamp = new DateTimeExtended($nextFile['fil_timestamp'], 'Y-m-d H:i:s');

            echo '
            <tr class="tableMouseOver" id="row_file_'.$nextFile['fil_id'].'">
                <td>
                    <a class="iconLink" href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/get_pdf.php?file_id='. $nextFile['fil_id']. '&form_id='.$getFormID.'">
                    <img src="'. THEME_PATH. '/icons/'.$iconFile.'" alt="'.$gL10n->get('SYS_FILE').'" title="'.$gL10n->get('SYS_FILE').'" /></a>
                </td>
                <td><a href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/get_pdf.php?file_id='. $nextFile['fil_id']. '&form_id='.$getFormID.'">'. $nextFile['fil_name']. '</a>';
                if($nextFile['fil_description']!="")
                {
                    echo '<span class="iconLink" ><a class="textTooltip" title="'.$nextFile['fil_description'].'" href="#"><img src="'. THEME_PATH. '/icons/info.png" alt="'.$gL10n->get('SYS_FILE').'"/></a></span>';
                }
                echo'</td>
                <td>'. $timestamp->format($gPreferences['system_date'].' '.$gPreferences['system_time']). '</td>
                <td>'. $nextFile['fil_size']. ' kB&nbsp;</td>';
            echo '</tr>';
        }
    }
}

//Ende der Tabelle
echo'</table>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>