<?php
/******************************************************************************
* 
* settings.php
*   
* Erzeugt das Menue Einstellungen fuer das Admidio-Plugin formfiller
* 
* Copyright    : (c) 2004 - 2014 The Admidio Team
* Homepage     : http://www.admidio.org
* License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
*
****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(dirname(__FILE__).'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/version.php');

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

// überprüfen, ob der angemeldete User berechtigt ist das Plugin aufzurufen
$showPlugin = check_showpluginPFF($config_ini['Pluginfreigabe']['freigabe_config']);

// weiter nur, wenn der User berechtigt ist
if($showPlugin)
{
    // DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
    $gDb->setCurrentDB();

    // Navigation faengt hier im Modul an
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);

    $html_icon_warning = '<img class="iconHelpLink" src="'.THEME_PATH.'/icons/warning.png" alt="'.$gL10n->get('SYS_WARNING').'" />';

    // zusaetzliche Daten fuer den Html-Kopf setzen
    $gLayout['title']  = $gL10n->get('PFF_FORMFILLER');
    $gLayout['header'] =  '
        <script type="text/javascript" src="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/settings.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.core.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.widget.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.tabs.js" ></script>		
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.accordion.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.scrollTo.js" ></script>

        <script type="text/javascript"><!--
        	var settingsJS = new settingsClass();
        	$(document).ready(function()
            	{settingsJS.init();
        		});
        	//-->
        </script>
        <link rel="stylesheet" type="text/css" href="'.THEME_PATH.'/css/jquery.css">';

    // Html-Kopf ausgeben
    require(SERVER_PATH. '/adm_program/system/overall_header.php');

    echo '<h1 class="moduleHeadline">'.$gL10n->get('PFF_FORMFILLER').'</h1>

    <div class="formLayout" id="admOrganizationMenu">
        <div class="formBody">
            <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/menue_function.php" method="post">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-setup">'.$gL10n->get('PFF_SETTINGS').'</a></li>
                    </ul>
                    <div id="tabs-setup">
                        <div id="accordion-setup">';
              	
                            /**************************************************************************************/
                            // Formularkonfiguration
                            /**************************************************************************************/

                            echo '<h3 id="Formularkonfiguration" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Formularkonfiguration" title="'.$gL10n->get('PFF_FORM_CONFIG').'" /></a>
                                <a href="#">'.$gL10n->get('PFF_FORM_CONFIG').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList"> 
                                	<li>'.$gL10n->get('PFF_FORM_CONFIG_HEADER').'</li>
                                	<BR>
                                	<li class="smallFontSize">'.$gL10n->get('PFF_FORM_CONFIG_DESC').'</li>
                                    <BR>';
                            		echo'
                            		<div style="width:100%; height:300px; overflow:auto; border:0px;">';
                            			$font = array('Courier','Arial','Times','Symbol','ZapfDingbats' );
                            			$fontstyle = array('Normal'=>'','Fett'=>'B','Kursiv'=>'I','Unterstrichen'=>'U','Fett-Kursiv'=>'BI','Fett-Unterstrichen'=>'BU','Kursiv-Unterstrichen'=>'IU');
                            			$fontsize = array('6','8','10','12','14','16','18','20');
                            			$fontcolor = array($gL10n->get('PFF_BLACK')=>'0,0,0',$gL10n->get('PFF_RED')=>'255,0,0',$gL10n->get('PFF_GREEN')=>'0,255,0',$gL10n->get('PFF_BLUE')=>'0,0,255');
                            		
                                    	for ($i=0;$i<$config_ini['Optionen']['formularanzahl'];$i++)
										{
											echo'
											<table border="0">
												<tr>
													<td><small>  '.($i+1).'. '.$gL10n->get('PFF_FORM').'</small></td>
												</tr>
												<tr>
                                            		<td><strong>'.$gL10n->get('PFF_DESCRIPTION').':</strong></td>
                                            		<td><input type="text" id="form_desc[]" name="form_desc[]" style="width: 200px;" maxlength="200" value="'. (isset($config_ini['Formular']['form_desc'][$i]) ?$config_ini['Formular']['form_desc'][$i] : ''). '" /></td>
                                    			</tr>
            									<tr>
                                            		<td>&nbsp</td>
                                    			</tr>                         	
                                    			<tr>
                                            		<td>'.$gL10n->get('PFF_FONT').':</td>
                                            		<td>
                                            			<select name="form_font[]" size="1">';
															foreach($font as $field )
    														{   
    															echo '<option value="'.$field.'"';
                  												if(isset($config_ini['Formular']['form_font'][$i]) && $field==$config_ini['Formular']['form_font'][$i] )
                                                        		{
                                                            		echo ' selected="selected"';	
                                                        		}
                  												echo '>'.$field.'</option>';
    														} 
    													echo '</select> 
                                            		</td>
                                    			</tr>
                  								<tr>
                                            		<td>'.$gL10n->get('PFF_FONTSTYLE').':</td>
                                            		<td>
                                            			<select name="form_style[]" size="1">';
															foreach($fontstyle as $field => $data)
    														{   
    															echo '<option value="'.$data.'"';
                  												if(isset($config_ini['Formular']['form_style'][$i]) && $data==$config_ini['Formular']['form_style'][$i] )
                                                        		{
                                                            		echo ' selected="selected"';	
                                                        		}
                  												echo '>'.$field.'</option>';
    														} 
    													echo '</select> 
                                            		</td>
                                    			</tr> 
                                    			<tr>
                                            		<td>'.$gL10n->get('PFF_FONTSIZE').':</td>
                                            		<td>
                                            			<select name="form_size[]" size="1">';
															foreach($fontsize as $field )
    														{   
    															echo '<option value="'.$field.'"';
                  												if(isset($config_ini['Formular']['form_size'][$i]) && $field==$config_ini['Formular']['form_size'][$i] )
                                                        		{
                                                            		echo ' selected="selected"';	
                                                        		}
                  												echo '>'.$field.'</option>';
    														} 
    													echo '</select> 
                                            		</td>
                                    			</tr> 
												<tr>
                                            		<td>'.$gL10n->get('PFF_FONTCOLOR').':</td>
                                            		<td>
                                            			<select name="form_color[]" size="1">';
															foreach($fontcolor as $field => $data)
    														{   
    															echo '<option value="'.$data.'"';
                  												if(isset($config_ini['Formular']['form_color'][$i]) && $data==$config_ini['Formular']['form_color'][$i] )
                                                        		{
                                                            		echo ' selected="selected"';	
                                                        		}
                  												echo '>'.$field.'</option>';
    														} 
    													echo '</select> 
                                            		</td>
                                    			</tr> 
												<tr>
													<td>'.$gL10n->get('PFF_PDF_FILE').':</td>
                                            		<td>'.$config_ini['Formular']['form_pdfname'][$i].'  
                                            			<a class="iconLink" id="selcetpdf" href="'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/select_pdf.php?form_id='.$i.'">
                                            				<img src="'. THEME_PATH. '/icons/page_white_acrobat.png" alt="'.$gL10n->get('PFF_PDF_FILE_SELECT').'" title="'.$gL10n->get('PFF_PDF_FILE_SELECT').'" />
                                            			</a>                        	
                                            		</td>
                                    			</tr> 
                                 				<tr>
                                            		<td>'.$gL10n->get('PFF_LABELS').':</td>
                                            		<td><input type="text" id="labels['.$i.']" name="labels['.$i.']" style="width: 200px;" maxlength="200" value="'. $config_ini['Formular']['labels'][$i]. '" /></td>
                                        		</tr>                                        		
                                        		<tr>
                                            		<td>&nbsp</td>
                                    			</tr>';		

												foreach($gProfileFields->mProfileFields as $field )
    											{ 
													echo'
                                        			<tr>
                                            			<td>'.$field->getValue('usf_name').':</td>
                                            			<td><input type="text" id="form_value['.$i.']['.$field->getValue('usf_id').']" name="form_value['.$i.']['.$field->getValue('usf_id').']" style="width: 250px;" maxlength="600" value="'. (isset($config_ini['Formular']['form_usfid-'.$field->getValue('usf_id')][$i]) ? $config_ini['Formular']['form_usfid-'.$field->getValue('usf_id')][$i] : '' ). '" /></td>
                                            		</tr>';	
    											}
    											echo'<tr>
                                            		<td>&nbsp</td>
                                    			</tr>
                                 				<tr>
                                            		<td>'.$gL10n->get('PFF_DATE').':</td>
                                            		<td><input type="text" id="date['.$i.']" name="date['.$i.']" style="width: 200px;" maxlength="200" value="'. $config_ini['Formular']['date'][$i]. '" /></td>
                                        		</tr>                                        		
                                 				<tr>
                                            		<td>'.$gL10n->get('PFF_PROFILE_PHOTO').':</td>
                                            		<td><input type="text" id="profile_photo['.$i.']" name="profile_photo['.$i.']" style="width: 200px;" maxlength="200" value="'. $config_ini['Formular']['profile_photo'][$i]. '" /></td>
                                        		</tr>
											</table>
											<HR>';
										}
							        	echo'
                                    </div>';
                                echo '</ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="formularkonfiguration_save"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
	                                        	
                            /**************************************************************************************/
                            // Optionen
                            /**************************************************************************************/

                            echo '<h3 id="Optionen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Optionen" title="'.$gL10n->get('PFF_OPTIONS').'" /></a>
                                <a href="#">'.$gL10n->get('PFF_OPTIONS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">                                    
                                	<li>
                                        <dl>
                                            <dt><label for="formularanzahl">'.$gL10n->get('PFF_FORM_NUMBER').':</label></dt>
                                            <dd>
                                            	'. $config_ini['Optionen']['formularanzahl'].' + <input type="text" id="formularanzahl" name="formularanzahl" style="width: 40px;" maxlength="40" value="0" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_FORM_NUMBER_DESC').'</li>
                                 	<li>
                                        <dl>
                                            <dt><label for="maxpdfview">'.$gL10n->get('PFF_MAX_PDFVIEW').':</label></dt>
                                            <dd>
                                            	<input type="text" id="max_pdfview" name="max_pdfview" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['maxpdfview']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_MAX_PDFVIEW_DESC').'</li>
                                 	<li>
                                        <dl>
                                            <dt><label for="maxlength">'.$gL10n->get('PFF_SELECT_MAXLENGTH').':</label></dt>
                                            <dd>
                                            	<input type="text" id="select__max_length" name="select_max_length" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['select_maxlength']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_SELECT_MAXLENGTH_DESC').'</li>
                                    <li>
                                        <dl>
                                            <dt><label for="dbtoken">'.$gL10n->get('PFF_DBTOKEN').':</label></dt>
                                            <dd>
                                            	<input type="text" id="dbtoken" name="dbtoken" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['dbtoken']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_DBTOKEN_DESC').'</li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="optionen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Pluginfreigabe
                            /**************************************************************************************/

                            echo '<h3 id="Pluginfreigabe" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/lock.png" alt="Pluginfreigabe" title="'.$gL10n->get('PFF_PLUGIN_CONTROL').'" /></a>
                                <a href="#">'.$gL10n->get('PFF_PLUGIN_CONTROL').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                        	<dt><label><strong>'.$gL10n->get('PFF_FORMFILLER').'</strong></label></dt>
                                        	<BR>
                                        	<BR>
                                            <dt><label>'.$gL10n->get('PFF_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePFF($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array('cat' => $row['cat_name'],'rol' => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {	
                                                            echo '<option value="" disabled="disabled">'.checkStringLengthPFF($gL10n->get('SYS_CATEGORY').' '.$data['cat'],$config_ini['Optionen']['select_maxlength']).'</option>';
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPFF($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_ROLE_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PFF_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPFF($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                    <HR>
                                    <li>
                                        <dl>
                                        	<dt><label><strong>'.$gL10n->get('PFF_SETTINGS').'</strong></label></dt>
                                        	<BR>
                                        	<BR>
                                            <dt><label>'.$gL10n->get('PFF_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe_config[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePFF($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array('cat' => $row['cat_name'],'rol' => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {	
                                                            echo '<option value="" disabled="disabled">'.checkStringLengthPFF($gL10n->get('SYS_CATEGORY').' '.$data['cat'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe_config']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPFF($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PFF_ROLE_SELECTION_DESC2').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PFF_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPFF($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="pluginfreigabe"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

                            /**************************************************************************************/
                            // Plugininformationen
                            /**************************************************************************************/

                            echo '<h3 id="Plugininformationen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Plugininformationen" title="'.$gL10n->get('PFF_PLUGIN_INFORMATION').'" /></a>
                                <a href="#">'.$gL10n->get('PFF_PLUGIN_INFORMATION').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">         
                                    <li>
                                        <dl>
                                            <dt><label for="Name des Plugins">'.$gL10n->get('PFF_PLUGIN_NAME').':</label></dt>
                                            <dd><label for="">'.$gL10n->get('PFF_FORMFILLER').'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Version">'.$gL10n->get('PFF_PLUGIN_VERSION').':</label></dt>
                                            <dd><label for="">'.$plugin_ff_version.'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Stand">'.$gL10n->get('PFF_PLUGIN_DATE').':</label></dt>
                                            <dd><label for="">'.$plugin_ff_stand.'</label></dd>
                                        </dl>
                                    </li>
                                </ul>
                                <br>
                            </div>';

                        // ENDE accordion-modules
                        echo'</div>
                    </div>
                </div>
            </form>
        </div>
    </div>';

    require(SERVER_PATH. '/adm_program/system/overall_footer.php');
}
?>