<?php
/******************************************************************************
 * 
 * createpdf.php
 *   
 * Erzeugt und befuellt die PDF-Datei fuer das Admidio-Plugin formfiller
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Parameters:
 * 
 * user_id : 		ID des Mitglieds, dessen Daten ausgelesen werden
 * form_id :		interne Nummer des verwendeten PDF-Formulars
 * 					Hinweis: form_id wird abhängig vom aufrufenden Programm
 * 						entweder über $_GET oder über $_POST übergeben
 * lst_id : 		Liste deren Konfiguration verwendet wird
 * rol_id : 		ID der verwendeten Rolle
 * show_members : 	0 - (Default) aktive Mitglieder der Rolle anzeigen
 *                	1 - Ehemalige Mitglieder der Rolle anzeigen
 *                	2 - Aktive und ehemalige Mitglieder der Rolle anzeigen
 *                
 * Hinweis: Abhängig vom aufrufenden Programm wird 
 * 	   entweder user_id oder (lst_id und rol_id und show_members) übergeben    
 *           
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_file.php');
require_once(SERVER_PATH. '/adm_program/system/classes/list_configuration.php');
require_once(SERVER_PATH. '/adm_program/system/classes/image.php');

require_once(dirname(__FILE__).'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/library/fpdf.php');
require_once($plugin_path. '/'.$plugin_folder.'/library/fpdi.php');

// Initialize and check the parameters
$getUserId       = admFuncVariableIsValid($_GET, 'user_id', 'numeric', 0);
$getFormID 	 	 = admFuncVariableIsValid($_GET, 'form_id', 'numeric', 0);
$postFormID 	 = admFuncVariableIsValid($_POST, 'form_id', 'numeric', 0);
$postListId      = admFuncVariableIsValid($_POST, 'lst_id', 'numeric', 0);
$postRoleId      = admFuncVariableIsValid($_POST, 'rol_id', 'numeric', 0);
$postShowMembers = admFuncVariableIsValid($_POST, 'show_members', 'numeric', 0);

$userArray = array();
unset($role_ids);
$getpostFormID = 0;

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

// wenn von der Profilanzeige aufgerufen wurde, dann ist $getUserId>0
// und form_id wurde über $_GET übergeben
if($getUserId > 0)
{
	$userArray[] = $getUserId ;
	$getpostFormID = $getFormID;
}
elseif(($postListId > 0) && ($postRoleId > 0))
{
	//$list->getSQL($role_ids, $postShowMembers) erwartet als Parameter für 
	//$role_ids ein Array, deshalb $postRoleId in ein Array umwandeln
	$role_ids[] = $postRoleId;
	$mainSql      = '';   // enthaelt das Haupt-Sql-Statement fuer die Liste

	// create list configuration object and create a sql statement out of it
	$list = new ListConfiguration($gDb, $postListId);
	$mainSql = $list->getSQL($role_ids, $postShowMembers);
		
	// SQL-Statement der Liste ausfuehren und pruefen ob Daten vorhanden sind
	$resultList = $gDb->query($mainSql);
	
	while ($row = $gDb->fetch_array($resultList))
	{
		$userArray[] = $row['usr_id'] ;
	}
	$getpostFormID = $postFormID;
}
else 
{
	//Fehlermeldung ausgeben, wenn Parameter fehler
	$gMessage->show($gL10n->get('PFF_MISSING_PARAMETER'),$gL10n->get('SYS_ERROR'));
}

//initiate FPDF
$pdf = new FPDI('P','mm','A4');

// falls ein Formular definiert wurde, dann ist der Wert der form_pdfid>0
if ($config_ini['Formular']['form_pdfid'][$getpostFormID]>0)
{
	//prüfen, ob das Formular noch in der DB existiert
	$sql = 'SELECT fil_id 
            FROM '.TBL_FILES.' , '. TBL_CATEGORIES. ', '. TBL_FOLDERS. '
            WHERE fil_id = \''.$config_ini['Formular']['form_pdfid'][$getpostFormID].'\' 
            AND fil_fol_id = fol_id
            AND (  fol_org_id = '.$gCurrentOrganization->getValue('org_id').'
            	OR fol_org_id IS NULL ) ';
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);
     
	// Gibt es das Formular noch in der DB, wenn nicht: Fehlermeldung
    if( !isset($row->fil_id) && !(strlen($row->fil_id) > 0) )
    {
    	$gMessage->show($gL10n->get('SYS_FILE_NOT_EXIST'));
    }     
	
	// get recordset of current file from databse
	$file = new TableFile($gDb);
	
	$file->getFileForDownload($config_ini['Formular']['form_pdfid'][$getpostFormID]);
    
	//kompletten Pfad der Datei holen
	$completePath = $file->getCompletePathOfFile();

	//pruefen ob File ueberhaupt physikalisch existiert
	if (!file_exists($completePath))
	{
		$gMessage->show($gL10n->get('SYS_FILE_NOT_EXIST'));
	}
}

//sind Daten für Etiketten definiert?
// die Etikettendaten überprüfen
$etiketten = explode(',',$config_ini['Formular']['labels'][$getpostFormID]);
		
if(count($etiketten)==4)
{
	foreach ($etiketten as $data)
	{
		if(!(is_numeric($data)))
		{
			$etiketten = array(1,0,1,0);       // das sind die Werte zum Drucken für eine Seite
			break;
		}
	}
}	
else 
{
	$etiketten = array();
}
//wenn 	count($etiketten) jetzt nicht 0 ist, dann Etikettendruck einleiten	
						
$spalte = 0;
$zeile = 0;	
$etikettenText = array();
		
foreach($userArray as $UserId)
{
	if ($zeile==0 && $spalte==0)
	{
		$pdf->AddPage();
		$pdf->SetAutoPageBreak(false);
	}

	if ($config_ini['Formular']['form_pdfid'][$getpostFormID]>0 && $zeile==0 && $spalte==0)
	{
		// set the sourcefile
		$pdf->setSourceFile($completePath);

		//import page
		$tplIdx = $pdf->importPage(1);

		//use the imported page...
		$pdf->useTemplate($tplIdx,null,null,0,0,true);
	}

	// nur zur Info: FPDI kann auch die Größe einer PDF-Datei auslesen
	//$arr_size = $pdf->getTemplateSize($tplIdx);
	
	// zuerst mal Standardschriftfarbe festlegen (falls nichts definiert wurde)
	$pdf->SetTextColor(0,0,0);

	// zuerst mal Standschrift, -stil und -größe festlegen (falls nichts definiert wurde)
	$pdf->SetFont('Arial','BI',10);
	
	//wurden Positionsangaben für das Datum definiert?
	$formdata = $config_ini['Formular']['date'][$getpostFormID];
	
	//anstelle von if wird while verwendet, damit die Routine über break verlassen werden kann
	while(!empty($formdata))
	{
		$text = '';
	
		// jetzt mit den konfigurierten Daten überschreiben
		$color = explode(',',$config_ini['Formular']['form_color'][$getpostFormID]);
		$pdf->SetTextColor($color[0],$color[1],$color[2]);
			  
		// jetzt mit den konfigurierten Daten überschreiben
		$pdf->SetFont($config_ini['Formular']['form_font'][$getpostFormID],
			  	  	  $config_ini['Formular']['form_style'][$getpostFormID],
			 	  	  $config_ini['Formular']['form_size'][$getpostFormID]   );		
		
		//zuerst mal sehen, ob Schrift-Parameter angefügt sind (wenn sich ein ';' darin befindet)
		$xyKoord = array();
		
		//$formdata splitten in Koordinaten und Rest
		$arrSplit = explode(';',$formdata);

		// xyKoordinaten extrahieren und in $arrSplit löschen
		$xyKoord = explode(',',array_shift($arrSplit));
		
		// Routine beenden, wenn nicht genau zwei Koordinaten (X und Y) angegeben wurden
		if (count($xyKoord)<>2)
		{
			break;
		}
		$pdf->SetXY($xyKoord[0], $xyKoord[1]);
					
		//arrSplit zerlegen in ein assoziatives Array
		$fontData = array();		
		foreach($arrSplit as $splitData)
		{
			$fontData[substr($splitData,0,1)] = substr($splitData,2) ;	
		}
		
		// wurde eine abweichende Schriftfarbe definiert? ->  prüfen und ggf. überschreiben
		if ( array_key_exists ( 'C', $fontData ) )
		{
			// jetzt mit den konfigurierten Daten überschreiben
			$color = explode(',',$fontData['C']);
			$key = true;
			foreach ($color as $data)
			{
				if(!(is_numeric($data)))
				{
					$key = false;
					break;
				}
			}
			if ($key)
			{
				$pdf->SetTextColor($color[0],$color[1],$color[2]);					
			}
		}
			
		// wurde eine abweichende Schriftgröße definiert? -> prüfen und ggf. löschen
		if ( array_key_exists ( 'S', $fontData ) && !(is_numeric($fontData['S'])))
		{
			unset($fontData['S']);
		}	

		// wurde ein abweichender Schrifttyp definiert? -> prüfen und ggf. löschen
		if ( array_key_exists ( 'F', $fontData ) && !(in_array($fontData['F'],array('Courier','Arial','Times','Symbol','ZapfDingbats' ))))
		{
			unset($fontData['F']);
		}			

		// wurden abweichende Schriftattribute definiert? -> prüfen und ggf. löschen
		if ( array_key_exists ( 'A', $fontData ) && !(strstr_multiple('BIU',$fontData['A'])) )
		{
			unset($fontData['A']);
		}	
		
		// wurden abweichende Schriftart, Schriftstil oder Schriftgröße definiert?	-> überschreiben	
		$pdf->SetFont(
			((array_key_exists ( 'F', $fontData )) ? $fontData['F'] : $config_ini['Formular']['form_font'][$getpostFormID]),
			((array_key_exists ( 'A', $fontData )) ? $fontData['A'] : $config_ini['Formular']['form_style'][$getpostFormID]),
			((array_key_exists ( 'S', $fontData )) ? $fontData['S'] : $config_ini['Formular']['form_size'][$getpostFormID])   );		

		$text = date("d.m.Y");
				
		// wurden Werte für das Datum definiert? 
		if ( array_key_exists ( 'D', $fontData ) )
		{
			// Hinweis: der übergebene Inhalt wird nicht überprüft (es kann auch kein Datum sein)
			$text = $fontData['D'];	
		}	
       
        //über ein Hilfsarray gehen, falls mit Etiketten gearbeitet wird
        if (count($etiketten)>0)
        {
        	$etikettenText[$pdf->GetY()][$pdf->GetX()]=$text;
        }
        else 
        {
        	$pdf->Write(0,utf8_decode($text));
        }
        break;             // while-Schleife verlassen
	}	
	
	//wurden Positionsangaben für ein Profilfoto definiert?
	$formdata = $config_ini['Formular']['profile_photo'][$getpostFormID];

	//anstelle von if wird while verwendet, damit die Routine über break verlassen werden kann
	while(!empty($formdata))
	{
		$image  = null;
		$zufall = 0;
		$imageW = 0;
		$imageH = 0;
		$picpath= '';	
		$xyKoord = array();

		//$formdata splitten in Koordinaten und Rest
		$arrSplit = explode(';',$formdata);

		// xyKoordinaten extrahieren und in $arrSplit löschen
		$xyKoord = explode(',',array_shift($arrSplit));
		
		// Routine beenden, wenn nicht mindestens die Koordinaten für X und Y angegeben wurden
		if (count($xyKoord)<2)
		{
			break;
		}
		$pdf->SetXY($xyKoord[0], $xyKoord[1]);
		
		// wurden Parameter für Weite und Höhe übergeben?
		if (isset($xyKoord[2]))
		{
			$imageW = $xyKoord[2];
			if (isset($xyKoord[3]))
			{
				$imageH = $xyKoord[3];		
			}	
		}

		// read user data 
		$user = new User($gDb, $gProfileFields, $UserId);

		//Foto aus einer alternativen Bilddatei
		// wenn eine alternative Bilddatei übergeben wurde, dann muss die Länge von $arrSplit[0]>0 sein
		if(strlen($arrSplit[0])>0 )
		{
			if(file_exists(SERVER_PATH. '/adm_my_files/download/'.$arrSplit[0]))
			{
				$picpath = SERVER_PATH. '/adm_my_files/download/'.$arrSplit[0];
			}	
		}
		//Foto aus adm_my_files
		elseif($gPreferences['profile_photo_storage'] == 1 )
		{
			if(file_exists(SERVER_PATH. '/adm_my_files/user_profile_photos/'.$UserId.'.jpg'))
			{
				$picpath = SERVER_PATH. '/adm_my_files/user_profile_photos/'.$UserId.'.jpg';
			}
		}
		//Foto aus der Datenbank
		elseif($gPreferences['profile_photo_storage'] == 0 )
		{		
			if(strlen($user->getValue('usr_photo')) != NULL)
    		{
        		$image = new Image();
        		$image->setImageFromData($user->getValue('usr_photo'));
        
        		// die Methode Image der Klasse FPDF benötigt einen Pfad zur Imagedatei
        		// ich habe es nicht geschafft von der Klasse Image direkt an die Klasse FPDF diesen Pfad zu übergeben
        		// deshalb der Umweg über eine temporäre Datei
        		$zufall = mt_rand(10000,99999);
        		$image->copyToFile(null,SERVER_PATH. '/adm_my_files/PFF'.$zufall.'.png');
        		$image->delete();
        
        		$picpath = SERVER_PATH. '/adm_my_files/PFF'.$zufall.'.png';   
    		}
		}

		//Bild nur in PDF-Datei schreiben, wenn auch ein Bild zum Mitglied gefunden wurde
		if ($picpath<>'')
		{
       		$pdf->Image($picpath,$xyKoord[0],$xyKoord[1], $imageW, $imageH);

			// ggf. die temporär angelegte Bilddatei wieder löschen
			if(file_exists(SERVER_PATH. '/adm_my_files/PFF'.$zufall.'.png'))
            {
                unlink(SERVER_PATH. '/adm_my_files/PFF'.$zufall.'.png');
            }
		}
		break;    //verlassen der while-Schleife
	}	

	
	// jetzt alle Profilfelder durchlaufen
	foreach($gProfileFields->mProfileFields as $field )
	{ 
		$text = '';
	
		// jetzt mit den konfigurierten Daten überschreiben
		$color = explode(',',$config_ini['Formular']['form_color'][$getpostFormID]);
		$pdf->SetTextColor($color[0],$color[1],$color[2]);
			  
		// jetzt mit den konfigurierten Daten überschreiben
		$pdf->SetFont($config_ini['Formular']['form_font'][$getpostFormID],
			  	  	  $config_ini['Formular']['form_style'][$getpostFormID],
			 	  	  $config_ini['Formular']['form_size'][$getpostFormID]   );										

		$formdata = $config_ini['Formular']['form_usfid-'.$field->getValue('usf_id')][$getpostFormID];
		if(!empty($formdata))
		{
			//zuerst mal sehen, ob Schrift-Parameter angefügt sind (wenn sich ein ';' darin befindet)
			$xyKoord = array();
			$gender = array('x','x');
			
			//$formdata splitten in Koordinaten und Rest
			$arrSplit = explode(';',$formdata);

			// xyKoordinaten extrahieren und in $arrSplit löschen
			$xyKoord = explode(',',array_shift($arrSplit));

			// Routine beenden, wenn nicht mindestens die Koordinaten für X und Y angegeben wurden
			if (count($xyKoord)<2)
			{
				continue ;
			}
			$pdf->SetXY($xyKoord[0], $xyKoord[1]);
					
			//arrSplit zerlegen in ein assoziatives Array
			$fontData = array();		
			foreach($arrSplit as $splitData)
			{
				$fontData[substr($splitData,0,1)] = substr($splitData,2) ;	
			}
		
			// wurde eine abweichende Schriftfarbe definiert? ->  prüfen und ggf. überschreiben
			if ( array_key_exists ( 'C', $fontData ) )
			{
				// jetzt mit den konfigurierten Daten überschreiben
				$color = explode(',',$fontData['C']);
				$key = true;
				foreach ($color as $data)
				{
					if(!(is_numeric($data)))
					{
						$key = false;
						break;
					}
				}
				if ($key)
				{
					$pdf->SetTextColor($color[0],$color[1],$color[2]);					
				}
			}
			
			// wurde eine abweichende Schriftgröße definiert? -> prüfen und ggf. löschen
			if ( array_key_exists ( 'S', $fontData ) && !(is_numeric($fontData['S'])))
			{
				unset($fontData['S']);
			}	

			// wurde ein abweichender Schrifttyp definiert? -> prüfen und ggf. löschen
			if ( array_key_exists ( 'F', $fontData ) && !(in_array($fontData['F'],array('Courier','Arial','Times','Symbol','ZapfDingbats' ))))
			{
				unset($fontData['F']);
			}			

			// wurden abweichende Schriftattribute definiert? -> prüfen und ggf. löschen
			if ( array_key_exists ( 'A', $fontData ) && !(strstr_multiple('BIU',$fontData['A'])) )
			{
				unset($fontData['A']);
			}	
		
			// wurden abweichende Schriftart, Schriftstil oder Schriftgröße definiert?	-> überschreiben	
			$pdf->SetFont(
				((array_key_exists ( 'F', $fontData )) ? $fontData['F'] : $config_ini['Formular']['form_font'][$getpostFormID]),
				((array_key_exists ( 'A', $fontData )) ? $fontData['A'] : $config_ini['Formular']['form_style'][$getpostFormID]),
				((array_key_exists ( 'S', $fontData )) ? $fontData['S'] : $config_ini['Formular']['form_size'][$getpostFormID])   );		

			// wurden Werte für das Geschlecht definiert? 
			if ( array_key_exists ( 'T', $fontData ) )
			{
				$gender = explode(',',$fontData['T']);
				if(!isset($gender[0]))
				{
					$gender[0]='x';
				}
				if(!isset($gender[1]))
				{
					$gender[1]=$gender[0];
				}
			}	
			
        	$user = new User($gDb, $gProfileFields, $UserId);
        
        	if($field->getValue('usf_name_intern')=='GENDER')
        	{
        		if(strstr($user->getValue($field->getValue('usf_name_intern')),'female'))
        		{
        	    	//female
        			if (isset($xyKoord[2]) && isset($xyKoord[3]))
        			{
        				$pdf->SetXY($xyKoord[2], $xyKoord[3]);
        			}
        			$text = $gender[1];
        		}
        		elseif(strstr($user->getValue($field->getValue('usf_name_intern')),'male')) 
        		{
        			$text = $gender[0];
        		}
        	}
			elseif($field->getValue('usf_type') == 'CHECKBOX')
        	{
        		if($user->getValue($field->getValue('usf_name_intern')))
        		{
        			$text = 'x';
        		}
        	}
        	else 
        	{
        		$text= $user->getValue($field->getValue('usf_name_intern'));
        	}
        	       	
        	//über ein Hilfsarray gehen, falls mit Etiketten gearbeitet wird
        	if (count($etiketten)>0)
        	{
        		$etikettenText[$pdf->GetY()][$pdf->GetX()]=$text;
        	}
        	else 
        	{
        		$pdf->Write(0,utf8_decode($text));
        	}
		}		
	}  // zum naechsten Profilfeld 

	$text = '';
	if (count($etiketten)>0)
    {        	
        foreach($etikettenText as $yKoord => $zeileData)	
        {
        	$pdf->SetY($yKoord+($zeile*$etiketten[3]));
        	
        	ksort($zeileData);
        	reset($zeileData);
        	$xKoord = key($zeileData);
        	
        	$pdf->SetX($xKoord+($spalte*$etiketten[1]));
        	
        	$text = '';
        	foreach($zeileData as $spalteText => $spalteData)
        	{
        		$text .= $spalteData.' ';
        	}
        	$pdf->Write(0,utf8_decode($text));
        }
	
    	unset($etikettenText);
        
		$spalte++;
		if($spalte==$etiketten[0])
		{
			$spalte=0;
			$zeile++;
		}
		if($zeile==$etiketten[2])
		{
			$zeile=0;
		}
    }
}  // zum naechsten User

if($pdf->PageNo() > $config_ini['Optionen']['maxpdfview'] )
{
	$pdf->Output($config_ini['Formular']['form_desc'][$getpostFormID].'.pdf','D');	
}
else 
{
	$pdf->Output();
}


?>