<?php
/******************************************************************************
 * 
 * menue_function.php
 *   
 * Menuefunktionen fuer das Admidio-Plugin formfiller
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePFF();

$_SESSION['organization_request'] = $_REQUEST;

// *******************************************************************************
// Setup: Optionen
// *******************************************************************************
if( isset($_POST['optionen']))
{
    $config_ini['Optionen']['select_maxlength']  = (($_POST['select_max_length']<20) ? 20 : $_POST['select_max_length']) ;
    $config_ini['Optionen']['maxpdfview'] = (intval($_POST['max_pdfview']<0) ? 0 : intval($_POST['max_pdfview']));
    
    // wenn zusätzliche Formulare definiert werden, muessen form_pdfid und form_pdfname vorbelegt werden 
    $more = (intval($_POST['formularanzahl']>0) ? intval($_POST['formularanzahl']) : 0);
    for ($i=0;$i<$more;$i++)
    {
    	$config_ini['Formular']['form_pdfid'][] =  '0';	
    	$config_ini['Formular']['form_pdfname'][] = '';		
    }
    $config_ini['Optionen']['formularanzahl'] += $more;   

    if (!empty($_POST['dbtoken']))	
    {
    	$config_ini['Optionen']['dbtoken'] = $_POST['dbtoken'];	
    }
  	writeConfigTablePFF($config_ini);
}

// *******************************************************************************
// Setup: Formularkonfiguration
// *******************************************************************************

if( isset($_POST['formularkonfiguration_save']))
{
	//form_pdfid und form_pdfname zwischenspeichern
	$form_pdfid = $config_ini['Formular']['form_pdfid'];
	$form_pdfname = $config_ini['Formular']['form_pdfname'];
	
	// da nicht mit assoziativen Arrays gearbeitet werden kann, muss diese Schleife 2x durchlaufen werden
	// im ersten Durchlauf Daten neu schreiben
	// im zweiten Durchlauf: Löschen, wenn form_desc leer ist
	for ($i=0;$i<$config_ini['Optionen']['formularanzahl'];$i++)
    {
    	$config_ini['Formular']['form_desc'][$i] 	=$_POST['form_desc'][$i];
    	$config_ini['Formular']['form_font'][$i] 	=$_POST['form_font'][$i];
    	$config_ini['Formular']['form_style'][$i]	=$_POST['form_style'][$i];    	
    	$config_ini['Formular']['form_size'][$i]	=$_POST['form_size'][$i];
    	$config_ini['Formular']['form_color'][$i]	=$_POST['form_color'][$i]; 
    	$config_ini['Formular']['labels'][$i]		=$_POST['labels'][$i]; 
    	$config_ini['Formular']['profile_photo'][$i]=$_POST['profile_photo'][$i]; 
    	$config_ini['Formular']['date'][$i]			=$_POST['date'][$i]; 	 
    	$config_ini['Formular']['form_pdfid'][$i]	=(isset($form_pdfid[$i]) ? $form_pdfid[$i] : '0');	
    	$config_ini['Formular']['form_pdfname'][$i]	=(isset($form_pdfname[$i]) ? $form_pdfname[$i] : '');	
    	
    	foreach($_POST['form_value'][$i] as $valuekey => $valuedata)
    	{
    		$config_ini['Formular']['form_usfid-'.$valuekey][$i]= $valuedata ;
    	}
    }
    for ($i=0;$i<$config_ini['Optionen']['formularanzahl'];$i++)
    {
    	if ($config_ini['Formular']['form_desc'][$i]=='')
    	{
    		foreach($config_ini['Formular'] as $key => $data)
    		{
    			unset($config_ini['Formular'][$key][$i]);
    		}
    	}
    }
    $config_ini['Optionen']['formularanzahl'] = count($config_ini['Formular']['form_desc']); 
    
    writeConfigTablePFF($config_ini);
}

// *******************************************************************************
// Setup: Pluginfreigabe
// *******************************************************************************
if(($_POST['freigabe'] == true) && ($_POST['freigabe_config']==true) && (isset($_POST['pluginfreigabe'])))
{
    unset($config_ini['Pluginfreigabe']);
    
    $config_ini['Pluginfreigabe']['freigabe'] = $_POST['freigabe'];
    $config_ini['Pluginfreigabe']['freigabe_config'] = $_POST['freigabe_config'];
    writeConfigTablePFF($config_ini);
}

// *******************************************************************************

// zur Ausgangsseite zurueck
$gMessage->setForwardUrl($gNavigation->getUrl(), 2000);
$gMessage->show($gL10n->get('SYS_SAVE_DATA'));	

?>=