<?php
/******************************************************************************
 * Klasse verwaltet die Konfigurationstabelle
 *
 * Copyright    : (c) 2004 - 2015 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Diese Klasse dient dazu die Konfigurationstabelle "adm_plugin_preferences" zu verwalten.
 *
 * Folgende Methoden stehen zur Verfügung:
 *
 * init()						:	prüft, ob die Konfigurationstabelle existiert, 
 * 									legt sie ggf. an und befüllt sie mit Default-Werten
 * save() 						: 	schreibt die Konfiguration in die Datenbank
 * read()						:	liest die Konfigurationsdaten aus der Datenbank
 * checkforupdate()				:	vergleicht die Angaben in der Datei version.php 
 * 									mit den Daten in der DB
 * delete_config_data()         :	löscht Konfigurationsdaten in der Datenbank
 * delete_member_data           :   löscht Nutzerdaten in der Datenbank
 * delete_mail_data             :   löscht Mail-Texte  in der Datenbank
 * 
 *****************************************************************************/ 

class ConfigTablePMB
{
	public	  $config		= array();     ///< Array mit allen Konfigurationsdaten
	
	protected $table_name;
	protected static $shortcut =  'PMB';
	protected static $version ;
	protected static $stand;
	protected static $dbtoken;
	
	public $config_default= array();	
	
	// constructor
	public function __construct()
	{
		global  $gDb, $gCurrentOrganization, $g_tbl_praefix;
		
		$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
		$plugin_file_pos   = strpos(__FILE__, basename(__FILE__))-8;
		$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
		$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

		require_once($plugin_path. '/'.$plugin_folder.'/version.php');
		include($plugin_path. '/'.$plugin_folder.'/configdata.php');
		
		$this->table_name = $g_tbl_praefix.'_plugin_preferences';

		if(isset($plugin_version))
		{
			self::$version = $plugin_version;
		}
		if(isset($plugin_stand))
		{
			self::$stand = $plugin_stand;
		}
		if(isset($dbtoken))
		{
			self::$dbtoken = $dbtoken;
		}
		$this->config_default = $config_default;
	}
	
	// prüft, ob die Konfigurationstabelle existiert, legt sie ggf. an und befüllt sie mit Standardwerten
	public function init()
	{
		global $gL10n, $gDb, $gCurrentOrganization,$gProfileFields;
	
		$config_ist = array();
		
		// pruefen, ob es die Tabelle bereits gibt
		$sql = 'SHOW TABLES LIKE \''.$this->table_name.'\' ';
   	 	$result = $gDb->query($sql);
    
    	// Tabelle anlegen, wenn es sie noch nicht gibt
    	if (!$gDb->num_rows($result))
    	{
    		// Tabelle ist nicht vorhanden --> anlegen
        	$sql = 'CREATE TABLE '.$this->table_name.' (
            	plp_id 		integer     unsigned not null AUTO_INCREMENT,
            	plp_org_id 	integer   	unsigned not null,
    			plp_name 	varchar(255) not null,
            	plp_value  	text, 
            	primary key (plp_id) )
            	engine = InnoDB
         		auto_increment = 1
          		default character set = utf8
         		collate = utf8_unicode_ci';
    		$gDb->query($sql);
    	} 
    
		$this->read();
	
		// Update/Konvertierungsroutine
		if (isset($this->config['Rollenpruefung']['bezugskategorie']) && $this->config['Rollenpruefung']['bezugskategorie'] == '')
    	{
    		$this->config['Rollenpruefung']['bezugskategorie'][0] = ' ';
    	} 	
		// Ende Update/Konvertierungsroutine
		
		$this->config['Plugininformationen']['version'] = self::$version;
		$this->config['Plugininformationen']['stand'] = self::$stand;
	
		// die eingelesenen Konfigurationsdaten in ein Arbeitsarray kopieren
		$config_ist = $this->config;
	
		// die Default-config durchlaufen
		foreach($this->config_default as $section => $sectiondata)
    	{
        	foreach($sectiondata as $key => $value)
        	{
        		// gibt es diese Sektion bereits in der config?
        		if (isset($config_ist[$section][$key]))
        		{
        			// wenn ja, diese Sektion in der Ist-config löschen
        			unset($config_ist[$section][$key]);
        		}
        		else
        		{
        			// wenn nicht, diese Sektion in der config anlegen und mit den Standardwerten aus der Soll-config befüllen
        			$this->config[$section][$key]=$value;
        		}
        	}
        	// leere Abschnitte (=leere Arrays) löschen
        	if ((isset($config_ist[$section]) && count($config_ist[$section])==0))
        	{
        		unset($config_ist[$section]);
        	}
    	}
    
    	// die Ist-config durchlaufen 
    	// jetzt befinden sich hier nur noch die DB-Einträge, die nicht verwendet werden und deshalb: 
    	// 1. in der DB gelöscht werden können
    	// 2. in der normalen config gelöscht werden können
		foreach($config_ist as $section => $sectiondata)
    	{
    		foreach($sectiondata as $key => $value)
        	{
        		$plp_name = self::$shortcut.'__'.$section.'__'.$key;
				$sql = 'DELETE FROM '.$this->table_name.'
        				WHERE plp_name = \''.$plp_name.'\' 
        				AND plp_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
				$gDb->query($sql);
				unset($this->config[$section][$key]);
        	}
			// leere Abschnitte (=leere Arrays) löschen
        	if (count($this->config[$section])==0)
        	{
        		unset($this->config[$section]);
        	}
    	}

    	// die aktualisierten und bereinigten Konfigurationsdaten in die DB schreiben 
  		$this->save();
	}

	// Funktion schreibt die Konfiguration in die Datenbank
	public function save()
	{
    	global $gDb, $gCurrentOrganization;
    
    	foreach($this->config as $section => $sectiondata)
    	{
        	foreach($sectiondata as $key => $value)
        	{
            	if (is_array($value))
            	{
                	// um diesen Datensatz in der Datenbank als Array zu kennzeichnen, wird er von Doppelklammern eingeschlossen 
            		$value = '(('.implode(self::$dbtoken,$value).'))';
            	} 
            
  				$plp_name = self::$shortcut.'__'.$section.'__'.$key;
          
            	$sql = ' SELECT plp_id 
            			FROM '.$this->table_name.' 
            			WHERE plp_name = \''.$plp_name.'\' 
            			AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 		OR plp_org_id IS NULL ) ';
            	$result = $gDb->query($sql);
            	$row = $gDb->fetch_object($result);

            	// Gibt es den Datensatz bereits?
            	// wenn ja: UPDATE des bestehende Datensatzes  
            	if(isset($row->plp_id) AND strlen($row->plp_id) > 0)
            	{
                	$sql = 'UPDATE '.$this->table_name.' 
                			SET plp_value = \''.$value.'\' 
                			WHERE plp_id = '.$row->plp_id;   
                    
                	$gDb->query($sql);           
            	}
            	// wenn nicht: INSERT eines neuen Datensatzes 
            	else
            	{
  					$sql = 'INSERT INTO '.$this->table_name.' (plp_org_id, plp_name, plp_value) 
  							VALUES (\''.$gCurrentOrganization->getValue('org_id').'\' ,\''.self::$shortcut.'__'.$section.'__'.$key.'\' ,\''.$value.'\')'; 
            		$gDb->query($sql); 
            	}   
        	} 
    	}
	}

	// Funktion liest die Konfigurationsdaten aus der Datenbank
	public function read()
	{
    	global $gDb, $gCurrentOrganization;
     
		$sql = ' SELECT plp_id, plp_name, plp_value
             	FROM '.$this->table_name.'
             	WHERE plp_name LIKE \''.self::$shortcut.'__%\'
             	AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
		$result = $gDb->query($sql);
	
		while($row = $gDb->fetch_array($result))
		{
			$array = explode('__',$row['plp_name']);
		
			// wenn plp_value von ((  )) eingeschlossen ist, dann ist es als Array einzulesen
			if ((substr($row['plp_value'],0,2)=='((' ) && (substr($row['plp_value'],-2)=='))' ))
        	{
        		$row['plp_value'] = substr($row['plp_value'],2,-2);
        		$this->config[$array[1]] [$array[2]] = explode(self::$dbtoken,$row['plp_value']); 
        	}
        	else 
			{
            	$this->config[$array[1]] [$array[2]] = $row['plp_value'];
        	}
		}
	}

	//vergleicht die Angaben in der Datei version.php mit den Daten in der DB
	// Rückgaben: 	0 = kein Update erforderlich
	//				1 = Versionen von Stand und Datum sind unterschiedlich: Init-Routine durchlaufen
	//				2 = Struktur der DB unterschiedlich: Install-Routine durchlaufen
	public function checkforupdate()
	{
	 	global $gL10n, $gDb, $gCurrentOrganization,$gProfileFields;
	 	$ret = 0;
 	
	 	// pruefen, ob es die Konfigurationstabelle gibt
		$sql = 'SHOW TABLES LIKE \''.$this->table_name.'\' ';
   	 	$result = $gDb->query($sql);
    
    	if ($gDb->num_rows($result))
    	{
			$plp_name = self::$shortcut.'__Plugininformationen__version';
          
    		$sql = 'SELECT plp_value 
            		FROM '.$this->table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
            	    	OR plp_org_id IS NULL ) ';
    		$result = $gDb->query($sql);
    		$row = $gDb->fetch_object($result);

    		// Vergleich Version.php  ./. DB (hier: version)
    		if(!isset($row->plp_value) || strlen($row->plp_value) == 0 || $row->plp_value<>self::$version)
    		{
    			$ret = 1;    
    		}
	
    		$plp_name = self::$shortcut.'__Plugininformationen__stand';
          
    		$sql = 'SELECT plp_value 
            		FROM '.$this->table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 		OR plp_org_id IS NULL ) ';
    		$result = $gDb->query($sql);
    		$row = $gDb->fetch_object($result);

    		// Vergleich Version.php  ./. DB (hier: stand)
    		if(!isset($row->plp_value) || strlen($row->plp_value) == 0 || $row->plp_value<>self::$stand)
    		{
    			$ret = 1;    
    		}
    	}
    	else  		// nein, Konfigurationstabelle fehlt komplett, deshalb Neuinstallation
    	{
    		$ret = 2; 
    	}
			    
    	// einen Suchstring für die SQL-Abfrage aufbereiten
		$fieldsarray = array();
		$fieldsarray[]	 = 'MEMBERNUMBER';
		$fieldsarray[]	 = 'BEITRITT'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'BEITRAG'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'BEZAHLT'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'DUEDATE'.$gCurrentOrganization->getValue('org_id');                        
		$fieldsarray[]	 = 'MANDATEID'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'MANDATEDATE'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id');
		$fieldsarray[]	 = 'KONTONUMMER';
		$fieldsarray[]	 = 'BANKLEITZAHL';
		$fieldsarray[]	 = 'IBAN';
		$fieldsarray[]	 = 'BIC';
		$fieldsarray[]	 = 'BANKNAME';        
		$fieldsarray[]	 = 'KONTOINHABER';
		$fieldsarray[]	 = 'DEBTORADDRESS';
		$fieldsarray[]	 = 'DEBTORPOSTCODE';
		$fieldsarray[]	 = 'DEBTORCITY'; 
		$fieldsarray[]	 = 'DEBTOREMAIL';
		$fieldsarray[]	 = 'ORIGDEBTORAGENT';
		$fieldsarray[]	 = 'ORIGIBAN' ;
		
		$fieldsString ='';
		foreach ($fieldsarray as $string)
		{
			$fieldsString .="'".$string."',";
		}
		$fieldsString = substr($fieldsString, 0, -1); 

    	// pruefen, ob alle erforderlichen Profilfelder des Plugins vorhanden sind
    	$sql = 'SELECT DISTINCT usf_id 
            		FROM '.TBL_USER_FIELDS.' , '. TBL_CATEGORIES.  '
            		WHERE usf_name_intern IN ('.$fieldsString.')
            		AND (  cat_org_id = '. $gCurrentOrganization->getValue('org_id'). '
			OR cat_org_id IS NULL ) ';
    		$result = $gDb->query($sql);

		if($gDb->num_rows() <> sizeof($fieldsarray))
		{
			$ret = 2; 
		}	
    
    	return $ret;
	}
	
	// Funktion löscht die Konfigurationsdaten in der Datenbank
	public function delete_config_data($deinst_org_select)
	{
    	global $gDb, $gCurrentOrganization,$gL10n;
 	
    	$result_sum = '';		
		$result_data=false;
		$result_db = false;
		
		if($deinst_org_select==0)                    //0 = Daten nur in aktueller Org löschen 
		{
			$sql = 'DELETE FROM '.$this->table_name.'
        			WHERE plp_name LIKE \''.self::$shortcut.'__%\'
        			AND plp_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
			$result_data = $gDb->query($sql);		
		}
		elseif ($deinst_org_select==1)              //1 = Daten in allen Org löschen 
		{
			$sql = 'DELETE FROM '.$this->table_name.'
        			WHERE plp_name LIKE \''.self::$shortcut.'__%\' ';
			$result_data = $gDb->query($sql);		
		}

		// wenn die Tabelle nur Einträge dieses Plugins hatte, sollte sie jetzt leer sein und kann gelöscht werden
		$sql = 'SELECT * FROM '.$this->table_name.' ';
		$result = $gDb->query($sql);

    	if($gDb->num_rows($result) ==0)
    	{
        	$sql = 'DROP TABLE '.$this->table_name.' ';
        	$result_db = $gDb->query($sql);
    	}
    	
    	$result_sum  = ($result_data ? $gL10n->get('PMB_DEINST_DATA_DELETE_SUCCESS') : $gL10n->get('PMB_DEINST_DATA_DELETE_ERROR') );
		$result_sum .= ($result_db ? $gL10n->get('PMB_DEINST_TABLE_DELETE_SUCCESS') : $gL10n->get('PMB_DEINST_TABLE_DELETE_ERROR') );
		
		return $result_sum;
	}

	// Funktion löscht die Nutzerdaten in der Datenbank
	public function delete_member_data($deinst_org_select, $dataField, $dataDesc)
	{
    	global $gDb, $gCurrentOrganization,$gL10n,$gProfileFields;

    	$result_sum = '';
    	$result_data=false;
    	$result_logdata=false;
    	$result_listdata=false;
    	$result_profilefield=false;
    	$result_category=false;
    	$usfIDs=array();
    	
    	
    	if($deinst_org_select==0)                    //0 = Daten nur in aktueller Org löschen 
		{
			$orgSelector = $gCurrentOrganization->getValue('org_id');
		}
		elseif ($deinst_org_select==1)              //1 = Daten in allen Org löschen 
		{
			$orgSelector = '%';
			//$orgSelector = '_';
		}
		else 										// else: übergebenes Datenfeld ist nicht Org-gebunden (ohne Org-ID, NULL)
		{
			$orgSelector = '';
		}
    	
		// alle usf_id´s des übergebenen $dataField einlesen
		$sql = 'SELECT usf_id, usf_name, usf_name_intern,usf_cat_id, cat_name,cat_name_intern FROM '.TBL_USER_FIELDS.', '.TBL_CATEGORIES.'
				WHERE usf_name_intern LIKE  \''.$dataField.$orgSelector.'\'
				AND  usf_cat_id=cat_id  ';
		$result = $gDb->query($sql);
		
		// ein Array befüllen
    	while( $row = $gDb->fetch_array($result))
		{
			$usfIDs[$row['usf_id']]['usf_id'] = $row['usf_id'];
			$usfIDs[$row['usf_id']]['usf_name'] = $row['usf_name'];
			$usfIDs[$row['usf_id']]['usf_name_intern'] = $row['usf_name_intern'];
			$usfIDs[$row['usf_id']]['usf_cat_id'] = $row['usf_cat_id'];
			$usfIDs[$row['usf_id']]['cat_name'] = $row['cat_name'];
			$usfIDs[$row['usf_id']]['cat_name_intern'] = $row['cat_name_intern'];
		}	
		
		$result_sum .= '<BR><EM>'.$dataDesc.'</EM>';
		
		// das Array durchlaufen und DELETE ausführen
		foreach ($usfIDs as $dummy => $data)
		{
			$sql = 'SELECT * FROM '.TBL_USER_DATA.'
			WHERE usd_usf_id = '.$data['usf_id'];
			$result = $gDb->query($sql);

    		if($gDb->num_rows($result) <>0)
    		{
    			$sql = 'DELETE FROM '.TBL_USER_DATA.'
            			WHERE usd_usf_id = '.$data['usf_id'];
    			$result_data = $gDb->query($sql);
    			$result_sum .= '<BR>'.$gL10n->get('PMB_DELETE_DATA_FROM').' '.$data['usf_name_intern'].' in '.TBL_USER_DATA.' - Status: '.($result_data ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );
    			//$result_sum .='<BR>';
    		}
    		
			$sql = 'SELECT * FROM '.TBL_USER_LOG.'
			WHERE usl_usf_id = '.$data['usf_id'];
			$result = $gDb->query($sql);

    		if($gDb->num_rows($result) <>0)
    		{
    			$sql = 'DELETE FROM '.TBL_USER_LOG.'
            		WHERE usl_usf_id = '.$data['usf_id'];
   				$result_logdata = $gDb->query($sql);
   				$result_sum .= '<BR>'.$gL10n->get('PMB_DELETE_DATA_FROM').' '.$data['usf_name_intern'].' in '.TBL_USER_LOG.' - Status: '.($result_logdata ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );
    			//$result_sum .='<BR>';
    		}
    		
			$sql = 'SELECT * FROM '.TBL_LIST_COLUMNS.'
				WHERE lsc_usf_id = '.$data['usf_id'];
			$result = $gDb->query($sql);

    		if($gDb->num_rows($result) <>0)
    		{
    			$sql = 'DELETE FROM '.TBL_LIST_COLUMNS.'
            		WHERE lsc_usf_id = '.$data['usf_id'];
   				$result_listdata = $gDb->query($sql);
   				$result_sum .= '<BR>'.$gL10n->get('PMB_DELETE_DATA_FROM').' '.$data['usf_name_intern'].' in '.TBL_LIST_COLUMNS.' - Status: '.($result_listdata ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );
    			//$result_sum .='<BR>';
    		}
 
        	$sql = 'DELETE FROM '.TBL_USER_FIELDS.'
            		WHERE usf_id = '.$data['usf_id'];
        	$result_profilefield = $gDb->query($sql);
        	
        	$result_sum .= '<BR>'.$gL10n->get('PMB_REMOVE_PROFILEFIELD').' '.$data['usf_name_intern'].' in '.TBL_USER_FIELDS.' - Status: '.($result_profilefield ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );
        		
        	$sql = 'SELECT * FROM '.TBL_USER_FIELDS.'
				    WHERE usf_cat_id = '.$data['usf_cat_id'];
			$result = $gDb->query($sql);
			if($gDb->num_rows($result) ==0)
    		{
    				$sql = 'DELETE FROM '.TBL_CATEGORIES.'
            			WHERE cat_id = '.$data['usf_cat_id'];
        			$result_category = $gDb->query($sql);
        	
        			$result_sum .= '<BR>'.$gL10n->get('PMB_REMOVE_CATEGORY').' '.$data['cat_name_intern'].' in '.TBL_CATEGORIES.' - Status: '.($result_category ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );
    		}			
		}
		$result_sum  .= '<BR>';
		
		return $result_sum;
	}
	
    public function delete_mail_data($deinst_org_select)
	{
    	global $gDb, $gCurrentOrganization,$gL10n;
 	
    	$result_sum = '';		
		$result_data=false;
		
		if($deinst_org_select==0)                    //0 = Daten nur in aktueller Org löschen 
		{
			$sql = 'DELETE FROM '.TBL_TEXTS.'
        			WHERE txt_name LIKE \'PMBMAIL_%\'
        			AND txt_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
			$result_data = $gDb->query($sql);		
		}
		elseif ($deinst_org_select==1)              //1 = Daten in allen Org löschen 
		{
			$sql = 'DELETE FROM '.TBL_TEXTS.'
        			WHERE txt_name LIKE \'PMBMAIL_%\' ';
			$result_data = $gDb->query($sql);		
		}

		$result_sum .= '<BR><EM>'.$gL10n->get('PMB_MAIL_TEXTS').'</EM>';
    	
  		$result_sum .= '<BR>'.$gL10n->get('PMB_DELETE_MAIL_TEXTS').TBL_LIST_COLUMNS.' - Status: '.($result_data ? $gL10n->get('PMB_DELETED') : $gL10n->get('PMB_ERROR') );

		return $result_sum;
	}
}

?>