<?php
/******************************************************************************
 * 
 * common_function.php
 *   
 * Gemeinsame Funktionen fuer das Admidio-Plugin Kategoriereport
 * 
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);
 
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_category.php');

// Funktion prueft, ob ein User die uebergebene Rolle besitzt
// $role_id   - ID der zu pruefenden Rolle
// $user_id   - ID des Users, fuer den die Mitgliedschaft geprueft werden soll
function hasRole_IDPKR($role_id, $user_id = 0)
{
    global $gCurrentUser, $gDb, $gCurrentOrganization;

    if($user_id == 0)
    {
        $user_id = $gCurrentUser->getValue('usr_id');
    }
    elseif(is_numeric($user_id) == false)
    {
        return -1;
    }

    $sql    = 'SELECT mem_id
                FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                WHERE mem_usr_id = '.$user_id.'
                AND mem_begin <= \''.DATE_NOW.'\'
                AND mem_end    > \''.DATE_NOW.'\'
                AND mem_rol_id = rol_id
                AND rol_id   = \''.$role_id.'\'
                AND rol_valid  = 1 
                AND rol_cat_id = cat_id
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
    $result = $gDb->query($sql);

    $user_found = $gDb->num_rows($result);

    if($user_found == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Funktion liest die Role-ID einer Rolle aus
// $role_name - Name der zu pruefenden Rolle
function getRole_IDPKR($role_name)
{
    global $gDb, $gCurrentOrganization;
	
    $sql    = 'SELECT rol_id
                 FROM '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                 WHERE rol_name   = \''.$role_name.'\'
                 AND rol_valid  = 1 
                 AND rol_cat_id = cat_id
                 AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR cat_org_id IS NULL ) ';
                      
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    return $row->rol_id ;
}

// Funktion prueft, ob der Nutzer, aufgrund seiner Rollenzugehörigkeit, berechtigt ist das Plugin aufzurufen
// Parameter: Array mit Rollen-IDs
// entweder $config_ini['Pluginfreigabe']['freigabe'] oder $config_ini['Pluginfreigabe']['freigabe_config']
function check_showpluginPKR($array)
{
    $showPlugin = false;

    foreach ($array AS $i)
    {
        if(hasRole_IDPKR($i))
        {
            $showPlugin = true;
        } 
    } 
    return $showPlugin;
}

// Funktion überprüft den übergebenen Namen, ob er gemaess den Namenskonventionen für
// Profilfelder und Kategorien zum Uebersetzen durch eine Sprachdatei geeignet ist
// Bsp: SYS_COMMON --> Rueckgabe true
// Bsp: Mitgliedsbeitrag --> Rueckgabe false
function check_languagePKR($field_name)
{
    $ret = false;
 
    //prüfen, ob die ersten 3 Zeichen von $field_name Grußbuchstaben sind
    //prüfen, ob das vierte Zeichen von $field_name ein _ ist

    //Prüfung entfällt: prüfen, ob die restlichen Zeichen von $field_name Grußbuchstaben sind
    //if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')  && (ctype_upper(substr($field_name,4)))   )

    if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')   )
    {
      $ret = true;
    }
    return $ret;
}

// erzeugt die Anzeigeliste für den Report
function erzeuge_listePKR()
{
	global $gDb, $gL10n, $gProfileFields, $gCurrentOrganization, $config_ini;

	// alle Kategorien der aktuellen Organisation einlesen
	$categories = array();
	$sql = ' SELECT cat.cat_name, cat.cat_id
             FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
             WHERE cat.cat_type = \'ROL\' 
             AND cat.cat_id = rol.rol_cat_id
             AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
               OR cat.cat_org_id IS NULL )';
	
	$result = $gDb->query($sql);

	while ($row = $gDb->fetch_array($result))
	{
		// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        if(check_languagePKR($row['cat_name']))
        {
        	$row['cat_name'] = $gL10n->get($row['cat_name']);
        }
		$categories[$row['cat_id']]['Kategoriename'] = $gL10n->get('SYS_CATEGORY').': '.$row['cat_name'] ;
		$categories[$row['cat_id']]['Rollen'] = array();
	}
 
	// alle eingelesenen Kategorien durchlaufen und die Rollen dazu einlesen
  	foreach ($categories as $catid => $dummy)
	{
        $sql = 'SELECT rol.rol_name, rol.rol_id
                FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                WHERE cat.cat_id = \''.$catid.'\'
                AND cat.cat_id = rol.rol_cat_id';
    	$result = $gDb->query($sql);
        while($row = $gDb->fetch_array($result))
        {
            $categories[$catid]['Rollen'][$row['rol_id']] = array();
            
            $categories[$catid]['Rollen'][$row['rol_id']]['name'] = $gL10n->get('SYS_ROLE').': '.$row['rol_name'];
            $categories[$catid]['Rollen'][$row['rol_id']]['members'] = array();
            
            // neu Leiter einlesen
            $categories[$catid]['Rollen'][$row['rol_id']]['leader_role'] = $gL10n->get('SYS_LEADER').': '.$row['rol_name'];
            $categories[$catid]['Rollen'][$row['rol_id']]['leader'] = array();
        }
        
        // zu jeder Rolle auch die Mitglieder einlesen
        foreach($categories[$catid]['Rollen'] as $rolid => $dummy)
        {
            $sql = 'SELECT mem.mem_usr_id, mem.mem_leader
                    FROM '.TBL_MEMBERS.' as mem, '.TBL_ROLES.' as rol
                    WHERE mem.mem_rol_id = rol.rol_id
                    AND mem.mem_end = \'9999-12-31\'
                    AND rol.rol_id = '.$rolid;
        	$result = $gDb->query($sql);
            while($row = $gDb->fetch_array($result))
            {
                $categories[$catid]['Rollen'][$rolid]['members'][] = $row['mem_usr_id']; 
            	if($row['mem_leader'])
            	{
                	$categories[$catid]['Rollen'][$rolid]['leader'][] = $row['mem_usr_id']; 
                }
            }
        }  
    }

	// alle Mitglieder der aktuellen Organisation einlesen
	$members = array();
	$sql = ' SELECT mem.mem_usr_id, mem.mem_begin
             FROM '.TBL_MEMBERS.' as mem, '.TBL_ROLES.' as rol, '. TBL_CATEGORIES. ' as cat
             WHERE mem.mem_rol_id = rol.rol_id
             AND rol.rol_valid  = 1   
             AND rol.rol_cat_id = cat.cat_id
             AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
               OR cat.cat_org_id IS NULL )
             AND mem.mem_end = \'9999-12-31\' ';
	
	$result = $gDb->query($sql);
	while($row = $gDb->fetch_array($result))
	{
		$members[$row['mem_usr_id']] = array();
	}
        
    //alle Attribute der Mitglieder einlesen
    $attributes = array();    
    foreach($gProfileFields->mProfileFields as $field)
    {    
		//falls ein Profilfeld öfters vorhanden ist, den Kategorienamen in Klammern anfügen
    	if (array_key_exists($field->getValue('usf_name'),$attributes))
    	{
    		$attributes[$field->getValue('usf_name').' ('.$field->getValue('cat_name').')'] = $field->getValue('usf_id');
    	}
    	else 
    	{
    		$attributes[$field->getValue('usf_name')] = $field->getValue('usf_id');
    	}
    }   
   
    // alle Mitlieder durchlaufen   ...
    foreach ($members as $member => $dummy)
	{ 
		foreach ($attributes as $attribute => $usf_id) 
        {
            $sql = 'SELECT usd_value
                    FROM '.TBL_USER_DATA.'
                    WHERE usd_usr_id = \''.$member.'\'
                    AND usd_usf_id = '.$usf_id;
			$result = $gDb->query($sql);
			$row = $gDb->fetch_array($result);
			
			$members[$member][$attribute] = $row['usd_value'];
		}

		// prüfen, ob das Mitglied Angehöriger einer Rolle ist
        foreach ($categories as $categorie => $catdata) 
        {
            $cattext = $config_ini['Spalten']['anzeige_nein'];
            
            // diese Zeile müsste nicht sein, aber damit im Menü Einstellungen
            // die Kategorie vor den Rollen steht, muß sie auch vor den Rollen definiert sein
            $members[$member][$catdata['Kategoriename']] = $cattext;	
            
    		foreach ($categories[$categorie]['Rollen'] as $catrol=> $catroldata)
            {
               if(in_array($member,$catroldata['members']) )
                {
                    $roltext = $config_ini['Spalten']['anzeige_ja'];
                    $cattext = $config_ini['Spalten']['anzeige_ja'];
            	}
                else
                {
                    $roltext =  $config_ini['Spalten']['anzeige_nein'];
                }
                $members[$member][$catroldata['name']] = $roltext;
        	}
	     	
	     	//für die Anzeige des Leiters
        	foreach ($categories[$categorie]['Rollen'] as $catrol=> $catroldata)
            {
               if(in_array($member,$catroldata['leader']) )
                {
                    $roltext = $config_ini['Spalten']['anzeige_ja'];
            	}
                else
                {
                    $roltext =  $config_ini['Spalten']['anzeige_nein'];
                }
                $members[$member][$catroldata['leader_role']] = $roltext;
        	}
        	$members[$member][$catdata['Kategoriename']] = $cattext;	
		}
	}   
    return $members;
} 

//Die Funktion überprüft die Länge von $tmpString für die Anzeige in Select-Boxen
//Autor: guenter47
//$tmpString = zu überprüfender String
//$maxStrLength = maximale Länge, die noch in die Selectbox passt
//Beispiel: Das ist ein sehr langer Text
//Rückgabe: Das ist ein se ... Text
function checkStringLengthPKR($tmpString, $maxStrLength)
{
	// Mindestlaenge vorgeben, ansonsten gibt es Ueberlappungen im neuen String 
	if ($maxStrLength<20)
	{
		$maxStrLength=20;
	}
    if(strlen($tmpString)>$maxStrLength)
    {
        $strPart1=substr($tmpString,0,$maxStrLength-20);
        $strPart2=substr($tmpString,strlen($tmpString)-15);
        $newString=$strPart1."...".$strPart2;
    }
    else
    {
        $newString=$tmpString;
    }
    return $newString;
}

// prüft, ob die Konfigurationstabelle existiert und legt sie ggf. an
function initConfigTablePKR()
{
	global $gL10n, $gDb, $gCurrentOrganization, $g_tbl_praefix;
	
	$config_ini = array();
	$table_name = $g_tbl_praefix.'_plugin_preferences';
	
	// pruefen, ob es die Tabelle bereits gibt
	$sql = 'SHOW TABLES LIKE \''.$table_name.'\' ';
    $result = $gDb->query($sql);
    
    // Tabelle anlegen, wenn es sie noch nicht gibt
    if (!$gDb->num_rows($result))
    {
    	// Tabelle ist nicht vorhanden --> anlegen
        $sql = 'CREATE TABLE '.$table_name.' (
            plp_id 		integer     unsigned not null AUTO_INCREMENT,
            plp_org_id 	integer   	unsigned not null,
    		plp_name 	varchar(255) not null,
            plp_value  	text, 
            primary key (plp_id) )
            engine = InnoDB
         	auto_increment = 1
          	default character set = utf8
         	collate = utf8_unicode_ci';
    	$gDb->query($sql);
    } 
    
    // Konfiguration einlesen
	$config_ini = readConfigTablePKR();

	// überprüfen, ob bereits Konfigurationsdaten gesetzt sind, wenn nicht: vorbelegen
	// Pluginfreigabe
	if (!isset($config_ini['Pluginfreigabe']['freigabe']))
    {
		$config_ini['Pluginfreigabe']['freigabe'] = array(getRole_IDPKR($gL10n->get('SYS_WEBMASTER')),getRole_IDPKR($gL10n->get('SYS_MEMBER')));    		
    }
	if (!isset($config_ini['Pluginfreigabe']['freigabe_config']))
    {
		$config_ini['Pluginfreigabe']['freigabe_config'] = array(getRole_IDPKR($gL10n->get('SYS_WEBMASTER')),getRole_IDPKR($gL10n->get('SYS_MEMBER')));    		
    }
    
    // Spalten
    if (!isset($config_ini['Spalten']['freigabe']))
    {
		$config_ini['Spalten']['freigabe'] = array($gL10n->get('SYS_FIRSTNAME'),$gL10n->get('SYS_LASTNAME'));    		
    }
    if (!isset($config_ini['Spalten']['anzeige_ja']))
    {
		$config_ini['Spalten']['anzeige_ja'] = 'ja';    		
    }
    if (!isset($config_ini['Spalten']['anzeige_nein']))
    {
		$config_ini['Spalten']['anzeige_nein'] = 'nein';    		
    }  
       
    // Optionen
    if (!isset($config_ini['Optionen']['export_feldtrenner']))
    {
		$config_ini['Optionen']['export_feldtrenner'] = ';';    		
    } 
    if (!isset($config_ini['Optionen']['export_dateiendung']))
    {
		$config_ini['Optionen']['export_dateiendung'] = 'csv';    		
    }  
    if (!isset($config_ini['Optionen']['export_zeichensatz']))
    {
		$config_ini['Optionen']['export_zeichensatz'] = 'ISO-8859-1';    		
    }           
    if (!isset($config_ini['Optionen']['select_maxlength']))
    {
		$config_ini['Optionen']['select_maxlength'] = 50;    		
    }  
    if (!isset($config_ini['Optionen']['dbtoken']))
    {
		$config_ini['Optionen']['dbtoken'] = '#_#';    		
    }   
    // $config_ini in die Tabelle schreiben
  	writeConfigTablePKR($config_ini); 
       
    return;
}

// Funktion schreibt die $config_ini in die Datenbank
function writeConfigTablePKR($config_ini)
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
    
    foreach($config_ini as $section => $sectiondata)
    {
        foreach($sectiondata as $key => $value)
        {
            if (is_array($value))
            {
                // um diesen Datensatz in der Datenbank als Array zu kennzeichnen, wird er von Doppelklammern eingeschlossen 
            	$value = '(('.implode($config_ini['Optionen']['dbtoken'],$value).'))';
            } 
            
  			$plp_name = 'PKR__'.$section.'__'.$key;
          
            $sql = ' SELECT plp_id 
            		FROM '.$table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
            $result = $gDb->query($sql);
            $row = $gDb->fetch_object($result);

            // Gibt es den Datensatz bereits?
            // wenn ja: UPDATE des bestehende Datensatzes  
            if(isset($row->plp_id) AND strlen($row->plp_id) > 0)
            {
                $sql = 'UPDATE '.$table_name.' 
                		SET plp_value = \''.$value.'\' 
                		WHERE plp_id = '.$row->plp_id;   
                    
                $gDb->query($sql);           
            }
            // wenn nicht: INSERT eines neuen Datensatzes 
            else
            {
  				$sql = 'INSERT INTO '.$table_name.' (plp_org_id, plp_name, plp_value) 
  						VALUES (\''.$gCurrentOrganization->getValue('org_id').'\' ,\'PKR__'.$section.'__'.$key.'\' ,\''.$value.'\')'; 
            	$gDb->query($sql); 
            }   
        } 
    }
    return ;
}

// Funktion liest die Konfigurationsdaten aus der Datenbank
function readConfigTablePKR()
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
    $config_ini = array();
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
 	
 	// im ersten Schritt das Token einlesen
 	$sql = ' SELECT plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PKR__Optionen__dbtoken\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
 	$result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);
    $dbtoken =  isset($row->plp_value) ? $row->plp_value : '#_#' ;
     
	$sql = ' SELECT plp_id, plp_name, plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PKR__%\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
	$result = $gDb->query($sql);
	
	while($row = $gDb->fetch_array($result))
	{
		$array = explode('__',$row['plp_name']);
		
		// wenn plp_value von ((  )) eingeschlossen ist, dann ist es als Array einzulesen
		if ((substr($row['plp_value'],0,2)=='((' ) && (substr($row['plp_value'],-2)=='))' ))
        {
        	$row['plp_value'] = substr($row['plp_value'],2,-2);
        	$config_ini[$array[1]] [$array[2]] = explode($dbtoken,$row['plp_value']); 
        }
        else 
		{
            $config_ini[$array[1]] [$array[2]] = $row['plp_value'];
        }
	}
    return $config_ini;
}
?>