<?php
 /******************************************************************************
 * kategoriereport_show
 *
 * Hauptprogramm fuer das Admidio-Plugin Kategoriereport
 *
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html  
 *   
 * Uebergaben:
 *
 * mode    : Ausgabeart   (html, print, csv-ms, csv-oo)
 * start   : Angabe, ab welchem Datensatz Mitglieder angezeigt werden sollen
 *  
 *****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

require_once($plugin_path. '/../adm_program/system/common.php');
require_once($plugin_path. '/../adm_program/system/classes/list_configuration.php');
require_once($plugin_path. '/../adm_program/system/classes/table_roles.php');
require_once($plugin_path. '/'.$plugin_folder.'/common_function.php');  

// DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
$gDb->setCurrentDB();

// Konfiguration einlesen
$config_ini = readConfigTablePKR();

// überprüfen, ob der angemeldete User berechtigt ist das Plugin aufzurufen
$showPlugin = check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe']);

// funktioniert nur, wenn SafeMode = Off
//set_time_limit(300);

// wenn Benutzer keine Rechte hat, dann Fehler ausgeben und beenden
if($showPlugin == false)
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

// lokale Variablen der Uebergabevariablen initialisieren
$arr_mode   = array('csv', 'html', 'print');
$req_start  = 0;
$charset    = '';
$separator    = '';
$fileextension='';

// Uebergabevariablen pruefen
$req_mode   = strStripTags($_GET['mode']);

if(in_array($req_mode, $arr_mode) == false)
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

if(isset($_GET['start']))
{
    if(is_numeric($_GET['start']) == false)
    {
        $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
    }
    $req_start = $_GET['start'];
}

if($req_mode == 'csv')
{
    $separator    = $config_ini['Optionen']['export_feldtrenner'];
    $fileextension= $config_ini['Optionen']['export_dateiendung'];
	$charset      = $config_ini['Optionen']['export_zeichensatz'];
}
else if($req_mode == 'html')
{
    $class_table           = 'tableList';
    $class_sub_header      = 'tableSubHeader';
    $class_sub_header_font = 'tableSubHeaderFont';
}
else if($req_mode == 'print')
{
    $class_table           = 'tableListPrint';
    $class_sub_header      = 'tableSubHeaderPrint';
    $class_sub_header_font = 'tableSubHeaderFontPrint';
}

//die Anzeigeliste erzeugen und in ein Array einlesen
$members = erzeuge_listePKR();

// enthaelt spaeter die komplette CSV-Datei als String
$str_csv   = ''; 
  
$align = 'center';

$num_members = count($members);

if($num_members == 0)
{
    // Es sind keine Daten vorhanden !
    $gMessage->show($gL10n->get('LST_NO_USER_FOUND'));
}

if($num_members < $req_start)
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

if($req_mode == 'html' && $req_start == 0)
{
    // Url fuer die Zuruecknavigation merken, aber nur in der Html-Ansicht
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);
}

if($req_mode != 'csv')
{
    // Html-Kopf wird geschrieben
    if($req_mode == 'print')
    {
    	header('Content-type: text/html; charset=utf-8');
        echo '
        <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
        <html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="de" xml:lang="de">
        <head>
            <!-- (c) 2004 - 2011 The Admidio Team - http://www.admidio.org -->
            
            <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        
            <title>'. $gCurrentOrganization->getValue('org_longname'). '</title>
            
            <link rel="stylesheet" type="text/css" href="'. THEME_PATH. '/css/print.css" />
            <script type="text/javascript" src="'. $g_root_path. '/adm_program/system/js/common_functions.js"></script>

            <style type="text/css">
                @page { size:landscape; }
            </style>
        </head>
        <body class="bodyPrint">';
    }
    else            
    {
        $gLayout['title']    = $gL10n->get('LST_LIST');
        $gLayout['includes'] = false;
        $gLayout['header']   = '
            <style type="text/css">
                body {
                    margin: 20px;
                }
            </style>';    
        require(SERVER_PATH. '/adm_program/system/overall_header.php');
    }
 
    echo '<h1 class="moduleHeadline">'.$gL10n->get('PKR_CATEGORY_REPORT').'</h1>';

    if($req_mode == 'html')
    {
        echo '<ul class="iconTextLinkList"> '; 

        echo '<li>
                <span class="iconTextLink">
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?&amp;mode=print&amp\', \'_blank\')"><img
                    src="'. THEME_PATH. '/icons/print.png" alt="'.$gL10n->get('LST_PRINT_PREVIEW').'" title="'.$gL10n->get('LST_PRINT_PREVIEW').'" /></a>
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?&amp;mode=print&amp\', \'_blank\')">'.$gL10n->get('LST_PRINT_PREVIEW').'</a>
                </span>
            </li> 
            <li>
                <span class="iconTextLink">
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?&amp;mode=csv&amp\', \'_blank\')"><img
                    src="'. THEME_PATH. '/icons/database_out.png" alt="'.$gL10n->get('PKR_EXPORT').'" title="'.$gL10n->get('PKR_EXPORT').'" /></a>
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?&amp;mode=csv&amp\', \'_blank\')">'.$gL10n->get('PKR_EXPORT').'</a>
                </span>
            </li>   
        </ul>';
    }
}

if($req_mode != 'csv')
{
    // Tabellenkopf schreiben
    echo '<table border rules=all class="'.$class_table.'" style="width: 95%;" cellspacing="0">
        <thead><tr>';       
}

// eine laufende Nummer davorsetzen
if($req_mode == 'csv')
{
    $str_csv = $str_csv. $gL10n->get('SYS_ABR_NO');
}
else
{                
    echo '<th style="text-align: '.$align.';">'.$gL10n->get('SYS_ABR_NO').'</th>';
}
     
//die Ueberschriften einlesen          
foreach($members as $member => $memberdata) 
{
    foreach($memberdata as $key => $data) 
    {
    	if(in_array($key,$config_ini['Spalten']['freigabe']))
        {          
        	if($req_mode == 'csv')
        	{            
            	$str_csv = $str_csv. $separator. $key;
        	}
        	else
        	{                            
            	echo '<th nowrap style="text-align: '.$align.';">'.$key.'</th>';
        	}
        }
    } 
    break;
}

if($req_mode == 'csv')
{
    $str_csv = $str_csv. "\n";
}
else
{
    echo '</tr></thead><tbody>';
}

if($req_mode == 'html' && $gPreferences['lists_members_per_page'] > 0)
{
    // Anzahl der Mitglieder, die auf einer Seite angezeigt werden
    $members_per_page = $gPreferences['lists_members_per_page'];     
}
else
{
    $members_per_page = $num_members;
}

$j = 0;
$k = 0;
$irow = $req_start + 1;  // Zaehler fuer die jeweilige Zeile


if($req_mode != 'csv')
{
    // die Daten einlesen
    foreach($members as $member => $memberdata) 
    {
        if($j > $req_start-1 && $k < $members_per_page)
        {   
	        // die laufende Nummer noch davorsetzen und mit einem Link versehen
            echo '<td style="text-align: '.$align.';"><a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $member. '">'.$irow.'</td>'; 
      
    		foreach($memberdata as $key => $data) 
            {
            	if(in_array($key,$config_ini['Spalten']['freigabe']))
        		{
                	// E-Mail-Adressen mit einem Link versehen
        		    if($key =='E-Mail' AND $data != '') // Mod DieterB
        		    {
                		echo '<td nowrap style="text-align: '.$align.';"><a href="mailto:'.$data.'">'.$data.'</a></td>';
        		    }
        		    else
        		    {
                	   echo '<td nowrap style="text-align: '.$align.';">'.$data.'</td>';
        		   	}
                } 
            } 
            echo '</tr>';
         $k++;   
         $irow++;
       }
       $j++;
    }
}
     
if($req_mode == 'csv')
{
    $irow = 1;
    //jetzt die Daten einlesen, aber nur bei csv
    foreach($members as $member => $memberdata) 
    {
        $str_csv = $str_csv. $irow;
            
		foreach($memberdata as $key => $data) 
        {
        	if(in_array($key,$config_ini['Spalten']['freigabe']))
        	{               
            	$str_csv = $str_csv. $separator. $data;
        	}
        } 
        $str_csv = $str_csv. "\n";

        $irow++;
    }
    
    // nun die erstellte CSV-Datei an den User schicken
    $filename = $g_organization.'-'.$gL10n->get('PKR_CATEGORY_REPORT').'.'.$fileextension;
    header('Content-Type: text/comma-separated-values; charset='.$charset);
    header('Content-Disposition: attachment; filename="'.$filename.'"');
	if($charset == 'ISO-8859-1')
	{
		echo utf8_decode($str_csv);
	}
	else
	{
		echo $str_csv;
	}
}
else
{
    echo '</tbody></table>';

    if($req_mode != 'print')
    {
        // Navigation mit Vor- und Zurueck-Buttons
        $base_url = $g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?mode='.$req_mode;
     
        echo admFuncGeneratePagination($base_url, $num_members, $members_per_page, $req_start, TRUE);
    }

    if($req_mode == 'print')
    {
        echo '</body></html>';
    }
    else
    {    
        echo '
        <ul class="iconTextLinkList">
            <li>
                <span class="iconTextLink">
                    <a href="'.$g_root_path.'/adm_program/system/back.php"><img 
                    src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                    <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
                </span>
            </li>
        </ul>';
    
        require(SERVER_PATH. '/adm_program/system/overall_footer.php');
    }
}

?>