<?php
/******************************************************************************
* 
* einstellungen.php
*   
* Erzeugt das Menue Einstellungen fuer das Admidio-Plugin Kategoriereport
* 
* Copyright    : (c) 2004 - 2013 The Admidio Team
* Homepage     : http://www.admidio.org
* License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
*
****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once($plugin_path. '/'.$plugin_folder.'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/version.php');

// Konfiguration einlesen
$config_ini = readConfigTablePKR();

// überprüfen, ob der angemeldete User berechtigt ist das Plugin aufzurufen
$showPlugin = check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe_config']);

// weiter nur, wenn der User berechtigt ist
if($showPlugin)
{
    // DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
    $gDb->setCurrentDB();

    //die Liste erzeugen und in ein array einlesen
	$members = erzeuge_listePKR();
    
    // Navigation faengt hier im Modul an
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);

    $html_icon_warning = '<img class="iconHelpLink" src="'.THEME_PATH.'/icons/warning.png" alt="'.$gL10n->get('SYS_WARNING').'" />';

    // zusaetzliche Daten fuer den Html-Kopf setzen
    $gLayout['title']  = $gL10n->get('PKR_CATEGORY_REPORT');
    $gLayout['header'] =  '
        <script type="text/javascript" src="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/einstellungen.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.core.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.widget.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.tabs.js" ></script>		
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.accordion.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.scrollTo.js" ></script>
        
        <script type="text/javascript"><!--
        var einstellungenJS = new einstellungenClass();
        $(document).ready(function()
            {einstellungenJS.init();
        });
        //--></script>
        <link rel="stylesheet" type="text/css" href="'.THEME_PATH.'/css/jquery.css">';

    // Html-Kopf ausgeben
    require(SERVER_PATH. '/adm_program/system/overall_header.php');

    echo '<h1 class="moduleHeadline">'.$gL10n->get('PKR_CATEGORY_REPORT').'</h1>

    <div class="formLayout" id="admOrganizationMenu">
        <div class="formBody">
            <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/menue_function.php" method="post">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-setup">'.$gL10n->get('PKR_SETTINGS').'</a></li>
                    </ul>
                    <div id="tabs-setup">
                        <div id="accordion-setup">';

                            /**************************************************************************************/
                            // Spalten
                            /**************************************************************************************/

                            echo '<h3 id="Spalten" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Spalten" title="'.$gL10n->get('PKR_COLUMN_CONTROL').'" /></a>
                                <a href="#">'.$gL10n->get('PKR_COLUMNS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PKR_COLUMN_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="spalten_freigabe[]" size="10" multiple>';
                            
													$freigegebene_spalten = array();
																			
													//die Überschriften einlesen          
													foreach($members as $member => $memberdata) 
													{
    													foreach($memberdata as $key => $data) 
    													{
                  											echo '<option value="'.$key.'"';
                  											if(in_array($key,$config_ini['Spalten']['freigabe']))
                                                        	{
                                                            	echo ' selected="selected"';	
                                                            	$freigegebene_spalten[] = $key; 
                                                        	} 
                  											echo '>'.checkStringLengthPKR($key,$config_ini['Optionen']['select_maxlength']).'</option>';
    													} 
    													break;
													}
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_COLUMN_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PKR_COLUMN_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="5">';
                                        			foreach ($freigegebene_spalten as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPKR($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="anzeigetext">'.$gL10n->get('PKR_DISPLAY_TEXT').':</label></dt>
                                            <dd>
                                            	<input type="text" id="anzeige_text_ja" name="anzeige_text_ja" style="width: 40px;" maxlength="40" value="'. $config_ini['Spalten']['anzeige_ja']. '" /> '.$gL10n->get('PKR_MEMBERSHIP_YES').'
                                            </dd>
                                            <BR>
                                            <dd>
                                            	<input type="text" id="anzeige_text_nein" name="anzeige_text_nein" style="width: 40px;" maxlength="40" value="'. $config_ini['Spalten']['anzeige_nein']. '" /> '.$gL10n->get('PKR_MEMBERSHIP_NO').'
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_DISPLAY_TEXT_DESC').'</li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="spalten"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Optionen
                            /**************************************************************************************/

                            echo '<h3 id="Optionen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Optionen" title="'.$gL10n->get('PKR_DISPLAY_TEXT').'" /></a>
                                <a href="#">'.$gL10n->get('PKR_OPTIONS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                        <dl>
                                            <dt><label for="fieldseparator">'.$gL10n->get('PKR_EXPORT_FIELDSEPARATOR').':</label></dt>
                                            <dd>
                                            	<input type="text" id="export_field_separator" name="export_field_separator" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['export_feldtrenner']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_EXPORT_FIELDSEPARATOR_DESC').'</li>
                                    <BR>
                                	<li>
                                        <dl>
                                            <dt><label for="fileextension">'.$gL10n->get('PKR_EXPORT_FILEEXTENSION').':</label></dt>
                                            <dd>
                                            	<input type="text" id="export_file_extension" name="export_file_extension" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['export_dateiendung']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_EXPORT_FILEEXTENSION_DESC').'</li>
                                    <BR>
                                	<li>
                                        <dl>
                                            <dt><label for="charset">'.$gL10n->get('PKR_EXPORT_CHARSET').':</label></dt>
                                          
           									<dd>
                                                <select name="export_charset" size="1">';                     
                                                    $token = array('ISO-8859-1','UTF-8' );
                                                    foreach ($token as $data)  
                                                    {
                                                        echo '<option value='.$data;
                                                        if(($data == $config_ini['Optionen']['export_zeichensatz'])      )
                                                        {
                                                            echo ' selected="selected" ';	
                                                        } 
                                                        echo '>'.$data.'</option>';		
                                                    }  
                                                echo '</select>              
                                            </dd>                                            
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_EXPORT_CHARSET_DESC').'</li>
                                    <BR>                                                                                                        
                                	<li>
                                        <dl>
                                            <dt><label for="maxlength">'.$gL10n->get('PKR_SELECT_MAXLENGTH').':</label></dt>
                                            <dd>
                                            	<input type="text" id="select__max_length" name="select_max_length" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['select_maxlength']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_SELECT_MAXLENGTH_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="dbtoken">'.$gL10n->get('PKR_DBTOKEN').':</label></dt>
                                            <dd>
                                            	<input type="text" id="dbtoken" name="dbtoken" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['dbtoken']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_DBTOKEN_DESC').'</li>
                                    <BR>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="optionen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Pluginfreigabe
                            /**************************************************************************************/

                            echo '<h3 id="Pluginfreigabe" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/lock.png" alt="Pluginfreigabe" title="'.$gL10n->get('PKR_SETUP_PLUGIN_CONTROL').'" /></a>
                                <a href="#">'.$gL10n->get('PKR_PLUGIN_CONTROL').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PKR_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePKR($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array(cat => $row['cat_name'],rol => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {
                                                            echo '<option value="" disabled="disabled">'.$gL10n->get('SYS_CATEGORY').' '.$data['cat'].'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPKR($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_ROLE_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PKR_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="5">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPKR($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                    <HR>
                                    <li>
                                        <dl>
                                        	<dt><label><strong>'.$gL10n->get('PKR_SETTINGS').'</strong></label></dt>
                                        	<BR>
                                        	<BR>
                                            <dt><label>'.$gL10n->get('PKR_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe_config[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePKR($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array(cat => $row['cat_name'],rol => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {
                                                            echo '<option value="" disabled="disabled">'.$gL10n->get('SYS_CATEGORY').' '.$data['cat'].'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe_config']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPKR($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PKR_ROLE_SELECTION_DESC2').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PKR_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPKR($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="pluginfreigabe"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

                            /**************************************************************************************/
                            // Plugininformationen
                            /**************************************************************************************/

                            echo '<h3 id="Plugininformationen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Plugininformationen" title="'.$gL10n->get('PKR_SETUP_PLUGIN_INFORMATION').'" /></a>
                                <a href="#">'.$gL10n->get('PKR_PLUGIN_INFORMATION').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">         
                                    <li>
                                        <dl>
                                            <dt><label for="Name des Plugins">'.$gL10n->get('PKR_PLUGIN_NAME').':</label></dt>
                                            <dd><label for="">'.$gL10n->get('PKR_CATEGORY_REPORT').'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Version">'.$gL10n->get('PKR_PLUGIN_VERSION').':</label></dt>
                                            <dd><label for="">'.$plugin_kr_version.'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Stand">'.$gL10n->get('PKR_PLUGIN_DATE').':</label></dt>
                                            <dd><label for="">'.$plugin_kr_stand.'</label></dd>
                                        </dl>
                                    </li>
                                </ul>
                                <br>
                            </div>';

                        // ENDE accordion-modules
                        echo'</div>
                    </div>
                </div>
            </form>
        </div>
    </div>';

    require(SERVER_PATH. '/adm_program/system/overall_footer.php');
}
?>