<?php
/******************************************************************************
 * Kategoriereport
 *
 * Version 1.3.2
 *
 * Dieses Plugin erzeugt eine Auflistung über alle Rollenzugehörigkeiten
 * eines Mitglieds.
 * Die erzeugte Liste wird in der bekannten Listenansicht angezeigt und kann
 * im Format .CSV heruntergeladen werden.
 * Die Daten werden angezeigt, wie sie in der Datenbank abgelegt sind, d.h.
 * es erfolgt keine Konvertierung (für männlich wird die Zahl 1 angezeigt, kein Symbol)
 *   
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * Author		: rmb
 * 
 * Version		: 1.3.2
 * Datum        : 17.10.2014
 * Änderung     : Für den Export sind diverse Parameter jetzt im Setup einstellbar
 * 
 * Version		: 1.3.1
 * Datum        : 23.09.2014
 * Änderung     : bei Namensgleichheit von Profilfeldern wird die Kategorie in Klammern angehängt 
 * 
 * Version		: 1.3.0
 * Datum        : 01.04.2013
 * Änderung     : - Anpassung an Admidio 2.4
 * 				  - Konfigurationsdaten werden nicht mehr in einer config.ini gespeichert,
 * 				    sondern in der Admidio Datenbank abgelegt
 *   			  - Das Menü Einstellungen kann separat über Berechtigungen angezeigt werden
 *   			  - Die Leiter von Rollen können ausgegeben werden
 * 				  - E-Mail-Adressen werden mit einem Link versehen (DieterB)
 * 				  - Englische Sprachdatei erstellt
 * 				  - Die Default-Einstellung der Pluginfreigabe wurde erweitert um die Rolle Mitglied     
 *
 * Version		: 1.2.1 
 * Datum        : 18.12.2012
 * Änderung     : - Setuproutine erstellt (Vorschlag im Forum durch guenter47: "Kategoriereport mit weniger Userspalten")
 * 				  - Die angezeigten Spalten sind frei wählbar (Vorschlag im Forum durch guenter47: "Kategoriereport mit weniger Userspalten")
 * 				  - Kleinere Änderungen eingepflegt
 * 				  - Funktion checkStringLenth von guenter47 eingearbeitet
 * 				  - In der Anzeige einen Link zum Userprofil eingearbeitet
 * 
 * Version		: 1.2.0 
 * Datum        : 21.02.2012
 * Änderung     : - das Plugin ist jetzt Admidio 2.3 kompatibel
 * 
 * Version		: 1.1.2
 * Datum        : 08.12.2011
 * Änderung     : - das Standard-Datenbankpräfix (adm_) ist nicht mehr fest kodiert
 *
 * Version		: 1.1.1  
 * Datum        : 21.11.2011                                
 * Änderung     : - Die Einschränkung in einer Abfrage (kategoriereport_show.php,
 *                  Zeile 412) auf nur Mitglieder der Rolle "Mitglied" wurde aufgehoben.   
 *                - Die Berechtigung das Plugin aufzurufen, wurde um 
 *                  Rollenmitgliedschaften erweitert.
 *                  
 * Version		: 1.1.0  
 * Datum        : 26.10.2011
 * Änderung     : Der gesamte Plugin wurde überarbeitet und an die in Admidio
 *                geführten Listen angepasst.
 *                Die erzeugte CSV-Datei wird nicht mehr auf dem Server 
 *                zwischengespeichert, sie wird in der Listenansicht zum
 *                Download angeboten. Das zusätzliche Plugin downloadfile.php
 *                wird nicht mehr benötigt. 
 *                     
 * Version		: 1.0.0
 * Datum        : 11.07.2011   
 *  
 *****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

require_once($plugin_path. '/../adm_program/system/common.php');
require_once($plugin_path. '/'.$plugin_folder.'/common_function.php');

// DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
$gDb->setCurrentDB();

// Einbinden der Sprachdatei
$gL10n->addLanguagePath($plugin_path.'/'.$plugin_folder.'/languages');

// prüfen, ob die Konfigurationstabelle existiert und ggf. anlegen
initConfigTablePKR();

// Konfiguration einlesen
$config_ini = readConfigTablePKR();

// Zeige Links zum Plugin
if(check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe']) || check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe_config']))
{
    echo '<div id="plugin_'. $plugin_folder. '" class="admPluginContent">
    <div class="admPluginHeader"><h3>'.$gL10n->get('PKR_CATEGORY_REPORT').'</h3></div>
        <div class="admPluginBody">
            <span class="menu">';
    			if(check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe']))
				{
        			echo'<a href="'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?mode=html"><img 
                    style="vertical-align: middle;" src="'. THEME_PATH. '/icons/lists.png" alt="Kategoriereport" title="Kategoriereport" /></a>
                	<a href="'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/kategoriereport_show.php?mode=html">'.$gL10n->get('PKR_CATEGORY_REPORT').'</a>';
                }
        		if(check_showpluginPKR($config_ini['Pluginfreigabe']['freigabe_config']))
				{
    				echo'<BR>
                	<a href="'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/einstellungen.php"><img 
                    	style="vertical-align: middle;" src="'. THEME_PATH. '/icons/options.png" alt="Einstellungen" title="Einstellungen" /></a>
                	<a href="'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/einstellungen.php">'.$gL10n->get('PKR_SETTINGS').'</a>';
            	}
            echo'</span>
        </div>
    </div>';
}

?>