<?php
/******************************************************************************
 * 
 * common_function.php
 *   
 * Gemeinsame Funktionen fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);
 
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_category.php');

// Funktion um alle beitragsbezogenen Rollen einzulesen
// übergebener 1. Parameter:    'alt'   für alle altersgestaffelte Rollen
//                              'fam'   für alle Familienrollen 
//                              'fix'   für alle restlichen Fixbeitragsrollen
//                              leer    für Gesamtliste aller beitragsbezogenen Rollen  (default))
// übergebener 2. Parameter:    leer    ohne Members (default)
//                              array   mit Members z.B. array('FIRST_NAME','LAST_NAME')   
function beitragsrollen_einlesen($rollenwahl = '',$with_members = array())
{
    global $gDb, $gCurrentOrganization, $config_ini;
    $rollen = array();
    
    // alle Rollen einlesen
    $sql = 'SELECT rol_id, rol_name, rol_cost, rol_cost_period, rol_timestamp_create, rol_description
            FROM '.TBL_ROLES.', '. TBL_CATEGORIES. ' 
            WHERE rol_valid  = 1
            AND rol_cost >=0
            AND rol_cost_period <>\'\' 
            AND rol_cat_id = cat_id
            AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                                                  
    $result = $gDb->query($sql);

    while ($row = $gDb->fetch_array($result))
    {
        $rollen[$row['rol_id']] = array('rolle' => $row['rol_name'],'rol_cost' => $row['rol_cost'],'rol_cost_period' => $row['rol_cost_period'],'rol_timestamp_create' => $row['rol_timestamp_create'],'rol_description' => $row['rol_description'],'von' => 0,'bis' => 0,'rollentyp' => '');
    }
    
    foreach ($rollen as $key => $data)
    {
        // alle Alterskonfigurationen durchlaufen
		foreach($config_ini['Altersrollen']['altersrollen_token'] as $altkey => $altdata)
        {
        	// ist es eine altersgestaffelte Rolle?
            if (substr_count($data['rolle'], $config_ini['Altersrollen']['altersrollen_token'][$altkey]) == 4) 
            {
                $v1 = strpos($data['rolle'], $config_ini['Altersrollen']['altersrollen_token'][$altkey], 0);
                $v2 = strpos($data['rolle'], $config_ini['Altersrollen']['altersrollen_token'][$altkey], $v1+1);
                $v3 = strpos($data['rolle'], $config_ini['Altersrollen']['altersrollen_token'][$altkey], $v2+1);
                $v4 = strpos($data['rolle'], $config_ini['Altersrollen']['altersrollen_token'][$altkey], $v3+1);
  
                $rollen[$key]['von'] = substr($data['rolle'], $v1+1, $v2-$v1-1);
                $rollen[$key]['bis'] = substr($data['rolle'], $v3+1, $v4-$v3-1);       
       
                $rollen[$key]['von'] = str_replace(' ', '', $rollen[$key]['von']);
                $rollen[$key]['bis'] = str_replace(' ', '', $rollen[$key]['bis']);
            
                if((is_numeric($rollen[$key]['von'] )) && (is_numeric($rollen[$key]['bis']) ))
                {          
                    if ($rollen[$key]['von'] > $rollen[$key]['bis']) 
                    {          
                        $dummy = $rollen[$key]['von']; 
                        $rollen[$key]['von'] = $rollen[$key]['bis'];
                        $rollen[$key]['bis'] = $dummy;
                    }
                    $rollen[$key]['rollentyp'] = 'alt';
                    $rollen[$key]['alterstyp'] = $config_ini['Altersrollen']['altersrollen_token'][$altkey];
                }
            }   
        } 
         
        // alle Familienkonfigurationen durchlaufen
		foreach($config_ini['Familienrollen']['familienrollen_prefix'] as $famkey => $famdata)
    	{
        	// ist es eine Familienrolle?
    		if (substr($data['rolle'],0, strlen($config_ini['Familienrollen']['familienrollen_prefix'][$famkey])) == $config_ini['Familienrollen']['familienrollen_prefix'][$famkey])   
        	{   
            	$rollen[$key]['rollentyp'] = 'fam';
            	$rollen[$key]['familientyp'] = $config_ini['Familienrollen']['familienrollen_prefix'][$famkey];
        	}    	
    	}

        // wenn der Rollentyp jetzt immer noch leer ist, dann kann es nur eine Fixrolle sein                      
        if ($rollen[$key]['rollentyp']=='')   
        {          
            $rollen[$key]['rollentyp'] = 'fix';
        }
    }
    
    // jetzt sind alle Familienrollen, Altersrollen und Fixrollen markiert
    // alle nicht benötigten Rollen löschen
    foreach ($rollen as $key => $data)
    {
        if (($rollenwahl == 'fam') && ($rollen[$key]['rollentyp'] <> 'fam')) 
        {
            unset($rollen[$key]) ; 
        }
        elseif (($rollenwahl == 'alt') && ($rollen[$key]['rollentyp'] <> 'alt'))
        {
            unset($rollen[$key]) ; 
        } 
        elseif (($rollenwahl == 'fix') && ($rollen[$key]['rollentyp'] <> 'fix'))
        {
            unset($rollen[$key]) ; 
        }
        else
        {
            if (is_array($with_members) && sizeof($with_members)>0)
            {
                $rollen[$key]['members'] = list_members($with_members, array($data['rolle'] => 0))  ;                    
            }
        }
    }
    return $rollen;
}

// Funktion bezugskategorie_einlesen
// Liest alle Mitglieder von Rollen einer oder mehrerer Kategorie(en) ein
// übergebene Parameter:    keine, die cat_ids der einzulesenden Kategorien werden direkt aus der $config_ini gelesen
// Rückgabe:				Array mit den user_ids der Mitglieder
function bezugskategorie_einlesen()
{
    global $gDb, $gCurrentOrganization, $config_ini;  
    
    $members = array(); 
    
    // Hinweis: die Überprüfung, ob $config_ini['Rollenpruefung']['bezugskategorie']
    // befüllt und ein Array ist, ist in der aufrufenden Routine erfolgt
    
    $sql = 'SELECT DISTINCT mem_usr_id
            FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. ' ';
    
    $firstpass = true; 
    foreach ($config_ini['Rollenpruefung']['bezugskategorie'] as $cat => $cat_id)
    {
        if ($firstpass)
        {
            $sql .= ' WHERE ( '; 
        }       
        else
        {
            $sql .= ' OR ( '; 
        }
        
        $sql .=  'cat_id = '.$cat_id.' '; 
		$sql .= ' AND mem_rol_id = rol_id
              	  AND rol_valid  = 1 
          
              	  AND mem_begin <= \''.DATE_NOW.'\' 
        		  AND mem_end >= \''.DATE_NOW.'\' 
        		  
                  AND rol_cat_id = cat_id ';            
        $sql .=  ' ) ';   
        $firstpass = false; 
    } 

    $sql .= ' AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
              OR cat_org_id IS NULL )
              ORDER BY mem_usr_id ASC ';

    $result = $gDb->query($sql);
    while($row = $gDb->fetch_array($result))
    {
       $members[] = $row['mem_usr_id']; 
    }    
    
    return $members;
}

//check_date wird verwendet um die bezahlt-Datumsangabe zu überprüfen
function check_date($date,$format,$sep)
{    
    $pos1    = strpos($format, 'd');
    $pos2    = strpos($format, 'm');
    $pos3    = strpos($format, 'Y'); 
    
    $check    = explode($sep,$date);
    
    return checkdate(intval($check[$pos2]),intval($check[$pos1]),intval($check[$pos3]));
}

// Funktion prueft, ob ein User die uebergebene Rolle besitzt
// $role_name - Name der zu pruefenden Rolle
// $user_id   - Id des Users, fuer den die Mitgliedschaft geprueft werden soll
function hasRole_IDPMB($role_id, $user_id = 0)
{
    global $gCurrentUser,$gCurrentOrganization, $gDb;

    if($user_id == 0)
    {
        $user_id = $gCurrentUser->getValue('usr_id');
    }
    elseif(is_numeric($user_id) == false)
    {
        return -1;
    }

    $sql    = 'SELECT mem_id
                FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                WHERE mem_usr_id = '.$user_id.'
                AND mem_begin <= \''.DATE_NOW.'\'
                AND mem_end    > \''.DATE_NOW.'\'
                AND mem_rol_id = rol_id
                AND rol_id   = \''.$role_id.'\'
                AND rol_valid  = 1 
                AND rol_cat_id = cat_id
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
    $result = $gDb->query($sql);

    $user_found = $gDb->num_rows($result);

    if($user_found == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Funktion list_members
// Diese Funktion liefert als Rückgabe ein assoziatives Array der usr_ids.
// mögliche Aufrufe:
//       list_members(array('usf_name_intern1','usf_name_intern2'),array('Rollenname1' => Schalter aktiv/ehem) )
// oder  list_members(array('usf_name_intern1','usf_name_intern2'), 'Rollenname' )
// oder  list_members(array('usf_name_intern1','usf_name_intern2'), Schalter aktiv/ehem )
//
// Schalter aktiv/ehem: 0 = aktive Mitglieder, 1 = ehemalige Mitglieder, ungleich 1 oder 0: alle Mitglieder
//
// Aufruf: z.B. list_members(array('FIRST_NAME','LAST_NAME'), array('Mitglied' => 0,'Webmaster' => 0));
function list_members( $fields, $rols = array() )
{
    global $gDb, $gCurrentOrganization, $gProfileFields;  
    
    $members = array(); 
    
    $sql = 'SELECT DISTINCT mem_usr_id, mem_begin, mem_end
            FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. ' ';

    if  (is_string($rols))
    {
        $sql .= ' WHERE mem_rol_id = '.getRole_IDPMB($rols).' ';        
    } 
    elseif  (is_integer($rols) && ($rols == 0) )
    {
        // nur aktive Mitglieder
        $sql .= ' WHERE mem_begin <= \''.DATE_NOW.'\' '; 
        $sql .= ' AND mem_end >= \''.DATE_NOW.'\' '; 
        
    }       
    elseif  (is_integer($rols) && ($rols == 1) )   
    {
        // nicht-aktive Mitglieder    ALT:nur ehemalige Mitglieder
        $sql .= ' WHERE ( (mem_begin > \''.DATE_NOW.'\') OR (mem_end < \''.DATE_NOW.'\') )';    
    } 
    elseif (is_array($rols))
    {
        $firstpass = true; 
        foreach ($rols as $rol => $rol_switch)
        {
            if ($firstpass)
            {
                $sql .= ' WHERE ( '; 
            }       
            else
            {
                $sql .= ' OR ( '; 
            }
            $sql .=  'mem_rol_id = '.getRole_IDPMB($rol).' '; 
            
            if ($rol_switch == 0)  
            {
                // aktive Mitglieder
                $sql .= ' AND mem_begin <= \''.DATE_NOW.'\' '; 
        		$sql .= ' AND mem_end >= \''.DATE_NOW.'\' '; 
            }       
            elseif ($rol_switch == 1)
            {
                // nicht aktive Mitglieder  ALT: ehemalige Mitglieder
                $sql .= ' AND ( (mem_begin > \''.DATE_NOW.'\') OR (mem_end < \''.DATE_NOW.'\') )'; 
            }
            $sql .=  ' ) ';   
            $firstpass = false; 
        } 
    }
    
    $sql .= ' AND mem_rol_id = rol_id
              AND rol_valid  = 1   
              AND rol_cat_id = cat_id
              AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
              OR cat_org_id IS NULL )
              ORDER BY mem_usr_id ASC ';

    $result = $gDb->query($sql);
    while($row = $gDb->fetch_array($result))
    {
        $members[$row['mem_usr_id']] = '';
        
        // mem_begin und mem_end werden nur in der neuberechnung.php ausgewertet,
        // wird für anteilige Beitragsberechnung verwendet
        $members[$row['mem_usr_id']]['mem_begin']=$row['mem_begin'];
        $members[$row['mem_usr_id']]['mem_end']=$row['mem_end'];
    }    
    foreach ($members as $member => $key)
    { 
        foreach ($fields as $field => $data) 
        {
            $sql = 'SELECT usd_value
                    FROM '.TBL_USER_DATA.'
                    WHERE usd_usr_id = '.$member.'
                    AND usd_usf_id = '.$gProfileFields->getProperty($data, 'usf_id').' ';
		    $result = $gDb->query($sql);
		    $row = $gDb->fetch_array($result);
		    $members[$member][$data] = $row['usd_value'];
	    }
    } 
    return $members;
}

// loescht Zeilen in einem Array
// die Variable $delete_NULL_field muß in der uebergebenden Routine definiert sein
function delete_NULL ( $wert )
{
    global $delete_NULL_field;
    
    return ( $wert[$delete_NULL_field] != NULL );
}

// gibt zu einem Rollennamen die entsprechende Role_ID zurück
function getRole_IDPMB($role_name)
{
    global $gDb,$gCurrentOrganization;
	
    $sql    = 'SELECT rol_id
                 FROM '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                 WHERE rol_name   = \''.$role_name.'\'
                 AND rol_valid  = 1 
                 AND rol_cat_id = cat_id
                 AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR cat_org_id IS NULL ) ';
                      
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    return $row->rol_id ;
}

// gibt zu einem Kategorienamen die entsprechende Cat_ID zurück
function getCat_IDPMB($cat_name)
{
    global $gDb,$gCurrentOrganization;
	
    $sql = ' SELECT cat_id
            FROM '.TBL_CATEGORIES.'
            WHERE cat_name = \''.$cat_name.'\'
            AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
               
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    return $row->cat_id ;
}

function getNextCatSequence($cat_type)
{
    global $gDb,$gCurrentOrganization;
  
	$sql    = 'SELECT cat_type, cat_sequence
                FROM '. TBL_CATEGORIES. '
                WHERE cat_type = \''.$cat_type.'\'
                AND (  cat_org_id  = '.$gCurrentOrganization->getValue('org_id'). '
                    OR cat_org_id IS NULL )
                ORDER BY cat_sequence ASC';
                    
    $result = $gDb->query($sql);

    while($row = $gDb->fetch_array($result))
    {
        $sequence = $row['cat_sequence'];
    }
    return $sequence+1 ;
}

function getNextFieldSequence($usf_cat_id)
{
    global $gDb;
    $sequence = 0;
  
	$sql    = 'SELECT usf_cat_id, usf_sequence
                FROM '. TBL_USER_FIELDS. '
                WHERE usf_cat_id = \''.$usf_cat_id.'\'
                ORDER BY usf_sequence ASC';
                    
    $result = $gDb->query($sql);

    while($row = $gDb->fetch_array($result))
    {
        $sequence = $row['usf_sequence'];
    }
    return $sequence+1 ;
}

function getCostPeriod($my_rol_cost_period)
{
    global $gL10n;
    
    if($my_rol_cost_period == -1)
    {
        return $gL10n->get('ROL_UNIQUELY');
    }
    elseif($my_rol_cost_period == 1)
    {
        return $gL10n->get('ROL_ANNUALLY');
    }
    elseif($my_rol_cost_period == 2)
    {
        return $gL10n->get('ROL_SEMIYEARLY');
    }
    elseif($my_rol_cost_period == 4)
    {
        return $gL10n->get('ROL_QUARTERLY');
    }
    elseif($my_rol_cost_period == 12)
    {
        return $gL10n->get('ROL_MONTHLY');
    }
    else
    {
        return '--';
    }
} 

function analyse_mem()                      
{
    global $config_ini,$gCurrentOrganization;
    
    $members = list_members(array('BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'BEZAHLT'.$gCurrentOrganization->getValue('org_id'),'KONTONUMMER','BANKLEITZAHL','IBAN','KONTOINHABER'), 0)  ; 
	$ret = array('data'=> $members,'BEITRAG_kto'=>0,'BEITRAG_kto_anzahl'=>0,'BEITRAG_rech'=>0,'BEITRAG_rech_anzahl'=>0,'BEZAHLT_kto'=>0,'BEZAHLT_kto_anzahl'=>0,'BEZAHLT_rech'=>0,'BEZAHLT_rech_anzahl'=>0);
    
	// alle Mitglieder durchlaufen und im ersten Schritt alle Mitglieder,  
	// bei denen kein Beitrag berechnet wurde,
	// und kein Beitragstext (=Verwendungszweck) existiert,  herausfiltern
    foreach ($members as $member => $memberdata)
    {
        if (empty($memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')]) || empty($memberdata['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')]) )  
        {
            unset($members[$member]);
        }
    }

    //jetzt wird gezählt
    foreach($members as $member => $memberdata)
    {
        if ((!empty($memberdata['KONTONUMMER']) && !empty($memberdata['BANKLEITZAHL'])) || !empty($memberdata['IBAN'])) 	    
        {	
            $ret['BEITRAG_kto'] += $memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')];
            $ret['BEITRAG_kto_anzahl']+=1;
        }
        if ( ((!empty($memberdata['KONTONUMMER']) && !empty($memberdata['BANKLEITZAHL'])) || !empty($memberdata['IBAN']))
        	&& !empty($memberdata['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]) )
        {
            $ret['BEZAHLT_kto'] += $memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')];
            $ret['BEZAHLT_kto_anzahl']+=1;
        }
        if (!((!empty($memberdata['KONTONUMMER']) && !empty($memberdata['BANKLEITZAHL'])) || !empty($memberdata['IBAN'])) )
        {
            $ret['BEITRAG_rech'] += $memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')];
            $ret['BEITRAG_rech_anzahl']+=1;
        }
        if ( !((!empty($memberdata['KONTONUMMER']) && !empty($memberdata['BANKLEITZAHL'])) || !empty($memberdata['IBAN'])) 
        	&& !empty($memberdata['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]) )
        {
            $ret['BEZAHLT_rech'] += $memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')];
            $ret['BEZAHLT_rech_anzahl']+=1;
        }
    }
    return $ret;
}
    
function analyse_rol()                      
{
    global $config_ini, $gCurrentOrganization, $gL10n;
  
    $ret = beitragsrollen_einlesen('alt');
    $ret = array_merge($ret,beitragsrollen_einlesen('fix'));
    foreach ($ret as $rol => $roldata)
    {
        $ret[$rol]['members'] = list_members(array('BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEZAHLT'.$gCurrentOrganization->getValue('org_id')), array($roldata['rolle'] => 0))  ; 
    }
    
    $fam = beitragsrollen_einlesen('fam');
    
	foreach($config_ini['Familienrollen']['familienrollen_prefix'] as $famkey => $famdata)
    {
        //wieviele Familienrollen mit diesem Präfix gibt es denn?
        //in der aufrufenden Funktion wird mittels sizeof abgefragt, 
        //deshalb muss hier eine Array erzeugt werden
        $arr = array();
    	foreach($fam as $key => $data)
    	{
			if (substr($data['rolle'],0, strlen($config_ini['Familienrollen']['familienrollen_prefix'][$famkey])) == $config_ini['Familienrollen']['familienrollen_prefix'][$famkey])  
			{
				$arr[]=$key;
			} 
    	}	
		$ret[$config_ini['Familienrollen']['familienrollen_prefix'][$famkey]] = array('rolle' => $gL10n->get('PMB_FAMILY_ROLE').' '.$config_ini['Familienrollen']['familienrollen_prefix'][$famkey],'rol_cost' => $config_ini['Familienrollen']['familienrollen_beitrag'][$famkey],'rol_cost_period' => $config_ini['Familienrollen']['familienrollen_zeitraum'][$famkey],'members' =>$arr); 
    		
    }
    return $ret;
}

function check_rollenmitgliedschaft_pflicht()
{
    global $config_ini, $gL10n, $g_root_path;
    $ret = array();
    
    // alle Beitragsrollen einlesen ('FIRST_NAME' wird zwar in der Funktion nicht benötigt, ist aber notwendig,
    // damit die Rollenmitglieder eingelesen werden)
    $beitragsrollen = beitragsrollen_einlesen('',array('FIRST_NAME'));
    $members = list_members(array('FIRST_NAME','LAST_NAME'), 0)  ;   
    
    // alle Beitragsrollen durchlaufen und diejenigen Rollen löschen, die nicht als Pflichtrolle definiert sind
    foreach ($beitragsrollen as $rol => $roldata)
    {
        //alle if und elseif könnte man in einer Zeile schreiben und mit || verknüpfen, aber so ist es übersichtlicher 
        if(($roldata['rollentyp'] == 'fam') && (!$config_ini['Rollenpruefung']['familienrollenpflicht']) )
        {
            unset ($beitragsrollen[$rol]);                                                          
        }       
        elseif(($roldata['rollentyp'] == 'alt') && (!$config_ini['Rollenpruefung']['altersrollenpflicht']) )
        {
            unset ($beitragsrollen[$rol]);                                                          
        } 
        elseif (($roldata['rollentyp'] == 'fix') && (!is_array($config_ini['Rollenpruefung']['fixrollenpflicht'])))
        {
            unset ($beitragsrollen[$rol]);  
        }
        elseif (($roldata['rollentyp'] == 'fix') && (is_array($config_ini['Rollenpruefung']['fixrollenpflicht'])) && !(in_array($rol,$config_ini['Rollenpruefung']['fixrollenpflicht']))) 
        {
            unset ($beitragsrollen[$rol]);  
        } 
    }
    // in $beitragsrollen sind jetzt nur noch Pflicht-Beitragsrollen 

    // Feature-Wunsch von joesch
    $bezugskategorieMembers = array();
    if (is_array($config_ini['Rollenpruefung']['bezugskategorie']) && sizeof($config_ini['Rollenpruefung']['bezugskategorie'])>0)
    {
    	// zuerst alle Member der Bezugskategorien einlesen
		$bezugskategorieMembers = bezugskategorie_einlesen();

		foreach ($members as $member => $memberdata)
    	{
    		// alle usr_ids löschen, wenn sie nicht innerhalb der Bezugskategorie sind 
    		if (!in_array($member,$bezugskategorieMembers))
    		{
    			unset($members[$member]) ; 
    		}           	
    	}
    }
    
    // alle Mitglieder durchlaufen und prüfen, ob sie in mind. einer Pflicht-Beitragsrolle sind
    foreach ($members as $member => $memberdata)
    {
        $marker = false;
        foreach ($beitragsrollen as $rol => $roldata)
        {
            if(array_key_exists($member,$roldata['members']))
            {
                $marker = true;     
            } 
        }
        if (!$marker)
        { 
        	$ret[] .= '- <a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $member. '">'.$memberdata['LAST_NAME'].', '.$memberdata['FIRST_NAME']. '</a>'; 
        }
    }

    if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY_RESULT_ERROR').'</strong>';
    }
    return $ret;
}

function check_rollenmitgliedschaft_ausschluss()
{
    global $config_ini, $gL10n, $g_root_path;
    $ret = array();
    
    // alle Beitragsrollen einlesen ('FIRST_NAME' wird zwar in der Funktion nicht benötigt, ist aber notwendig,
    // damit die Rollenmitglieder eingelesen werden)
    $beitragsrollen = beitragsrollen_einlesen('',array('FIRST_NAME'));
    $members = list_members(array('FIRST_NAME','LAST_NAME'), 0)  ;   
    
    // alle Beitragsrollen durchlaufen und für jedes Mitglied seine Rollenzugehörigkeiten bestimmen
    foreach ($beitragsrollen as $rol => $roldata)
    {
        foreach ($roldata['members'] as $key => $dummy)
        {
        	if (!isset($members[$key]['rollen']))
        	{
            	$members[$key]['rollen'] = array();   
        	}
        
            if($roldata['rollentyp']== 'alt') 
            {
                $members[$key]['rollen'][]= 'alt';    
            }
            elseif($roldata['rollentyp']== 'fam') 
            {
                $members[$key]['rollen'][]= 'fam';    
            }
            else
            {
                $members[$key]['rollen'][]= $rol;    
            }
        }
    } 

    // Feature-Wunsch von joesch
    $bezugskategorieMembers = array();
    if (is_array($config_ini['Rollenpruefung']['bezugskategorie']) && sizeof($config_ini['Rollenpruefung']['bezugskategorie'])>0)
    {
    	// zuerst alle Member der Bezugskategorien einlesen
		$bezugskategorieMembers = bezugskategorie_einlesen();

		foreach ($members as $member => $memberdata)
    	{
    		// alle usr_ids löschen, wenn sie nicht innerhalb der Bezugskategorie sind 
    		if (!in_array($member,$bezugskategorieMembers))
    		{
    			unset($members[$member]) ; 
    		}           	
    	}
    }        
    
    // alle Mitglieder durchlaufen und prüfen, ob sie in Ausschluss-Beitragsrollen sind
    foreach ($members as $member => $memberdata)
    {
        //falls das Mitglied kein Angehöriger einer Beitragsrolle ist: abbrechen und zum nächsten Datensatz gehen 
        if (!isset($memberdata['rollen']))
        {
            continue;     
        }
        
        $marker = false;
        if(($config_ini['Rollenpruefung']['altersrollenfamilienrollen']) && (in_array('fam',$memberdata['rollen'])) && (in_array('alt',$memberdata['rollen'])))
        {
            $marker = true;     
        } 
        if(is_array($config_ini['Rollenpruefung']['familienrollenfix']))
        {
            foreach ($config_ini['Rollenpruefung']['familienrollenfix'] as $rol => $roldata)
            {
                if((in_array($roldata,$memberdata['rollen'])) && (in_array('fam',$memberdata['rollen'])))
                {
                    $marker = true;     
                }   
            }     
        } 
        if(is_array($config_ini['Rollenpruefung']['altersrollenfix']))
        {
            foreach ($config_ini['Rollenpruefung']['altersrollenfix'] as $rol => $roldata)
            {
                if((in_array($roldata,$memberdata['rollen'])) && (in_array('alt',$memberdata['rollen'])))
                {
                    $marker = true;     
                }   
            }     
        } 
       
        if ($marker)
        {
        	$ret[] .= '- <a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $member. '">'.$memberdata['LAST_NAME'].', '.$memberdata['FIRST_NAME']. '</a>'; 
        }
    } 

    if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION_RESULT_ERROR').'</strong>';
    }
    return $ret;
}

// Vergleichsfunktion; erforderlich für usort()
function vergleich($wert_a, $wert_b)
{
    //Sortierung nach dem zweiten Wert des Arrays (Index: 1)
    $a = $wert_a['year'];
    $b = $wert_b['year'];
   
    if ($a == $b) return 0;
    elseif ($a > $b) return 1;
    else return -1;
}   
 
function check_rols()
{
	global $config_ini,$gL10n;
    $ret = array();
    $alt = beitragsrollen_einlesen('alt',array('LAST_NAME'));

    foreach ($config_ini['Altersrollen']['altersrollen_token'] as $tokenkey => $tokendata)
    {
    	$check = array();
    	foreach ($alt as $altrol => $altdata)
    	{
    		if ($altdata['alterstyp']==$tokendata)
    		{
	       		$check[]  = array('year' => $altdata['von'],'rol' => $altrol);
        		$check[]  = array('year' => $altdata['bis'],'rol' => $altrol);    		
    		}
    	} 
 
    	usort($check, 'vergleich');
     
    	for ($i = 0; $i < sizeof($check)-1; $i = $i+2) 
    	{
	   	if ($check[$i]['rol'] <> $check[$i+1]['rol']) 
        	{
            	$ret[$check[$i]['rol']] = '- '.$alt[$check[$i]['rol']]['rolle'];
            	$ret[$check[$i+1]['rol']] = '- '.$alt[$check[$i+1]['rol']]['rolle'];
			}
			if (($i < sizeof($check)-2) && ($check[$i+1]['year'] <> ($check[$i+2]['year'])-1)) 
        	{
            	$ret[$check[$i+1]['rol']] = '- '.$alt[$check[$i+1]['rol']]['rolle'];
            	$ret[$check[$i+2]['rol']] = '- '.$alt[$check[$i+2]['rol']]['rolle'];
			}
		}
    }
       
    if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_OLD_STAGGERED_ROLES_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_OLD_STAGGERED_ROLES_RESULT_ERROR').'</strong>';
    }
    return $ret;
} 

// Funktion für die Rollenprüfung von Familienrollen
function check_family_roles()
{
    global $config_ini, $gL10n, $g_root_path;
    $ret = array();
    $ret_error = array();
    $temp_arr  = array();
    $temp_arr2 = array();    
    $ret_marker = false;
    $fam = beitragsrollen_einlesen('fam',array('LAST_NAME','FIRST_NAME','BIRTHDAY'));
    $check = $config_ini['Familienrollen'];

    // alle Prüfbedingungen einlesen
	foreach($check['familienrollen_prefix'] as $key => $prefix)
    {
    	$temp_arr = explode(';',$config_ini['Familienrollen']['familienrollen_pruefung'][$key]);
		foreach ($temp_arr as $keybed => $bedingung)
		{
			// den Doppelpunkt in der Prüfbedingung ersetzen
			// eine Prüfbedingung könnte deshalb auch in folgender Syntax geschrieben werden: von*bis*Anzahl
			$bedingung = str_replace(':','*',$bedingung);
			
			$temp_arr2 = explode('*',$bedingung);
			
			// prüfen auf unsinnige Bedingungen
			if( isset($temp_arr2[0]) && isset($temp_arr2[1]) && isset($temp_arr2[2]) 
			 && is_numeric($temp_arr2[0]) && is_numeric($temp_arr2[1]) && is_numeric($temp_arr2[2]))
			{
				$check['pruefungsbedingungen'][$key][$keybed]['von'] = $temp_arr2[0];
				$check['pruefungsbedingungen'][$key][$keybed]['bis'] = $temp_arr2[1];
				$check['pruefungsbedingungen'][$key][$keybed]['anz'] = $temp_arr2[2];
			}
			else 
			{
				unset($check['familienrollen_prefix'][$key]);
    			unset($check['familienrollen_beitrag'][$key]);
    			unset($check['familienrollen_zeitraum'][$key]);
    			unset($check['familienrollen_beschreibung'][$key]);
    			unset($check['familienrollen_pruefung'][$key]);	
    			unset($check['pruefungsbedingungen'][$key]);
    			$ret_marker = true;
    			continue;
			}
		}

		// Meldung bei fehlerhaften Prüfbedingungen
		if($ret_marker && strlen($config_ini['Familienrollen']['familienrollen_pruefung'][$key])>0)
		{
			$ret_error[] = '<small>'.$gL10n->get('PMB_CONDITION').' '.$config_ini['Familienrollen']['familienrollen_pruefung'][$key].' ('.$prefix.') '.$gL10n->get('PMB_INVALID').'.</small>';
		}
		$ret_marker = false;        		
    }
    
    // Leerzeile einfügen
	if (sizeof($ret_error) <> 0)
    {
        $ret_error[] = '';
    }
    
    unset($bedingung);
    unset($keybed);
    unset($temp_arr);
    unset($temp_arr2);
    unset($ret_marker);
       
    // alle Prüfbedingungen durchlaufen
	foreach($check['familienrollen_prefix'] as $key => $prefix)
    {
     	// alle Familienrollen durchlaufen
		foreach($fam as $famkey => $famdata)
    	{
     		if ($famdata['familientyp'] == $prefix)
     		{
     			$ret_temp = array();
     			
    			// alle Prüfungsbedingungen durchlaufen
    			foreach ($check['pruefungsbedingungen'][$key] as $pruefkey => $pruefdata)
    			{	
    				$counter = 0;
    				// alle Mitglieder durchlaufen
					foreach($famdata['members'] as $memberID => $memberdata)
    				{
    					// das Alter des Mitglieds am Stichtag bestimmen
    					$age = date("Y", strtotime($config_ini['Altersrollen']['altersrollen_stichtag'])) - date("Y", strtotime($memberdata['BIRTHDAY']));
    				
    					// passt das Alter zu einer der Prüfbedingungen?
    					if (   $age >= $pruefdata['von'] && $age <= $pruefdata['bis'] )
            			{ 
                			$counter++;
            			}
    				}
    				
    				if ($counter <> $pruefdata['anz'])         
                	{
                		$ret_temp[] = '&#160&#160&#160&#183<small>'.$gL10n->get('PMB_CONDITION').' '.$pruefdata['von'].'*'.$pruefdata['bis'].':'.$pruefdata['anz'].' '.$gL10n->get('PMB_NOT_SATISFIED').'.</small>';               		
                	}
    			}
    			if (sizeof($ret_temp) <> 0)
    			{
	   				$ret[] = '- <a href="'.$g_root_path.'/adm_program/modules/lists/lists_show.php?mode=html&rol_id='. $famkey. '">'.$famdata['rolle']. '</a>'; 
    				$ret = array_merge($ret,$ret_temp);
    			}
    		}     	
    	}    	
    }   

	if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_FAMILY_ROLES_ROLE_TEST_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_FAMILY_ROLES_ROLE_TEST_RESULT_ERROR').'</strong>';
    }
    
    // eine evtl. vorhandene Fehlermeldung davorsetzen 
	if (sizeof($ret_error) <> 0)
    {
    	$ret = array_merge($ret_error,$ret);
    }
    return $ret;
} 

function check_mandate_management()
{
    global $gL10n, $g_root_path;
    $ret = array();
    
    $members = list_members(array('FIRST_NAME','LAST_NAME','KONTOINHABER','DEBTORPOSTCODE','DEBTORCITY','DEBTORADDRESS'), 0)  ;

	foreach ($members as $member => $memberdata)
	{
		if ((strlen($memberdata['KONTOINHABER'])<>0) && ( (strlen($memberdata['DEBTORPOSTCODE'])==0) || (strlen($memberdata['DEBTORCITY'])==0) || (strlen($memberdata['DEBTORADDRESS'])==0)) )
		{
			$ret[] = '- <a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $member. '">'.$memberdata['LAST_NAME'].', '.$memberdata['FIRST_NAME']. '</a>'; 				
		}
	}
 
	if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_MANDATE_MANAGEMENT_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_MANDATE_MANAGEMENT_RESULT_ERROR').'</strong>';
    }
    return $ret;
}

function check_iban()
{
    global $gL10n, $g_root_path;
    $ret = array();
    
    $members = list_members(array('FIRST_NAME','LAST_NAME','IBAN'), 0)  ;

	foreach ($members as $member => $memberdata)
	{
		if ((strlen($memberdata['IBAN'])<>0) && !test_iban($memberdata['IBAN']) )
		{
			$ret[] = '- <a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $member. '">'.$memberdata['LAST_NAME'].', '.$memberdata['FIRST_NAME']. '</a>'; 				
		}
	}
 
	if (sizeof($ret) == 0)
    {
        $ret = array($gL10n->get('PMB_IBANCHECK_RESULT_OK'));
    }
    else
    {
        $ret[] = '<BR><strong>=> '.$gL10n->get('PMB_IBANCHECK_RESULT_ERROR').'</strong>';
    }
    return $ret;
}
 
function check_DB()
{
    global $gDb,$gCurrentOrganization,$gL10n;

    //Mit der Version 3.3.0 wurde die Installationsroutine umprogrammiert. 
	//Früher wurde auf usf_name geprüft, jetzt auf usf_name_intern.
  	//Die Installationsscripte der Versionen 1.x und 2.x befüllten jedoch
  	// von der Kategorie kontodaten usf_name_intern nicht mit dem Wert KONTODATEN. 
  	//Hier wird deshalb überprüft, ob es eine Kategorie kontodaten gibt.
  	//Falls von dieser Kategorei der usf_name_intern leer ist, wird er mit KONTODATEN beschreiben.
          
    $sql = ' SELECT cat_name,cat_name_intern 
           	FROM '. TBL_CATEGORIES. ' 
           	WHERE cat_name = \'Kontodaten\' 
            AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
            OR cat_org_id IS NULL ) ';
            
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    // Gibt es einen zutreffenden Datensatz?  Wenn ja: UPDATE
    if( isset($row->cat_name_intern) && isset($row->cat_name) && (($row->cat_name_intern) == '') && (($row->cat_name) == 'Kontodaten') )
    {
    	$sql = 'UPDATE '.TBL_CATEGORIES.' 
                SET cat_name_intern = \'KONTODATEN\' 
                WHERE cat_name = \'Kontodaten\'
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
            	OR cat_org_id IS NULL ) ';
        $gDb->query($sql);           
    }        
            
    // $DB_array['SOLL'] beinhaltet die erforderlichen Werte für die Kategorien und die User Fields 
    $DB_array['SOLL']['TBL_CATEGORIES']['Kontodaten']       = array('cat_id'=>-1,'cat_org_id' => 'Null',   									'cat_name' => 'Kontodaten',        	'cat_name_intern' => 'KONTODATEN',              									'cat_type' => 'USF', 'cat_system'=> 0, 'cat_hidden' => 0);
    $DB_array['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag'] = array('cat_id'=>-1,'cat_org_id' => $gCurrentOrganization->getValue('org_id'), 'cat_name' => 'Mitgliedsbeitrag',  	'cat_name_intern' => 'MITGLIEDSBEITRAG'.$gCurrentOrganization->getValue('org_id'), 	'cat_type' => 'USF', 'cat_system'=> 0, 'cat_hidden' => 0 );
    $DB_array['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']   = array('cat_id'=>-1,'cat_org_id' => $gCurrentOrganization->getValue('org_id'), 'cat_name' => 'Mitgliedschaft',    	'cat_name_intern' => 'MITGLIEDSCHAFT'.$gCurrentOrganization->getValue('org_id'),   	'cat_type' => 'USF', 'cat_system'=> 0, 'cat_hidden' => 0 );
    $DB_array['SOLL']['TBL_CATEGORIES']['Mandat']   		= array('cat_id'=>-1,'cat_org_id' => $gCurrentOrganization->getValue('org_id'), 'cat_name' => 'PMB_MANDATE',		'cat_name_intern' => 'MANDATE'.$gCurrentOrganization->getValue('org_id'),   		'cat_type' => 'USF', 'cat_system'=> 0, 'cat_hidden' => 0 );
                                          
    $DB_array['SOLL']['TBL_USER_FIELDS']['Kontonummer']  		= array('usf_name'=>'Kontonummer',  		'usf_name_intern'=>'KONTONUMMER',          								'usf_type'=>'NUMERIC',  'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Die Kontonummer für den Bankeinzug');     
    $DB_array['SOLL']['TBL_USER_FIELDS']['Bankleitzahl'] 		= array('usf_name'=>'Bankleitzahl', 		'usf_name_intern'=>'BANKLEITZAHL',         								'usf_type'=>'NUMERIC',  'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Die Bankleitzahl Ihres Kreditinstituts für den Bankeinzug');  
    $DB_array['SOLL']['TBL_USER_FIELDS']['IBAN'] 				= array('usf_name'=>'PMB_IBAN', 			'usf_name_intern'=>'IBAN',         										'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
    $DB_array['SOLL']['TBL_USER_FIELDS']['BIC'] 				= array('usf_name'=>'PMB_BIC', 				'usf_name_intern'=>'BIC',         										'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
   	$DB_array['SOLL']['TBL_USER_FIELDS']['Bankname'] 			= array('usf_name'=>'PMB_BANK', 			'usf_name_intern'=>'BANKNAME',         									'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Der Name der Bank für den Bankeinzug');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Kontoinhaber'] 		= array('usf_name'=>'Kontoinhaber', 		'usf_name_intern'=>'KONTOINHABER',         								'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'<p>Inhaber der angegebenen Bankverbindung.</p><p>Ein Eintrag ist nur erforderlich, wenn der Inhaber der Bankverbindung und das Mitglied nicht identisch sind. Wenn das Feld belegt ist, dann müssen KtoInh-Adresse, KtoInh-PLZ und KtoInh-Ort ausgefüllt sein.</p>');
   	
  	$DB_array['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse'] = array('usf_name'=>'PMB_ADDRESS', 			'usf_name_intern'=>'DEBTORADDRESS',										'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'<p>Adresse des Kontoinhabers.</p><p>Eine Angabe ist zwingend erforderlich, wenn der Inhaber der Bankverbindung und das Mitglied nicht identisch sind.</p>');
  	$DB_array['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ'] 	= array('usf_name'=>'PMB_POSTCODE', 		'usf_name_intern'=>'DEBTORPOSTCODE',									'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'<p>PLZ des Kontoinhabers.</p><p>Eine Angabe ist zwingend erforderlich, wenn der Inhaber der Bankverbindung und das Mitglied nicht identisch sind.</p>');
  	$DB_array['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt'] 	= array('usf_name'=>'PMB_CITY', 			'usf_name_intern'=>'DEBTORCITY',     									'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'<p>Wohnort des Kontoinhabers.</p><p>Eine Angabe ist zwingend erforderlich, wenn der Inhaber der Bankverbindung und das Mitglied nicht identisch sind.</p>');
  	$DB_array['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail'] 	= array('usf_name'=>'PMB_EMAIL', 			'usf_name_intern'=>'DEBTOREMAIL',     									'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
  	
    $DB_array['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer'] 	= array('usf_name'=>'PMB_MEMBERNUMBER', 	'usf_name_intern'=>'MEMBERNUMBER',         										'usf_type'=>'NUMERIC',  'usf_system'=>0, 'usf_disabled'=>0, 'usf_hidden'=>0, 'usf_mandatory'=>0, 'usf_description'=>'ACHTUNG: Mitgliedsnummern nicht selbständig vergeben. Zum Löschen einer Mitgliedsnummer entweder 0 oder eine negative Zahl eingeben.');  
    $DB_array['SOLL']['TBL_USER_FIELDS']['Beitritt']     		= array('usf_name'=>'Beitritt',     		'usf_name_intern'=>'BEITRITT'.$gCurrentOrganization->getValue('org_id'),    	'usf_type'=>'DATE',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Das Beitrittsdatum zum Verein');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Bezahlt']      		= array('usf_name'=>'Bezahlt',      		'usf_name_intern'=>'BEZAHLT'.$gCurrentOrganization->getValue('org_id'),     	'usf_type'=>'DATE',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Datumsangabe, ob und wann der Beitrag bezahlt wurde');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Beitrag']      		= array('usf_name'=>'Beitrag',      		'usf_name_intern'=>'BEITRAG'.$gCurrentOrganization->getValue('org_id'),     	'usf_type'=>'NUMERIC',  'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Der errechnete Mitgliedsbeitrag');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Beitragstext'] 		= array('usf_name'=>'Beitragstext', 		'usf_name_intern'=>'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),	'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Verwendungszweck');
   	$DB_array['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']		= array('usf_name'=>'PMB_MANDATEID', 		'usf_name_intern'=>'MANDATEID'.$gCurrentOrganization->getValue('org_id'),		'usf_type'=>'TEXT',  	'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Mandatsdatum'] 		= array('usf_name'=>'PMB_MANDATEDATE', 		'usf_name_intern'=>'MANDATEDATE'.$gCurrentOrganization->getValue('org_id'),		'usf_type'=>'DATE',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum'] 	= array('usf_name'=>'PMB_DUEDATE', 			'usf_name_intern'=>'DUEDATE'.$gCurrentOrganization->getValue('org_id'),			'usf_type'=>'DATE',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Sequenztyp'] 			= array('usf_name'=>'PMB_SEQUENCETYPE', 	'usf_name_intern'=>'SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'),	'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'');
    
    $DB_array['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent'] 	= array('usf_name'=>'PMB_ORIG_DEBTOR_AGENT','usf_name_intern'=>'ORIGDEBTORAGENT',											'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Wird durch das Modul Mandatsänderung automatisch befüllt.');
    $DB_array['SOLL']['TBL_USER_FIELDS']['Orig_IBAN'] 			= array('usf_name'=>'PMB_ORIG_IBAN', 		'usf_name_intern'=>'ORIGIBAN',													'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Wird durch das Modul Mandatsänderung automatisch befüllt.');     
    $DB_array['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']= array('usf_name'=>'PMB_ORIG_MANDATEID', 	'usf_name_intern'=>'ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'),	'usf_type'=>'TEXT',     'usf_system'=>0, 'usf_disabled'=>1, 'usf_hidden'=>1, 'usf_mandatory'=>0, 'usf_description'=>'Wird durch das Modul Mandatsänderung automatisch befüllt.');     
    
     $DB_array['IST'] = $DB_array['SOLL'];
    
    foreach ($DB_array['IST']['TBL_USER_FIELDS'] as $field => $fielddata)
    {
        $sql = ' SELECT usf_name, usf_name_intern, usf_type, usf_system, usf_disabled, usf_hidden, usf_mandatory 
            FROM '.TBL_USER_FIELDS.' , '. TBL_CATEGORIES. '
            WHERE usf_name_intern = \''.$fielddata['usf_name_intern'].'\' 
            AND usf_cat_id = cat_id
            AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
            OR cat_org_id IS NULL ) ';

        $result = $gDb->query($sql);
        $row = $gDb->fetch_object($result);

        $DB_array['IST']['TBL_USER_FIELDS'][$field]= array(
				'usf_name_intern'  	=>  (isset($row->usf_name_intern) ? $row->usf_name_intern : ''), 
				'usf_name'  		=>  (isset($row->usf_name) ? $row->usf_name : ''), 
				'usf_type'  		=>  (isset($row->usf_type) ? $row->usf_type : ''), 
				'usf_system'  		=>  (isset($row->usf_system) ? $row->usf_system : ''), 
 				'usf_disabled'  	=>  (isset($row->usf_disabled) ? $row->usf_disabled : ''), 
 				'usf_hidden'  		=>  (isset($row->usf_hidden) ? $row->usf_hidden : ''),
  				'usf_mandatory'  	=>  (isset($row->usf_mandatory) ? $row->usf_mandatory : '')        
        	);
       
        if ($DB_array['IST']['TBL_USER_FIELDS'][$field]['usf_name_intern'] <> $DB_array['SOLL']['TBL_USER_FIELDS'][$field]['usf_name_intern'])
        {
            unset($DB_array['IST']['TBL_USER_FIELDS'][$field]);
        }  
    }
     
    foreach ($DB_array['IST']['TBL_CATEGORIES'] as $cat => $catdata)
    {
        $sql = ' SELECT cat_id, cat_org_id, cat_name, cat_name_intern, cat_type, cat_system, cat_hidden
            FROM '.TBL_CATEGORIES.'
            WHERE cat_name_intern = \''.$catdata['cat_name_intern'].'\' 
            AND cat_type = \'USF\' 
            AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
        $result = $gDb->query($sql);
        $row = $gDb->fetch_object($result);

         $DB_array['IST']['TBL_CATEGORIES'][$cat]= array(
				'cat_name_intern'  	=>  (isset($row->cat_name_intern) ? $row->cat_name_intern : ''), 
				'cat_name'  		=>  (isset($row->cat_name) ? $row->cat_name : ''), 
				'cat_id'  			=>  (isset($row->cat_id) ? $row->cat_id : ''), 
				'cat_org_id'  		=>  (isset($row->cat_org_id) ? $row->cat_org_id : ''), 
 				'cat_type'  		=>  (isset($row->cat_type) ? $row->cat_type : ''), 
 				'cat_system'  		=>  (isset($row->cat_system) ? $row->cat_system : ''), 
  				'cat_hidden'  		=>  (isset($row->cat_hidden) ? $row->cat_hidden : '')       
        	);       
          
        if ($DB_array['IST']['TBL_CATEGORIES'][$cat]['cat_name_intern'] <> $DB_array['SOLL']['TBL_CATEGORIES'][$cat]['cat_name_intern'])
        {
            unset($DB_array['IST']['TBL_CATEGORIES'][$cat]);
        } 
    }        
    return $DB_array;
}
 
function iban_berechnung_DE($blz,$kto)
{
	//berechnet die IBAN aus BLZ und Kontonummer
	//NUR FÜR DE-Banken!!!
	// Autor: guenter47
	$u_iban = "DE00";
	$bban=$blz.str_pad($kto,10,"0",STR_PAD_LEFT);
	$num_de="131400";   // (D = 13, E = 14, +00)
	$pruefsum=$bban.$num_de;
   	for($pos=0;$pos<strlen($pruefsum); $pos+=7 ) {
        $part = strval($rest) . substr($pruefsum,$pos,7);
        $rest = intval($part) % 97;
    }	
	$pz1=98-$rest;
	$pz2=str_pad($pz1,2,"0",STR_PAD_LEFT);
	$iban='DE'.$pz2.$bban;
	return $iban;
}

function test_iban( $iban ) 
{
	// aus dem Internet
    $iban = str_replace( ' ', '', $iban );
    $iban1 = substr( $iban,4 )
        . strval( ord( $iban{0} )-55 )
        . strval( ord( $iban{1} )-55 )
        . substr( $iban, 2, 2 );

    $rest=0;
    for ( $pos=0; $pos<strlen($iban1); $pos+=7 ) {
        $part = strval($rest) . substr($iban1,$pos,7);
        $rest = intval($part) % 97;
    }
    $pz = sprintf("%02d", 98-$rest);

    if ( substr($iban,2,2)=='00')
        return substr_replace( $iban, $pz, 2, 2 );
    else
        return ($rest==1) ? true : false;
}

function SollIstAnzeige($arr,$field)
{
	global $gL10n;
	$ret ='';

    if (($field == 'Mitgliedschaft')||($field == 'Mitgliedsbeitrag')||($field == 'Mandat')||($field == 'Kontodaten') )
	{
        if ($arr['SOLL']['TBL_CATEGORIES'][$field]['cat_name_intern'] <> $arr['IST']['TBL_CATEGORIES'][$field]['cat_name_intern'])
        {
            $ret .= '<td align="center"><strong>'.$arr['SOLL']['TBL_CATEGORIES'][$field]['cat_name_intern'].'</strong></td>
                    <td align="center"><strong>'.$arr['IST']['TBL_CATEGORIES'][$field]['cat_name_intern'].'</strong></td>
                    <td colspan="8">&#160;</td>';
        } 
        else
        {
            $ret .= '<td align="center">'.$arr['SOLL']['TBL_CATEGORIES'][$field]['cat_name_intern'].'</td>
                    <td align="center">'.$arr['IST']['TBL_CATEGORIES'][$field]['cat_name_intern'].'</td>
                    <td colspan="8">&#160;</td>';
        }
     
    }
    else
    {
        if ($arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_name_intern'] <> $arr['IST']['TBL_USER_FIELDS'][$field]['usf_name_intern'])
        {
            $ret .= '<td align="center"><strong>'.$arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_name_intern'].'</strong></td>
                    <td align="center"><strong>'.$arr['IST']['TBL_USER_FIELDS'][$field]['usf_name_intern'].'</strong></td>';
        } 
        else
        {
            $ret .= '<td align="center">'.$arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_name_intern'].'</td>
                    <td align="center">'.$arr['IST']['TBL_USER_FIELDS'][$field]['usf_name_intern'].'</td>';
        }
  
        if ($arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_type']<>$arr['IST']['TBL_USER_FIELDS'][$field]['usf_type'])
        {
            $ret .= '<td align="center"><strong>'.$arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_type'].'</strong></td>
                    <td align="center"><strong>'.$arr['IST']['TBL_USER_FIELDS'][$field]['usf_type'].'</strong></td>';
        } 
        else
        {
            $ret .= '<td align="center">'.$arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_type'].'</td>
                    <td align="center">'.$arr['IST']['TBL_USER_FIELDS'][$field]['usf_type'].'</td>';
        }            
                    
        $ret .= '<td align="center">';
            if ($arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_hidden']==1)
    		{
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/eye_gray.png" alt="'.$gL10n->get('ORG_FIELD_HIDDEN').'" title="'.$gL10n->get('ORG_FIELD_HIDDEN').'" />';
            }
            else
            {
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/eye.png" alt="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" title="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" />';
            }
        $ret .= '</td>';
        $ret .= '<td align="center">';

            if ($arr['IST']['TBL_USER_FIELDS'][$field]['usf_hidden']==1)
        		{
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/eye_gray.png" alt="'.$gL10n->get('ORG_FIELD_HIDDEN').'" title="'.$gL10n->get('ORG_FIELD_HIDDEN').'" />';
            }
            else
            {
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/eye.png" alt="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" title="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" />';
            }
        $ret .= '</td>';
        $ret .= '<td align="center">';           
            if ($arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_disabled']==1)
            {
            	$ret .=  '<img class="iconInformation" src="'. THEME_PATH. '/icons/textfield_key.png" alt="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" title="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" />';
            }
            else
            {
            	$ret .=  '<img class="iconInformation" src="'. THEME_PATH. '/icons/textfield.png" alt="'.$gL10n->get('ORG_FIELD_NOT_DISABLED').'" title="'.$gL10n->get('ORG_FIELD_NOT_DISABLED').'" />';
            }
		$ret .= '</td>';
        $ret .= '<td align="center">';                       
            if ($arr['IST']['TBL_USER_FIELDS'][$field]['usf_disabled']==1)
                {
            	$ret .=  '<img class="iconInformation" src="'. THEME_PATH. '/icons/textfield_key.png" alt="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" title="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" />';
            }
            else
            {
            	$ret .=  '<img class="iconInformation" src="'. THEME_PATH. '/icons/textfield.png" alt="'.$gL10n->get('ORG_FIELD_NOT_DISABLED').'" title="'.$gL10n->get('ORG_FIELD_NOT_DISABLED').'" />';
            }
		$ret .= '</td>';
        $ret .= '<td align="center">'; 
                                                 
            if ($arr['SOLL']['TBL_USER_FIELDS'][$field]['usf_mandatory']==1)
            {
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/asterisk_yellow.png" alt="'.$gL10n->get('ORG_FIELD_MANDATORY').'" title="'.$gL10n->get('ORG_FIELD_MANDATORY').'" />';
            }
            else
           	{
            		$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/asterisk_gray.png" alt="'.$gL10n->get('ORG_FIELD_NOT_MANDATORY').'" title="'.$gL10n->get('ORG_FIELD_NOT_MANDATORY').'" />';
            }
		$ret .= '</td>';
        $ret .= '<td align="center">'; 
                                              
            if ($arr['IST']['TBL_USER_FIELDS'][$field]['usf_mandatory']==1)
                {
            	$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/asterisk_yellow.png" alt="'.$gL10n->get('ORG_FIELD_MANDATORY').'" title="'.$gL10n->get('ORG_FIELD_MANDATORY').'" />';
            }
            else
           	{
            		$ret .= '<img class="iconInformation" src="'. THEME_PATH. '/icons/asterisk_gray.png" alt="'.$gL10n->get('ORG_FIELD_NOT_MANDATORY').'" title="'.$gL10n->get('ORG_FIELD_NOT_MANDATORY').'" />';
            }             
 		$ret .= '</td>';
            
		}
    return $ret;
}

// Funktion prueft, ob der Nutzer, aufgrund seiner Rollenzugehoerigkeiten berechtigt ist, das Plugin aufzurufen
// Parameter: Array mit Rollen-IDs  ( => $config_ini['Pluginfreigabe']['freigabe'] )
function check_showpluginPMB($array)
{
    $showPlugin = false;

    foreach ($array AS $i)
    {
        if(hasRole_IDPMB($i))
        {
            $showPlugin = true;
        } 
    } 
    return $showPlugin;
}

// Funktion date_format2mysql ersetzt date_german2mysql (erstellt von eiseli)
function date_format2mysql($date)
{
	return date('Y-m-d',strtotime($date));
}

function ageCalculator( $geburtstag, $stichtag )
{ 
    $day = date("d", $geburtstag); 
    $month = date("m", $geburtstag); 
    $year = date("Y", $geburtstag); 
       
    $cur_day = date("d", $stichtag); 
    $cur_month = date("m", $stichtag); 
    $cur_year = date("Y", $stichtag); 

    $calc_year = $cur_year - $year; 
     
    if( $month > $cur_month ) 
        return $calc_year - 1; 
    elseif ( $month == $cur_month && $day > $cur_day ) 
        return $calc_year - 1; 
     else 
        return $calc_year; 
}   

// Funktion überprüft den übergebenen Namen, ob er gemaess den Namenskonventionen für
// Profilfelder und Kategorien zum Uebersetzen durch eine Sprachdatei geeignet ist
// Bsp: SYS_COMMON --> Rueckgabe true
// Bsp: Mitgliedsbeitrag --> Rueckgabe false
function check_languagePMB($field_name)
{
    $ret = false;
 
    //prüfen, ob die ersten 3 Zeichen von $field_name Grußbuchstaben sind
    //prüfen, ob das vierte Zeichen von $field_name ein _ ist
    
    //Prüfung entfällt: prüfen, ob die restlichen Zeichen von $field_name Grußbuchstaben sind
    //if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')  && (ctype_upper(substr($field_name,4)))   )

    if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')   )
    {
    	$ret = true;
    }
    return $ret;
} 

//Diese Funktion überprüft die Länge von $tmpString für die Anzeige in Select-Boxen
//Autor: guenter47
//$tmpString = zu überprüfender String
//$maxStrLength = maximale Länge, die noch in die Selectbox passt
//Beispiel: Das ist ein sehr langer Text
//Rückgabe: Das ist ein se ... Text
function checkStringLengthPMB($tmpString, $maxStrLength)
{
	// Mindestlaenge vorgeben, ansonsten gibt es Ueberlappungen im neuen String 
	if ($maxStrLength<20)
	{
		$maxStrLength=20;
	}
    if(strlen($tmpString)>$maxStrLength)
    {
        $strPart1=substr($tmpString,0,$maxStrLength-20);
        $strPart2=substr($tmpString,strlen($tmpString)-15);
        $newString=$strPart1."...".$strPart2;
    }
    else
    {
        $newString=$tmpString;
    }
    return $newString;
}

// prüft, ob die Konfigurationstabelle existiert und legt sie ggf. an
function initConfigTablePMB()
{
	global $gL10n, $gDb, $gCurrentOrganization, $g_tbl_praefix;
	
	$config_ini = array();	
	$table_name = $g_tbl_praefix.'_plugin_preferences';
	
	// pruefen, ob es die Tabelle bereits gibt
	$sql = 'SHOW TABLES LIKE \''.$table_name.'\' ';
    $result = $gDb->query($sql);
    
    // Tabelle anlegen, wenn es sie noch nicht gibt
    if (!$gDb->num_rows($result))
    {
    	// Tabelle ist nicht vorhanden --> anlegen
        $sql = 'CREATE TABLE '.$table_name.' (
            plp_id 		integer     unsigned not null AUTO_INCREMENT,
            plp_org_id 	integer   	unsigned not null,
    		plp_name 	varchar(255) not null,
            plp_value  	text, 
            primary key (plp_id) )
            engine = InnoDB
         	auto_increment = 1
          	default character set = utf8
         	collate = utf8_unicode_ci';
    	$gDb->query($sql);
    } 

    // Konfiguration einlesen
	$config_ini = readConfigTablePMB();

	// überprüfen, ob bereits Konfigurationsdaten gesetzt sind, wenn nicht: vorbelegen
	// Pluginfreigabe
	if (!isset($config_ini['Pluginfreigabe']['freigabe']))
    {
		$config_ini['Pluginfreigabe']['freigabe'] = array(getRole_IDPMB($gL10n->get('SYS_WEBMASTER')),getRole_IDPMB($gL10n->get('SYS_MEMBER')));    		
    }

    // Plugininformationen
    if (!isset($config_ini['Plugininformationen']['plgin_mb_version']))
    {
		$config_ini['Plugininformationen']['plgin_mb_version'] = '';    		
    }
    if (!isset($config_ini['Plugininformationen']['plgin_mb_stand']))
    {
    	$config_ini['Plugininformationen']['plgin_mb_stand'] = '';	
    }    

    // Altersrollen
    if (!isset($config_ini['Altersrollen']['altersrollen_anzahl']))
    {
		$config_ini['Altersrollen']['altersrollen_anzahl'] = 1;   	
    }
    if (!isset($config_ini['Altersrollen']['altersrollen_token']))
    {
		$config_ini['Altersrollen']['altersrollen_token'] = array('*');    	
    }
    if (!isset($config_ini['Altersrollen']['altersrollen_stichtag']))
    {
    	$config_ini['Altersrollen']['altersrollen_stichtag'] = date('d.m.Y',strtotime((date('Y')-1).'-12-31'));	
    }

    // Familienrollen
    if (!isset($config_ini['Familienrollen']['familienrollen_anzahl']))
    {
    	$config_ini['Familienrollen']['familienrollen_anzahl'] = 1;	
    }
    if (!isset($config_ini['Familienrollen']['familienrollen_beitrag']))
    {
    	$config_ini['Familienrollen']['familienrollen_beitrag'] = array(0);	
    }    
    if (!isset($config_ini['Familienrollen']['familienrollen_zeitraum']))
    {
    	$config_ini['Familienrollen']['familienrollen_zeitraum'] = array(12);	
    }    
    if (!isset($config_ini['Familienrollen']['familienrollen_beschreibung']))
    {
    	$config_ini['Familienrollen']['familienrollen_beschreibung'] = array('Familienbeitrag');	
    }    
    if (!isset($config_ini['Familienrollen']['familienrollen_prefix']))
    {
    	$config_ini['Familienrollen']['familienrollen_prefix'] = array('Familie');	
    } 
    if (!isset($config_ini['Familienrollen']['familienrollen_pruefung']))
    {
    	$config_ini['Familienrollen']['familienrollen_pruefung'] = array('');	
    }    

    //Beitrag
    if (!isset($config_ini['Beitrag']['beitrag_prefix']))
    {
    	$config_ini['Beitrag']['beitrag_prefix'] = 'Mitgliedsbeitrag 2014';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_suffix']))
    {
    	$config_ini['Beitrag']['beitrag_suffix'] = '(ant.)';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_modus']))
    {
    	$config_ini['Beitrag']['beitrag_modus'] = 'standard';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_loeschen']))
    {
    	$config_ini['Beitrag']['beitrag_loeschen'] = 'all';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_rollenabfrage']))
    {
    	$config_ini['Beitrag']['beitrag_rollenabfrage'] = '';	
    }
    if (!isset($config_ini['Beitrag']['zahlungen_rollenabfrage']))
    {
    	$config_ini['Beitrag']['zahlungen_rollenabfrage'] = '';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_textmitnam']))
    {
    	$config_ini['Beitrag']['beitrag_textmitnam'] = 1;	
    }    
    if (!isset($config_ini['Beitrag']['beitrag_textmitfam']))
    {
    	$config_ini['Beitrag']['beitrag_textmitfam'] = '';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_text_token']))
    {
    	$config_ini['Beitrag']['beitrag_text_token'] = '#';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_anteilig']))
    {
    	$config_ini['Beitrag']['beitrag_anteilig'] = '';	
    }
    if (!isset($config_ini['Beitrag']['beitrag_abrunden']))
    {
    	$config_ini['Beitrag']['beitrag_abrunden'] = 1;	
    }    
    if (!isset($config_ini['Beitrag']['beitrag_mindestbetrag']))
    {
    	$config_ini['Beitrag']['beitrag_mindestbetrag'] = 0;	
    }
        
    //Kontodaten
    if (!isset($config_ini['Kontodaten']['ktonr']))
    {
    	$config_ini['Kontodaten']['ktonr'] = 1234567890;	
    }    
    if (!isset($config_ini['Kontodaten']['blz']))
    {
    	$config_ini['Kontodaten']['blz'] = 1234567890;	
    }    
    if (!isset($config_ini['Kontodaten']['bank']))
    {
    	$config_ini['Kontodaten']['bank'] = 'Sparkasse Musterstadt';	
    }    
    if (!isset($config_ini['Kontodaten']['inhaber']))
    {
    	$config_ini['Kontodaten']['inhaber'] = 'Musterverein e.V.';	
    }    
    if (!isset($config_ini['Kontodaten']['iban']))
    {
    	$config_ini['Kontodaten']['iban'] = 'DE123456789';	
    }    
    if (!isset($config_ini['Kontodaten']['bic']))
    {
    	$config_ini['Kontodaten']['bic'] = 'ABCDEFGH';	
    }    
    if (!isset($config_ini['Kontodaten']['ci']))
    {
    	$config_ini['Kontodaten']['ci'] = 'DE98ZZZ09999999999';	
    }    
    if (!isset($config_ini['Kontodaten']['origcreditor']))
    {
    	$config_ini['Kontodaten']['origcreditor'] = '';	
    }    
    if (!isset($config_ini['Kontodaten']['origci']))
    {
    	$config_ini['Kontodaten']['origci'] = '';	
    }    
    
    //Mandatsreferenz
    if (!isset($config_ini['Mandatsreferenz']['prefix_fam']))
    {
    	$config_ini['Mandatsreferenz']['prefix_fam'] = 'FAM';	
    } 
    if (!isset($config_ini['Mandatsreferenz']['prefix_mem']))
    {
    	$config_ini['Mandatsreferenz']['prefix_mem'] = 'MIT';	
    } 
    if (!isset($config_ini['Mandatsreferenz']['prefix_pay']))
    {
    	$config_ini['Mandatsreferenz']['prefix_pay'] = 'ZAL';	
    } 
    if (!isset($config_ini['Mandatsreferenz']['min_length']))
    {
    	$config_ini['Mandatsreferenz']['min_length'] = 15;	
    } 
    if (!isset($config_ini['Mandatsreferenz']['data_field']))
    {
    	$config_ini['Mandatsreferenz']['data_field'] = '-- User_ID --';	
    } 
    
    //Rollenpruefung
    if (!isset($config_ini['Rollenpruefung']['altersrollenfamilienrollen']))
    {
    	$config_ini['Rollenpruefung']['altersrollenfamilienrollen'] = 1;	
    }
    if (!isset($config_ini['Rollenpruefung']['altersrollenpflicht']))
    {
    	$config_ini['Rollenpruefung']['altersrollenpflicht'] = '';	
    }
    if (!isset($config_ini['Rollenpruefung']['familienrollenpflicht']))
    {
    	$config_ini['Rollenpruefung']['familienrollenpflicht'] = '';	
    }
    if (!isset($config_ini['Rollenpruefung']['fixrollenpflicht']))
    {
    	$config_ini['Rollenpruefung']['fixrollenpflicht'] = '';	
    }
    if (!isset($config_ini['Rollenpruefung']['bezugskategorie']))
    {
    	$config_ini['Rollenpruefung']['bezugskategorie'] = '';	
    }
    if (!isset($config_ini['Rollenpruefung']['familienrollenfix']))
    {
    	$config_ini['Rollenpruefung']['familienrollenfix'] = '';	
    }
    if (!isset($config_ini['Rollenpruefung']['altersrollenfix']))
    {
    	$config_ini['Rollenpruefung']['altersrollenfix'] = '';	
    }

    //Rechnungs-Export
    if (!isset($config_ini['Rechnungs-Export']['rechnung_dateiname']))
    {
    	$config_ini['Rechnungs-Export']['rechnung_dateiname'] = 'rechnung.csv';	
    }

    //SEPA
    if (!isset($config_ini['SEPA']['dateiname']))
    {
    	$config_ini['SEPA']['dateiname'] = 'sepa';	
    }
    if (!isset($config_ini['SEPA']['kontroll_dateiname']))
    {
    	$config_ini['SEPA']['kontroll_dateiname'] = 'sepa';	
    }
    if (!isset($config_ini['SEPA']['duedate_rollenabfrage']))
    {
    	$config_ini['SEPA']['duedate_rollenabfrage'] = '';	
    }

    //Optionen
    if (!isset($config_ini['Optionen']['select_maxlength']))
    {
    	$config_ini['Optionen']['select_maxlength'] = 30;	
    }
    if (!isset($config_ini['Optionen']['dbtoken']))
    {
    	$config_ini['Optionen']['dbtoken'] = '#_#';	
    }
    
	// $config_ini in die Tabelle schreiben
    writeConfigTablePMB($config_ini);  
     
    return ;
}

// Funktion schreibt die $config_ini in die Datenbank
function writeConfigTablePMB($config_ini)
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
    
     foreach($config_ini as $section => $sectiondata)
    {
        foreach($sectiondata as $key => $value)
        {
            if (is_array($value))
            {
                // um diesen Datensatz in der Datenbank als Array zu kennzeichnen, wird er von Doppelklammern eingeschlossen 
            	$value = '(('.implode($config_ini['Optionen']['dbtoken'],$value).'))';
            } 
            
  			$plp_name = 'PMB__'.$section.'__'.$key;
          
            $sql = ' SELECT plp_id 
            		FROM '.$table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
            $result = $gDb->query($sql);
            $row = $gDb->fetch_object($result);

            // Gibt es den Datensatz bereits?
            // wenn ja: UPDATE des bestehende Datensatzes  
            if( isset($row->plp_id) && (strlen($row->plp_id) > 0) )
            {
                $sql = 'UPDATE '.$table_name.' 
                		SET plp_value = \''.$value.'\' 
                		WHERE plp_id = '.$row->plp_id;   
                    
                $gDb->query($sql);           
            }
            // wenn nicht: INSERT eines neuen Datensatzes 
            else
            {
  				$sql = 'INSERT INTO '.$table_name.' (plp_org_id, plp_name, plp_value) 
  						VALUES (\''.$gCurrentOrganization->getValue('org_id').'\' ,\'PMB__'.$section.'__'.$key.'\' ,\''.$value.'\')'; 
            	$gDb->query($sql); 
            }   
        } 
    }
    return ;
}

// Funktion liest die Konfigurationsdaten aus der Datenbank
function readConfigTablePMB()
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
    $config_ini = array();
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
 	
 	// im ersten Schritt das Token einlesen
 	$sql = ' SELECT plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PMB__Optionen__dbtoken\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
 	$result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);
    $dbtoken =  $row->plp_value ;
     
	$sql = ' SELECT plp_id, plp_name, plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PMB__%\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
	$result = $gDb->query($sql);
	
	while($row = $gDb->fetch_array($result))
	{
		$array = explode('__',$row['plp_name']);
		
		// wenn plp_value von ((  )) eingeschlossen ist, dann ist es als Array einzulesen
		if ((substr($row['plp_value'],0,2)=='((' ) && (substr($row['plp_value'],-2)=='))' ))
        {
        	$row['plp_value'] = substr($row['plp_value'],2,-2);
        	$config_ini[$array[1]] [$array[2]] = explode($dbtoken,$row['plp_value']); 
        }
        else 
		{
            $config_ini[$array[1]] [$array[2]] = $row['plp_value'];
        }
	}
    return $config_ini;
}

// diese Funktion erzeugt eine Mitgliedsnummer
function erzeuge_mitgliedsnummer()
{    
	global $gDb,$gMessage,$gL10n;
	
    $rueckgabe_mitgliedsnummer = 0;
 	$mitgliedsnummern = array();
	$id_mitgliedsnummer = 0;
	
	$sql = ' SELECT usf_id
             FROM '.TBL_USER_FIELDS.'
             WHERE usf_name = \'PMB_MEMBERNUMBER\' ';
    $result = $gDb->query($sql);
   	$row = $gDb->fetch_object($result);
    $id_mitgliedsnummer = $row->usf_id;
    
    $sql = 'SELECT usd_value
            FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = \''.$id_mitgliedsnummer.'\' ';
    $result = $gDb->query($sql);
    while( $row = $gDb->fetch_array($result))
	{
		$mitgliedsnummern[] = $row['usd_value'];
	}	
      
    sort($mitgliedsnummern);
   
    //überprüfung auf doppelte Mitgliedsnummern
    for ($i=0; $i < count($mitgliedsnummern)-1;$i++)
    {
        if ($mitgliedsnummern[$i] == $mitgliedsnummern[$i+1])
        {
            $gMessage->show($gL10n->get('PMB_MEMBERNUMBER_ERROR',$mitgliedsnummern[$i]));
            break;
     	}
    }     
        
    $hoechste_mitgliedsnummer = end($mitgliedsnummern);

    $i = 1;
    while ($i < $hoechste_mitgliedsnummer)
    {
        if (!in_array($i,$mitgliedsnummern)) 
        {
            $rueckgabe_mitgliedsnummer = $i;
            break;
        }
        $i++;
    }  
    return ($rueckgabe_mitgliedsnummer == 0) ? $hoechste_mitgliedsnummer+1 : $rueckgabe_mitgliedsnummer;
}

// erzeugt Mandatsreferenzen
function erzeuge_mandatsreferenz()
{ 
	global $gDb,$config_ini,$gMessage,$gCurrentOrganization,$gProfileFields,$gL10n;
    $referenz = ''; 
    $message = '';  
    $members = array();

	if($config_ini['Mandatsreferenz']['data_field']<>'-- User_ID --')
	{     
		$members = list_members(array('LAST_NAME','FIRST_NAME','KONTOINHABER','MANDATEID'.$gCurrentOrganization->getValue('org_id'),'BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'IBAN',$config_ini['Mandatsreferenz']['data_field']), 0)  ;
	}
	else 
	{
		$members = list_members(array('LAST_NAME','FIRST_NAME','KONTOINHABER','MANDATEID'.$gCurrentOrganization->getValue('org_id'),'BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'IBAN'), 0)  ;
	}

	//alle Mitglieder löschen, bei denen kein Beitrag berechnet wurde
	$members = array_filter($members, 'delete_without_BEITRAG');
                            
	//alle Mitglieder löschen, bei denen keine IBAN vorhanden ist
	$members = array_filter($members, 'delete_without_IBAN');
	
	//alle Mitglieder löschen, bei denen bereits eine Mandatsreferenz vorhanden ist
	$members = array_filter($members, 'delete_with_MANDATEID');
	
	//alle übriggebliebenen Mitglieder durchlaufen und eine Mandatsreferenz erzeugen
	foreach ($members as $member => $memberdata)
	{		
		$prefix = $config_ini['Mandatsreferenz']['prefix_mem'];
		
		//wenn 'KONTOINHABER' nicht leer ist, dann gibt es einen Zahlungspflichtigen
		if($memberdata['KONTOINHABER']<>'')
		{
			$prefix = $config_ini['Mandatsreferenz']['prefix_pay'];
		}
		
		foreach ($config_ini['Familienrollen']['familienrollen_beschreibung'] as $famrolbesch )
		{
			if(substr_count($memberdata['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')],$famrolbesch)==1)
			{
				$prefix = $config_ini['Mandatsreferenz']['prefix_fam'];
			}			
		}				
		if($config_ini['Mandatsreferenz']['data_field']<>'-- User_ID --')
		{
			$suffix = $memberdata[$config_ini['Mandatsreferenz']['data_field']];
		}
		else 
		{
			$suffix = $member;
		}		
		
    	$referenz = str_pad($prefix, $config_ini['Mandatsreferenz']['min_length']-strlen($suffix) , '0').$suffix;
	
    	$user = new User($gDb, $gProfileFields, $member);
    	$user->setValue('MANDATEID'.$gCurrentOrganization->getValue('org_id'), $referenz);
    	$user->save();
    	$message .= $gL10n->get('PMB_MANDATEID_RES1',$members[$member]['FIRST_NAME'],$members[$member]['LAST_NAME'],$referenz);
	}
	
	// Message ausgeben (wenn keinem Mitglied eine Mitgliedsnummer zugewiesen wurde, dann ist die Variable leer)
	if ($message == '')
	{
    	$gMessage->show($gL10n->get('PMB_MANDATEID_RES2'));
	}
	else
	{
    	$gMessage->show($message);    
	}
    
    return;
}

// loescht Zeilen in einem Array
function delete_without_BEITRAG ( $wert )
{
    global $gCurrentOrganization;
    return ( $wert['BEITRAG'.$gCurrentOrganization->getValue('org_id')] != NULL );
}
// loescht Zeilen in einem Array
function delete_without_IBAN ( $wert )
{    
    return ( $wert['IBAN'] != NULL );
}
// loescht Zeilen in einem Array
function delete_without_BIC ( $wert )
{    
    return ( $wert['BIC'] != NULL );
}
// loescht Zeilen in einem Array
function delete_with_MANDATEID ( $wert )
{       
	global $gCurrentOrganization;
    return !( $wert['MANDATEID'.$gCurrentOrganization->getValue('org_id')] != NULL );
}
// loescht Zeilen in einem Array
function delete_with_BEZAHLT ( $wert )
{       
	global $gCurrentOrganization;
    return !( $wert['BEZAHLT'.$gCurrentOrganization->getValue('org_id')] != NULL );
}
// loescht Zeilen in einem Array
function delete_without_MANDATEID ( $wert )
{       
	global $gCurrentOrganization;
    return ( $wert['MANDATEID'.$gCurrentOrganization->getValue('org_id')] != NULL );
}
// loescht Zeilen in einem Array
function delete_without_MANDATEDATE ( $wert )
{       
	global $gCurrentOrganization;
    return ( $wert['MANDATEDATE'.$gCurrentOrganization->getValue('org_id')] != NULL );
}

function umlaute($tmptext)
{
	// Autor: guenter47
	// angepasst wegen einem Fehler bei der Umsetzung von ß
	
	$tmptext = htmlentities($tmptext);
	$tmptext=str_replace('&uuml;','ue', $tmptext);
	$tmptext=str_replace('&auml;','ae', $tmptext);
	$tmptext=str_replace('&ouml;','oe', $tmptext);
	$tmptext=str_replace('&szlig;','ss',$tmptext);
	$tmptext=str_replace('&Uuml;','Ue', $tmptext);
	$tmptext=str_replace('&Auml;','Ae', $tmptext);
	$tmptext=str_replace('&Ouml;','Oe', $tmptext);
	return $tmptext;
}

function umlaute2($tmptext)
{
	$charMap = array(
        'Ä' => 'Ae',
        'ä' => 'ae',
        'À' => 'A',
        'à' => 'a',
        'Á' => 'A',
        'á' => 'a',
        'Â' => 'A',
        'â' => 'a',
        'Æ' => 'AE',
        'æ' => 'ae',
        'Ã' => 'A',
        'ã' => 'a',
        'Å' => 'A',
        'å' => 'a',
        'Ç' => 'C',
        'ç' => 'c',
        'Ë' => 'E',
        'ë' => 'e',
        'È' => 'E',
        'è' => 'e',
        'É' => 'E',
        'é' => 'e',
        'Ê' => 'E',
        'ê' => 'e',
        'Ï' => 'I',
        'ï' => 'i',
        'Ì' => 'I',
        'ì' => 'i',
        'Í' => 'I',
        'í' => 'i',
        'Î' => 'I',
        'î' => 'i',
        'ß' => 'ss',
        'Ñ' => 'N',
        'ñ' => 'n',
        'Œ' => 'OE',
        'œ' => 'oe',
        'Ö' => 'Oe',
        'ö' => 'oe',
        'Ò' => 'O',
        'ò' => 'o',
        'Ó' => 'O',
        'ó' => 'o',
        'Ô' => 'O',
        'ô' => 'o',
        'Õ' => 'O',
        'õ' => 'o',
        'Ø' => 'O',
        'ø' => 'o',
        'ß' => 'ss',
        'Ü' => 'Ue',
        'ü' => 'ue',
        'Ù' => 'U',
        'ù' => 'u',
        'Ú' => 'U',
        'ú' => 'u',
        'Û' => 'U',
        'û' => 'u',
        'ÿ' => 'y',
        'Ý' => 'Y',
        'ý' => 'y',
		'€' => 'EUR',
		'&' => 'und');

	return str_replace(array_keys($charMap), array_values($charMap), $tmptext);
}

//löscht die Einträge Beitrag, Beitragstext und Bezahlt-Datum
function delete_contribution()
{       
	global $gDb,$config_ini,$gCurrentOrganization,$gProfileFields;
	
   	$members = array();
	$members = list_members(array('BEZAHLT'.$gCurrentOrganization->getValue('org_id'),'BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'DUEDATE'.$gCurrentOrganization->getValue('org_id')), 0)  ;

	foreach ($members as $key => $data)
	{
		$user = new User($gDb, $gProfileFields, $key);

		if (!empty($data['DUEDATE'.$gCurrentOrganization->getValue('org_id')])
			&& ( ($config_ini['Beitrag']['beitrag_loeschen']=='duedate') )
			)
		{
    		$user->setValue('DUEDATE'.$gCurrentOrganization->getValue('org_id'), '');	
		}
		
		if (!empty($data['BEZAHLT'.$gCurrentOrganization->getValue('org_id')])
			&& (   ($config_ini['Beitrag']['beitrag_loeschen']=='with')
				|| ($config_ini['Beitrag']['beitrag_loeschen']=='only')
				|| ($config_ini['Beitrag']['beitrag_loeschen']=='all')
			   )
			)
		{
    		$user->setValue('BEZAHLT'.$gCurrentOrganization->getValue('org_id'), '');	
		}
		
		if (!empty($data['BEITRAG'.$gCurrentOrganization->getValue('org_id')])
			&& (   (($config_ini['Beitrag']['beitrag_loeschen']=='with') && !empty($data['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]))
				|| (($config_ini['Beitrag']['beitrag_loeschen']=='without')&& empty($data['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]))
				|| ($config_ini['Beitrag']['beitrag_loeschen']=='all')
			   )
			)
		{
    		$user->setValue('BEITRAG'.$gCurrentOrganization->getValue('org_id'), '');	
		}
		
		if (!empty($data['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')])
			&& (   (($config_ini['Beitrag']['beitrag_loeschen']=='with') && !empty($data['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]))
				|| (($config_ini['Beitrag']['beitrag_loeschen']=='without')&& empty($data['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]))
				|| ($config_ini['Beitrag']['beitrag_loeschen']=='all')
			   )
			)
		{
    		$user->setValue('BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'), '');	
		}
   		$user->save();
	} 
    return;
}

function replace_emailparameter($text,$user)
{       
	global $gCurrentOrganization;
	
	// Konfiguration einlesen
	$config_ini = readConfigTablePMB();

	// now replace all parameters in email text
	$text = preg_replace ('/%user_first_name%/', $user->getValue('FIRST_NAME'),  $text);
	$text = preg_replace ('/%user_last_name%/',  $user->getValue('LAST_NAME'), $text);
	$text = preg_replace ('/%organization_long_name%/', $gCurrentOrganization->getValue('org_longname'), $text);
	$text = preg_replace ('/%fee%/', $user->getValue('BEITRAG'.$gCurrentOrganization->getValue('org_id')),   $text);
	$text = preg_replace ('/%due_day%/', $user->getValue('DUEDATE'.$gCurrentOrganization->getValue('org_id')),  $text);
	$text = preg_replace ('/%mandate_id%/', $user->getValue('MANDATEID'.$gCurrentOrganization->getValue('org_id')), $text);
	$text = preg_replace ('/%creditor_id%/',  $config_ini['Kontodaten']['ci'], $text);
	$text = preg_replace ('/%iban%/',   $user->getValue('IBAN'), $text);
	$text = preg_replace ('/%debtor%/',   $user->getValue('KONTOINHABER'), $text);
	$text = preg_replace ('/%membership_fee_text%/', $user->getValue('BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')),   $text);
 
	return $text; 
}
?>