<?php
/******************************************************************************
 * 
 * install.php
 *   
 * Setuproutine fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *  
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once(dirname(__FILE__).'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/version.php');

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

// mit der Version 3.3.6 des Plugins wurde die Option DTA-Export ersatzlos gestrichen
// Die nachfolgende Routine löscht jetzt überflüssige Einträge in der DB
unset($config_ini['DTA-Export']);

$table_name = $g_tbl_praefix.'_plugin_preferences';
$sql = 'DELETE FROM '.$table_name.'
        WHERE plp_name LIKE \'PMB__DTA-Export%\'
        AND plp_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
$gDb->query($sql);
// Ende Löschroutine
    		
// Navigation faengt hier im Modul an
$gNavigation->clear();
$gNavigation->addUrl(CURRENT_URL);

if (isset($_REQUEST['speichern'])) 
{
    $config_ini['Plugininformationen']['plgin_mb_version'] = $plugin_mb_version ;
    $config_ini['Plugininformationen']['plgin_mb_stand'] = $plugin_mb_stand ;
    writeConfigTablePMB($config_ini);
    header('Location: '.$g_root_path.'//index.php');
} 

$gLayout['title']  = $gL10n->get('PMB_INSTALL_TITLE');

require(SERVER_PATH. '/adm_program/system/overall_header.php');

echo '<h1 class="moduleHeadline">'.$gLayout['title'].'</h1>';
 
if (isset($_REQUEST['anlegen'])) 
{
    $arr = Check_DB();
     
    unset($_REQUEST['anlegen']) ;

    // prüfen, ob es die Kategorie Mitgliedschaft gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_CATEGORIES']['Mitgliedschaft']['cat_id']))
    {
        $nextCatSequence = getNextCatSequence('USF') ;
        
        $sql = 'INSERT INTO '.TBL_CATEGORIES.' (cat_type, cat_name, cat_name_intern, cat_org_id, cat_hidden, cat_system, cat_sequence,cat_usr_id_create)
                VALUES (\'USF\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']['cat_name'].'\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']['cat_name_intern'].'\' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']['cat_org_id'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']['cat_hidden'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedschaft']['cat_system'].' ,
                        '.$nextCatSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);  
    }  
        
    // prüfen, ob es das Profilfeld Beitritt gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Beitritt']['usf_name'])) 
    {
        $cat_id_mitgliedschaft = getCat_IDPMB('Mitgliedschaft');  
        $nextFieldSequence = getNextFieldSequence($cat_id_mitgliedschaft) ; 
        
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedschaft.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitritt']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);          
    }

	// prüfen, ob es das Profilfeld Mitgliedsnummer gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_name'])) 
    {
        $cat_id_stammdaten = getCat_IDPMB('SYS_MASTER_DATA');  
        $nextFieldSequence = getNextFieldSequence($cat_id_stammdaten) ; 
        
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_stammdaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);          
    }
    
    // prüfen, ob es die Kategorie Mitgliedsbeitrag gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_id']))
    {
        $nextCatSequence = getNextCatSequence('USF') ;
        
        $sql = 'INSERT INTO '.TBL_CATEGORIES.' (cat_type, cat_name, cat_name_intern, cat_org_id, cat_hidden, cat_system, cat_sequence,cat_usr_id_create)
                VALUES (\'USF\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_name'].'\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_name_intern'].'\' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_org_id'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_hidden'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_system'].' ,
                        '.$nextCatSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);  
    }
      
    $cat_id_mitgliedsbeitrag = getCat_IDPMB('Mitgliedsbeitrag');  
    $nextFieldSequence = getNextFieldSequence($cat_id_mitgliedsbeitrag) ; 
    
    // prüfen, ob es das Profilfeld Bezahlt gibt, wenn nicht: anlegen         
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Bezahlt']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedsbeitrag.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bezahlt']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++; 
    }

    // prüfen, ob es das Profilfeld Beitrag gibt, wenn nicht: anlegen        
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Beitrag']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedsbeitrag.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitrag']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                          
    }
        
    // prüfen, ob es das Profilfeld Beitragstext gibt, wenn nicht: anlegen
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Beitragstext']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedsbeitrag.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Beitragstext']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;    
    }
    
    // prüfen, ob es das Profilfeld Sequenztyp gibt, wenn nicht: anlegen
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Sequenztyp']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedsbeitrag.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Sequenztyp']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;    
    }
    
    // prüfen, ob es das Profilfeld Fälligkeitsdatum gibt, wenn nicht: anlegen
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mitgliedsbeitrag.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
    }

    
    // prüfen, ob es die Kategorie Mandat gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_CATEGORIES']['Mandat']['cat_id']))
    {
        $nextCatSequence = getNextCatSequence('USF') ;
        
        $sql = 'INSERT INTO '.TBL_CATEGORIES.' (cat_type, cat_name, cat_name_intern, cat_org_id, cat_hidden, cat_system, cat_sequence,cat_usr_id_create)
                VALUES (\'USF\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mandat']['cat_name'].'\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Mandat']['cat_name_intern'].'\' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mandat']['cat_org_id'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mandat']['cat_hidden'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Mandat']['cat_system'].' ,
                        '.$nextCatSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);  
    } 
         
    $cat_id_mandat = getCat_IDPMB('PMB_MANDATE');  
    $nextFieldSequence = getNextFieldSequence($cat_id_mandat) ; 
    
    // prüfen, ob es das Profilfeld Mandatsreferenz gibt, wenn nicht: anlegen
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mandat.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;  
    }
    
    // prüfen, ob es das Profilfeld Mandatsdatum gibt, wenn nicht: anlegen
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsdatum']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mandat.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Mandatsdatum']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;  
    }
    
    // prüfen, ob es das Profilfeld Orig_Mandatsreferenz gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_mandat.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);
 	} 
    
    // prüfen, ob es die Kategorie Kontodaten gibt, wenn nicht: anlegen
    if (!isset($arr['IST']['TBL_CATEGORIES']['Kontodaten']['cat_id']))
    {
        $nextCatSequence = getNextCatSequence('USF') ;
        
        $sql = 'INSERT INTO '.TBL_CATEGORIES.' (cat_type, cat_name, cat_name_intern, cat_org_id, cat_hidden, cat_system, cat_sequence,cat_usr_id_create)
                VALUES (\'USF\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Kontodaten']['cat_name'].'\' ,
                        \''.$arr['SOLL']['TBL_CATEGORIES']['Kontodaten']['cat_name_intern'].'\' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Kontodaten']['cat_org_id'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Kontodaten']['cat_hidden'].' ,
                        '.$arr['SOLL']['TBL_CATEGORIES']['Kontodaten']['cat_system'].' ,
                        '.$nextCatSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);    
    } 
         
    $cat_id_kontodaten = getCat_IDPMB('Kontodaten');  
    $nextFieldSequence = getNextFieldSequence($cat_id_kontodaten) ; 

    // prüfen, ob es das Profilfeld Kontonummer gibt, wenn nicht: anlegen                          
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Kontonummer']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontonummer']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                     
    }

    // prüfen, ob es das Profilfeld Bankleitzahl gibt, wenn nicht: anlegen         
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Bankleitzahl']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankleitzahl']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                       
    }
   // prüfen, ob es das Profilfeld IBAN gibt, wenn nicht: anlegen         
    if (!isset($arr['IST']['TBL_USER_FIELDS']['IBAN']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['IBAN']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                      
    }
   // prüfen, ob es das Profilfeld BIC gibt, wenn nicht: anlegen         
    if (!isset($arr['IST']['TBL_USER_FIELDS']['BIC']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['BIC']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                        
    }
    
   	// prüfen, ob es das Profilfeld Bankname gibt, wenn nicht: anlegen         
    if (!isset($arr['IST']['TBL_USER_FIELDS']['Bankname']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Bankname']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;                                        
    }   
    // prüfen, ob es das Profilfeld Kontoinhaber gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Kontoinhaber']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Kontoinhaber']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;
    }
    
    // prüfen, ob es das Profilfeld KontoinhaberAdresse gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;
    } 
    
    // prüfen, ob es das Profilfeld KontoinhaberPLZ gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql);
        $nextFieldSequence++; 
    }
               
    // prüfen, ob es das Profilfeld KontoinhaberOrt gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;
    }
    
    // prüfen, ob es das Profilfeld KontoinhaberEMail gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;
    }    
    
    // prüfen, ob es das Profilfeld Orig_Debtor_Agent gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
        $nextFieldSequence++;
    }                             
    // prüfen, ob es das Profilfeld Orig_IBAN gibt, wenn nicht: anlegen 
    if(!isset($arr['IST']['TBL_USER_FIELDS']['Orig_IBAN']['usf_name']))
    {
        $sql = 'INSERT INTO '.TBL_USER_FIELDS.' (usf_cat_id, usf_type, usf_name, usf_name_intern, usf_description, usf_system, usf_disabled, usf_hidden, usf_mandatory, usf_sequence, usf_usr_id_create)
                VALUES (\''.$cat_id_kontodaten.'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_type'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_name'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_name_intern'].'\' ,
                        \''.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_description'].'\' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_system'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_disabled'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_hidden'].' ,
                        '.$arr['SOLL']['TBL_USER_FIELDS']['Orig_IBAN']['usf_mandatory'].' ,
                        '.$nextFieldSequence.',
                        '.$gCurrentUser->getValue('usr_id').' )'; 
        $gDb->query($sql); 
    }                               
}

$arr = Check_DB();
        
if (isset($_REQUEST['soll_ist'])) 
{
    // Beginn Prüfung SOLL-IST-Vergleich 
    echo'
    <table border="0">
        <tr>
            <td>'.$gL10n->get('PMB_INSTALL_DESCRIPTION').'</td>
        </tr>
        <tr>
            <td>&#160;</td>
        </tr>
        <tr>
            <td>'.$gL10n->get('PMB_INSTALL_FIRST_PASSAGE').': '.$gL10n->get('PMB_INSTALL_VERIFICATION_MISSING_FIELDS').'</td>
        </tr>
        <tr>
            <td><strong>'.$gL10n->get('PMB_INSTALL_SECOND_PASSAGE').':  ==> '.$gL10n->get('PMB_INSTALL_VERIFICATION_COMPARISON').'</strong></td>
        </tr>
    </table>
    <BR>
    
    <div style="width:100%; overflow:auto; border:0px;">
        <table border="0">
            <tr>
                <th rowspan="2" align="center">'.$gL10n->get('SYS_CATEGORY').'</th>
                <th rowspan="2" align="center">'.$gL10n->get('PMB_PROFILE_FIELD').'</th>
                <th align="center" colspan="2">'.$gL10n->get('SYS_INTERNAL_NAME').'</th>
                <th align="center" colspan="2">'.$gL10n->get('PMB_DATA_TYPE').'</th>
                <td align="center" colspan="2"><img class="iconInformation" src="'. THEME_PATH. '/icons/eye.png" alt="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" title="'.$gL10n->get('ORG_FIELD_NOT_HIDDEN').'" /></td>
                <td align="center" colspan="2"><img class="iconInformation" src="'. THEME_PATH. '/icons/textfield_key.png" alt="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" title="'.$gL10n->get('ORG_FIELD_DISABLED', $gL10n->get('ROL_RIGHT_EDIT_USER')).'" /></td>
                <td align="center" colspan="2"><img class="iconInformation" src="'. THEME_PATH. '/icons/asterisk_yellow.png" alt="'.$gL10n->get('ORG_FIELD_MANDATORY').'" title="'.$gL10n->get('ORG_FIELD_MANDATORY').'" /></td>
            </tr>
            <tr>';
                for ($i=0;$i<5;$i++)
                {
				    echo '  <th align="center">'.$gL10n->get('PMB_SHALL').'</th>
                        <th align="center">'.$gL10n->get('PMB_IS').'</th> ';
                }    
            echo'</tr>
            <tr>
                <td colspan="2">'.$gL10n->get('SYS_MASTER_DATA').'</td>';
                echo'
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_MEMBERNUMBER').'</td>' ;    
                echo SollIstAnzeige($arr,'Mitgliedsnummer');
                echo' 
            </tr>
            <tr>
                <td colspan="2">'.$gL10n->get('PMB_MEMBERSHIP').'</td>';
                echo SollIstAnzeige($arr,'Mitgliedschaft');
                echo'
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ACCESSION').'</td>' ;    
                echo SollIstAnzeige($arr,'Beitritt');
                echo' 
            </tr>
            <tr>
                <td colspan="2">'.$gL10n->get('PMB_MEMBERSHIP_FEE').'</td>';
                echo SollIstAnzeige($arr,'Mitgliedsbeitrag');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('SYS_CONTRIBUTION').'</td>';
                echo SollIstAnzeige($arr,'Beitrag');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_PAID').'</td>';
                echo SollIstAnzeige($arr,'Bezahlt');
                echo' 
            </tr>
            <tr>   
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_CONTRIBUTORY_TEXT').'</td>';
                echo SollIstAnzeige($arr,'Beitragstext');
                echo' 
            </tr>
            <tr>   
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_SEQUENCETYPE').'</td>';
                echo SollIstAnzeige($arr,'Sequenztyp');
                echo' 
            </tr>
            <tr>   
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_DUEDATE').'</td>';
                echo SollIstAnzeige($arr,'Faelligkeitsdatum');
                echo' 
            </tr>
            <tr>
                <td colspan="2">'.$gL10n->get('PMB_MANDATE').'</td>';
                echo SollIstAnzeige($arr,'Mandat');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_MANDATEID').'</td>';
                echo SollIstAnzeige($arr,'Mandatsreferenz');
                echo' 
            </tr>
            <tr>   
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_MANDATEDATE').'</td>';
                echo SollIstAnzeige($arr,'Mandatsdatum');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ORIG_MANDATEID').'</td>';
                echo SollIstAnzeige($arr,'Orig_Mandatsreferenz');
                echo' 
            </tr>
            <tr>
                <td colspan="2">'.$gL10n->get('PMB_ACCOUNT_DATA').'</td>';
                echo SollIstAnzeige($arr,'Kontodaten');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ACCOUNT_NUMBER').'</td>';
                echo SollIstAnzeige($arr,'Kontonummer');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_BANK_CODE_NUMBER').'</td>';
                echo SollIstAnzeige($arr,'Bankleitzahl');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_IBAN').'</td>';
                echo SollIstAnzeige($arr,'IBAN');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_BIC').'</td>';
                echo SollIstAnzeige($arr,'BIC');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_BANK').'</td>';
                echo SollIstAnzeige($arr,'Bankname');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ACCOUNT_HOLDER').'</td>';
                echo SollIstAnzeige($arr,'Kontoinhaber');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ADDRESS').'</td>';
                echo SollIstAnzeige($arr,'KontoinhaberAdresse');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_POSTCODE').'</td>';
                echo SollIstAnzeige($arr,'KontoinhaberPLZ');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_CITY').'</td>';
                echo SollIstAnzeige($arr,'KontoinhaberOrt');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_EMAIL').'</td>';
                echo SollIstAnzeige($arr,'KontoinhaberEMail');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ORIG_DEBTOR_AGENT').'</td>';
                echo SollIstAnzeige($arr,'Orig_Debtor_Agent');
                echo' 
            </tr>
            <tr>
                <td align="right">-</td>
                <td>'.$gL10n->get('PMB_ORIG_IBAN').'</td>';
                echo SollIstAnzeige($arr,'Orig_IBAN');
                echo' 
            </tr>
        </table>
    </div> 
    <BR>'.$gL10n->get('PMB_SECOND_PASSAGE_INFO').'
    <table border="0">
        <tr>
            <td>
        	   <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/install.php" method="post">
                    <div class="formSubmit">	
                        <button id="btnSpeichern" type="submit" name="speichern"><img src="'. THEME_PATH. '/icons/disk.png" alt="Speichern" />&nbsp;'.$gL10n->get('SYS_NEXT').'</button>
                    </div>
                </form>
            </td>
            <td>
                <form action="'.$g_root_path.'/adm_program/system/back.php" method="post">
                    <div class="formSubmit">	
                        <button id="btnAbbrechen" type="submit" name="abbrechen"><img src="'. THEME_PATH. '/icons/delete.png" alt="Abbrechen" />&nbsp;'.$gL10n->get('SYS_ABORT').'</button>
                    </div>
                </form>
            </td>
        </tr>
        <tr>
            <td>&#160;</td>
        </tr>
        <tr>
            <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_NEXT').'</strong> '.$gL10n->get('PMB_INSTALL_END').'</td>
        </tr>
        <tr>
            <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_ABORT').'</strong> '.$gL10n->get('PMB_NO_CHANGES_2').'</td>
        </tr>         
    </table>';
    // Ende Prüfung SOLL-IST-Vergleich 
}
else
{      
    echo'
    <table border="0">
        <tr>
            <td>'.$gL10n->get('PMB_INSTALL_DESCRIPTION').'</td>
        </tr>
        <tr>
            <td>&#160;</td>
        </tr><tr>
            <td><strong>'.$gL10n->get('PMB_INSTALL_FIRST_PASSAGE').':  ==> '.$gL10n->get('PMB_INSTALL_VERIFICATION_MISSING_FIELDS').'</strong></td>
        </tr>
        <tr>
            <td>'.$gL10n->get('PMB_INSTALL_SECOND_PASSAGE').': '.$gL10n->get('PMB_INSTALL_VERIFICATION_COMPARISON').'</td>
        </tr>
    </table>
    <BR>
    <table border="0">
        <tr>
            <th width="150">'.$gL10n->get('SYS_CATEGORY').'</th>
            <th width="150">'.$gL10n->get('PMB_PROFILE_FIELD').'</th>
            <th>'.$gL10n->get('PMB_STATUS').'</th>
        </tr>
        <tr>
            <td colspan="2">'.$gL10n->get('SYS_MASTER_DATA').'</td>
            <td>' ;
                echo $gL10n->get('PMB_AVAILABLE');
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_MEMBERNUMBER').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td colspan="2">'.$gL10n->get('PMB_MEMBERSHIP').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_CATEGORIES']['Mitgliedschaft']['cat_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ACCESSION').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Beitritt']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td colspan="2">'.$gL10n->get('PMB_MEMBERSHIP_FEE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_CATEGORIES']['Mitgliedsbeitrag']['cat_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('SYS_CONTRIBUTION').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Beitrag']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_PAID').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Bezahlt']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>   
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_CONTRIBUTORY_TEXT').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Beitragstext']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>   
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_SEQUENCETYPE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Sequenztyp']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>   
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_DUEDATE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td colspan="2">'.$gL10n->get('PMB_MANDATE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_CATEGORIES']['Mandat']['cat_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>   
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_MANDATEID').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>   
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_MANDATEDATE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsdatum']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ORIG_MANDATEID').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>        
        <tr>
            <td colspan="2">'.$gL10n->get('PMB_ACCOUNT_DATA').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_CATEGORIES']['Kontodaten']['cat_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ACCOUNT_NUMBER').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Kontonummer']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_BANK_CODE_NUMBER').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Bankleitzahl']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_IBAN').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['IBAN']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_BIC').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['BIC']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_BANK').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Bankname']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
	    </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ACCOUNT_HOLDER').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Kontoinhaber']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ADDRESS').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_POSTCODE').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_CITY').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_EMAIL').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ORIG_DEBTOR_AGENT').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>
        <tr>
            <td align="right">-</td>
            <td>'.$gL10n->get('PMB_ORIG_IBAN').'</td>
            <td>' ;
                if (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_IBAN']['usf_name']))
                {
                    echo '<strong>'.$gL10n->get('PMB_MISSING').'</strong>';
                }
                else
                {
                    echo $gL10n->get('PMB_AVAILABLE');
                }
            echo'</td>
        </tr>        
    </table>
    <BR> ';

    if (   (!isset($arr['IST']['TBL_USER_FIELDS']['Beitritt']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Bezahlt']['usf_name']))  
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Mitgliedsnummer']['usf_name']))  
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Beitrag']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Beitragstext']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Faelligkeitsdatum']['usf_name']))  
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Kontonummer']['usf_name']))  
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Bankleitzahl']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['IBAN']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['BIC']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Bankname']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Kontoinhaber']['usf_name']))
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Sequenztyp']['usf_name']))
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsreferenz']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberAdresse']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberPLZ']['usf_name']))
        || (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberOrt']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['KontoinhaberEMail']['usf_name']))        
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Debtor_Agent']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_IBAN']['usf_name'])) 
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Orig_Mandatsreferenz']['usf_name']))              
        || (!isset($arr['IST']['TBL_USER_FIELDS']['Mandatsdatum']['usf_name'])))
    {
        echo
        $gL10n->get('PMB_FIELDS_SHOULD_BE_CREATED').'
        <table border="0">
            <tr>
                <td>
                    <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/install.php" method="post">
                        <div class="formSubmit">	
                            <button id="btnAnlegen" type="submit" name="anlegen"><img src="'. THEME_PATH. '/icons/disk.png" alt="Anlegen" />&nbsp;'.$gL10n->get('SYS_NEXT').'</button>
                        </div>
                    </form>
                </td>
                <td>
                    <form action="'.$g_root_path.'/adm_program/system/back.php" method="post">
                        <div class="formSubmit">	
                            <button id="btnAbbrechen" type="submit" name="abbrechen"><img src="'. THEME_PATH. '/icons/delete.png" alt="Abbrechen" />&nbsp;'.$gL10n->get('SYS_ABORT').'</button>
                        </div>
                    </form>
                </td>
            </tr>
            <tr>
                <td>&#160;</td>
            </tr>
            <tr>
                <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_NEXT').'</strong> '.$gL10n->get('PMB_CREATE_MISSING_FIELDS').'</td>
            </tr>
            <tr>
                <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_ABORT').'</strong> '.$gL10n->get('PMB_NO_CHANGES_1').'</td>
            </tr>         
        </table>'; 
    }
    else
    {
        echo
        $gL10n->get('PMB_ALL_FIELDS_ARE_AVAILABLE').'
        <table border="0">
            <tr>
                <td>
                    <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/install.php" method="post">
                        <div class="formSubmit">	
                            <button id="btnSollIst" type="submit" name="soll_ist"><img src="'. THEME_PATH. '/icons/disk.png" alt="Soll_Ist" />&nbsp;'.$gL10n->get('SYS_NEXT').'</button>
                        </div>
                    </form>
                </td> 
                <td>
                    <form action="'.$g_root_path.'/adm_program/system/back.php" method="post">
                        <div class="formSubmit">	
                            <button id="btnAbbrechen" type="submit" name="abbrechen"><img src="'. THEME_PATH. '/icons/delete.png" alt="Abbrechen" />&nbsp;'.$gL10n->get('SYS_ABORT').'</button>
                        </div>
                    </form>
                </td>
            </tr>
            <tr>
                <td>&#160;</td>
            </tr>
            <tr>
                <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_NEXT').'</strong> '.$gL10n->get('PMB_CHANGE_NEXT_TEST').'</td>
            </tr>
            <tr>
                <td colspan="2" class="smallFontSize"><strong>'.$gL10n->get('SYS_ABORT').'</strong> '.$gL10n->get('PMB_NO_CHANGES_2').'</td>
            </tr>         
        </table>';
    }
}

require(SERVER_PATH. '/adm_program/system/overall_footer.php');
?>
