<?php
/******************************************************************************
 * 
 * mandat_change_cdtr.php
 *   
 * Mandatsaenderung (Creditor) fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

$members = list_members(array('IBAN','ORIGIBAN','MANDATEID'.$gCurrentOrganization->getValue('org_id'),'ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id')), 0)  ;

$gNavigation->addUrl('http://'.$_SERVER["SERVER_NAME"].'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

// Kopf ausgeben
$gLayout['title']  = $gL10n->get('PMB_MANDATE_CHANGE').' ('.$gL10n->get('PMB_CREDITOR').')';

$gLayout['header'] ='
<script type="text/javascript">
	function cischieben(){ 
		var ci = $("input[type=text]#ci").val(); 
		var origci = $("input[type=text]#origci").val(ci);
		$("input[type=text]#ci").val("");
	}

	function creditorschieben(){ 
		var creditor = $("input[type=text]#creditor").val(); 
		var origcreditor = $("input[type=text]#origcreditor").val(creditor);
		$("input[type=text]#creditor").val("");
	}

	function speichern(){ 
		var ci = $("input[type=text]#ci").val(); 
		var origci = $("input[type=text]#origci").val();
		var creditor = $("input[type=text]#creditor").val(); 
		var origcreditor = $("input[type=text]#origcreditor").val();

		//Datenbank schreiben
        $.ajax({
            url: "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandat_change_cdtr_save.php?ci="+ci+"&origci="+origci+"&creditor="+creditor+"&origcreditor="+origcreditor,
            type: "POST",
                   
            async: false,
            success: function(result){                    
 
            //Result auswerten
            if(result=="marker_success")
            {
                jQueryAlert("SYS_SAVE_DATA");
            }
            else
            {
                jQueryAlert("SYS_NO_ENTRIES");
            }
            return false;
            }
       });
	}
</script>';
     					
require(SERVER_PATH. '/adm_program/system/overall_header.php');
echo '<h1>'. $gLayout['title']. '</h1>';

echo '
<form id="mem_form">
    
 		<div style="width:100%; overflow:auto; border:0px;">
        	<table border="0">
        		<tr>
                	<td>'.$gL10n->get('PMB_CI').'</td>
 					<td>&nbsp</td>
                	<td>'.$gL10n->get('PMB_ORIG_CI').'</td>
				</tr>
            	<tr>
                	<td><input type="text" id="ci" name="ci" style="width: 250px;" maxlength="60" value="'. $config_ini['Kontodaten']['ci']. '" /></td>
 	    			<td><a class="iconLink" id="cischieben" href="javascript:cischieben()"><img 
							src="'. THEME_PATH. '/icons/arrow_turn_right.png" alt="'.$gL10n->get('PMB_MOVE').'" title="'.$gL10n->get('PMB_MOVE').'" /></a></td>
                    <td><input type="text" id="origci" name="origci" style="width: 250px;" maxlength="60" value="'. $config_ini['Kontodaten']['origci']. '" /></td>
                </tr>
                <tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td>'.$gL10n->get('PMB_CREDITOR').'</td>
 					<td>&nbsp</td>
                	<td>'.$gL10n->get('PMB_ORIG_CREDITOR').'</td>
				</tr>
            	<tr>
                	<td><input type="text" id="creditor" name="creditor" style="width: 250px;" maxlength="60" value="'. $config_ini['Kontodaten']['inhaber']. '" /></td>
 	    			<td><a class="iconLink" id="creditorschieben" href="javascript:creditorschieben()"><img 
							src="'. THEME_PATH. '/icons/arrow_turn_right.png" alt="'.$gL10n->get('PMB_MOVE').'" title="'.$gL10n->get('PMB_MOVE').'" /></a></td>
                    <td><input type="text" id="origcreditor" name="origcreditor" style="width: 250px;" maxlength="60" value="'. $config_ini['Kontodaten']['origcreditor']. '" /></td>
                </tr>             
                <tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td colspan="3"><button id="abspeichern" type="button" name="abspeichern" onclick="speichern();"<img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button></td>
				</tr> 
				<tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td colspan="3" class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_MANDATE_CHANGE_CDTR_INFO').'</td>  		
                </tr>				               
 			</table>
 		</div>

</form>';

// Zurueck-Button nur anzeigen, wenn MyList nicht direkt aufgerufen wurde
if($gNavigation->count() > 1)
{
    echo '
    <ul class="iconTextLinkList">
        <li>
            <span class="iconTextLink">
                <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
            </span>
        </li>
    </ul>';
}

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>