<?php
/******************************************************************************
 * 
 * mandat_change_cdtr_save.php
 *   
 * Routine um die Daten einer Mandatsaenderung (Zahlungsempfaenger) zu schreiben 
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Parameters:
 *
 * ci       	: der neue Creditor Identifier
 * origci 		: der urspruengliche Creditor Identifier
 * creditor		: der neue Name des Zahlungsempfaengers
 * origcreditor	: der urspruengliche Name des Zahlungsempfaengers
 *
 ****************************************************************************/
  
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(dirname(__FILE__).'/common_function.php');

$getCI              = admFuncVariableIsValid($_GET, 'ci', 'string','');
$getOrigCI          = admFuncVariableIsValid($_GET, 'origci', 'string','');
$getCreditor        = admFuncVariableIsValid($_GET, 'creditor', 'string','');
$getOrigCreditor    = admFuncVariableIsValid($_GET, 'origcreditor', 'string','');

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

// neue Daten nur setzen, wenn ein Creditor Identifier gesetzt ist
if (strlen($getCI) <> 0 )
{
	$config_ini['Kontodaten']['ci'] = $getCI;
	$config_ini['Kontodaten']['origci'] = $getOrigCI;
}

// neue Daten nur setzen, wenn ein Zahlungsempfänger gesetzt ist
if (strlen($getCreditor) <> 0 ) 
{
	$config_ini['Kontodaten']['inhaber'] = $getCreditor;
	$config_ini['Kontodaten']['origcreditor'] = $getOrigCreditor;
}

if ((strlen($getCI)) <> 0 || (strlen($getCreditor) <> 0 ))
{
	writeConfigTablePMB($config_ini);
	echo 'marker_success';		
}
else
{
	echo 'marker_error';			
}

?>