<?php
/******************************************************************************
 * 
 * mandat_change_dbtr.php
 *   
 * Mandatsaenderung (Debitor) fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

// Initialize and check the parameters
$getUserId = admFuncVariableIsValid($_GET, 'user_id', 'numeric', $gCurrentUser->getValue('usr_id'));

$members = list_members(array('IBAN','ORIGIBAN','MANDATEID'.$gCurrentOrganization->getValue('org_id'),'ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id')), 0)  ;

$gNavigation->addUrl('http://'.$_SERVER["SERVER_NAME"].'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

// Kopf ausgeben
$gLayout['title']  = $gL10n->get('PMB_MANDATE_CHANGE').' ('.$gL10n->get('PMB_DEBTOR').')';

$gLayout['header'] ='
<script type="text/javascript">
	function ibanschieben(){ 
		var iban = $("input[type=text]#iban").val(); 
		var origiban = $("input[type=text]#origiban").val(iban);
		$("input[type=text]#iban").val("");
	}

	function mandatschieben(){ 
		var mandateid = $("input[type=text]#mandateid").val(); 
		var origmandateid = $("input[type=text]#origmandateid").val(mandateid);
		$("input[type=text]#mandateid").val("");
	}

	function speichern(){ 
		var userid = '. $getUserId. ';
		var iban = $("input[type=text]#iban").val(); 
		var origiban = $("input[type=text]#origiban").val();
		var mandateid = $("input[type=text]#mandateid").val(); 
		var origmandateid = $("input[type=text]#origmandateid").val();
		var bankchanged = $("input[type=checkbox]#bank_changed").prop("checked");

		//Datenbank schreiben
        $.ajax({
            url: "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandat_change_dbtr_save.php?iban="+iban+"&bankchanged="+bankchanged+"&mandateid="+mandateid+"&origmandateid="+origmandateid+"&origiban="+origiban+"&usr_id="+userid,
            type: "POST",
                   
            async: false,
            success: function(result){                    
 
            //Result auswerten
             if(result=="marker_success")
            {
                jQueryAlert("SYS_SAVE_DATA");
            }
            else
            {
                jQueryAlert("PMB_EXPORT_EMPTY");
            }
            return false;
            }
       });
	}
</script>';
     					
require(SERVER_PATH. '/adm_program/system/overall_header.php');
echo '<h1>'. $gLayout['title']. '</h1>';

echo '
<form id="mem_form">
    
 		<div style="width:100%; overflow:auto; border:0px;">
        	<table border="0">
        		<tr>
                	<td>'.$gL10n->get('PMB_IBAN').'</td>
 					<td>&nbsp</td>
                	<td>'.$gL10n->get('PMB_ORIG_IBAN').'</td>
				</tr>
            	<tr>
                	<td><input type="text" id="iban" name="iban" style="width: 250px;" maxlength="60" value="'. $members[$getUserId]['IBAN']. '" /></td>
 	    			<td><a class="iconLink" id="ibanschieben" href="javascript:ibanschieben()"><img 
							src="'. THEME_PATH. '/icons/arrow_turn_right.png" alt="'.$gL10n->get('PMB_MOVE').'" title="'.$gL10n->get('PMB_MOVE').'" /></a></td>
                    <td><input type="text" disabled="disabled" id="origiban" name="origiban" style="width: 250px;" maxlength="60" value="'. $members[$getUserId]['ORIGIBAN']. '" /></td>
                </tr>
                <tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td>'.$gL10n->get('PMB_MANDATEID').'</td>
 					<td>&nbsp</td>
                	<td>'.$gL10n->get('PMB_ORIG_MANDATEID').'</td>
				</tr>
            	<tr>
                	<td><input type="text" id="mandateid" name="mandateid" style="width: 250px;" maxlength="60" value="'. $members[$getUserId]['MANDATEID'.$gCurrentOrganization->getValue('org_id')]. '" /></td>
 	    			<td><a class="iconLink" id="mandatschieben" href="javascript:mandatschieben()"><img 
							src="'. THEME_PATH. '/icons/arrow_turn_right.png" alt="'.$gL10n->get('PMB_MOVE').'" title="'.$gL10n->get('PMB_MOVE').'" /></a></td>
                    <td><input type="text" disabled="disabled" id="origmandateid" name="origmandateid" style="width: 250px;" maxlength="60" value="'. $members[$getUserId]['ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id')]. '" /></td>
                </tr>
				<tr>
                	<td colspan="3">&nbsp</td>
                </tr>
				<tr>
                	<td colspan="3"><input type="checkbox" name="bank_changed" id="bank_changed" /><label for="bank_changed">'.$gL10n->get('PMB_BANK_CHANGED').'</label></td>
                </tr>                
                <tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td colspan="3"><button id="abspeichern" type="button" name="abspeichern" onclick="speichern();"<img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button></td>
				</tr> 
				<tr>
                	<td colspan="3">&nbsp</td>
                </tr>
                <tr>
                	<td colspan="3" class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_MANDATE_CHANGE_DBTR_INFO').'</td>  		
                </tr>				               
 			</table>
 		</div>
</form>';

// Zurueck-Button nur anzeigen, wenn MyList nicht direkt aufgerufen wurde
if($gNavigation->count() > 1)
{
    echo '
    <ul class="iconTextLinkList">
        <li>
            <span class="iconTextLink">
                <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
            </span>
        </li>
    </ul>';
}

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>