<?php
/******************************************************************************
 * 
 * mandat_change_dbtr_save.php
 *   
 * Routine um die Daten einer Mandatsaenderung (Zahlungspflichtiger) zu schreiben 
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Parameters:
 *
 * usr_id       : ID des Mitglieds desssen Mandatsdatum geaendert werden soll
 * iban 		: die neue IBAN des Zahlungspflichtigen
 * origiban		: die urspruengliche IBAN des Zahlungspflichtigen
 * mandateid	: die neue Mandatsreferenz des Zahlungspflichtigen
 * origmandateid: die urspruengliche Mandatsreferenz des Zahlungspflichtigen
 * bankchanged	: die Bankverbindung wurde geaendert
 *
 ****************************************************************************/
   
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');

require_once(dirname(__FILE__).'/common_function.php');

$getUserId 	        = admFuncVariableIsValid($_GET, 'usr_id', 'numeric', null, true, null, true);
$getIBAN            = admFuncVariableIsValid($_GET, 'iban', 'string','');
$getOrigIBAN        = admFuncVariableIsValid($_GET, 'origiban', 'string','');
$getMandateID       = admFuncVariableIsValid($_GET, 'mandateid', 'string','');
$getOrigMandateID   = admFuncVariableIsValid($_GET, 'origmandateid', 'string','');
$getBankChanged     = admFuncVariableIsValid($_GET, 'bankchanged', 'boolean',false);

$user = new User($gDb, $gProfileFields, $getUserId);

if ((strlen($getMandateID) <> 0 ) && (strlen($getOrigMandateID) <> 0 ))
{
	$user->setValue('MANDATEID'.$gCurrentOrganization->getValue('org_id'), $getMandateID);
	$user->setValue('ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'), $getOrigMandateID);
}

if (strlen($getIBAN) <> 0 )
{
	$user->setValue('IBAN', $getIBAN);	
	$user->setValue('ORIGIBAN', $getOrigIBAN);	
}

if ($getBankChanged=='true') 
{
	$user->setValue('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'), '');
	$user->setValue('ORIGDEBTORAGENT', 'SMNDA');	
	
	// wenn die Bank gewechselt wurde, braucht die neue Bank die ursprüngliche IBAN nicht kennen
	$user->setValue('ORIGIBAN', '');	
}
if (((strlen($getMandateID) <> 0 ) && (strlen($getOrigMandateID) <> 0 )) || (strlen($getIBAN) <> 0 )  || ($getBankChanged=='true'))
{
	$user->save();
	echo 'marker_success';	
}
else
{
	echo 'marker_error';	
}


?>