<?php
/******************************************************************************
 * 
 * mandatsdatum.php
 *   
 * Setzen eines Mandatsdatums fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Hinweis: mandatsdatum.php ist eine modifizierte members.php
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

$datumtemp = new DateTimeExtended(DATE_NOW, 'Y-m-d', 'date');
$datum = $datumtemp->format($gPreferences['system_date']);

$gNavigation->addUrl($g_root_path.'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

// Kopf ausgeben
$gLayout['title']  = $gL10n->get('PMB_MANDATEDATE_SET');

$gLayout['header'] ='
<script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/calendar/calendar-popup.js"></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/system/js/date-functions.js"></script>
        <link rel="stylesheet" href="'.THEME_PATH.'/css/calendar.css" type="text/css" />
        
<script type="text/javascript"><!--
    //Erstmal warten bis Dokument fertig geladen ist
    $(document).ready(function(){       
        //Bei Seitenaufruf Daten laden
        $("input[type=checkbox]#change_all").hide();  
        $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memserach_form").serialize(), function(result){
            $("form#memlist_form").append(result).show();
            $("#list_load_animation").hide();  
            return false;
        });
        
        //Checkbox alle Benutzer
        $("input[type=checkbox]#mem_show_all").live("click", function(){
            $("#list_load_animation").show();
            $("input[type=checkbox]#mem_show_all").prop("checked", true);
            $("input[type=checkbox]#mem_show_without").prop("checked", false);
            $("input[type=checkbox]#mem_show_with").prop("checked", false);
            $("input[type=checkbox]#change_all").hide();    
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").append(result).show();               
                $("#list_load_animation").hide();
                return false;
            });
        });
        
        //Checkbox nur mit ... anzeigen
        $("input[type=checkbox]#mem_show_with").live("click", function(){
            $("#list_load_animation").show();
            $("input[type=checkbox]#mem_show_with").prop("checked", true);
            $("input[type=checkbox]#mem_show_all").prop("checked", false);
            $("input[type=checkbox]#mem_show_without").prop("checked", false);   
            var memsearch = $("input[type=text]#mem_search").val();
            if(memsearch=="")
            {
            	$("input[type=checkbox]#change_all").show();    
            }       
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").append(result).show();               
                $("#list_load_animation").hide();
               
                return false;
            });
        });
        
        //Checkbox nur ohne ... anzeigen
        $("input[type=checkbox]#mem_show_without").live("click", function(){
            $("#list_load_animation").show();
            $("input[type=checkbox]#mem_show_without").prop("checked", true);
            $("input[type=checkbox]#mem_show_all").prop("checked", false);
            $("input[type=checkbox]#mem_show_with").prop("checked", false);       
            var memsearch = $("input[type=text]#mem_search").val();
            if(memsearch=="")
            {
            	$("input[type=checkbox]#change_all").show();    
            }       
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").append(result).show();               
                $("#list_load_animation").hide();
                return false;
            });
        }); 
        
        //Checkbox Datum aufsteigend anzeigen 
        $("input[type=checkbox]#order_by_date_asc").live("click", function(){
            $("#list_load_animation").show();
            $("input[type=checkbox]#order_by_date_desc").prop("checked", false);
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").append(result).show();               
                $("#list_load_animation").hide();
                return false;
            });
        }); 
        
        //Checkbox Datum absteigend anzeigen
        $("input[type=checkbox]#order_by_date_desc").live("click", function(){
            $("#list_load_animation").show();
            $("input[type=checkbox]#order_by_date_asc").prop("checked", false);
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").append(result).show();               
                $("#list_load_animation").hide();
                return false;
            });
        }); 
        
        // Checkbox alle ändern
        $("input[type=checkbox]#change_all").live("click", function(){
            
        	var memshowall = $("input[type=checkbox]#mem_show_all").prop("checked");
        	var memshowwith = $("input[type=checkbox]#mem_show_with").prop("checked");
        	var memshowwithout = $("input[type=checkbox]#mem_show_without").prop("checked");
        	var datum = $("#datum").val();
        	
        	$("#list_load_animation").show();
                                            
            //Datenbank schreiben
            $.ajax({
                    url: "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_save.php?datum_neu="+datum+"&mem_show_all="+memshowall+"&mem_show_with="+memshowwith+"&mem_show_without="+memshowwithout,
                    type: "POST",
                    async: false,
                    success: function(result){                    

                        //Rueckgabewert auswerten
                        if(result=="multi_change")
                        {
            				$("form#memlist_form").hide().empty();
            				$.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                				$("form#memlist_form").append(result).show();               
                				$("#list_load_animation").hide();
                				return false;
            				});
                        }
           				else if(result=="single_set")
                       		{
                       			// Rückgabe muss nur abgefangen werden
                       		}  
                       		else if(result=="single_delete")
                       		{
                       			// Rückgabe muss nur abgefangen werden
                       		} 
                       	else
                       	{
						   jQueryAlert("SYS_INVALID_PAGE_VIEW");
                       	}
                       	$("#list_load_animation").hide(); 
                       	return false;
                    }
            });
            $("input[type=checkbox]#change_all").prop("checked", false);
        });         
        
        //Suchfeldeingabe
        $("input[type=text]#mem_search").keyup(function(event){
            $("#list_load_animation").show();      
            $("input[type=checkbox]#change_all").hide();    
            var memsearch = $("input[type=text]#mem_search").val();
            var memshowwithout = $("input[type=checkbox]#mem_show_without").prop("checked");
            if(memsearch.length=="" && memshowwithout)
            {
            	$("input[type=checkbox]#change_all").show();    
            }          
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_get.php", $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").empty().append(result).show();
                $("#list_load_animation").hide();                 
            });
            return false;
        });
    
        //Enter abfangen
        $("input[type=text]#mem_search").keydown(function(e) {
            if(e.keyCode === 13) {
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                return;
            }
        });
        
        //Buchstabennavigation
        $(".pageNavigationLink").live("click", function(){
            var letter = $(this).attr("letter");            
            //Alle anzeigen
            if(letter == "all"){
            	//$("input[type=checkbox]#change_all").show();
                $(".letterBlockBody").show();
                $(".letterBlockHead").show();
            }
            else{  
            	//$("input[type=checkbox]#change_all").hide();
	            $(".letterBlockBody[block_body_id!="+letter+"]").hide();
	            $(".letterBlockHead[block_head_id!="+letter+"]").hide();
	            $(".letterBlockBody[block_body_id="+letter+"]").show();
	            $(".letterBlockHead[block_head_id="+letter+"]").show();
	        }
	        return false;
        });
        
        //beim Anklicken einer Checkbox
        $("input[type=checkbox].memlist_checkbox").live("click", function(){
                 
            //Checkbox ID
            var checkboxtype = $(this).attr("checkboxtype");            
            var checkbox_id = $(this).attr("id");
            var userid = $(this).parent().parent().attr("user_id");
            var datum = $("#datum").val();
                                
            //Ladebalken an checkbox
            $("#loadindicator_" + checkbox_id).append("<img src=\''.THEME_PATH.'/icons/loader_inline.gif\' alt=\'loadindicator\' />").show();
                                 
            //Datenbank schreiben
            $.ajax({
                    url: "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandatsdatum_save.php?datum_neu="+datum+"&usr_id="+userid,
                    type: "POST",
                   
                    async: false,
                    success: function(result){                    
                       $("#loadindicator_" + checkbox_id).hide().empty();

                       //Result auswerten
                       if(result=="single_set")
                       {
                       		$(".text_"+userid).text(datum);
                       }
                        else if(result=="single_delete")
                       {
                       		$(".text_"+userid).text("");
                       }
                       else if(result=="multi_change")
                       	{
                       		// Rückgabe muss nur abgefangen werden
                       	}   
                       else
                       {
						   jQueryAlert("SYS_INVALID_PAGE_VIEW");
                       }
                       return false;
                    }
            });
        });
     });            
//--></script>';
        
require(SERVER_PATH. '/adm_program/system/overall_header.php');
echo '<h1>'. $gLayout['title']. '</h1>';

//Suchleiste
echo '
<form id="memsearch_form">
    <ul class="iconTextLinkList">
        <li>'.$gL10n->get('SYS_SEARCH').': <input type="text" name="mem_search" id="mem_search" /></li>';
        
        $width = '80px';
        $maxlength = '10';
 	    $value = '<script type="text/javascript">
					var calDate = new CalendarPopup("calendardiv");
 						calDate.setCssPrefix("calendar");
 						calDate.showNavigationDropdowns();
  						calDate.setYearSelectStartOffset(50);
  						calDate.offsetX = 0;
 						calDate.offsetY = 0;
  						calDate.setYearSelectEndOffset(10);
     				</script>';

        $value .= '
     		<input type="text" id="datum" name="datum" style="width: 80px;" maxlength="10" value="'. $datum. '" />
    		<a class="iconLink" id="anchor_datum" href="javascript:calDate.select(document.getElementById(\'datum\'),\'anchor_datum\',\''.$gPreferences['system_date'].'\');"><img 
				src="'. THEME_PATH. '/icons/calendar.png" alt="'.$gL10n->get('SYS_SHOW_CALENDAR').'" title="'.$gL10n->get('SYS_SHOW_CALENDAR').'" /></a>
   			<span id="calendardiv" style="position: absolute; visibility: hidden;"></span>';
   		echo '<li>
				<label for="datum">'.$gL10n->get('PMB_MANDATEDATE').':</label>
 					'. $value.  '
 		</li>
        <BR><BR>
        <li>'.$gL10n->get('PMB_FILTER').':</li>
        <li><input type="checkbox" checked="checked" name="mem_show_all" id="mem_show_all" /><label for="mem_show_all">'.$gL10n->get('MEM_SHOW_ALL_USERS').'</label></li>
        <li><input type="checkbox" name="mem_show_with" id="mem_show_with" /><label for="mem_show_with">'.$gL10n->get('PMB_WITH_MANDATEDATE').'</label></li>
 		<li><input type="checkbox" name="mem_show_without" id="mem_show_without" /><label for="mem_show_without">'.$gL10n->get('PMB_WITHOUT_MANDATEDATE').'</label></li>
        <BR>
        <li>'.$gL10n->get('SYS_ORDER').':</li>
        <li><input type="checkbox" name="order_by_date_asc" id="order_by_date_asc" /><label for="order_by_date_asc">'.$gL10n->get('PMB_DATE_ASC').'</label></li>
        <li><input type="checkbox" name="order_by_date_desc" id="order_by_date_desc" /><label for="order_by_date_desc">'.$gL10n->get('PMB_DATE_DESC').'</label></li>
 		<BR>
        <li>'.$gL10n->get('SYS_OPTIONAL').':</li>
 		<li><input type="checkbox" name="change_all" id="change_all" /><label for="change_all">'.$gL10n->get('PMB_CHANGE_ALL').'</label></li>
			
    </ul>
</form>';

//Ladebalken
echo '<img src="'.THEME_PATH.'/images/loading_animation.gif" alt="'.$gL10n->get('SYS_PROGRESS_BAR').'" id="list_load_animation"/>';

//Liste mit Namen zu abhaken
echo '<form id="memlist_form"></form>';

// Zurueck-Button nur anzeigen, wenn MyList nicht direkt aufgerufen wurde
if($gNavigation->count() > 1)
{
    echo '
    <ul class="iconTextLinkList">
        <li>
            <span class="iconTextLink">
                <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
            </span>
        </li>
    </ul>';
}

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>