<?php
/******************************************************************************
 * 
 * mandatsdatum_save.php
 *   
 * Funktion um das Mandatsdatum fuer das Admidio-Plugin Mitgliedsbeitrag zu setzen oder zu loeschen 
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Parameters:
 *
 * usr_id       			: 	ID des Mitglieds desssen Mandatsdatum geaendert werden soll
 * datum_neu 				: 	das neue Mandatsdatum
 *
 * mem_show_all 			: 	1 - alle Benutzer anzeigen (default)
 *                				0 - (ein anderer mem_show... ist aktiv)
 * mem_show_only_bezahlt 	: 	1 - nur Benutzer anzeigen, die ein Mandatsdatum besitzen
 *                				0 - (ein anderer mem_show... ist aktiv)
 * mem_show_without_bezahlt : 	1 - nur Benutzer anzeigen, die kein Mandatsdatum besitzen
 *                				0 - (ein anderer mem_show... ist aktiv)
 *                
 * Hinweis: 1. wird ein mem_show-Schalter übergeben, dann ist immer einer (und nur einer) aktiv gesetzt  
 * 			2. abhängig vom aufrufenden Link wird entweder usr_id übergeben oder die mem_schow-Schalter
 * 			   usr_id wenn nur ein User gewählt wurde, bei "alle ändern" wird keine usr_id übergeben,
 * 			   sondern nur die mem_show-Schalter (datum_neu wird immer übergeben)              
 *
 ****************************************************************************/
  
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(dirname(__FILE__).'/common_function.php');

$getUserId 				= admFuncVariableIsValid($_GET, 'usr_id', 'numeric', 0);
$getDatumNeu 			= admFuncVariableIsValid($_GET, 'datum_neu', 'date');
$getMembersShowAll 		= admFuncVariableIsValid($_GET, 'mem_show_all', 'boolean', 'false');
$getMembersShowWith 	= admFuncVariableIsValid($_GET, 'mem_show_with', 'boolean', 'false');
$getMembersShowWithout	= admFuncVariableIsValid($_GET, 'mem_show_without', 'boolean', 'false');

if($getUserId<>0)			// Mandatssdatum nur für einen einigen User ändern
{
	$members = array($getUserId => 'dummy');
	$getMembersShowAll = true;	
}
else 						// "alle ändern" wurde gewählt
{
	$members = list_members(array('MANDATEDATE'.$gCurrentOrganization->getValue('org_id')), 0);
}

foreach ($members as $key => $data)
{
	$user = new User($gDb, $gProfileFields, $key);
	
	// Filter ist gesetzt auf nur die, die ein Mandatsdatum besitzen
	// --> nur die bearbeiten, bei denen Mandatsdatum nicht NULL ist und hier den Eintrag löschen
	// oder Filter ist gesetzt auf alle Benutzer anzeigen, dann auch abarbeiten
   	if( strlen($user->getValue('MANDATEDATE'.$gCurrentOrganization->getValue('org_id')))<>0 
   			&&  strlen($user->getValue('MANDATEID'.$gCurrentOrganization->getValue('org_id')))<>0
   			&&  ( $getMembersShowWith=='true' || $getMembersShowAll=='true') )
   	{ 
        $user->setValue('MANDATEDATE'.$gCurrentOrganization->getValue('org_id'), '');

        //Rückgabewert setzen
        if($getUserId<>0)
		{
			echo 'single_delete';
		}		
   	}
   	
   	// Filter ist gesetzt auf nur die, die kein Mandatsdatum besitzen
	// --> nur die bearbeiten, bei denen kein Mandatsdatum vorhanden ist und hier einen Eintrag setzen
	// oder Filter ist gesetzt auf alle Benutzer anzeigen, dann auch abarbeiten
	else if( strlen($user->getValue('MANDATEDATE'.$gCurrentOrganization->getValue('org_id')))==0 
		&&  strlen($user->getValue('MANDATEID'.$gCurrentOrganization->getValue('org_id')))<>0
   		&&  ( $getMembersShowWithout=='true' || $getMembersShowAll=='true') )
	{ 
   		$user->setValue('MANDATEDATE'.$gCurrentOrganization->getValue('org_id'), $getDatumNeu);	

   		//Rückgabewert setzen
   		if($getUserId<>0)
		{
			echo 'single_set';
		}	
   	}	
   	$user->save();
} 

//Rückgabewert setzen
if($getUserId==0)
{
	echo 'multi_change';  
} 

?>