<?php
/******************************************************************************
 * 
 * menue_function.php
 *   
 * Menuefunktionen fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

$_SESSION['organization_request'] = $_REQUEST;

// *******************************************************************************
// Allgemein: Beitragsberechnung 
// *******************************************************************************
           
if (isset($_POST['neuzuordnung']))
{
    include($plugin_path. '/'.$plugin_folder.'/neuzuordnung.php');
}                    

if (isset($_POST['loeschen']))
{
	$config_ini['Beitrag']['beitrag_loeschen'] = $_POST['beitrag_loeschen'];
	writeConfigTablePMB($config_ini);

	delete_contribution();
}                    

if (isset($_POST['neuberechnung']))
{
	$config_ini['Beitrag']['beitrag_rollenabfrage'] = (isset($_POST['beitrag_rollenabfrage']) ? 1 : '');	
	$config_ini['Beitrag']['beitrag_modus'] = $_POST['beitrag_modus'];
	writeConfigTablePMB($config_ini);
	
	if ($config_ini['Beitrag']['beitrag_rollenabfrage'])
	{
		include($plugin_path. '/'.$plugin_folder.'/neuberechnung_query.php');		
	}
	else
	{
		include($plugin_path. '/'.$plugin_folder.'/neuberechnung.php');		
	}    
    exit();
}                    

// *******************************************************************************
// Allgemein: Beitragszahlungen 
// *******************************************************************************

if (isset($_POST['beitragszahlungen']))
{
	$config_ini['Beitrag']['zahlungen_rollenabfrage'] = (isset($_POST['zahlungen_rollenabfrage']) ? 1 : '');	
	writeConfigTablePMB($config_ini);
	
	if ($config_ini['Beitrag']['zahlungen_rollenabfrage'])
	{
		include($plugin_path. '/'.$plugin_folder.'/zahlungen_query.php');		
	}
	else
	{
		include($plugin_path. '/'.$plugin_folder.'/zahlungen.php');		
	}    
    exit();
} 
    
// *******************************************************************************
// Allgemein: Mandatsverwaltung
// *******************************************************************************

if( isset($_POST['mandatsreferenzen_erzeugen']))
{
	erzeuge_mandatsreferenz();
}

if( isset($_POST['mandat_bearbeiten']))
{
    include($plugin_path. '/'.$plugin_folder.'/mandatsdatum.php');
    exit();
}

// *******************************************************************************
// Export: SEPA-Export 
// *******************************************************************************

if (isset($_POST['faelligkeitsdatum_bearbeiten']))
{
	$config_ini['SEPA']['duedate_rollenabfrage'] = (isset($_POST['duedate_rollenabfrage']) ? 1 : '');      
	writeConfigTablePMB($config_ini);
	    
    if ($config_ini['SEPA']['duedate_rollenabfrage'])
	{
		include($plugin_path. '/'.$plugin_folder.'/faelligkeitsdatum_query.php');		
	}
	else
	{
		include($plugin_path. '/'.$plugin_folder.'/faelligkeitsdatum.php');		
	}    
    exit();
}

if (isset($_POST['xml_datei']) || isset($_POST['xml_kontroll_datei']) || isset($_POST['xml_begleitzettel']))
{
    include($plugin_path. '/'.$plugin_folder.'/sepa_export.php');	
}

if (isset($_POST['pre_notification']))
{
    include($plugin_path. '/'.$plugin_folder.'/pre_notification.php');
    exit();
}
                 
// *******************************************************************************
// Export: Rechnungs-Export
// *******************************************************************************

if (isset($_POST['rechnungs_export']))
{
    include($plugin_path. '/'.$plugin_folder.'/rechnung_export.php');
}

// *******************************************************************************
// Setup: Reset 
// *******************************************************************************

if (isset($_POST['mandate_loeschen']))
{
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('MANDATEID'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('MANDATEID'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('MANDATEDATE'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('MANDATEDATE'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
} 

if (isset($_POST['mitgliedsnummern_loeschen']))
{
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('MEMBERNUMBER', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('MEMBERNUMBER', 'usf_id');
    $gDb->query($sql);
} 
if (isset($_POST['lastschrifttypen_loeschen']))
{
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
} 

if (isset($_POST['iban_bic_loeschen']))
{
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('IBAN', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('IBAN', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('BIC', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('BIC', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('BANKNAME', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('BANKNAME', 'usf_id');
    $gDb->query($sql);
}
if (isset($_POST['mandatsaenderungen_loeschen']))
{
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'), 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('ORIGIBAN', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('ORIGIBAN', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '.$gProfileFields->getProperty('ORIGDEBTORAGENT', 'usf_id');
    $gDb->query($sql);
    $sql = 'DELETE FROM '.TBL_USER_LOG.'
            WHERE usl_usf_id = '.$gProfileFields->getProperty('ORIGDEBTORAGENT', 'usf_id');
    $gDb->query($sql);
    $config_ini['Kontodaten']['origci']  = '';   
   	$config_ini['Kontodaten']['origcreditor']  = '';   
    writeConfigTablePMB($config_ini);
}  
// *******************************************************************************
// Setup: Beitragseinstellungen
// *******************************************************************************

if( isset($_POST['beitragseinstellungen']))
{
    $config_ini['Beitrag']['beitrag_prefix'] = $_POST['beitrag_prefix'];
    $config_ini['Beitrag']['beitrag_suffix'] = $_POST['beitrag_suffix'];
    $config_ini['Beitrag']['beitrag_textmitnam'] = (isset($_POST['beitrag_textmitnam']) ? 1 : '');
    $config_ini['Beitrag']['beitrag_textmitfam'] = (isset($_POST['beitrag_textmitfam']) ? 1 : '');
    $config_ini['Beitrag']['beitrag_text_token'] = $_POST['beitrag_text_token'];
    $config_ini['Beitrag']['beitrag_anteilig'] = (isset($_POST['beitrag_anteilig']) ? 1 : '');
    $config_ini['Beitrag']['beitrag_abrunden'] = (isset($_POST['beitrag_abrunden']) ? 1 : '');
    $config_ini['Beitrag']['beitrag_mindestbetrag'] = (is_numeric($_POST['beitrag_mindestbetrag']) ? $_POST['beitrag_mindestbetrag'] : 0);
    writeConfigTablePMB($config_ini);
    
    $text2 = new TableText($gDb);
    $text2->readDataByColumns(array('txt_org_id' => $gCurrentOrganization->getValue('org_id'), 'txt_name' => 'PMBMAIL_CONTRIBUTION_PAYMENTS'));
    $text2->setValue('txt_text', $_POST['PMBMAIL_CONTRIBUTION_PAYMENTS']);
    $text2->save();
}

// *******************************************************************************
// Setup: Altersgestaffelte Rollen
// *******************************************************************************
if( isset($_POST['altersrollenanzahl']))
{
   	$config_ini['Altersrollen']['altersrollen_anzahl'] += intval($_POST['altersrollen_anzahl'])>0 ? intval($_POST['altersrollen_anzahl']) : 0;  
    writeConfigTablePMB($config_ini); 	
}

if( isset($_POST['altersrollen']))
{
    if(check_date($_POST['altersrollen_stichtag'],"dmY","."))
    {
        $config_ini['Altersrollen']['altersrollen_stichtag'] = $_POST['altersrollen_stichtag'];   
    }
    
    unset($config_ini['Altersrollen']['altersrollen_token']); 
    unset($config_ini['Altersrollen']['altersrollen_anzahl']);      
    $config_ini['Altersrollen']['altersrollen_token'] = $_POST['altersrollen_token'];
    
   	// alle Alterskonfigurationen durchlaufen
	foreach($config_ini['Altersrollen']['altersrollen_token'] as $key => $data)
    {
    	// wenn das Token leer ist, diese Zeile im Array löschen
    	if (empty($config_ini['Altersrollen']['altersrollen_token'][$key])) 
    	{  
 			unset($config_ini['Altersrollen']['altersrollen_token'][$key]);	
    	} 
    } 

    // es muss mindestens 1 Token definiert sein, ansonsten führt es im weiteren Verlauf
    // des Plugins zu Fehlern --> wenn 0: vorbelegen mit '*'
    if (count($config_ini['Altersrollen']['altersrollen_token'])==0)
    {
    	$config_ini['Altersrollen']['altersrollen_token']=array('*');
    }
    $config_ini['Altersrollen']['altersrollen_anzahl'] = count($config_ini['Altersrollen']['altersrollen_token']); 
    writeConfigTablePMB($config_ini); 
}

// *******************************************************************************
// Setup: Familienrollen
// *******************************************************************************
if( isset($_POST['familienrollenanzahl']))
{
   	$config_ini['Familienrollen']['familienrollen_anzahl'] += intval($_POST['familienrollen_anzahl'])>0 ? intval($_POST['familienrollen_anzahl']) : 0;  
    writeConfigTablePMB($config_ini); 	
}

if( isset($_POST['familienrollen']))
{
	unset($config_ini['Familienrollen']['familienrollen_prefix']);
	unset($config_ini['Familienrollen']['familienrollen_beitrag']);
	unset($config_ini['Familienrollen']['familienrollen_zeitraum']);
	unset($config_ini['Familienrollen']['familienrollen_beschreibung']);
	    
    $config_ini['Familienrollen']['familienrollen_prefix'] = $_POST['familienrollen_prefix'];
    $config_ini['Familienrollen']['familienrollen_beitrag'] = $_POST['familienrollen_beitrag'];
    $config_ini['Familienrollen']['familienrollen_zeitraum'] = $_POST['familienrollen_zeitraum'];
    $config_ini['Familienrollen']['familienrollen_beschreibung'] = $_POST['familienrollen_beschreibung'];  

	// alle Familienkonfigurationen durchlaufen
	foreach($config_ini['Familienrollen']['familienrollen_prefix'] as $key => $data)
    {
    	// wenn das Präfix leer, der Beitrag leer oder der Zeitraum -- ist, alle weiteren Werte im Array löschen
    	if (empty($config_ini['Familienrollen']['familienrollen_prefix'][$key]) 
    		|| empty($config_ini['Familienrollen']['familienrollen_beitrag'][$key])
    		|| ($config_ini['Familienrollen']['familienrollen_zeitraum'][$key]=='--'))	
    	{  
 			unset($config_ini['Familienrollen']['familienrollen_prefix'][$key]);
    		unset($config_ini['Familienrollen']['familienrollen_beitrag'][$key]);
    		unset($config_ini['Familienrollen']['familienrollen_zeitraum'][$key]);
    		unset($config_ini['Familienrollen']['familienrollen_beschreibung'][$key]);

    		//auch eine evtl. konfigurierte Rollenprüfung löschen
    		unset($config_ini['Familienrollen']['familienrollen_pruefung'][$key]);
    	} 
    }

    // Es sollte mindestens eine Altersrolle definiert sein; 
    // Wenn keine definiert ist, wird zwar kein Fehler produziert, 
    // aber alle Beitragsrollen werden als Familienrollen interpretiert
    // prüfen --> wenn 0: Parameter vorbelegen
    if (count($config_ini['Familienrollen']['familienrollen_prefix'])==0)
    {
    	$config_ini['Familienrollen']['familienrollen_prefix']=array('Familie');
    	$config_ini['Familienrollen']['familienrollen_beitrag']=array(0);
    	$config_ini['Familienrollen']['familienrollen_zeitraum']=array(12);
    }
    else 
    {
    	// alle Familienkonfigurationen durchlaufen
		foreach($config_ini['Familienrollen']['familienrollen_prefix'] as $key => $data)
    	{ 
    		// zuerst alle Familienrollen herausfinden 
    		$sql = 'SELECT rol_name, rol_id, rol_cost, rol_cost_period
            		FROM '.TBL_ROLES.' 
            		WHERE rol_name LIKE \''. $data.'%'. '\' ';
                                
    		$result = $gDb->query($sql); 
    	   	
        	// jetzt den neuen Betrag, den Beitragszeitraum und die Beschreibung in die DB schreiben
    		while ($row = $gDb->fetch_array($result))
    		{
        		$sql = 'UPDATE '.TBL_ROLES.'
                		SET rol_cost = \''.$config_ini['Familienrollen']['familienrollen_beitrag'][$key].'\'
                		WHERE rol_id = \''.$row['rol_id'].'\' '; 
           
        		$gDb->query($sql);
 
        		$sql = 'UPDATE '.TBL_ROLES.'
            		SET rol_cost_period = \''.$config_ini['Familienrollen']['familienrollen_zeitraum'][$key].'\'
            		WHERE rol_id = \''.$row['rol_id'].'\' '; 
           
        		$gDb->query($sql); 
     
        		$sql = 'UPDATE '.TBL_ROLES.'
                		SET rol_description = \''.$config_ini['Familienrollen']['familienrollen_beschreibung'][$key].'\'
                		WHERE rol_id = \''.$row['rol_id'].'\' '; 
           
        		$gDb->query($sql); 
    		}
    	}    	
    }
    $config_ini['Familienrollen']['familienrollen_anzahl'] = count($config_ini['Familienrollen']['familienrollen_prefix']); 
    writeConfigTablePMB($config_ini); 
}

// *******************************************************************************
// Setup: Kontodaten
// *******************************************************************************

if( isset($_POST['kontodaten']))
{
    $config_ini['Kontodaten']['ktonr'] = $_POST['ktonr'];
    $config_ini['Kontodaten']['blz'] =  $_POST['blz'];
    $config_ini['Kontodaten']['bank'] = $_POST['bank'];
    $config_ini['Kontodaten']['inhaber'] =  $_POST['inhaber']; 
    $config_ini['Kontodaten']['iban']  = $_POST['iban'];   
    $config_ini['Kontodaten']['bic']  = $_POST['bic'];   
   	$config_ini['Kontodaten']['ci']  = $_POST['creditor_identifier'];   
    writeConfigTablePMB($config_ini);
}
if (isset($_POST['convert_account_data']))
{
    include($plugin_path. '/'.$plugin_folder.'/sepa_convert.php');
    exit();
}  

// *******************************************************************************
// Setup: Export
// *******************************************************************************

if( isset($_POST['export-setup']))
{
    $config_ini['SEPA']['dateiname'] = $_POST['xml_dateiname']; 
    $config_ini['SEPA']['kontroll_dateiname'] = $_POST['xml_kontroll_dateiname'];     
    $config_ini['Rechnungs-Export']['rechnung_dateiname']  = $_POST['rechnung_dateiname'];   
    writeConfigTablePMB($config_ini);
    
    $text = new TableText($gDb);
    $text->readDataByColumns(array('txt_org_id' => $gCurrentOrganization->getValue('org_id'), 'txt_name' => 'PMBMAIL_PRE_NOTIFICATION'));
    $text->setValue('txt_text', $_POST['PMBMAIL_PRE_NOTIFICATION']);
    $text->save();
}

// *******************************************************************************
// Setup: Mandatsverwaltung
// *******************************************************************************

if( isset($_POST['setup-mandatsverwaltung']))
{
    $config_ini['Mandatsreferenz']['prefix_fam'] = $_POST['prefix_fam']; 
    $config_ini['Mandatsreferenz']['prefix_mem'] = $_POST['prefix_mem'];      
    $config_ini['Mandatsreferenz']['prefix_pay'] = $_POST['prefix_pay']; 
    $config_ini['Mandatsreferenz']['min_length'] = $_POST['min_length'];      
    $config_ini['Mandatsreferenz']['data_field'] = $_POST['data_field'];      

    // in der SEPA XML-Datei duerfen Mandatsreferenzen max. 35 Zeichen lang sein
    if( $config_ini['Mandatsreferenz']['min_length']>35)
	{
		$config_ini['Mandatsreferenz']['min_length']=35;
	}
    writeConfigTablePMB($config_ini);
}

// *******************************************************************************
// Setup: Rollenprüfung
// *******************************************************************************

if( isset($_POST['rollenpruefung']))
{
    // zuerst die Arrays in $config_ini löschen
    unset ($config_ini['Rollenpruefung']['fixrollenpflicht']);
    unset ($config_ini['Rollenpruefung']['altersrollenfix']) ;
    unset ($config_ini['Rollenpruefung']['familienrollenfix']);

    $fixrollenpflicht = array();
    $altersrollenfix = array();
    $familienrollenfix = array();
    
    //aus dem übergebenen $_POST die Rollen herausfiltern
    foreach($_POST as $key => $data)
    {
         if (substr($key,0,16)=='fixrollenpflicht')
        {
            $fixrollenpflicht[] = substr($key,16);
        }
        if (substr($key,0,15)=='altersrollenfix')
        {
            $altersrollenfix[] = substr($key,15);
        }
        if (substr($key,0,17)=='familienrollenfix')
        {
            $familienrollenfix[] = substr($key,17);
        }     
    } 
	$config_ini['Rollenpruefung']['altersrollenpflicht'] = (isset($_POST['altersrollenpflicht']) ? $_POST['altersrollenpflicht'] : '') ;
    $config_ini['Rollenpruefung']['familienrollenpflicht'] = (isset($_POST['familienrollenpflicht']) ? $_POST['familienrollenpflicht'] : '') ;
    $config_ini['Rollenpruefung']['fixrollenpflicht'] = $fixrollenpflicht ;
    $config_ini['Rollenpruefung']['altersrollenfamilienrollen'] = (isset($_POST['altersrollenfamilienrollen']) ? $_POST['altersrollenfamilienrollen'] : '') ;
    $config_ini['Rollenpruefung']['familienrollenfix'] = $familienrollenfix ;
    $config_ini['Rollenpruefung']['altersrollenfix'] = $altersrollenfix ;
    $config_ini['Rollenpruefung']['bezugskategorie'] = (isset($_POST['bezugskategorie']) ? $_POST['bezugskategorie'] : '') ;

    // die Prüfbedingung für Familienrollen wird im Abschnitt Familienrollen abgelegt, 
    // da sich hier auch die Definitionen der Familienrollen befinden
    $config_ini['Familienrollen']['familienrollen_pruefung'] = $_POST['familienrollen_pruefung'];

    writeConfigTablePMB($config_ini);
}

// *******************************************************************************
// Setup: Optionen
// *******************************************************************************

if( isset($_POST['optionen']))
{
    $config_ini['Optionen']['select_maxlength'] = $_POST['select_max_length'];
	if (!empty($_POST['dbtoken']))	
    {
    	$config_ini['Optionen']['dbtoken'] = $_POST['dbtoken'];	
    }
    writeConfigTablePMB($config_ini);
}

if( isset($_POST['mitgliedsnummer']))
{
	include($plugin_path. '/'.$plugin_folder.'/mitgliedsnummer.php');
}

// *******************************************************************************
// Setup: Pluginfreigabe
// *******************************************************************************

if( isset($_POST['pluginfreigabe']))
{
    $config_ini['Pluginfreigabe']['freigabe'] = (isset($_POST['freigabe']) ? $_POST['freigabe'] : array(getRole_IDPMB($gL10n->get('SYS_WEBMASTER'))));
    writeConfigTablePMB($config_ini);
}

// zur Ausgangsseite zurueck
$gMessage->setForwardUrl($gNavigation->getUrl(), 2000);
$gMessage->show($gL10n->get('SYS_SAVE_DATA'));	

?>