<?php
/******************************************************************************
* 
* mitgliedsbeitrag_show.php
*   
* Erzeugt das Menue fuer das Admidio-Plugin Mitgliedsbeitrag
* 
* Copyright    : (c) 2004 - 2014 The Admidio Team
* Homepage     : http://www.admidio.org
* License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
*
****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once(dirname(__FILE__).'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/version.php');

// Fehlermeldungen einschalten, ausgenommen Warnungen
//error_reporting(E_ALL ^E_NOTICE);

// Alle Fehlermeldungen einschalten
//error_reporting(E_ALL);

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

// weiter nur, wenn der User berechtigt ist
if(check_showpluginPMB($config_ini['Pluginfreigabe']['freigabe']))
{
    //prüfen, ob ein Update stattgefunden hat und ggf. die Installroutine aufrufen
    if(($config_ini['Plugininformationen']['plgin_mb_version']<>$plugin_mb_version) || ($config_ini['Plugininformationen']['plgin_mb_stand']<>$plugin_mb_stand))
    {
        require_once($plugin_path. '/'.$plugin_folder.'/install.php');
        exit();
    } 

    // DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
    $gDb->setCurrentDB();

    // diverse Daten einlesen und Variablen initialisieren
    //alle Fälligkeitsdaten einlesen        
    $duedates = array();
    $directdebittype=false;
    $sql = 'SELECT DISTINCT usd_value
            FROM '.TBL_USER_DATA.'
            WHERE usd_usf_id = '. $gProfileFields->getProperty('DUEDATE'.$gCurrentOrganization->getValue('org_id'), 'usf_id').' ';
		
    $result = $gDb->query($sql);
                                                    
    while ($row = $gDb->fetch_array($result))
    {
        $duedates[$row['usd_value']] = array();
        $duedates[$row['usd_value']]['FNAL']=0;
        $duedates[$row['usd_value']]['RCUR']=0;
        $duedates[$row['usd_value']]['OOFF']=0;
        $duedates[$row['usd_value']]['FRST']=0;
    }
                                      
    //alle Mitglieder einlesen
	$members = list_members(array('DUEDATE'.$gCurrentOrganization->getValue('org_id'),'SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'),'BEZAHLT'.$gCurrentOrganization->getValue('org_id'),'BEITRAG'.$gCurrentOrganization->getValue('org_id'),'MANDATEID'.$gCurrentOrganization->getValue('org_id'),'MANDATEDATE'.$gCurrentOrganization->getValue('org_id'),'IBAN','BIC'), 0)  ; 

	$duedatecount = 0;
	$paidcount = 0;
								
	foreach ($members as $member => $memberdata)
	{
										
		if (!empty($memberdata['DUEDATE'.$gCurrentOrganization->getValue('org_id')]))
		{
			$duedatecount++;
		}
		if (!empty($memberdata['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]))
		{
			$paidcount++;
		}
	}
									
	// die nachfolgenden Löschungen müssten normalerweise nicht sein, 
	// aber es könnte ja sein, dass Daten nachträglich über das Profil verändert wurden
									
	//alle Mitglieder löschen, bei denen ein Bezahlt-Datum vorhanden ist
	$members = array_filter($members, 'delete_with_BEZAHLT');
	//alle Mitglieder löschen, bei denen keine Mandatsreferenz vorhanden ist
	$members = array_filter($members, 'delete_without_MANDATEID');
	//alle Mitglieder löschen, bei denen kein Mandatsdatum vorhanden ist
	$members = array_filter($members, 'delete_without_MANDATEDATE');	
	//alle Mitglieder löschen, bei denen keine IBAN vorhanden ist
	$members = array_filter($members, 'delete_without_IBAN');
	//alle Mitglieder löschen, bei denen kein Beitrag vorhanden ist
	$members = array_filter($members, 'delete_without_BEITRAG');		
												
	foreach ($members as $member => $memberdata)
	{
		foreach ($duedates as $duedate => $duedatedata)
		{
			if($memberdata['DUEDATE'.$gCurrentOrganization->getValue('org_id')]==$duedate)
			{
				if($memberdata['SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')]=='FNAL')
				{
					$duedates[$duedate]['FNAL']++;
					$directdebittype=true;
				}
				elseif($memberdata['SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')]=='RCUR')
				{
					$duedates[$duedate]['RCUR']++;
					$directdebittype=true;
				}
			    elseif($memberdata['SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')]=='OOFF')
                {
					$duedates[$duedate]['OOFF']++;
					$directdebittype=true;
				}
				else
				{
					$duedates[$duedate]['FRST']++;
					$directdebittype=true;
				}
			}
		}
	}
	unset($members);
    
    $beitrag = analyse_mem();                
    $sum = 0;                  

    // Navigation faengt hier im Modul an
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);

    $html_icon_warning = '<img class="iconHelpLink" src="'.THEME_PATH.'/icons/warning.png" alt="'.$gL10n->get('SYS_WARNING').'" />';

    // zusaetzliche Daten fuer den Html-Kopf setzen
    $gLayout['title']  = $gL10n->get('PMB_MEMBERSHIP_FEE');
    $gLayout['header'] =  '
        <script type="text/javascript" src="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mitgliedsbeitrag_show.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.core.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.widget.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.tabs.js" ></script>		
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.accordion.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.scrollTo.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/calendar/calendar-popup.js"></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/system/js/date-functions.js"></script>
        <link rel="stylesheet" href="'.THEME_PATH.'/css/calendar.css" type="text/css" />
        <script type="text/javascript"><!--
        var mitgliedsbeitrag_showJS = new mitgliedsbeitrag_showClass();
        $(document).ready(function()
            {mitgliedsbeitrag_showJS.init();
        });
        //--></script>
        <link rel="stylesheet" type="text/css" href="'.THEME_PATH.'/css/jquery.css">';

    // Html-Kopf ausgeben
    require(SERVER_PATH. '/adm_program/system/overall_header.php');

    echo '<h1 class="moduleHeadline">'.$gL10n->get('PMB_MEMBERSHIP_FEE').'</h1>

    <div class="formLayout" id="admOrganizationMenu">
        <div class="formBody">
            <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/menue_function.php" method="post">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-common">'.$gL10n->get('PMB_TAB_COMMON').'</a></li>
                        <li><a href="#tabs-export">'.$gL10n->get('PMB_EXPORT').'</a></li>
                        <li><a href="#tabs-setup">'.$gL10n->get('PMB_SETUP').'</a></li>
                    </ul>
                    <div id="tabs-common">
                        <div id="accordion-common">';
            
                            /**************************************************************************************/
                            // Beitragsberechnung
                            /**************************************************************************************/

                            echo '<h3 id="Beitragsberechnung" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/edit.png" alt="Beitragsberechnung" title="'.$gL10n->get('PMB_CONTRIBUTION_CALCULATION').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_CONTRIBUTION_CALCULATION').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">                             	
                                	<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="neuzuordnung"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_REMAPPING_OLD_STAGGERED_ROLES').'" />&nbsp;'.$gL10n->get('PMB_REMAPPING_OLD_STAGGERED_ROLES').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_REMAPPING_OLD_STAGGERED_ROLES_DESC').'</li>
                   					<br>
                                	<HR>
                                	<li>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_ALL').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_loeschen"  ';
                                                if( $config_ini['Beitrag']['beitrag_loeschen'] == 'all')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="all" /><small> ('. ($beitrag['BEITRAG_kto_anzahl']+$beitrag['BEITRAG_rech_anzahl']).')</small>
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_WITH_PAID').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_loeschen"  ';
                                                if( $config_ini['Beitrag']['beitrag_loeschen'] == 'with')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="with" /><small> ('. ($beitrag['BEZAHLT_kto_anzahl']+$beitrag['BEZAHLT_rech_anzahl']).')</small>
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_WITHOUT_PAID').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_loeschen"  ';
                                                if( $config_ini['Beitrag']['beitrag_loeschen'] == 'without')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="without" /><small> ('. (($beitrag['BEITRAG_kto_anzahl']+$beitrag['BEITRAG_rech_anzahl'])-($beitrag['BEZAHLT_kto_anzahl']+$beitrag['BEZAHLT_rech_anzahl'])).')</small>
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_ONLY_PAID').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_loeschen"  ';
                                                if( $config_ini['Beitrag']['beitrag_loeschen'] == 'only')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="only" /><small> ('. ($paidcount) .')</small>
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_DUEDATE').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_loeschen"  ';
                                                if( $config_ini['Beitrag']['beitrag_loeschen'] == 'duedate')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="duedate" /><small> ('. ($duedatecount) .')</small>
                                            </dd>
                                        </dl>                                        
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_DELETE_DESC').'</li>
                                	<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_CONTRIBUTION_DELETE').'" />&nbsp;'.$gL10n->get('PMB_CONTRIBUTION_DELETE').'</button>
                                		</div> 
                                	</li>         	
                                	<HR>
                                    <li>
                                        <dl>
                                            <dt><label for="beitragsrollenabfrage">'.$gL10n->get('PMB_CONTRIBUTION_ROLLQUERY').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="beitrag_rollenabfrage" name="beitrag_rollenabfrage" ';
                                                if( $config_ini['Beitrag']['beitrag_rollenabfrage'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_ROLLQUERY_DESC').'</li>
                                    <li>   
                                     	<dl>
                                            <dt><label for="standard">'.$gL10n->get('PMB_CONTRIBUTION_DEFAULT').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_modus"  ';
                                                if( $config_ini['Beitrag']['beitrag_modus'] == 'standard')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="standard" />
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_OVERWRITE').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_modus"  ';
                                                if( $config_ini['Beitrag']['beitrag_modus'] == 'overwrite')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="overwrite" />
                                            </dd>
                                        </dl>
                                        <dl>
                                            <dt><label for="loeschen">'.$gL10n->get('PMB_CONTRIBUTION_SUMMATION').':</label></dt>
                                            <dd>
                                                <input type="radio" name="beitrag_modus"  ';
                                                if( $config_ini['Beitrag']['beitrag_modus'] == 'summation')
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="summation" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_MODUS_DESC').'</li>
                                  	<br>
                                	<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="neuberechnung"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_RECALCULATION').'" />&nbsp;'.$gL10n->get('PMB_RECALCULATION').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_RECALCULATION_DESC').'</li>
                                </ul>
                            </div>';

                            /**************************************************************************************/
                            // Beitragszahlungen
                            /**************************************************************************************/

                            echo '<h3 id="Beitragszahlungen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/edit.png" alt="Beitragszahlungen" title="'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                        <dl>
                                            <dt><label for="zahlungenrollenabfrage">'.$gL10n->get('PMB_ROLLQUERY').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="zahlungen_rollenabfrage" name="zahlungen_rollenabfrage" ';
                                                if( $config_ini['Beitrag']['zahlungen_rollenabfrage'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_PAYMENTS_ROLLQUERY_DESC').'</li> 
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="beitragszahlungen"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS_EDIT').'" />&nbsp;'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS_EDIT').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS_DESC',$gL10n->get('SYS_NOTE').':').'</li>
                                </ul>
                            </div>';

                            /**************************************************************************************/
                            // Beitragsanalyse
                            /**************************************************************************************/		

                            echo '<h3 id="Beitragsanalyse" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Beitragsanalyse" title="'.$gL10n->get('PMB_CONTRIBUTION_ANALYSIS').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_CONTRIBUTION_ANALYSIS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li><strong>'.$gL10n->get('PMB_MEMBERS_CONTRIBUTION').'</strong></li>
                                    <BR><BR>
                                    <table border="0">
                                        <tr>
                                            <th>&#160;</th>
                                            <th colspan="2" align = "center">'.$gL10n->get('PMB_ACCOUNT').'</th>
                                            <th colspan="2" align = "center">'.$gL10n->get('PMB_BILL').'</th>
                                            <th colspan="2" align = "center">'.$gL10n->get('PMB_SUM').'</th>
                                        </tr>
                                        <tr>
                                            <td>&#160;</td>';
                                            for ($i=0;$i<3;$i++)
                                            {
                                                echo '<td align = "right">'.$gL10n->get('SYS_CONTRIBUTION').'</td>
                                                <td align = "right">'.$gL10n->get('PMB_ITEM').'</td> ';
                                            }    
                                            echo'       
                                        </tr>
                                        <tr>
                                            <td>'.$gL10n->get('PMB_DUES').'</td>
                                            <td  align = "right">'. $beitrag['BEITRAG_kto'].' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. $beitrag['BEITRAG_kto_anzahl'].'</td>
                                            <td  align = "right">'. $beitrag['BEITRAG_rech'].' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. $beitrag['BEITRAG_rech_anzahl'].'</td>
                                            <td  align = "right">'.($beitrag['BEITRAG_kto']+$beitrag['BEITRAG_rech']).' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'.($beitrag['BEITRAG_kto_anzahl']+$beitrag['BEITRAG_rech_anzahl']).'</td>
                                        </tr>
                                        <tr>
                                            <td>'.$gL10n->get('PMB_ALREADY_PAID').'</td>
                                            <td  align = "right">'. $beitrag['BEZAHLT_kto'].' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. $beitrag['BEZAHLT_kto_anzahl'].'</td>
                                            <td  align = "right">'. $beitrag['BEZAHLT_rech'].' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. $beitrag['BEZAHLT_rech_anzahl'].'</td>
                                            <td  align = "right">'.($beitrag['BEZAHLT_kto']+$beitrag['BEZAHLT_rech']).' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'.($beitrag['BEZAHLT_kto_anzahl']+$beitrag['BEZAHLT_rech_anzahl']).'</td>
                                        </tr>
                                        <tr>
                                            <td>'.$gL10n->get('PMB_PENDING').'</td>
                                            <td  align = "right">'. ($beitrag['BEITRAG_kto']-$beitrag['BEZAHLT_kto']).' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. ($beitrag['BEITRAG_kto_anzahl']-$beitrag['BEZAHLT_kto_anzahl']).'</td>
                                            <td  align = "right">'. ($beitrag['BEITRAG_rech']-$beitrag['BEZAHLT_rech']).' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'. ($beitrag['BEITRAG_rech_anzahl']-$beitrag['BEZAHLT_rech_anzahl']).'</td>
                                            <td  align = "right">'.(($beitrag['BEITRAG_kto']+$beitrag['BEITRAG_rech'])-($beitrag['BEZAHLT_kto']+$beitrag['BEZAHLT_rech'])).' '.$gPreferences['system_currency'].'</td>
                                            <td  align = "right">'.(($beitrag['BEITRAG_kto_anzahl']+$beitrag['BEITRAG_rech_anzahl'])-($beitrag['BEZAHLT_kto_anzahl']+$beitrag['BEZAHLT_rech_anzahl'])).'</td>
                                        </tr>
                                    </table>
                                    <BR>
                                    <li class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_MEMBERS_CONTRIBUTION_DESC').'</li> 					
                                    <HR>
                                    <li><strong>'.$gL10n->get('PMB_ROLES_CONTRIBUTION').'</strong></li>
                                    <BR><BR> ';
                                    $rollen = analyse_rol() ;
                                    echo '<div style="width:100%; height:150px; overflow:auto; border:0px;">
                                        <table border="0">
                                            <tr>
                                                <th>'.$gL10n->get('PMB_ROLE').'</th>
                                                <th align = "right">'.$gL10n->get('SYS_CONTRIBUTION').'</th>
                                                <th align = "right">'.$gL10n->get('PMB_NUMBER').'</th>
                                                <th align = "right">'.$gL10n->get('PMB_SUM').'</th>
                                            </tr>';
                                            foreach ($rollen as $rol => $roldata )
                                            {
                                                echo '<tr>
                                                    <td>'.$roldata['rolle'].'</td>
                                                    <td align = "right">'.$roldata['rol_cost'].' '.$gPreferences['system_currency'].'</td>
                                                    <td align = "right">'.sizeof($roldata['members']).'</td>
                                                    <td align = "right">'.($roldata['rol_cost']*sizeof($roldata['members'])).' '.$gPreferences['system_currency'].'</td>
                                                </tr>';
                                                $sum += ($roldata['rol_cost']*sizeof($roldata['members']));
                                            } 
                                            echo'<tr>
                                                <td>&#160;</td>
                                            </tr>
                                            <tr>
                                                <td>'.$gL10n->get('PMB_TOTAL').'</td>
                                                <td>&#160;</td>
                                                <td>&#160;</td>
                                                <td align = "right">'.$sum.' '.$gPreferences['system_currency'].'</td>
                                            </tr>
                                        </table>
                                    </div>
                                    <BR>
                                    <li class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_ROLES_CONTRIBUTION_DESC').'</li> 									
                                </ul>
                                <br>
                            </div>'; 
                         
                            /**************************************************************************************/
                            // Prüfungen ALT:Rollenpruefung
                            /**************************************************************************************/

                            echo '<h3 id="Rollenprüfung" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Rollenprüfung" title="'.$gL10n->get('PMB_ROLE_TEST').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_ROLE_TEST').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li>
                                        <dl>
                                            <dt><label for="Altersgestaffelte Rollen">'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').':</label></dt>
                                            <dd><label for="">';
                                                foreach (check_rols() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                                echo'</label>
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_OLD_STAGGERED_ROLES_DESC').'</li> 									
                                    <HR>
                                    <li>
                                        <dl>
                                            <dt><label for="Rollenmitgliedschaft-Pflicht">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY').':</label></dt> 
                                            <dd><label for="">';
                                                foreach (check_rollenmitgliedschaft_pflicht() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                                echo'</label>
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY_DESC').'</li>
                                    <HR>
                                    <li>
                                        <dl>
                                            <dt><label for="Rollenmitgliedschaft-Ausschluss">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION').':</label></dt> 
                                            <dd><label for="">';
                                                foreach (check_rollenmitgliedschaft_ausschluss() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                                echo'</label>
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION_DESC').'</li>  
									<HR>
                                    <li>
                                        <dl>
                                            <dt><label for="Überprüfung der Familienrollen">'.$gL10n->get('PMB_FAMILY_ROLES').':</label></dt>
                                            <dd><label for="">';
                                                foreach (check_family_roles() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                             echo'</label>
                                            </dd>	
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_ROLE_TEST_DESC').'</li> 									
                                    <HR>
                                    <li>
                                        <dl>
                                            <dt><label for="Mandatsverwaltung">'.$gL10n->get('PMB_MANDATE_MANAGEMENT').':</label></dt>
                                            <dd><label for="">';
                                                foreach (check_mandate_management() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                                echo'</label>
                                            </dd>	
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_MANDATE_MANAGEMENT_DESC2').'</li> 									
             						<HR>
                                    <li>
                                        <dl>
                                            <dt><label for="IBAN-Check">'.$gL10n->get('PMB_IBANCHECK').':</label></dt>
                                            <dd><label for="">';
                                                foreach (check_iban() as $data )
                                                {
                                                    echo ' '.$data.'<BR> ';
                                                } 
                                                echo'</label>
                                            </dd>	
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_IBANCHECK_DESC').'</li> 									
                                </ul>
                                <br>				
                            </div>';

                            /**************************************************************************************/
                            // Rollenübersicht
                            /**************************************************************************************/

                            echo '<h3 id="Rollenübersicht" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Rollenübersicht" title="'.$gL10n->get('PMB_ROLE_OVERVIEW').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_ROLE_OVERVIEW').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">  
                                <li><strong>'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').':</strong></li>
                                <BR>';
                                $rollen = beitragsrollen_einlesen('alt',array('LAST_NAME'));
                                if (sizeof($rollen)>0)
                                {
                                    echo'<div style="width:100%; height:100px; overflow:auto; border:0px;">
                                        <table border="0">
                                            <tr>
                                                <td>'.$gL10n->get('PMB_ROLE_NAME').'</td>
                                                <td align="center">'.$gL10n->get('PMB_MEMBER_ACCOUNT').'</td>
                                            </tr>';
                                            foreach ($rollen as $data )
                                            {
                                                echo '<tr>
                                                    <td>'.$data['rolle'].'</td>
                                                    <td align="center">'.sizeof($data['members']).'</td>
                                                </tr>';
                                            }
                                        echo '</table>
                                    </div> ';
                                }
                                else
                                {
                                    echo $gL10n->get('PMB_NO_ROLES').'<BR>';
                                }
                                echo'					
                                <BR>
                                <li><strong>'.$gL10n->get('PMB_FAMILY_ROLES').':</strong></li>
                                <BR>';
                                $rollen = beitragsrollen_einlesen('fam',array('LAST_NAME'));
                                if (sizeof($rollen)>0)
                                {
                                    echo'<div style="width:100%; height:100px; overflow:auto; border:0px;">
                                        <table border="0">
                                            <tr>
                                                <td>'.$gL10n->get('PMB_ROLE_NAME').'</td>
                                                <td align="center">'.$gL10n->get('PMB_MEMBER_ACCOUNT').'</td>
                                            </tr>';
                                            foreach ($rollen as $data )
                                            {
                                                echo '<tr>
                                                    <td>'.$data['rolle'].'</td>
                                                    <td align="center">'.sizeof($data['members']).'</td>
                                                </tr>';
                                            }
                                        echo '</table>
                                    </div> ';
                                }
                                else
                                {
                                    echo $gL10n->get('PMB_NO_ROLES').'<BR>';
                                }
                                echo'					
                                <BR>
                                <li><strong>'.$gL10n->get('PMB_OTHER_CONTRIBUTION_ROLES').':</strong></li>
                                <BR>';
                                $rollen = beitragsrollen_einlesen('fix',array('LAST_NAME'));
                                if (sizeof($rollen)>0)
                                {
                                    echo'<div style="width:100%; height:100px; overflow:auto; border:0px;">
                                        <table border="0">
                                            <tr>
                                                <td>'.$gL10n->get('PMB_ROLE_NAME').'</td>
                                                <td align="center">'.$gL10n->get('PMB_MEMBER_ACCOUNT').'</td>
                                            </tr>';
                                            foreach ($rollen as $data )
                                            {
                                                echo '<tr>
                                                    <td>'.$data['rolle'].'</td>
                                                    <td align="center">'.sizeof($data['members']).'</td>
                                                </tr>';
                                            }
                                        echo '</table>
                                    </div> ';
                                }
                                else
                                {
                                    echo $gL10n->get('PMB_NO_ROLES').'<BR>';
                                }
                                echo'
                            </div>';
                                
                            /**************************************************************************************/
                            // Mandatsverwaltung
                            /**************************************************************************************/

                            echo '<h3 id="Mandatsverwaltung" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/edit.png" alt="Mandatsverwaltung" title="'.$gL10n->get('PMB_MANDATE_MANAGEMENT').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_MANDATE_MANAGEMENT').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">                      
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="mandatsreferenzen_erzeugen"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_MANDATE_GENERATE').'" />&nbsp;'.$gL10n->get('PMB_MANDATE_GENERATE').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_MANDATE_GENERATE_DESC').'</li>
                               		<br>
                                	<br>
									<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="mandat_bearbeiten"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_MANDATE_EDIT').'" />&nbsp;'.$gL10n->get('PMB_MANDATE_EDIT').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_MANDATE_EDIT_DESC').'</li>
                                </ul>
                            </div>';
                            
                        // ENDE accordion-common
                        echo'</div>              
                    </div>                        
                
                    <div id="tabs-export">
                        <div id="accordion-export">';

                            /**************************************************************************************/
                            // SEPA-Export
                            /**************************************************************************************/

                            echo '<h3 id="SEPA-Export" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/download.png" alt="SEPA-Export" title="'.$gL10n->get('PMB_SEPA').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_SEPA').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                        <dl>
                                            <dt><label for="beitragsrollenabfrage">'.$gL10n->get('PMB_DUEDATE_ROLLQUERY').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="duedate_rollenabfrage" name="duedate_rollenabfrage" ';
                                                if( $config_ini['SEPA']['duedate_rollenabfrage'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_DUEDATE_ROLLQUERY_DESC').'</li>
 									<br> 
                                    <li>
                                    	<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="faelligkeitsdatum_bearbeiten"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_DUEDATE_EDIT').'" />&nbsp;'.$gL10n->get('PMB_DUEDATE_EDIT').'</button>
                                		</div>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_DUEDATE_EDIT_DESC').'</li>
                                    <br>
                                    <hr>';
                            

                            		echo'<div style="width:100%; overflow:auto; border:0px;">
        								<table border="0">
            								<tr>
            									<th>&#160;&#160;'.$gL10n->get('PMB_DUEDATE').'&#160;&#160;</td>
            									<th>&#160;&#160;FRST&#160;&#160;</td>
            									<th>&#160;&#160;RCUR&#160;&#160;</td>
            									<th>&#160;&#160;FNAL&#160;&#160;</td>
            									<th>&#160;&#160;OOFF&#160;&#160;</td>
            								</tr>';
                            		foreach ($duedates as $duedate => $duedatedata)
										{
											$datumtemp = new DateTimeExtended($duedate, 'Y-m-d', 'date');
											
											echo'<tr>
            									<td align="center">'.$datumtemp->format($gPreferences['system_date']).'</td>
            									<td align="center"><input type="radio" name="duedatesepatype" ';
													if ($duedatedata['FRST']==0)
                                                	{
                                                    	echo ' disabled="disabled" ';
                                                	}
                                                	echo 'value="'.$duedate.'FRST" /><small> ('.$duedatedata['FRST'].')</small>
                                                </td>
            									<td align="center"><input type="radio" name="duedatesepatype" ';
													if ($duedatedata['RCUR']==0)
                                                	{
                                                    	echo ' disabled="disabled" ';
                                                	}
                                                	echo ' value="'.$duedate.'RCUR" /><small> ('.$duedatedata['RCUR'].')</small>
                                                </td>
            									<td align="center"><input type="radio" name="duedatesepatype"  ';
													if ($duedatedata['FNAL']==0)
                                                	{
                                                    	echo ' disabled="disabled" ';
                                                	}
                                                	echo 'value="'.$duedate.'FNAL" /><small> ('.$duedatedata['FNAL'].')</small>
                                                </td>
            									<td align="center"><input type="radio" name="duedatesepatype"  ';
													if ($duedatedata['OOFF']==0)
                                                	{
                                                    	echo ' disabled="disabled" ';
                                                	}
                                                	echo 'value="'.$duedate.'OOFF" /><small> ('.$duedatedata['OOFF'].')</small>
                                                </td>
            								</tr>';
										}	
            							echo'</table>
            						</div>
                                   	<br>
                                   	<li class="smallFontSize">'.$gL10n->get('PMB_DUEDATE_SELECTION_DESC').'</li>
                                   	<br>
                             		<li>
                                        <dl>
                                            <dt><label for="eillastschrift">'.$gL10n->get('PMB_COR1_MARKER').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="eillastschrift" name="eillastschrift" value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_COR1_MARKER_DESC').'</li>
                                   	<br>
                                   	<br>
                                    <li>  
                                     	<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" ';
												if (!$directdebittype)
                                                {
                                                    echo ' disabled="disabled" ';
                                                }
                                    		 echo ' name="xml_datei"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_XML_FILE').'" />&nbsp;'.$gL10n->get('PMB_XML_FILE').'</button>
                                		</div>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_XML_FILE_DESC').'</li>
                                    <br>
                                    <br>
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" ';
												if (!$directdebittype)
                                                {
                                                    echo ' disabled="disabled" ';
                                                }
                                    		 echo ' name="xml_begleitzettel"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_ESCORT_NOTEPAPER').'" />&nbsp;'.$gL10n->get('PMB_ESCORT_NOTEPAPER').'</button>
                                		</div> 
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_ESCORT_NOTEPAPER_DESC').'</li>
                                    <br>
                                    <br>
                                   	<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit"  ';
												if (!$directdebittype)
                                                {
                                                    echo ' disabled="disabled" ';
                                                }
                                    		 echo ' name="xml_kontroll_datei"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_CONTROL_FILE').'" />&nbsp;'.$gL10n->get('PMB_CONTROL_FILE').'</button>
                                		</div> 
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTROL_FILE_DESC').'</li>
                        			<br>
                                    <br>
                                    <li class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_SEPA_EXPORT_INFO').'</li>  
                                    <br>
                                    <hr>
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit ';
												if (!$directdebittype)
                                                {
                                                    echo ' disabled="disabled" ';
                                                }
                                    		 echo ' " name="pre_notification"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_PRE_NOTIFICATION').'" />&nbsp;'.$gL10n->get('PMB_PRE_NOTIFICATION').'</button>
                                		</div> 
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_PRE_NOTIFICATION_DESC').'</li>
                                </ul>
                            </div>';                      
                         
                          	/**************************************************************************************/
                            // Rechnungs-Export (guenter47)
                            /**************************************************************************************/

                            echo '<h3 id="Rechnungs-Export" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/download.png" alt="Rechnungs-Export" title="'.$gL10n->get('PMB_STATEMENT_EXPORT').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_STATEMENT_EXPORT').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="rechnungs_export"><img src="'. THEME_PATH. '/icons/download.png" alt="'.$gL10n->get('PMB_STATEMENT_FILE').'" />&nbsp;'.$gL10n->get('PMB_STATEMENT_FILE').'</button>
                                		</div> 
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_STATEMENT_FILE_DESC').'</li>
                                </ul>
                            </div>';                        
                        
                        // ENDE accordion-export
                        echo'</div>              
                    </div>    
                    
                    <div id="tabs-setup">
                        <div id="accordion-setup">';

                            /**************************************************************************************/
                            // Löschen (ALT:Reset)
                            /**************************************************************************************/

                            echo '<h3 id="Reset" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/delete.png" alt="Reset" title="'.$gL10n->get('PMB_RESET').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_RESET').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li class="smallFontSize">'.$gL10n->get('SYS_NOTE').': '.$gL10n->get('PMB_DELETE_INFO').'</li>    
                                    <li>
									   <div class="formSubmit">	
                                        <button id="btnSave" type="submit" name="mandate_loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_DELETE_MANDATE').'" />&nbsp;'.$gL10n->get('PMB_DELETE_MANDATE').'</button>
                                	   </div> 
                                    </li> 
                                    <li>
									   <div class="formSubmit">	
                                    	   <button id="btnSave" type="submit" name="mitgliedsnummern_loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_DELETE_MEMBERNUMBER').'" />&nbsp;'.$gL10n->get('PMB_DELETE_MEMBERNUMBER').'</button>
                                	   </div> 
                                    </li> 
                                    <li>
									   <div class="formSubmit">	
                                    	   <button id="btnSave" type="submit" name="lastschrifttypen_loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_DELETE_SEQUENCETYPE').'" />&nbsp;'.$gL10n->get('PMB_DELETE_SEQUENCETYPE').'</button>
                                	   </div> 
                                    </li> 
                                    <li>
									   <div class="formSubmit">	
                                    	   <button id="btnSave" type="submit" name="iban_bic_loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_DELETE_IBAN_BIC').'" />&nbsp;'.$gL10n->get('PMB_DELETE_IBAN_BIC').'</button>
                                	   </div> 
                                    </li> 
                                    <li>
									   <div class="formSubmit">	
                                    	   <button id="btnSave" type="submit" name="mandatsaenderungen_loeschen"><img src="'. THEME_PATH. '/icons/delete.png" alt="'.$gL10n->get('PMB_DELETE_MANDATECHANGE').'" />&nbsp;'.$gL10n->get('PMB_DELETE_MANDATECHANGE').'</button>
                                	   </div> 
                                    </li>  
                                </ul>                               
                            </div>';

                            /**************************************************************************************/
                            // Beitragseinstellungen
                            /**************************************************************************************/
							$text2 = new TableText($gDb);
                            echo '<h3 id="Beitragseinstellungen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Beitragseinstellungen" title="'.$gL10n->get('PMB_CONTRIBUTION_SETTINGS').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_CONTRIBUTION_SETTINGS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                            <dt><label for="beitrag_prefix">'.$gL10n->get('PMB_PREFIX').':</label></dt>
                                            <dd><input type="text" id="beitrag_prefix" name="beitrag_prefix" style="width: 200px;" maxlength="60" value="'. $config_ini['Beitrag']['beitrag_prefix']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_PREFIX_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="beitrag_suffix">'.$gL10n->get('PMB_CONTRIBUTION_SUFFIX').':</label></dt>
                                            <dd><input type="text" id="beitrag_suffix" name="beitrag_suffix" style="width: 200px;" maxlength="60" value="'. $config_ini['Beitrag']['beitrag_suffix']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_SUFFIX_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="anteilig">'.$gL10n->get('PMB_CONTRIBUTION_PRORATA').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="beitrag_anteilig" name="beitrag_anteilig" ';
                                                if( $config_ini['Beitrag']['beitrag_anteilig'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_PRORATA_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="abrunden">'.$gL10n->get('PMB_CONTRIBUTION_ROUNDDOWN').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="beitrag_abrunden" name="beitrag_abrunden" ';
                                                if( $config_ini['Beitrag']['beitrag_abrunden'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_ROUNDDOWN_DESC').'</li>
                                    <li>
                                        <dl> 
                                            <dt><label for="mindestberechnungsbetrag">'.$gL10n->get('PMB_CONTRIBUTION_MINCALC').':</label></dt> 
                                            <dd><input type="text" id="beitrag_mindestbetrag" name="beitrag_mindestbetrag" style="width: 50px;" maxlength="6" value="'.$config_ini['Beitrag']['beitrag_mindestbetrag'].'" /> '.$gPreferences['system_currency'].'</dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_MINCALC_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="textmitnam">'.$gL10n->get('PMB_CONTRIBUTION_TEXT_MEMNAMES').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="beitrag_textmitnam" name="beitrag_textmitnam" ';
                                                if( $config_ini['Beitrag']['beitrag_textmitnam'] == 1)
                                                {
                                                   echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_TEXT_MEMNAMES_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="textmitfam">'.$gL10n->get('PMB_CONTRIBUTION_TEXT_FAMNAMES').':</label></dt>
                                            <dd>
                                                <input type="checkbox" id="beitrag_textmitfam" name="beitrag_textmitfam" ';
                                                if( $config_ini['Beitrag']['beitrag_textmitfam'] == 1)
                                                {
                                                    echo ' checked="checked" ';
                                                }
                                                echo ' value="1" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_TEXT_FAMNAMES_DESC').'</li>
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PMB_CONTRIBUTION_TEXT_TOKEN').':</label></dt>
                                            <dd>
                                                <select name="beitrag_text_token" size="1">';                     
                                                    $token = array('#'=>' &nbsp '.$gL10n->get('PMB_CONTRIBUTION_BLANK') ,
                                                    			   '.'=>'. '.$gL10n->get('PMB_CONTRIBUTION_DOT') ,
                                                    			   ','=>', '.$gL10n->get('PMB_CONTRIBUTION_COMMA') ,
                                                    			   '-'=>'- '.$gL10n->get('PMB_CONTRIBUTION_HYPHEN') ,
                                                    			   '/'=>'/ '.$gL10n->get('PMB_CONTRIBUTION_SLASH') ,
                                                    			   '+'=>'+ '.$gL10n->get('PMB_CONTRIBUTION_PLUS') ,
                                                    			   '*'=>'* '.$gL10n->get('PMB_CONTRIBUTION_TIMES').'(*)',
                                                    			   '%'=>'% '.$gL10n->get('PMB_CONTRIBUTION_PERCENT').'(*)' );
                                                    foreach ($token as $key => $data)  
                                                    {
                                                        echo '<option value='.$key;
                                                        if(($key == $config_ini['Beitrag']['beitrag_text_token'])      )
                                                        {
                                                            echo ' selected="selected" ';	
                                                        } 
                                                        echo '>'.$data.'</option>';		
                                                    }  
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_TEXT_TOKEN_DESC').'</li>
                                    <BR>
									<li>
                        				<dl>
                            				<dt><label>'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS_MAIL_TEXT').':</label></dt>
                            				<dd><br /></dd>
                        				</dl>
                    				</li>
                    				<li  class="smallFontSize">'.$gL10n->get('PMB_CONTRIBUTION_PAYMENTS_MAIL_TEXT_DESC').':<br />
                        				<strong>%user_first_name%</strong> - '.$gL10n->get('PMB_VARIABLE_FIRST_NAME').'<br />
                        				<strong>%user_last_name%</strong> - '.$gL10n->get('PMB_VARIABLE_LAST_NAME').'<br />
										<strong>%organization_long_name%</strong> - '.$gL10n->get('ORG_VARIABLE_NAME_ORGANIZATION').'<br />
                        				<strong>%fee%</strong> - '.$gL10n->get('PMB_VARIABLE_FEE').'<br />
                        				<strong>%due_day%</strong> - '.$gL10n->get('PMB_VARIABLE_DUE_DAY').'<br />
                        				<strong>%mandate_id%</strong> - '.$gL10n->get('PMB_VARIABLE_MANDATE_ID').'<br />
                        				<strong>%creditor_id%</strong> - '.$gL10n->get('PMB_VARIABLE_CREDITOR_ID').'<br />
                        				<strong>%iban%</strong> - '.$gL10n->get('PMB_VARIABLE_IBAN').'<br />
                        				<strong>%debtor%</strong> - '.$gL10n->get('PMB_VARIABLE_DEBTOR').'<br />
                        				<strong>%membership_fee_text%</strong> - '.$gL10n->get('PMB_VARIABLE_MEMBERSHIP_FEE_TEXT').'<br />
                        				<br />
                    				</li>';

                    				$text2->readDataByColumns(array('txt_name' => 'PMBMAIL_CONTRIBUTION_PAYMENTS', 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));

                    				//wenn noch nichts drin steht, dann vorbelegen
                    				if ($text2->getValue('txt_text')=='')
                    				{
                    	
        								// convert <br /> to a normal line feed
        								$value = preg_replace('/<br[[:space:]]*\/?[[:space:]]*>/',chr(13).chr(10),$gL10n->get('PMB_PMBMAIL_CONTRIBUTION_PAYMENTS'));
                    			
            							$text2->setValue('txt_text', $value);
            							$text2->save();
            							$text2->readDataByColumns(array('txt_name' => 'PMBMAIL_CONTRIBUTION_PAYMENTS', 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));
                    				}
                    				echo '<li>
                        				<textarea id="PMBMAIL_CONTRIBUTION_PAYMENTS" name="PMBMAIL_CONTRIBUTION_PAYMENTS" style="width: 100%;" rows="7" cols="40">'.$text2->getValue('txt_text').'</textarea>
                    				</li>                                    
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="beitragseinstellungen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Altersgestaffelte Rollen
                            /**************************************************************************************/

                            echo '<h3 id="Altersgestaffelte Rollen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Altersgestaffelte Rollen" title="'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                		<dl>
                                    		<dt><label for="altersrollen_anzahl">'.$gL10n->get('PMB_STAGGERING_NUMBER').':</label></dt>
                                        	<dd>
                                        		'. $config_ini['Altersrollen']['altersrollen_anzahl'].' + <input type="text" id="altersrollen_anzahl" name="altersrollen_anzahl" style="width: 40px;" maxlength="40" value="0" />
                                        	</dd>
                                    	</dl>
                                	</li>
                               		<li>                                
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="altersrollenanzahl"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                		</div>
                                		<HR>';
                            
                                    	$width = '80px';
                                    	$maxlength = '10';
                                    	$stichtag = '';

                                    	$value2 = '<script type="text/javascript">
                                        	var calDate2 = new CalendarPopup("calendardiv2");
                                        	calDate2.setCssPrefix("calendar");
                                        	calDate2.showNavigationDropdowns();
                                        	calDate2.setYearSelectStartOffset(50);
                                        	//calDate2.offsetX = -220;
                                        	//calDate2.offsetY = -500;
                                        	calDate2.offsetX = 0;
                                        	calDate2.offsetY = 0;
                                        	calDate2.setYearSelectEndOffset(10);
                                    	</script>';

                  						$value2 .= '
                                        	<input type="text" id="altersrollen_stichtag" name="altersrollen_stichtag" style="width: 80px;" maxlength="10" value="'. $config_ini['Altersrollen']['altersrollen_stichtag']. '" />
                                        	<a class="iconLink" id="anchor_stichtag" href="javascript:calDate2.select(document.getElementById(\'altersrollen_stichtag\'),\'anchor_stichtag\',\''.$gPreferences['system_date'].'\');">
                                        		<img src="'. THEME_PATH. '/icons/calendar.png" alt="'.$gL10n->get('SYS_SHOW_CALENDAR').'" title="'.$gL10n->get('SYS_SHOW_CALENDAR').'" />
                                        	</a>
                                        	<span id="calendardiv2" style="position: static; float:right; visibility: hidden;"></span>';

                                    	echo '<li>
                                        	<dl>
                                            	<dt><label for="stichtag">'.$gL10n->get('PMB_DEADLINE').':</label></dt>
                                            	<dd>'. $value2.  '</dd>  
                                        	</dl>
                                    	</li>    
                                    	 
                                    	<li class="smallFontSize">'.$gL10n->get('PMB_DEADLINE_DESC').'</li>';
                                
                                		for ($i=1;$i<$config_ini['Altersrollen']['altersrollen_anzahl']+1;$i++)
										{
							    			echo'<HR>
                                    		<li  class="smallFontSize">'.$i.'. '.$gL10n->get('PMB_STAGGERING').'</li>
                                    		<li>
                                        		<dl>
                                            		<dt><label for="altersrollen_token">'.$gL10n->get('PMB_DELIMITER').':</label></dt>
                                            		<dd><input type="text" id="altersrollen_token[]" name="altersrollen_token[]" style="width: 30px;" maxlength="1" value="'. (isset($config_ini['Altersrollen']['altersrollen_token'][$i-1]) ? $config_ini['Altersrollen']['altersrollen_token'][$i-1] : ''). '" /></dd>
                                        		</dl>
                                    		</li>
                                    		<li class="smallFontSize">'.$gL10n->get('PMB_DELIMITER_DESC').'</li>
                                    		<BR>';
                                    	}
                                	echo '
                                	<HR> 
                                    <li class="smallFontSize">'.$gL10n->get('PMB_DELIMITER_INFO1').'<strong> '.$gL10n->get('PMB_DELIMITER_INFO2').'</strong>'.$gL10n->get('PMB_DELIMITER_INFO3').'</li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="altersrollen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

                            /**************************************************************************************/
                            // Familienrollen
                            /**************************************************************************************/

                            echo '<h3 id="Familienrollen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Familienrollen" title="'.$gL10n->get('PMB_FAMILY_ROLES').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_FAMILY_ROLES').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                					<li>
                                        <dl>
                                            <dt><label for="familienrollen_anzahl">'.$gL10n->get('PMB_FAMILY_ROLES_NUMBER').':</label></dt>
                                            <dd>
                                            	'. $config_ini['Familienrollen']['familienrollen_anzahl'].' + <input type="text" id="familienrollen_anzahl" name="familienrollen_anzahl" style="width: 40px;" maxlength="40" value="0" />
                                            </dd>
                                        </dl>
                                    </li>
                                 	<li>                                
									<div class="formSubmit">	
                                    	<button id="btnSave" type="submit" name="familienrollenanzahl"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                	</div>';
                                	for ($i=1;$i<$config_ini['Familienrollen']['familienrollen_anzahl']+1;$i++)
									{
							    		echo'<HR>
                                    	<li  class="smallFontSize">'.$i.'. '.$gL10n->get('PMB_FAMILY_ROLE').'</li>
                                   		<li>
                                    		<dl>
                                        		<dt><label for="familienrollen_prefix">'.$gL10n->get('PMB_PREFIX').':</label></dt>
                                            	<dd>
                                            		<input type="text" id="familienrollen_prefix[]" name="familienrollen_prefix[]" style="width: 200px;" maxlength="20" value="'. (isset($config_ini['Familienrollen']['familienrollen_prefix'][$i-1]) ? $config_ini['Familienrollen']['familienrollen_prefix'][$i-1] : ''). '" />
                                            		<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                            	</dd>
                                        	</dl>
                                    	</li>
                                    	<li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_PREFIX_DESC').'</li>
                                    	<li>
                                        	<dl>
                                        		<dt><label for="familienbeitrag">'.$gL10n->get('SYS_CONTRIBUTION').':</label></dt> 
                                        		<dd>
                                        			<input type="text" id="familienrollen_beitrag[]" name="familienrollen_beitrag[]" style="width: 50px;" maxlength="6" value="'.(isset($config_ini['Familienrollen']['familienrollen_beitrag'][$i-1]) ? $config_ini['Familienrollen']['familienrollen_beitrag'][$i-1] : '').'" /> '.$gPreferences['system_currency'].'
                                        			<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                        		</dd>
                                        	</dl>
                                    	</li>
                                    	<li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_CONTRIBUTION_DESC').'</li>
                                  		<li>
                                        	<dl>
                                        		<dt><label>'.$gL10n->get('SYS_CONTRIBUTION_PERIOD').':</label></dt>
                                            	<dd>
                                                	<select name="familienrollen_zeitraum[]" size="1">';                     
                                                    	$period = array('--',-1,1,2,4,12);
                                                    	foreach ($period as $key) 
                                                    	{
                                                        	echo '<option value='.$key;
                                                        	if($key == (isset($config_ini['Familienrollen']['familienrollen_zeitraum'][$i-1]) ? $config_ini['Familienrollen']['familienrollen_zeitraum'][$i-1] : '') )
                                                        	{
                                                            	echo ' selected="selected" ';	
                                                        	} 
                                                        	echo '>'.getCostPeriod($key).'</option>';		
                                                    	}  
                                                	echo '</select>
                                                	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>              
                                            	</dd>
                                        	</dl>
                                    	</li>
                                    	<li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_CONTRIBUTION_PERIOD_DESC').'</li>
                                    	<li>
                                        	<dl>
                                        		<dt><label for="familienbeschreibung">'.$gL10n->get('SYS_DESCRIPTION').':</label></dt> 
                                            	<dd><input type="text" id="familienrollen_beschreibung[]" name="familienrollen_beschreibung[]" style="width: 200px;" maxlength="50" value="'.$config_ini['Familienrollen']['familienrollen_beschreibung'][$i-1].'" /></dd>
                                        	</dl>
                                    	</li>
                                    	<li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_DESCRIPTION_DESC').'</li>';
									}
                                echo '</ul>
                                <br>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="familienrollen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

							/**************************************************************************************/
                            // Kontodaten
                            /**************************************************************************************/

                            echo '<h3 id="Kontodaten" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Kontodaten" title="'.$gL10n->get('PMB_ACCOUNT_DATA').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_ACCOUNT_DATA').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li>
                                        <dl>
                                            <dt><label for="Kontonummer">'.$gL10n->get('PMB_ACCOUNT_NUMBER').':</label></dt>
                                            <dd>
                                            	<input type="text" id="ktonr" name="ktonr" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['ktonr']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                            </dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Bankleitzahl">'.$gL10n->get('PMB_BANK_CODE_NUMBER').':</label></dt>
                                            <dd>
                                            	<input type="text" id="blz" name="blz" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['blz']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                            </dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="iban">'.$gL10n->get('PMB_IBAN').':</label></dt>
                                            <dd>
                                            	<input type="text" id="iban" name="iban" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['iban']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                            </dd>
                                    	</dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="bic">'.$gL10n->get('PMB_BIC').':</label></dt>
                                            <dd>
                                            	<input type="text" id="bic" name="bic" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['bic']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
                                            </dd>
                                    	</dl>
                                    </li> 
                                    <li>
                                        <dl>
                                            <dt><label for="bank">'.$gL10n->get('PMB_BANK').':</label></dt>
                                            <dd><input type="text" id="bank" name="bank" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['bank']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Kontoinhaber">'.$gL10n->get('PMB_CREDITOR').':</label></dt>
                                            <dd>
                                            	<input type="text" id="inhaber" name="inhaber" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['inhaber']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span> 
                                            	<a href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandat_change_cdtr.php"><img src="'. THEME_PATH.'/icons/edit.png" alt="'.$gL10n->get('PMB_MANDATE_CHANGE').'" title="'.$gL10n->get('PMB_MANDATE_CHANGE').'"/></a>
                                            </dd>
                                        </dl>
                                    </li> 
									<li>
                                        <dl>
                                            <dt><label for="creditor_identifier">'.$gL10n->get('PMB_CI').':</label></dt>
                                            <dd>
                                            	<input type="text" id="creditor_identifier" name="creditor_identifier" style="width: 200px;" maxlength="60" value="'. $config_ini['Kontodaten']['ci']. '" />
                                            	<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span> 
                                            	<a href="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/mandat_change_cdtr.php"><img src="'. THEME_PATH.'/icons/edit.png" alt="'.$gL10n->get('PMB_MANDATE_CHANGE').'" title="'.$gL10n->get('PMB_MANDATE_CHANGE').'"/></a>
                                            </dd>
                                    	</dl>
                                    </li>  
                                  	<li class="smallFontSize">'.$gL10n->get('PMB_ACCOUNT_DATA_INFO').'</li>                                                                       
                                    <br>
                                    <div class="formSubmit">	
                                        <button id="btnSave" type="submit" name="kontodaten"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                    </div> 
                                    <hr>
                                    <li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="convert_account_data"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_CONVERT_ACCOUNT_DATA').'" />&nbsp;'.$gL10n->get('PMB_CONVERT_ACCOUNT_DATA').'</button>
                                		</div> 
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CONVERT_ACCOUNT_DATA_DESC').'</li>
                                </ul>
                            </div>'; 

                            /**************************************************************************************/
                            // Export
                            /**************************************************************************************/
							$text = new TableText($gDb);
                            echo '<h3 id="Export" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Export" title="'.$gL10n->get('PMB_EXPORT').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_EXPORT').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li>
                                        <dl>
                                            <dt><strong>'.$gL10n->get('PMB_SEPA').'</strong></dt>
                                            <dd>&nbsp;</dd>
                                        </dl>
                                    </li>  		
                                    <li>
                                        <dl>
                                            <dt><label for="XML-Dateiname">'.$gL10n->get('PMB_XML_FILE_NAME').':</label></dt>
                                            <dd><input type="text" id="xml_dateiname" name="xml_dateiname" style="width: 200px;" maxlength="60" value="'. $config_ini['SEPA']['dateiname']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="XML-Kontrolldateiname">'.$gL10n->get('PMB_CONTROL_FILE_NAME').':</label></dt>
                                            <dd><input type="text" id="xml_kontroll_dateiname" name="xml_kontroll_dateiname" style="width: 200px;" maxlength="60" value="'. $config_ini['SEPA']['kontroll_dateiname']. '" /></dd>
                                        </dl>
                                    </li>
 									<li class="smallFontSize"><strong>'.$gL10n->get('SYS_NOTE').':</strong> '.$gL10n->get('PMB_SEPA_SETUP_INFO').'</li> 									
                        			<BR>                                          
									<li>
                        				<dl>
                            				<dt><label>'.$gL10n->get('PMB_PRE_NOTIFICATION_MAIL_TEXT').':</label></dt>
                            				<dd><br /></dd>
                        				</dl>
                    				</li>
                    				<li  class="smallFontSize">'.$gL10n->get('PMB_PRE_NOTIFICATION_MAIL_TEXT_DESC').':<br />
                        				<strong>%user_first_name%</strong> - '.$gL10n->get('PMB_VARIABLE_FIRST_NAME').'<br />
                        				<strong>%user_last_name%</strong> - '.$gL10n->get('PMB_VARIABLE_LAST_NAME').'<br />
										<strong>%organization_long_name%</strong> - '.$gL10n->get('ORG_VARIABLE_NAME_ORGANIZATION').'<br />
                        				<strong>%fee%</strong> - '.$gL10n->get('PMB_VARIABLE_FEE').'<br />
                        				<strong>%due_day%</strong> - '.$gL10n->get('PMB_VARIABLE_DUE_DAY').'<br />
                        				<strong>%mandate_id%</strong> - '.$gL10n->get('PMB_VARIABLE_MANDATE_ID').'<br />
                        				<strong>%creditor_id%</strong> - '.$gL10n->get('PMB_VARIABLE_CREDITOR_ID').'<br />
                        				<strong>%iban%</strong> - '.$gL10n->get('PMB_VARIABLE_IBAN').'<br />
                        				<strong>%debtor%</strong> - '.$gL10n->get('PMB_VARIABLE_DEBTOR').'<br />
                        				<strong>%membership_fee_text%</strong> - '.$gL10n->get('PMB_VARIABLE_MEMBERSHIP_FEE_TEXT').'<br />
                        				<br />
                    				</li>';

                    				$text->readDataByColumns(array('txt_name' => 'PMBMAIL_PRE_NOTIFICATION', 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));

                    				//wenn noch nichts drin steht, dann vorbelegen
                    				if ($text->getValue('txt_text')=='')
                    				{
        								// convert <br /> to a normal line feed
        								$value = preg_replace('/<br[[:space:]]*\/?[[:space:]]*>/',chr(13).chr(10),$gL10n->get('PMB_PMBMAIL_PRE_NOTIFICATION'));
                    			
            							$text->setValue('txt_text', $value);
            							$text->save();
            							$text->readDataByColumns(array('txt_name' => 'PMBMAIL_PRE_NOTIFICATION', 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));
                    				}
                    				echo '<li>
                        				<textarea id="PMBMAIL_PRE_NOTIFICATION" name="PMBMAIL_PRE_NOTIFICATION" style="width: 100%;" rows="7" cols="40">'.$text->getValue('txt_text').'</textarea>
                    				</li>
                                    <hr>
                                    <li>
                                        <dl>
                                            <dt><strong>'.$gL10n->get('PMB_STATEMENT_EXPORT').'</strong></dt>
                                            <dd>&nbsp;</dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Rechnungs-Dateiname">'.$gL10n->get('PMB_STATEMENT_FILE_NAME').':</label></dt>
                                            <dd><input type="text" id="rechnung_dateiname" name="rechnung_dateiname" style="width: 200px;" maxlength="60" value="'. $config_ini['Rechnungs-Export']['rechnung_dateiname']. '" /></dd>
                                            </dl>
                                    </li>   	  
                                </ul>
                                <br>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="export-setup"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Mandatsverwaltung
                            /**************************************************************************************/

                            echo '<h3 id="Setup-Mandatsverwaltung" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Setup-Mandatsverwaltung" title="'.$gL10n->get('PMB_MANDATE_MANAGEMENT').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_MANDATE_MANAGEMENT').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                    <li>
                                        <dl>
                                            <dt><label for="Prefix_Family">'.$gL10n->get('PMB_PREFIX_FAM').':</label></dt>
                                            <dd><input type="text" id="prefix_fam" name="prefix_fam" style="width: 200px;" maxlength="60" value="'. $config_ini['Mandatsreferenz']['prefix_fam']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Prefix_Member">'.$gL10n->get('PMB_PREFIX_MEM').':</label></dt>
                                            <dd><input type="text" id="prefix_mem" name="prefix_mem" style="width: 200px;" maxlength="60" value="'. $config_ini['Mandatsreferenz']['prefix_mem']. '" /></dd>
                                        </dl>
                                    </li>
                    				<li>
                                        <dl>
                                            <dt><label for="Prefix_HasToPay">'.$gL10n->get('PMB_PREFIX_PAY').':</label></dt>
                                            <dd><input type="text" id="prefix_pay" name="prefix_pay" style="width: 200px;" maxlength="60" value="'. $config_ini['Mandatsreferenz']['prefix_pay']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Min_Length">'.$gL10n->get('PMB_MIN_LENGTH').':</label></dt>
                                            <dd><input type="text" id="min_length" name="min_length" style="width: 50px;" maxlength="20" value="'. $config_ini['Mandatsreferenz']['min_length']. '" /></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PMB_DATA_FIELD_SERIAL_NUMBER').':</label></dt>
                                            <dd>
                                                <select name="data_field" size="0">';
													
                            						echo '<option value="-- User_ID --"';
                  									if('-- User_ID --'== $config_ini['Mandatsreferenz']['data_field'])
                                                    {
                                                    	echo ' selected="selected"';	
                                                    } 
                  									echo '>-- User_ID --</option>';
													
                            						foreach($gProfileFields->mProfileFields as $field)
    												{
                  										echo '<option value="'.$field->getValue('usf_name_intern').'"';
                  										if($field->getValue('usf_name_intern')== $config_ini['Mandatsreferenz']['data_field'])
                                                        {
                                                            echo ' selected="selected"';	
                                                        } 
                  										echo '>'.checkStringLengthPMB($field->getValue('usf_name'),$config_ini['Optionen']['select_maxlength']).'</option>';
    												} 
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_MANDATE_MANAGEMENT_DESC').'</li>
                                </ul>
                                <br>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="setup-mandatsverwaltung"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';                            

                            /**************************************************************************************/
                            // Rollenprüfung
                            /**************************************************************************************/

                            echo '<h3 id="Rollenprüfung" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Rollenprüfung" title="'.$gL10n->get('PMB_ROLE_TEST').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_ROLE_TEST').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <BR>
                                    <li>'.$gL10n->get('PMB_ROLE_TEST_SETUP_INFO').'</li>
                                    <BR><HR>';
                                    for ($i=1;$i<$config_ini['Familienrollen']['familienrollen_anzahl']+1;$i++)
									{
							    		echo'
                                    	<li  class="smallFontSize">'.$i.'. '.$gL10n->get('PMB_FAMILY_ROLE').'</li>
                                   		<li>
                                    		<dl>
                                        		<dt><label for="familienrollen_pruefung">'.$gL10n->get('PMB_PREFIX').' '.$config_ini['Familienrollen']['familienrollen_prefix'][$i-1].':</label></dt>
                                            	<dd>
                                            		<input type="text" id="familienrollen_pruefung[]" name="familienrollen_pruefung[]" style="width: 200px;" maxlength="200" value="'. (isset($config_ini['Familienrollen']['familienrollen_pruefung'][$i-1]) ? $config_ini['Familienrollen']['familienrollen_pruefung'][$i-1] : ''). '" />
                                            		
                                            	</dd>
                                        	</dl>
                                    	</li>';
									}
                                    echo'<li class="smallFontSize">'.$gL10n->get('PMB_FAMILY_ROLES_ROLE_TEST_DESC2').'</li>
                                    <HR>';
                                    $familienrollen = beitragsrollen_einlesen('fam');
                                    $altersrollen = beitragsrollen_einlesen('alt');
                                    $fixrollen = beitragsrollen_einlesen('fix');
                                    echo'<BR>'.$gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY').':<BR>
                                    <BR>';
                                    if ((sizeof($altersrollen)>0) || (sizeof($familienrollen)>0) || (sizeof($fixrollen)>0)) 
                                    {
                                        echo'<div style="width:100%; height:150px; overflow:auto; border:0px;">
                                            <table border="0">';
                                                if (sizeof($altersrollen)>0)                   
                                                {
                                                    echo'<tr>
                                                        <td>'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').'</td>
                                                        <td>
                                                            <input type="checkbox" id="altersrollenpflicht" name="altersrollenpflicht" ';
                                                            if( $config_ini['Rollenpruefung']['altersrollenpflicht'] == 1)
                                                            {
                                                                echo ' checked="checked" ';
                                                            }
                                                            echo ' value="1" /></td>
                                                    </tr>';  
                                                }
                                                if (sizeof($familienrollen)>0)                   
                                                {
                                                    echo'<tr>
                                                        <td>'.$gL10n->get('PMB_FAMILY_ROLES').'</td>
                                                        <td>
                                                            <input type="checkbox" id="familienrollenpflicht" name="familienrollenpflicht" ';
                                                            if( $config_ini['Rollenpruefung']['familienrollenpflicht'] == 1)
                                                            {
                                                                echo ' checked="checked" ';
                                                            }
                                                            echo ' value="1" /></td>
                                                    </tr>';  
                                                    
                                                }
                                                if (sizeof($fixrollen)>0)     
                                                {
                                                    foreach($fixrollen as $key => $data)
                                                    {
                                                        echo'<tr>
                                                            <td>'.$data['rolle'].'</td>
                                                            <td>
                                                                <input type="checkbox" id="fixrollenpflicht'.$key.'" name="fixrollenpflicht'.$key.'" ';
                                                                if( (is_array($config_ini['Rollenpruefung']['fixrollenpflicht'])) && in_array($key,$config_ini['Rollenpruefung']['fixrollenpflicht']))
                                                                {
                                                                    echo ' checked="checked" ';
                                                                }
                                                                echo ' value="1" />
                                                            </td>
                                                        </tr>';  
                                                    } 
                                                }
                                            echo '</table>
                                        </div> ';
                                    }
                                    else
                                    {
                                        echo $gL10n->get('PMB_NO_CONTRIBUTION_ROLES').'<BR>';
                                    }
                                    echo'<li class="smallFontSize">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_DUTY_DESC2').'</li>';
                                    echo'<BR><BR>'.$gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION').':<BR>
                                    <BR>';
                                    if (((sizeof($altersrollen)>0) && (sizeof($familienrollen)>0)) || ((sizeof($altersrollen)>0) && (sizeof($fixrollen)>0)) || ((sizeof($familienrollen)>0) && (sizeof($fixrollen)>0))) 
                                    {
                                        echo'<div style="width:100%; height:150px; overflow:auto; border:0px;">
                                            <table border="0">';
                                                if ((sizeof($altersrollen)>0) && (sizeof($familienrollen)>0))                     
                                                {
                                                    echo'<tr>
                                                        <td>'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').' ./. '.$gL10n->get('PMB_FAMILY_ROLES').'</td>
                                                        <td>
                                                            <input type="checkbox" id="altersrollenfamilienrollen" name="altersrollenfamilienrollen" ';
                                                            if( $config_ini['Rollenpruefung']['altersrollenfamilienrollen'] == 1)
                                                            {
                                                                echo ' checked="checked" ';
                                                            }
                                                            echo ' value="1" /></td>
                                                    </tr>';  
                                                }
                                                if ((sizeof($altersrollen)>0) && (sizeof($fixrollen)>0))                     
                                                {
                                                    foreach($fixrollen as $key => $data)
                                                    {
                                                        echo'<tr>
                                                            <td>'.$gL10n->get('PMB_OLD_STAGGERED_ROLES').' ./. '.$data['rolle'].'</td>
                                                            <td>
                                                                <input type="checkbox" id="altersrollenfix'.$key.'" name="altersrollenfix'.$key.'" ';
                                                                if ( (is_array($config_ini['Rollenpruefung']['altersrollenfix']))&& (in_array($key,$config_ini['Rollenpruefung']['altersrollenfix'])))
                                                                {
                                                                    echo ' checked="checked" ';
                                                                }
                                                                echo ' value="1" />
                                                            </td>
                                                        </tr>';  
                                                    } 
                                                }
                                                if ((sizeof($familienrollen)>0) && (sizeof($fixrollen)>0))                    
                                                {
                                                    foreach($fixrollen as $key => $data)
                                                    {
                                                        echo'<tr>
                                                            <td>'.$gL10n->get('PMB_FAMILY_ROLES').' ./. '.$data['rolle'].'</td>
                                                            <td>
                                                                <input type="checkbox" id="familienrollenfix'.$key.'" name="familienrollenfix'.$key.'" ';
                                                                if ((is_array($config_ini['Rollenpruefung']['familienrollenfix'])) && (in_array($key,$config_ini['Rollenpruefung']['familienrollenfix'])))
                                                                {
                                                                    echo ' checked="checked" ';
                                                                }
                                                                echo ' value="1" />
                                                            </td>
                                                        </tr>';  
                                                    } 
                                                }
                                            echo '</table>
                                        </div> ';
                                    }
                                    else
                                    {
                                        echo $gL10n->get('PMB_NO_COMBINATION_ROLES').'<BR>';
                                    }
                                    echo'<li class="smallFontSize">'.$gL10n->get('PMB_ROLE_MEMBERSHIP_EXCLUSION_DESC2').'</li>
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PMB_CAT_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="bezugskategorie[]" size="4" multiple>';                     
                                                    $cats = array();
                                                    $sql = 'SELECT rol.rol_name, cat.cat_id, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePMB($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $cats[$row['cat_id']] = array('cat' => $row['cat_name']);
                                                    }

                                                    foreach($cats as $key => $data)
                                                    {
                                                        echo '<option value='.$key;

                                                        if(is_array($config_ini['Rollenpruefung']['bezugskategorie']) && (in_array($key,$config_ini['Rollenpruefung']['bezugskategorie'])))
                                                        {
                                                            echo ' selected="selected"';	
                                                        } 
                                                        echo '>'.checkStringLengthPMB($data['cat'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_CAT_SELECTION_DESC').'</li>
                                </ul>
                                <br>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="rollenpruefung"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

							/**************************************************************************************/
                            // Optionen
                            /**************************************************************************************/

                            echo '<h3 id="Optionen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Optionen" title="'.$gL10n->get('PMB_OPTIONS').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_OPTIONS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                        <dl>
                                            <dt><label for="maxlength">'.$gL10n->get('PMB_SELECT_MAXLENGTH').':</label></dt>
                                            <dd>
                                            	<input type="text" id="select__max_length" name="select_max_length" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['select_maxlength']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_SELECT_MAXLENGTH_DESC').'</li>
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="dbtoken">'.$gL10n->get('PMB_DBTOKEN').':</label></dt>
                                            <dd>
                                            	<input type="text" id="dbtoken" name="dbtoken" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['dbtoken']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_DBTOKEN_DESC').'</li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="optionen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                                <hr>
                                <ul class="formFieldList">
                                	<li>
										<div class="formSubmit">	
                                    		<button id="btnSave" type="submit" name="mitgliedsnummer"><img src="'. THEME_PATH. '/icons/edit.png" alt="'.$gL10n->get('PMB_PRODUCE_MEMBERNUMBER').'" />&nbsp;'.$gL10n->get('PMB_PRODUCE_MEMBERNUMBER').'</button>
                                		</div> 
                                	</li> 
                                	<li class="smallFontSize">'.$gL10n->get('PMB_PRODUCE_MEMBERNUMBER_DESC',$gL10n->get('SYS_NOTE').':').'</li>
                                </ul>
                            </div>';
                            
                            /**************************************************************************************/
                            // Pluginfreigabe
                            /**************************************************************************************/

                            echo '<h3 id="Pluginfreigabe" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/lock.png" alt="Pluginfreigabe" title="'.$gL10n->get('PMB_PLUGIN_CONTROL').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_PLUGIN_CONTROL').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PMB_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePMB($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array('cat' => $row['cat_name'],'rol' => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {
                                                            echo '<option value="" disabled="disabled">'.$gL10n->get('SYS_CATEGORY').' '.$data['cat'].'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPMB($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PMB_ROLE_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PMB_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPMB($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                </ul>
                                <br>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="pluginfreigabe"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

                            /**************************************************************************************/
                            // Plugininformationen
                            /**************************************************************************************/

                            echo '<h3 id="Plugininformationen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Plugininformationen" title="'.$gL10n->get('PMB_PLUGIN_INFORMATION').'" /></a>
                                <a href="#">'.$gL10n->get('PMB_PLUGIN_INFORMATION').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">         
                                    <li>
                                        <dl>
                                            <dt><label for="Name des Plugins">'.$gL10n->get('PMB_PLUGIN_NAME').':</label></dt>
                                            <dd><label for="">'.$gL10n->get('PMB_MEMBERSHIP_FEE').'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Version">'.$gL10n->get('PMB_PLUGIN_VERSION').':</label></dt>
                                            <dd><label for="">'.$config_ini['Plugininformationen']['plgin_mb_version'].'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Stand">'.$gL10n->get('PMB_PLUGIN_DATE').':</label></dt>
                                            <dd><label for="">'.$config_ini['Plugininformationen']['plgin_mb_stand'].'</label></dd>
                                        </dl>
                                    </li>
                                </ul>
                                <br>
                            </div>';

                        // ENDE accordion-modules
                        echo'</div>
                    </div>
                </div>
            </form>
        </div>
    </div>';

    require(SERVER_PATH. '/adm_program/system/overall_footer.php');
}
?>