<?php
/******************************************************************************
 * 
 * neuberechnung.php
 *   
 * Neuberechnung der Mitgliedsbeitraege fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

// anstelle eines Leerzeichens ist ein # in der $config_ini gespeichert; # wird hier wieder ersetzt
$text_token = ($config_ini['Beitrag']['beitrag_text_token']=='#') ? ' ' : $config_ini['Beitrag']['beitrag_text_token'] ;
$message = '';

//alle Beitragsrollen einlesen 
$rols = beitragsrollen_einlesen('',array('FIRST_NAME','LAST_NAME','KONTONUMMER','IBAN','BANKLEITZAHL','KONTOINHABER')); 

//falls eine Rollenabfrage durchgeführt wurde, die Rollen, die nicht gewählt wurden, löschen
if (isset($_POST['rollenwahl_weiter']) )
{
	if (isset($_POST['rollenwahl']))
	{
		$message .= '<strong>'.$gL10n->get('PMB_CONTRIBUTION_ROLLQUERY_INFO').'</strong><BR><BR>';
		foreach ($rols as $rol => $roldata)
		{
			if (!in_array($rol,$_POST['rollenwahl']))
			{
				unset($rols[$rol]) ;	
			}
			else 
			{
				$message .= $roldata['rolle'].'<BR>';
			}
		}
		$message .= '<BR><BR>';
	}
	else 
	{
		// Fehlermeldung wenn keine Beitragsrollen ausgewählt wurden
		$gMessage->show($gL10n->get('PMB_CONTRIBUTION_ROLLQUERY_NOROLL'));			
	}
}  

// diese Rollen durchlaufen und bei den Familienrollen eine Zahlungspflichtigen bestimmen
foreach ($rols as $rol => $roldata)
{
   	// nur Familien
	if ($roldata['rollentyp']== 'fam')	
    { 
        // alle Mitglieder dieser Rolle durchlaufen und einen Zahlungspflichtigen bestimmen
        // 1. Durchlauf: hierbei das erste Mitglied bei dem (Kontonummer UND BLZ) oder IBAN belegt sind bestimmen
        foreach ($roldata['members'] as $key => $data)
        { 
            $rols[$rol]['has_to_pay'] = $key;
          
            if( (($data['BANKLEITZAHL'] > 0) && ($data['KONTONUMMER'] > 0)) || strlen($data['IBAN'])<>0 ) 
            { 
                $rols[$rol]['has_to_pay'] = $key;
                break;
            }
        }
        // alle Mitglieder dieser Rolle durchlaufen und einen Zahlungspflichtigen bestimmen
        // 2. Durchlauf: gibt es einen Rollenleiter, dann den Zahlungspflichtigen überschreiben, da höherwertiger
        foreach ($roldata['members'] as $key => $data)
        { 
            if (isGroupLeader($key, $rol)) 
            { 
                $rols[$rol]['has_to_pay'] = $key;
                break;
            }
        }
    }     
}

// alle aktiven Mitglieder einlesen
$members = list_members(array('FIRST_NAME','LAST_NAME','BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'BEZAHLT'.$gCurrentOrganization->getValue('org_id'),'BEITRITT'.$gCurrentOrganization->getValue('org_id'),'KONTOINHABER'), 0)  ; 

//alle Mitglieder durchlaufen und aufgrund von Rollenzugehörigkeiten die Beiträge bestimmen
foreach ($members as $member => $memberdata)
{
	$members[$member]['BEITRAG-NEU']='';
	$members[$member]['BEITRAGSTEXT-NEU']='';
	
    foreach ($rols as $rol => $roldata) 
    {
    	// alle Rollen, außer Familienrollen
    	if (($roldata['rollentyp']<> 'fam')	&& (array_key_exists($member, $roldata['members'])))
		{ 
            if($config_ini['Beitrag']['beitrag_anteilig'] == true)
            {
                $members[$member]['BEITRITT'.$gCurrentOrganization->getValue('org_id')] = $roldata['members'][$member]['mem_begin'];
            }
            
			if($config_ini['Beitrag']['beitrag_anteilig'] == true)
            {
                $time_begin = strtotime($roldata['members'][$member]['mem_begin']);
            }
            else 
            {
            	$time_begin = strtotime($members[$member]['BEITRITT'.$gCurrentOrganization->getValue('org_id')]);
            }
            
            // das Standarddatum '9999-12-31' kann auf best. Systemen nicht verarbeitet werden
			if($roldata['members'][$member]['mem_end'] == '9999-12-31')
            {
                $time_end = strtotime('2038-01-19');
            }
            else 
            {
            	$time_end = strtotime($roldata['members'][$member]['mem_end']);
            } 
            
            // anteiligen Beitrag berechnen, falls das Mitglied im aktuellen Jahr ein- oder ausgetreten ist
            // && Beitragszeitraum (cost_period) darf nicht "Einmalig" (-1) sein
            // && Beitragszeitraum (cost_period) darf nicht "Jährlich" (1) sein
            if ( (strtotime(date("Y")."-01-01") < $time_begin || $time_end < strtotime(date("Y")."-12-31")  ) 
            	&& ($roldata['rol_cost_period']<>-1) 
            	&& ($roldata['rol_cost_period']<>1) ) 
            {
                
            	if ( strtotime(date("Y")."-01-01") <  $time_begin )
            	{
            		$month_begin = date("n", $time_begin);
            	}
            	else
            	{
            		$month_begin = 1;
            	}
            	if (strtotime(date("Y")."-12-31") >  $time_end )
            	{
            		$month_end   = date("n", $time_end);
            	}
            	else
            	{
            		$month_end = 12;
            	}

                $segment_begin = ceil($month_begin * $roldata['rol_cost_period']/12);
                $segment_end = ceil($month_end * $roldata['rol_cost_period']/12);
                
                $members[$member]['BEITRAG-NEU'] +=  ($segment_end - $segment_begin +1) * $roldata['rol_cost'] / $roldata['rol_cost_period'] ;
                if ($roldata['rol_description']<>'') 
                {
                    $members[$member]['BEITRAGSTEXT-NEU'] .= ' '.$roldata['rol_description'].' ';
                }
                if ($config_ini['Beitrag']['beitrag_suffix']<>'') 
                {
                	$members[$member]['BEITRAGSTEXT-NEU'] .= ' '.$config_ini['Beitrag']['beitrag_suffix'].' ';
                }
                // nur einmal soll beitrag_suffix angezeigt werden, wenn aber rol_description leer ist,
                // wird es mehrfach hintereinander mit vielen Leerzeichen dazwischen angefügt, deshalb ersetzen
                //zuerst zwei aufeinanderfolgende Leerzeichen durch ein Leerzeichen ersetzen
        		$members[$member]['BEITRAGSTEXT-NEU'] = str_replace('  ',' ',$members[$member]['BEITRAGSTEXT-NEU']);
        		//jetzt mehrfache beitrag_suffix löschen
                $members[$member]['BEITRAGSTEXT-NEU'] = str_replace($config_ini['Beitrag']['beitrag_suffix'].' '.$config_ini['Beitrag']['beitrag_suffix'],$config_ini['Beitrag']['beitrag_suffix'],$members[$member]['BEITRAGSTEXT-NEU']);
            }	            
            else                             //keine anteilige Berechnung
            {
                $members[$member]['BEITRAG-NEU'] += $roldata['rol_cost'] ;
                if ($roldata['rol_description']<>'') 
                {
                    $members[$member]['BEITRAGSTEXT-NEU'] .= ' '.$roldata['rol_description'].' ';
                }
            }
        }
    }
    
    // wenn definiert: Beitragstext mit dem Namen des Benutzers 
    if(	($config_ini['Beitrag']['beitrag_textmitnam'] == true) 
    	&&  ($members[$member]['BEITRAG-NEU']<>'')
        &&  !(($members[$member]['LAST_NAME'].' '.$members[$member]['FIRST_NAME']==$members[$member]['KONTOINHABER'])
           || ($members[$member]['FIRST_NAME'].' '.$members[$member]['LAST_NAME']==$members[$member]['KONTOINHABER'])
           || (empty($members[$member]['KONTOINHABER']))))
    {
        $members[$member]['BEITRAGSTEXT-NEU'] .= $text_token.$members[$member]['LAST_NAME'].' '.$members[$member]['FIRST_NAME'].$text_token;
    }    
} 

// alle Rollen und deren Mitglieder durchlaufen  und die Beiträge eines Mitglieds,
// das zudem ein Familienmitglied ist, dem Zahlungspflichtigen der Familie zugeschlagen
foreach ($rols as $rol => $roldata) 
{     
    // nur Rollen mit dem Präfix einer Familie && die Familienrolle muß Mitglieder aufweisen 
    if (($roldata['rollentyp']== 'fam')	&& (sizeof($roldata['members'])>0))
    {   
        // wenn definiert: Beitragstext mit allen Familienmitgliedern
        if($config_ini['Beitrag']['beitrag_textmitfam'] == true)
        { 
            $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] .= ' '; 
            foreach ($roldata['members'] as $member => $memberdata)
            { 
                $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] .= $text_token.$members[$member]['LAST_NAME'].' '.$members[$member]['FIRST_NAME'] ;
            }
            $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] .= $text_token.' ';
        }
         
        //alle Mitglieder dieser Rolle durchlaufen und die Beiträge der Mitglieder dem Zahlungspflichtigen zuordnen
        foreach ($roldata['members'] as $member => $memberdata)
        { 
            // nicht beim Zahlungspflichtigen selber und auch nur, wenn ein Zusatzbeitrag beim Mitglied errechnet wurde
            if  (( $roldata['has_to_pay'] <> $member ) && ($members[$member]['BEITRAG-NEU'] > 0))
            {
                $members[$roldata['has_to_pay']]['BEITRAG-NEU'] += $members[$member]['BEITRAG-NEU'] ;
                $members[$member]['BEITRAG-NEU'] = '';
                $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] .= $members[$member]['BEITRAGSTEXT-NEU'].' ' ;
                
                // wenn nicht definiert: Beitragstext mit allen Familienmitgliedern, trotzdem Name und Vorname anfügen
                if(!$config_ini['Beitrag']['beitrag_textmitnam'])
                {
                    $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] .= $text_token.$memberdata['LAST_NAME'].' '.$memberdata['FIRST_NAME'].$text_token.' ' ;
                }
                $members[$member]['BEITRAGSTEXT-NEU'] = '';
            }
        }
        
        // anteiligen Beitrag berechnen, falls die Familie erst im aktuellen Jahr angelegt wurde
        // && Beitragszeitraum (cost_period) darf nicht "Einmalig" (-1) sein
        // && Beitragszeitraum (cost_period) darf nicht "Jährlich" (1) sein
	    if ((date("Y") == date("Y", strtotime($roldata['rol_timestamp_create']))) && ($roldata['rol_cost_period']<>-1) && ($roldata['rol_cost_period']<>1)) 
        {
            $beitrittsmonat = date("n", strtotime($roldata['rol_timestamp_create']));
            $members[$roldata['has_to_pay']]['BEITRAG-NEU'] +=  (($roldata['rol_cost_period']+1)-ceil($beitrittsmonat/(12/$roldata['rol_cost_period'])))*($roldata['rol_cost']/$roldata['rol_cost_period']) ;   
            $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] = ' '.$roldata['rol_description'].' '.$config_ini['Beitrag']['beitrag_suffix'].' '.$members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'].' ' ;    
        }
        else
        {
            $members[$roldata['has_to_pay']]['BEITRAG-NEU'] += $roldata['rol_cost'] ;
            $members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'] = ' '.$roldata['rol_description'].$members[$roldata['has_to_pay']]['BEITRAGSTEXT-NEU'].' ' ;    
        }
    }
}
                             
foreach ($members as $member => $memberdata)
{
    // den errechneten Beitrag nur in die DB schreiben wenn mehrere Kriterien erfüllt sind
    if ( (is_null($members[$member]['BEITRAG'.$gCurrentOrganization->getValue('org_id')])
    		||  (!(is_null($members[$member]['BEITRAG'.$gCurrentOrganization->getValue('org_id')])) 
    			&& ( ($config_ini['Beitrag']['beitrag_modus'] == 'overwrite') 
    				||($config_ini['Beitrag']['beitrag_modus'] == 'summation') ) )   )
    	&& ($members[$member]['BEITRAG-NEU']>$config_ini['Beitrag']['beitrag_mindestbetrag']) )
    {
        $members[$member]['BEITRAGSTEXT-NEU'] =  $config_ini['Beitrag']['beitrag_prefix'].' '.$members[$member]['BEITRAGSTEXT-NEU'].' '  ;          
    
        // alle Beiträge auf 2 Nachkommastellen runden
        $members[$member]['BEITRAG-NEU'] = round($members[$member]['BEITRAG-NEU'],2);
        
        //ggf. abrunden
        if ($config_ini['Beitrag']['beitrag_abrunden'] == true)
        {
            $members[$member]['BEITRAG-NEU'] = floor($members[$member]['BEITRAG-NEU']);
        }
    
        if($config_ini['Beitrag']['beitrag_modus'] == 'summation')
        {    
         	$members[$member]['BEITRAG-NEU'] += $members[$member]['BEITRAG'.$gCurrentOrganization->getValue('org_id')];   	
        	$members[$member]['BEITRAGSTEXT-NEU'] .= ' '.$members[$member]['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')].' ';
        }
 
        //führende und nachfolgene Leerstellen im Beitragstext löschen
        $members[$member]['BEITRAGSTEXT-NEU'] = trim($members[$member]['BEITRAGSTEXT-NEU']);
        //zwei aufeinanderfolgende Leerzeichen durch ein Leerzeichen ersetzen
        $members[$member]['BEITRAGSTEXT-NEU'] = str_replace('  ',' ',$members[$member]['BEITRAGSTEXT-NEU']);
        
        //neuen Beitrag schreiben
        $user = new User($gDb, $gProfileFields, $member);
    	$user->setValue('BEITRAG'.$gCurrentOrganization->getValue('org_id'), $members[$member]['BEITRAG-NEU']);
    	$user->setValue('BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'), $members[$member]['BEITRAGSTEXT-NEU']);
    	$user->save();
    } 
}
$message .= $gL10n->get('SYS_SAVE_DATA');

// zur Ausgangsseite zurueck
$gMessage->setForwardUrl($gNavigation->getUrl(), 0);
$gMessage->show($message);   
	
?>