<?php
/******************************************************************************
 * 
 * pre_notification.php
 *   
 * Vorabankuendigung (Pre-Notification) fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

if (strpos($gNavigation->getUrl(),'common_massmail.php') > 0 )
{
    $gNavigation->deleteLastUrl();
}
$gNavigation->addUrl($g_root_path.'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

// Kopf ausgeben
$gLayout['title']  = $gL10n->get('PMB_PRE_NOTIFICATION');

$gLayout['header'] ='
        
<script type="text/javascript"><!--
  
    checkedArray = new Array();
    
    function prenotexport(){ 

		//checkedArray wird als String übergeben (JScript -> php)
		//Fehler beim Testen im Livesystem festgestellt (nicht in der Testumgebung)
		//wenn der Uebergabestring groeßer als 512 Zeichen ist, wird er nicht uebertragen
		//Abhilfe: checkedArrray wird in einen String konvertiert
		//Dieser String wird in Bloecke zu 512 Zeichen zerlegt.
		//Diese Bloecke werden uebertragen und auf PHP-Seite wieder zusammengesetzt
		
		var checkedString = checkedArray.join(",");
		var i = 1;
		var uebergabestring = "";
				
		checkedString = checkedString.replace(/member_/g,"");
		
		while(checkedString.length>0) {			
			teilString = checkedString.substr(0,512);			
			uebergabestring = uebergabestring + "&teilString"+i+"="+teilString;			
			checkedString = checkedString.substr(512); 			
			++i;
		};
		--i;	
		uebergabestring = uebergabestring + "&teilStringLength="+i;
		
		//Daten aufbereiten und in einen String schreiben   
        $.ajax({
            url: "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/pre_notification_export.php?"+uebergabestring,
            type: "POST",
                   
            async: false,
            success: function(result){                    
             
            //Result auswerten
            if(result=="marker_empty")
            {
               jQueryAlert("PMB_EXPORT_EMPTY");
            }
            else
            {
 				var uriContent = "data:text/csv;charset=utf-8," + encodeURIComponent(result);
     			var myWindow = window.open(uriContent);
     			myWindow.focus();  
            }
            return false;
            }
       });
	}

	function massmail(){ 

		//übergabestring wie in der vorhergehenden Funktion zusammensetzen		
		var checkedString = checkedArray.join(",");
		var i = 1;
		var uebergabestring = "";
				
		checkedString = checkedString.replace(/member_/g,"");
		
		while(checkedString.length>0) {			
			teilString = checkedString.substr(0,512);			
			uebergabestring = uebergabestring + "&teilString"+i+"="+teilString;			
			checkedString = checkedString.substr(512); 			
			++i;
		};
		--i;	
		uebergabestring = uebergabestring + "&teilStringLength="+i;
	
		//Result auswerten
        if(uebergabestring=="&teilStringLength=0")
        {
           	
        	jQueryAlert("PMB_EMAIL_EMPTY");
        }
        else
        {
        	window.location.href = "'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/common_massmail.php?"+uebergabestring ;  	
        }
	}	
	
    //Erstmal warten bis Dokument fertig geladen ist
    $(document).ready(function(){       
        //Bei Seitenaufruf Daten laden
        $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/pre_notification_get.php", $("#memsearch_form").serialize(), function(result){
            $("form#memlist_form").append(result).show();
            $("#list_load_animation").hide();        
            return false;
        });

        //Checkbox select_all
        $("input[type=checkbox]#select_all").live("click", function(){
        	$("#list_load_animation").show();
            $("input[type=checkbox][name=\'member[]\' ]").each( function() {
	       		if(!$(this).is(":checked")) {
        			checkedArray.push($(this).val());
        			$(this).prop("checked", true) ;
    			}
	  		}); 
	       	$("#list_load_animation").hide();  
	       	$("input[type=checkbox]#select_all").prop("checked", false);    
        });        

       	//Checkbox unselect_all
        $("input[type=checkbox]#unselect_all").live("click", function(){
            $("#list_load_animation").show();  
            $("input[type=checkbox][name=\'member[]\' ]").each( function() {
	       		if($(this).is(":checked")) {
        			for(var i=0; i<checkedArray.length;i++ ){
           		 		if(checkedArray[i]== $(this).val()) {
                			checkedArray.splice(i,1);
            			}
        			}
        			$(this).prop("checked", false) ;
    			}				
	       	}); 
	      	$("#list_load_animation").hide();    
	       	$("input[type=checkbox]#unselect_all").prop("checked", false);        
        });          
        
        //Suchfeldeingabe
        $("input[type=text]#mem_search").keyup(function(event){
            $("#list_load_animation").show();
            $("input[type=checkbox]#change_all").hide();    
            var memsearch = $("input[type=text]#mem_search").val();
            var memshowwithout = $("input[type=checkbox]#mem_show_without").prop("checked");
            if(memsearch.length=="" && memshowwithout){
            	$("input[type=checkbox]#change_all").show();    
            }   
            
            $("form#memlist_form").hide().empty();
            $.post("'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/pre_notification_get.php?members="+checkedArray, $("#memsearch_form").serialize(), function(result){
                $("form#memlist_form").empty().append(result).show();
                $("#list_load_animation").hide();               
            });
            return false;
        });
    
        //Enter abfangen
        $("input[type=text]#mem_search").keydown(function(e) {
            if(e.keyCode === 13) {
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                return;
            }
        });
        
        //Buchstabennavigation
        $(".pageNavigationLink").live("click", function(){
            var letter = $(this).attr("letter");            
            //Alle anzeigen
            if(letter == "all"){
                $(".letterBlockBody").show();
                $(".letterBlockHead").show();
            }
            else{  
	            $(".letterBlockBody[block_body_id!="+letter+"]").hide();
	            $(".letterBlockHead[block_head_id!="+letter+"]").hide();
	            $(".letterBlockBody[block_body_id="+letter+"]").show();
	            $(".letterBlockHead[block_head_id="+letter+"]").show();
	        }
	        return false;
        });

        //beim anklicken einer Checkbox
        $("input[type=checkbox].memlist_checkbox").live("click", function(){
                 
            //Checkbox ID
            var checkbox_id = $(this).attr("id");

	       	members = $("input[type=checkbox][name=\'member[]\' ]:checked").map(function() {
			 	return $(this).val();
	       	}).get();  

    		if($(this).is(":checked")) {
        		checkedArray.push($(this).val());
   			} 
   			else {
        		for(var i=0; i<checkedArray.length;i++ ) {
           		 	if(checkedArray[i]== $(this).val()) {
                		checkedArray.splice(i,1);
            		}
        		}
    		}
	       	
            //Ladebalken an checkbox
            $("#loadindicator_" + checkbox_id).append("<img src=\''.THEME_PATH.'/icons/loader_inline.gif\' alt=\'loadindicator\' />").show();

        });       
     });            
//--></script>';
        
require(SERVER_PATH. '/adm_program/system/overall_header.php');
echo '<h1>'. $gLayout['title']. '</h1>';

//Suchleiste
echo '
<form id="memsearch_form">
    <ul class="iconTextLinkList">
        <li>'.$gL10n->get('SYS_SEARCH').': <input type="text" name="mem_search" id="mem_search" /></li>
        <br>
        <li>'.$gL10n->get('SYS_OPTIONAL').':</li>
 		<li><input type="checkbox" name="select_all" id="select_all" /><label for="select_all">'.$gL10n->get('PMB_SELECT_ALL').'</label></li>
 		<li><input type="checkbox" name="unselect_all" id="unselect_all" /><label for="unselect_all">'.$gL10n->get('PMB_UNSELECT_ALL').'</label></li>
		<br>
		<br>
 		<li><button id="exportieren" type="button" name="exportieren" onclick="prenotexport();"<img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('PMB_EXPORT').'" />&nbsp;'.$gL10n->get('PMB_EXPORT').'</button></li>
 		<li><button id="mailen" type="button" name="mailen" onclick="massmail();"<img src="'. THEME_PATH. '/icons/email.png" alt="'.$gL10n->get('SYS_EMAIL').'" />&nbsp;'.$gL10n->get('SYS_EMAIL').'</button></li>	
 	</ul>
</form>';

//Ladebalken
echo '<img src="'.THEME_PATH.'/images/loading_animation.gif" alt="'.$gL10n->get('SYS_PROGRESS_BAR').'" id="list_load_animation"/>';

//Liste mit Namen zu abhaken
echo '<form id="memlist_form"></form>';

// Zurueck-Button nur anzeigen, wenn MyList nicht direkt aufgerufen wurde
if($gNavigation->count() > 1)
{
    echo '
    <ul class="iconTextLinkList">
        <li>
            <span class="iconTextLink">
                <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
            </span>
        </li>
    </ul>';
}

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>