<?php
/******************************************************************************
 * 
 * pre_notification_export.php
 *   
 * Funktion um das Faelligkeitsdatum fuer das Admidio-Plugin Mitgliedsbeitrag zu setzen oder zu loeschen 
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Parameters:
 *
 * teilStringX		: Strings mit user_ids (teilString1, teilString2 usw)
 * teilStringLength	: Anzahl der Strings (mit user_ids)
 *
 ****************************************************************************/
  
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');

require_once(dirname(__FILE__).'/common_function.php');

$membersString = '';

$getTeilStringLength	= admFuncVariableIsValid($_GET, 'teilStringLength', 'numeric');

for ($i=1;$i<=$getTeilStringLength;$i++)
{
	$membersString .= admFuncVariableIsValid($_GET, 'teilString'.$i, 'string');
}

if (strlen($membersString)<>0)
{
	$membersArr = explode(',',$membersString);
	$export = '';

	$export = $gL10n->get('PMB_SERIAL_NUMBER').";"
			 .$gL10n->get('PMB_MEMBERNUMBER').";"		 	
			 .$gL10n->get('SYS_FIRSTNAME').";"
			 .$gL10n->get('SYS_LASTNAME').";"
			 .$gL10n->get('SYS_ADDRESS').";"
			 .$gL10n->get('SYS_POSTCODE').";"
			 .$gL10n->get('SYS_CITY').";"	
			 .$gL10n->get('SYS_EMAIL').";"	
			 .$gL10n->get('SYS_PHONE').";"	
			 .$gL10n->get('SYS_MOBILE').";"	
			 .$gL10n->get('SYS_BIRTHDAY').";"				 
			 .$gL10n->get('PMB_ACCESSION').";"
			 				 			 			 			 			 	 
			 .$gL10n->get('PMB_ACCOUNT_HOLDER')."/".$gL10n->get('PMB_DEBTOR').";"
			 .$gL10n->get('PMB_ADDRESS').";"		 
			 .$gL10n->get('PMB_POSTCODE').";"
			 .$gL10n->get('PMB_CITY').";"
			 .$gL10n->get('PMB_EMAIL').";"	

			 .$gL10n->get('PMB_BANK').";"
			 .$gL10n->get('PMB_BIC').";"
			 .$gL10n->get('PMB_IBAN').";"	
 	  		 .$gL10n->get('PMB_MANDATEDATE').";"	
			 .$gL10n->get('PMB_MANDATEID').";"
			 .$gL10n->get('PMB_DUEDATE').";"					 			 		 			 			 
 			 .$gL10n->get('PMB_FEE').";"
			 ."\n";
		 
	$nr = 1;

	foreach ($membersArr as $UserId )
	{
		$user = new User($gDb, $gProfileFields, $UserId);	
	
		$export .= $nr.";";
		$export .= $user->getValue('MEMBERNUMBER').";";		
		$export .= $user->getValue('FIRST_NAME').";";
		$export .= $user->getValue('LAST_NAME').";";
		$export .= $user->getValue('ADDRESS').";";
		$export .= $user->getValue('POSTCODE').";";
		$export .= $user->getValue('CITY').";";
		$export .= $user->getValue('EMAIL').";";
		$export .= $user->getValue('PHONE').";";
		$export .= $user->getValue('MOBILE').";";
		$export .= $user->getValue('BIRTHDAY').";";				
		$export .= $user->getValue('BEITRITT'.$gCurrentOrganization->getValue('org_id')).";";		
		
		if (strlen($user->getValue('KONTOINHABER'))<>0)
		{
			$export .= $user->getValue('KONTOINHABER').";";
			$export .= $user->getValue('DEBTORADDRESS').";";
			$export .= $user->getValue('DEBTORPOSTCODE').";";
			$export .= $user->getValue('DEBTORCITY').";";
			$export .= $user->getValue('DEBTOREMAIL').";";							
		}
		else 
		{
			$export .= $user->getValue('FIRST_NAME')." ".$user->getValue('LAST_NAME').";";
			$export .= $user->getValue('ADDRESS').";";
			$export .= $user->getValue('POSTCODE').";";
			$export .= $user->getValue('CITY').";";	
			$export .= $user->getValue('EMAIL').";";					
		}

		$export .= $user->getValue('BANKNAME').";";	
		$export .= $user->getValue('BIC').";";	
		$export .= $user->getValue('IBAN').";";
		$export .= $user->getValue('MANDATEDATE'.$gCurrentOrganization->getValue('org_id')).";";
		$export .= $user->getValue('MANDATEID'.$gCurrentOrganization->getValue('org_id')).";";
		$export .= $user->getValue('DUEDATE'.$gCurrentOrganization->getValue('org_id')).";";		
		$export .= $user->getValue('BEITRAG'.$gCurrentOrganization->getValue('org_id')).";";
		$export .= "\n";
	
		$nr += 1;
	}
	echo $export;	
}
else 
{
	echo 'marker_empty';	
}

?>