<?php
/******************************************************************************
 * 
 * pre_notification_get.php
 *   
 * Erstellen einer CSV-Datei mit Daten für Vorabankuendigungen
 *    Unterprogramm zum Einlesen der Mitglieder
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Hinweis: pre_notification_get.php ist eine modifizierte members_get.php
 * 
 * Parameters:    
 *                                              
 * mem_search   : Suchstring nach dem Mitglieder angezeigt werden sollen
 * members		: String der Mitglieder, die markiert sind
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

// Initialize and check the parameters
$postMembersSearch  = admFuncVariableIsValid($_POST, 'mem_search', 'string');
$getMembers			= admFuncVariableIsValid($_GET, 'members', 'string');

$condition = '';
$limit = '';
$getMembersArr = explode(',',$getMembers);

$member_condition = ' EXISTS 
        (SELECT 1
         FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. ','. TBL_USER_DATA. '
         WHERE mem_usr_id = usr_id
            AND mem_rol_id = rol_id
            AND mem_begin <= \''.DATE_NOW.'\'
            AND mem_end    > \''.DATE_NOW.'\'
            AND usd_usr_id = usr_id
            AND usd_usf_id = '. $gProfileFields->getProperty('DUEDATE'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). '
            AND usd_value <> \'\'        	
            AND rol_valid  = 1
            AND rol_cat_id = cat_id
            AND (  cat_org_id = '. $gCurrentOrganization->getValue('org_id'). '
                OR cat_org_id IS NULL )) ';	

//Suchstring zerlegen
if(strlen($postMembersSearch) > 0)
{
    $postMembersSearch = str_replace('%', ' ', $postMembersSearch);
    $search_therms = explode(' ', $postMembersSearch);
    
    if(count($search_therms)>0)
    {
    	//in Condition einbinden
	    foreach($search_therms as $search_therm)
	    {
	    	$member_condition .= ' AND (  (UPPER(last_name.usd_value)  LIKE UPPER(\''.$search_therm.'%\')) 
									   OR (UPPER(first_name.usd_value) LIKE UPPER(\''.$search_therm.'%\'))) ';
	    }
    }
    //Ergebnissmenge Limitieren
    $limit .= ' LIMIT 30 ';
}

 // SQL-Statement zusammensetzen
$sql = 'SELECT DISTINCT usr_id, last_name.usd_value as last_name, first_name.usd_value as first_name, birthday.usd_value as birthday,
               city.usd_value as city, address.usd_value as address, zip_code.usd_value as zip_code, country.usd_value as country,
               faelligkeitsdatum.usd_value as faelligkeitsdatum,beitrag.usd_value as beitrag,
               mandatsreferenz.usd_value as mandatsreferenz,debtor.usd_value as debtor, debtoraddress.usd_value as debtoraddress,
               debtorpostcode.usd_value as debtorpostcode, debtorcity.usd_value as debtorcity, debtoremail.usd_value as debtoremail,
               email.usd_value as email
        FROM '. TBL_USERS. '
        LEFT JOIN '. TBL_USER_DATA. ' as last_name
          ON last_name.usd_usr_id = usr_id
         AND last_name.usd_usf_id = '. $gProfileFields->getProperty('LAST_NAME', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as first_name
          ON first_name.usd_usr_id = usr_id
         AND first_name.usd_usf_id = '. $gProfileFields->getProperty('FIRST_NAME', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as birthday
          ON birthday.usd_usr_id = usr_id
         AND birthday.usd_usf_id = '. $gProfileFields->getProperty('BIRTHDAY', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as city
          ON city.usd_usr_id = usr_id
         AND city.usd_usf_id = '. $gProfileFields->getProperty('CITY', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as address
          ON address.usd_usr_id = usr_id
         AND address.usd_usf_id = '. $gProfileFields->getProperty('ADDRESS', 'usf_id'). '
      	LEFT JOIN '. TBL_USER_DATA. ' as mandatsreferenz
          ON mandatsreferenz.usd_usr_id = usr_id
         AND mandatsreferenz.usd_usf_id = '. $gProfileFields->getProperty('MANDATEID'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). '     
       	LEFT JOIN '. TBL_USER_DATA. ' as faelligkeitsdatum
          ON faelligkeitsdatum.usd_usr_id = usr_id
         AND faelligkeitsdatum.usd_usf_id = '. $gProfileFields->getProperty('DUEDATE'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). ' 
        LEFT JOIN '. TBL_USER_DATA. ' as beitrag
          ON beitrag.usd_usr_id = usr_id
         AND beitrag.usd_usf_id = '. $gProfileFields->getProperty('BEITRAG'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). ' 
        LEFT JOIN '. TBL_USER_DATA. ' as zip_code
          ON zip_code.usd_usr_id = usr_id
         AND zip_code.usd_usf_id = '. $gProfileFields->getProperty('POSTCODE', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as debtor
          ON debtor.usd_usr_id = usr_id
         AND debtor.usd_usf_id = '. $gProfileFields->getProperty('KONTOINHABER', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as debtoraddress
          ON debtoraddress.usd_usr_id = usr_id
         AND debtoraddress.usd_usf_id = '. $gProfileFields->getProperty('DEBTORADDRESS', 'usf_id'). '    
		LEFT JOIN '. TBL_USER_DATA. ' as debtoremail
          ON debtoremail.usd_usr_id = usr_id
         AND debtoremail.usd_usf_id = '. $gProfileFields->getProperty('DEBTOREMAIL', 'usf_id'). '    
 		LEFT JOIN '. TBL_USER_DATA. ' as email
          ON email.usd_usr_id = usr_id
         AND email.usd_usf_id = '. $gProfileFields->getProperty('EMAIL', 'usf_id'). '      
         LEFT JOIN '. TBL_USER_DATA. ' as debtorpostcode
          ON debtorpostcode.usd_usr_id = usr_id
         AND debtorpostcode.usd_usf_id = '. $gProfileFields->getProperty('DEBTORPOSTCODE', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as debtorcity
          ON debtorcity.usd_usr_id = usr_id
         AND debtorcity.usd_usf_id = '. $gProfileFields->getProperty('DEBTORCITY', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as country
          ON country.usd_usr_id = usr_id
         AND country.usd_usf_id = '. $gProfileFields->getProperty('COUNTRY', 'usf_id'). '
       
        LEFT JOIN '. TBL_MEMBERS. ' mem
          ON  mem.mem_begin  <= \''.DATE_NOW.'\'
         AND mem.mem_end     > \''.DATE_NOW.'\'
         AND mem.mem_usr_id  = usr_id
        WHERE '. $member_condition. '
        ORDER BY last_name, first_name '.$limit;

$result_user = $gDb->query($sql);    

if($gDb->num_rows($result_user)>0) 
{
    //Buchstaben Navigation bei mehr als 50 personen
    if($gDb->num_rows($result_user) >= 50)
    {
        echo '<div class="pageNavigation">
            <a href="#" letter="all" class="pageNavigationLink">'.$gL10n->get('SYS_ALL').'</a>&nbsp;&nbsp;';
        
            // Nun alle Buchstaben mit evtl. vorhandenen Links im Buchstabenmenue anzeigen
            $letter_menu = 'A';
            
            for($i = 0; $i < 26;$i++)
            {
                // pruefen, ob es Mitglieder zum Buchstaben gibt
                // dieses SQL muss fuer jeden Buchstaben ausgefuehrt werden, ansonsten werden Sonderzeichen nicht immer richtig eingeordnet
                $sql = 'SELECT COUNT(1) as count
                          FROM '. TBL_USERS. ', '. TBL_USER_FIELDS. ', '. TBL_USER_DATA. '
                         WHERE usr_valid  = 1
                           AND usf_name_intern = \'LAST_NAME\'
                           AND usd_usf_id = usf_id
                           AND usd_usr_id = usr_id
                           AND usd_value LIKE \''.$letter_menu.'%\'
                           AND '.$member_condition.'
                         GROUP BY UPPER(SUBSTRING(usd_value, 1, 1))';
                $result      = $gDb->query($sql);
                $letter_row  = $gDb->fetch_array($result);

                if($letter_row['count'] > 0)
                {
                    echo '<a href="#" letter="'.$letter_menu.'" class="pageNavigationLink">'.$letter_menu.'</a>';
                }
                else
                {
                    echo $letter_menu;
                }
        
                echo '&nbsp;&nbsp;';
        
                $letter_menu = strNextLetter($letter_menu);
            }
        echo '</div>';    
    }
    
    //Tabelle anlegen
    echo '
    <table class="tableList" cellspacing="0">
        <thead>
            <tr>
                <th style="text-align: center;">'.$gL10n->get('PMB_EXPORT').'</th>
                <th>'.$gL10n->get('PMB_DUE_ON').'</th>    
                <th>'.$gL10n->get('PMB_FEE').'</th>
                <th>'.$gL10n->get('SYS_LASTNAME').'</th>
                <th>'.$gL10n->get('SYS_FIRSTNAME').'</th>
                <th><img class="iconInformation" src="'. THEME_PATH. '/icons/map.png" 
                    alt="'.$gL10n->get('SYS_ADDRESS').'" title="'.$gL10n->get('SYS_ADDRESS').'" /></th>
                <th><img class="iconInformation" src="'. THEME_PATH. '/icons/info.png" 
                    alt="'.$gL10n->get('PMB_DEBTOR').'" title="'.$gL10n->get('PMB_DEBTOR').'" /></th>
                <th><img class="iconInformation"
                    src="'. THEME_PATH. '/icons/email.png" alt="'.$gL10n->get('SYS_EMAIL').'" title="'.$gL10n->get('SYS_EMAIL').'" /></th>
 				<th style="text-align: right;">'.$gL10n->get('PMB_MANDATEID').'</th>                          
            </tr>
        </thead>';
        
    $letter_merker = '';
    $this_letter   = '';
    
    function convSpecialChar($specialChar)
    {
        $convTable = array('Ä' => 'A', 'É' => 'E', 'È' => 'E', 'Ö' => 'O', 'Ü' => 'U');
        
        if(array_key_exists($specialChar, $convTable))
        {
            return admstrtoupper($convTable[$specialChar]);
        }
        return $specialChar;
    }

    //Zeilen ausgeben
    while($user = $gDb->fetch_array($result_user))
    {
    	if($gDb->num_rows($result_user) >= 50)
    	{
            // Buchstaben auslesen
            $this_letter = admstrtoupper(substr($user['last_name'], 0, 1));
            
            if(ord($this_letter) < 65 || ord($this_letter) > 90)
            {
                $this_letter = convSpecialChar(substr($user['last_name'], 0, 2));
            }
            
            if($this_letter != $letter_merker)
            {
                if(mb_strlen($letter_merker) > 0)
                {
                    echo '</tbody>';
                }

                // Ueberschrift fuer neuen Buchstaben
                echo '<tbody block_head_id="'.$this_letter.'" class="letterBlockHead">
                    <tr>
                        <td class="tableSubHeader" colspan="9">
                            '.$this_letter.'
                        </td>
                    </tr>
                </tbody>
                <tbody block_body_id="'.$this_letter.'" class="letterBlockBody">';

                // aktuellen Buchstaben merken
                $letter_merker = $this_letter;
            }
        }

        $datumtemp = new DateTimeExtended($user['faelligkeitsdatum'], 'Y-m-d', 'date');
        
        //Datensatz für Icon zusammensetzen
        $user_text = '';
        if(strlen($user['address']) > 0)
        {
            $user_text = $user['address'];
        }
        if(strlen($user['zip_code']) > 0 || strlen($user['city']) > 0)
        {
            $user_text = $user_text. ' - '. $user['zip_code']. ' '. $user['city'];
        }
        if(strlen($user['country']) > 0)
        {
            $user_text = $user_text. ' - '. $user['country'];
        }

        //Datensatz für Zahlungspflichtigen zusammensetzen
        $debtor_text = '';
        if(strlen($user['debtor']) > 0)
        {
            $debtor_text = $user['debtor'];
        }
        if(strlen($user['debtoraddress']) > 0)
        {
            $debtor_text = $debtor_text. ' - '. $user['debtoraddress'];
        }
        if(strlen($user['debtorpostcode']) > 0 || strlen($user['debtorcity']) > 0)
        {
            $debtor_text = $debtor_text. ' - '. $user['debtorpostcode']. ' '. $user['debtorcity'];
        }
        
        //Datensatz für E-Mail-Adresse zusammensetzen
        $email = '';
        if(strlen($user['debtor']) > 0)
        {
			if(strlen($user['debtoremail']) > 0)
			{
				$email = $user['debtoremail'];				
			}         	
        }
        else 
        {
			if(strlen($user['email']) > 0)
			{
				$email = $user['email'];				
			}         	
        }
        
        echo '
        <tr class="tableMouseOver" user_id="'.$user['usr_id'].'">
            <td style="text-align: center;">'; 
        	if (in_array('member_'.$user['usr_id'],$getMembersArr)) 
        	{
 				echo '<input type="checkbox" value="member_'.$user['usr_id'].'" checked="checked" name="member[]" class="memlist_checkbox" checkboxtype="member" />';  
        	}  
        	else 
        	{
        		echo '<input type="checkbox" value="member_'.$user['usr_id'].'" name="member[]" class="memlist_checkbox" checkboxtype="member" />';
        	}  
            echo'<td>';
                //Fälligkeitsdatum ausgeben
                // über div class gehen, da ansonsten jquery die id nicht auslesen kann
                echo '<div class="text_'.$user['usr_id'].'"><label for="datumtemp"  />'.((strlen($user['faelligkeitsdatum']) > 0)? $datumtemp->format($gPreferences['system_date']):"").'</label></div>';
            echo '</td>'; 
            echo '<td style="text-align: right;">'.$user['beitrag'].' '.$gPreferences['system_currency'].'</td>'; 
           	echo '<td><a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $user['usr_id']. '">'.$user['last_name']. '</a></td>
            <td>'.$user['first_name'].'</td>
            <td>';
            	if(strlen($user_text) > 0)
                {
                    echo '<img class="iconInformation" src="'. THEME_PATH.'/icons/map.png" alt="'.$user_text.'" title="'.$user_text.'" />';
                }
                else
                {
                    echo '&nbsp';
                }
            echo '</td>
            <td>';
            	if(strlen($debtor_text) > 0)
                {
                    echo '<img class="iconInformation" src="'. THEME_PATH.'/icons/info.png" alt="'.$debtor_text.'" title="'.$debtor_text.'" />';
                }
                else
                {
                    echo '&nbsp';
                }
            echo '</td>
            <td>';
				if(strlen($email) > 0)
				{
					if($gPreferences['enable_mail_module'] != 1)
					{
						$mail_link = 'mailto:'. $email;
					}
					else
					{
						$mail_link = $g_root_path.'/adm_plugins/'.$plugin_folder.'/common_mail.php?usr_id='. $user['usr_id'];			
					}
					echo '<a class="iconLink" href="'.$mail_link.'"><img src="'. THEME_PATH. '/icons/email.png"
							alt="'.$gL10n->get('SYS_SEND_EMAIL_TO', $email).'" title="'.$gL10n->get('SYS_SEND_EMAIL_TO', $email).'" /></a>';
				}
    			else
                {
                    echo '&nbsp';
                }
			echo '</td>
            <td style="text-align: right;">'.$user['mandatsreferenz'].'</td>
        </tr>';
    }//End While

    echo '</table>';

    //Hilfe nachladen
    echo '<script type="text/javascript">$("a[rel=\'colorboxHelp\']").colorbox({preloading:true,photo:false,speed:300,rel:\'nofollow\'})</script>';
}
else
{
	echo '<p>'.$gL10n->get('SYS_NO_ENTRIES_FOUND').'</p>';
}
?>