<?php
/******************************************************************************
 * 
 * sepa_convert.php
 *    
 * Konvertiert BLZ und Kontonummer in IBAN, BIC und Bankname
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *  
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(dirname(__FILE__).'/common_function.php');

$gNavigation->addUrl('http://'.$_SERVER["SERVER_NAME"].'/adm_plugins/'.$plugin_folder.'/'.basename(__FILE__));

// Html-Kopf ausgeben
$gLayout['title']  = $gL10n->get('PMB_CONVERT_ACCOUNT_DATA');
$gLayout['header'] = '
    <script type="text/javascript"><!--
        $(document).ready(function() 
        {
            $("#userfile").focus();
        }); 
    //--></script>';
    
require(SERVER_PATH. '/adm_program/system/overall_header.php');

// Html des Modules ausgeben
echo '
<form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/sepa_convert_function.php" method="post" enctype="multipart/form-data">
<div class="formLayout" id="convert_form">
    <div class="formHead">'.$gLayout['title'].'</div>
    <div class="formBody">
        <ul class="formFieldList">
            <li>'.$gL10n->get('PMB_CONVERT_ACCOUNT_DATA_INFO','<a href="http://www.bundesbank.de/Redaktion/DE/Standardartikel/Kerngeschaeftsfelder/Unbarer_Zahlungsverkehr/bankleitzahlen_download.html" target = "_blank">hier</a>').'</li>
            <li>
                <dl>
                    <dt><label for="userfile">'.$gL10n->get('DOW_CHOOSE_FILE').':</label></dt>
                    <dd>
                        <input type="hidden" name="MAX_FILE_SIZE" value="'.($gPreferences['max_file_upload_size'] * 1024).'" />
                        <input type="file" id="userfile" name="userfile" style="width: 90%;" />
                    </dd>
                </dl>
            </li>
            <li>
 				<dl>
                	<dt><label for="generate_BIC">'.$gL10n->get('PMB_GENERATE_BIC').':</label></dt>
                    <dd>
                    	<input type="checkbox" id="generateBIC" name="generateBIC" />
                    </dd>
                </dl>
            </li>
            <li>
 				<dl>
                	<dt><label for="generate_Bank">'.$gL10n->get('PMB_GENERATE_BANK').':</label></dt>
                    <dd>
                    	<input type="checkbox" id="generateBank" name="generateBank" />
                    </dd>
                </dl>
            </li> 
			<li class="smallFontSize">'.$gL10n->get('PMB_CONVERT_ACCOUNT_DATA_NOTE',$gL10n->get('SYS_NOTE').':').'</li>
        </ul>
        <hr>
        <div class="formSubmit">
            <button id="btnUpload" type="submit"><img 
            src="'.THEME_PATH.'/icons/edit.png" alt="'.$gL10n->get('PMB_CONVERT').'" />
            &nbsp;'.$gL10n->get('PMB_CONVERT').'</button>
        </div>
    </div>  
</div>
</form>

<ul class="iconTextLinkList">
    <li>
        <span class="iconTextLink">
            <a href="'.$g_root_path.'/adm_program/system/back.php"><img
            src="'.THEME_PATH.'/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
            <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
        </span>
    </li>
</ul>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>