<?php
/******************************************************************************
 * sepa_convert_function.php
 * 
 * Funktionen für das Modul sepa_convert
 *
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(dirname(__FILE__).'/common_function.php');


$gNavigation->deleteLastUrl();
            
$gMessage->setForwardUrl($gNavigation->getPreviousUrl());

$_SESSION['download_request'] = $_POST;

// wenn BIC oder Bankname gewählt wurde, dann muss auch eine Bankleitzahlendatei ausgewählt worden sein
// --> überprüfen
if (isset($_POST['generateBIC']) || isset($_POST['generateBank']) )
{
    //Dateigroesse ueberpruefen Servereinstellungen
    if ($_FILES['userfile']['error']==1) 
    {
        $gMessage->show($gL10n->get('SYS_FILE_TO_LARGE_SERVER',ini_get('upload_max_filesize')));
    }
    
    //Dateigroesse ueberpruefen Administratoreinstellungen
    if (($_FILES['userfile']['size']>($gPreferences['max_file_upload_size'])*1024) || ($_FILES['userfile']['error']==2) )
    {
        $gMessage->show($gL10n->get('DOW_FILE_TO_LARGE', $gPreferences['max_file_upload_size']));
    }
    
    // Dateinamen ermitteln
    $file_name = $_FILES['userfile']['name'];

    // pruefen, ob der Dateiname gueltig ist
    $ret_code = isValidFileName($file_name, true);

    if($ret_code < 0)
    {
        if($ret_code == -1)
        {
            $gMessage->show($gL10n->get('SYS_FIELD_EMPTY', $gL10n->get('DOW_CHOOSE_FILE')));
        }
        elseif($ret_code == -2)
        {
            $gMessage->show($gL10n->get('DOW_FILE_NAME_INVALID'));
        }
        elseif($ret_code == -3)
        {
            $gMessage->show($gL10n->get('DOW_FILE_EXTENSION_INVALID'));
        }
    }
    
	if ($_FILES['userfile']['error']==0)
	{
		// bei einem Upload von lokal auf Server ist $_FILES['userfile']['tmp_name'] befüllt
		// dann diesen temporären Dateinamen verwenden
		// wenn sich die blz-Datei bereits auf dem Server befindet (Testumgebung),
		//      dann ist $_FILES['userfile']['tmp_name'] leer
		// dann den originalen Dateinamen verwenden		 
		if (strlen($_FILES['userfile']['tmp_name'])<>0)
		{
			$blz_array = file ($_FILES['userfile']['tmp_name']);			
		}
		else 
		{
			$blz_array = file ($_FILES['userfile']['name']);			
		}
	}
	else 
	{
		$gMessage->show($gL10n->get('DOW_FILE_UPLOAD_ERROR',$file_name));	
	}    
}

$marker = false;

// Daten einlesen
$members = list_members(array('KONTONUMMER','BANKLEITZAHL','IBAN','BIC','BANKNAME'), 0)  ;

//alle Mitglieder durchlaufen
foreach ($members as $member => $memberdata)
{
	$user = new User($gDb, $gProfileFields, $member);
	
	// IBAN erzeugen
    if (empty($memberdata['IBAN']) && !empty($memberdata['KONTONUMMER']) && !empty($memberdata['BANKLEITZAHL']) )
    {
		$user->setValue('IBAN', iban_berechnung_DE($memberdata['BANKLEITZAHL'],$memberdata['KONTONUMMER']));
		$marker = true;
    }
    
    // BIC erzeugen
	if ( empty($memberdata['BIC']) && !empty($memberdata['BANKLEITZAHL']) &&  isset($_POST['generateBIC']) )
    {
    	foreach ($blz_array as $data)
		{
			if ( (substr($data,0,8) == $memberdata['BANKLEITZAHL']) && (substr($data,8,1) =='1') )
    		{
    			$user->setValue('BIC', substr($data,139,11));
    			$marker = true;
    		}
		}
    }

    // Bankname erzeugen
	if ( empty($memberdata['BANKNAME']) && !empty($memberdata['BANKLEITZAHL']) &&  isset($_POST['generateBank']) )
    {
    	foreach ($blz_array as $data)
		{
			if ( (substr($data,0,8) == $memberdata['BANKLEITZAHL']) && (substr($data,8,1) =='1') )
    		{
    			$user->setValue('BANKNAME', umlaute(substr($data,9,58)));
    			$marker = true;
    		}
		}	
    }
    $user->save();
}

if ($marker)
{
	$gMessage->show($gL10n->get('SYS_SAVE_DATA'));    	         
}
else 
{
   	$gMessage->show($gL10n->get('PMB_NO_DATA_TO_CONVERT')); 
}


?>