<?php
/******************************************************************************
 * 
 * sepa_export.php
 *    
 * SEPA-Export fuer das Admidio-Plugin Mitgliedsbeitrag
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *  
 *  SEPA Lastschriften als XML-Datei erstellen
 *  Grundgeruest erstellt von Günter Scheuermann am 28.1.2013
 *  
 * Parameters:
 *
 * duedatesepatype	: 	Faelligkeitsdatum und SepaTyp in einem String
 * 						- Zeichen 0 bis 9: Faelligkeitsdatum
 * 						- ab Zeichen 10: Sepatyp		   
 *
 * eillastschrift	:	Kennung für SEPA Eil-Lastschrift (COR1)
 *****************************************************************************/

/*
Zulässige Zeichen
Für die Erstellung von SEPA-Nachrichten sind die folgenden Zeichen in der 
Kodierung gemäß UTF-8 bzw. ISO-885933 zugelassen.
---------------------------------------------------
Zugelassener Zeichencode| Zeichen 	| Hexcode
Numerische Zeichen 		| 0 bis 9	| X'30' bis X'39'
Großbuchstaben 			| A bis Z 	| X'41' bis X'5A'
Kleinbuchstaben 		| a bis z 	| X'61' bis 'X'7A'
Apostroph 				|  '  		| X'27
Doppelpunkt 			|  :  		| X'3A
Fragezeichen 			|  ?  		| X'3F
Komma 					|  ,  		| X'2C
Minus 					|  -  		| X'2D
Leerzeichen 			|     		| X'20
Linke Klammer 			|  (  		| X'28
Pluszeichen 			|  +  		| X'2B
Rechte Klammer 			|  )  		| X'29
Schrägstrich 			|  /  		| X'2F

*/

require_once(dirname(__FILE__).'/common_function.php');

// Initialize and check the parameters
$postDueDateSepaType 	= admFuncVariableIsValid($_POST, 'duedatesepatype', 'string', 'off');
$postCOR1Marker 		= admFuncVariableIsValid($_POST, 'eillastschrift', 'boolean', false);

// $postDueDateSepaType splitten in DueDate und SepaType
$postDueDate=substr($postDueDateSepaType,0,10);
$postSepaType=substr($postDueDateSepaType,10);

// Konfiguration einlesen
$config_ini = readConfigTablePMB();

/******************************************************************************
 * alle Mitglieder einlesen
 *****************************************************************************/
 
$members = list_members(array('FIRST_NAME','LAST_NAME','BEITRAG'.$gCurrentOrganization->getValue('org_id'),'BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id'),'BEZAHLT'.$gCurrentOrganization->getValue('org_id'),'KONTONUMMER','BANKLEITZAHL','KONTOINHABER','IBAN','ORIGIBAN','BIC','BANKNAME','ORIGDEBTORAGENT','MANDATEID'.$gCurrentOrganization->getValue('org_id'),'ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'),'MANDATEDATE'.$gCurrentOrganization->getValue('org_id'),'DUEDATE'.$gCurrentOrganization->getValue('org_id'),'SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')), 0)  ;

$zempf=array();
$zpflgt=array();
$lst_euro_sum = 0;
$now=time();
$format1="Y-m-d";
$format2="H:i:s";

//alle Mitglieder durchlaufen und abhänfig von bestimmten Daten, das Array $zpflgt befüllen
foreach ($members as $member => $memberdata)
{
    if  (!empty($memberdata['BEITRAG'.$gCurrentOrganization->getValue('org_id')]) 
    	&& empty($memberdata['BEZAHLT'.$gCurrentOrganization->getValue('org_id')]) 
    	&& !empty($memberdata['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')]) 
    	&& !empty($memberdata['IBAN']) 
    	&& ($memberdata['DUEDATE'.$gCurrentOrganization->getValue('org_id')]==$postDueDate)
    	&& ( ($memberdata['SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')]==$postSepaType)
    		|| (($postSepaType=='FRST') && ($memberdata['SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id')]==''))  ) )
    {
      	if (empty($memberdata['KONTOINHABER']))
        {  
            $members[$member]['KONTOINHABER'] = $memberdata['FIRST_NAME'].' '.$memberdata['LAST_NAME'] ;
        }
        
		$zpflgt[$member]['name']=substr(umlaute2($members[$member]['KONTOINHABER']),0,70);     											// Name of account owner.
		$zpflgt[$member]['alt_name']="";																								// Array SEPA Zahlungspflichtiger abweichender Name
		$zpflgt[$member]['iban']=$members[$member]['IBAN'];        																		// IBAN 
		$zpflgt[$member]['bic']=$members[$member]['BIC'];        																		// BIC 
		$zpflgt[$member]['mandat_id']=$members[$member]['MANDATEID'.$gCurrentOrganization->getValue('org_id')];        					// Mandats-ID 
		$zpflgt[$member]['mandat_datum']=$members[$member]['MANDATEDATE'.$gCurrentOrganization->getValue('org_id')];     				// Mandats-Datum
		$zpflgt[$member]['betrag']=$members[$member]['BEITRAG'.$gCurrentOrganization->getValue('org_id')];        						// Amount of money 
		$zpflgt[$member]['text']=substr(umlaute2($members[$member]['BEITRAGSTEXT'.$gCurrentOrganization->getValue('org_id')]),0,140);   // Description of the transaction ("Verwendungszweck").
		$zpflgt[$member]['orig_mandat_id']=$members[$member]['ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id')];        		// ursprüngliche Mandats-ID 
		$zpflgt[$member]['orig_iban']=$members[$member]['ORIGIBAN'];        															// ursprüngliche IBAN 
		$zpflgt[$member]['orig_dbtr_agent']=$members[$member]['ORIGDEBTORAGENT'];        												// ursprüngliches Kreditinstitut, nur "SMNDA" möglich
			
    	$lst_euro_sum += $zpflgt[$member]['betrag'];

    	$zpflgt[$member]['end2end_id']=substr(umlaute2($gCurrentOrganization->getValue('org_shortname')).'-'.$member.'-'.date($format1,$now),0,35);		//SEPA End2End-ID	(max. 35)
    	
	}
}

$lst_num=count($zpflgt);																												//SEPA Anzahl der Lastschriften

if ($lst_num==0)
{
	$gMessage->show('Keine Daten für den Export vorhanden!');	
}
				
$message_id=substr("Message-ID-".umlaute2($gCurrentOrganization->getValue('org_shortname')),0,35);		//SEPA Message-ID	(max. 35)		
$message_datum=date($format1,$now)."T".date($format2,$now).".000Z";										//SEPA Message-Datum z.B.: 2010-11-21T09:30:47.000Z
$message_initiator_name=substr(umlaute2($config_ini['Kontodaten']['inhaber']),0,70);						//SEPA Message Initiator Name

$payment_id="Beitragszahlungen";																		//SEPA Payment_ID (max. 35)
$payment_datum=$postDueDate;

//$payment_end2end_id (wird nicht mehr benötigt)
$payment_end2end_id="NOTPROVIDED";	
																	//SEPA Payment_EndToEndIdentification
$payment_seqtp=$postSepaType; 

$zempf['name']=substr(umlaute2($config_ini['Kontodaten']['inhaber']),0,70);								//SEPA  Zahlungsempfänger Kontoinhaber
$zempf['ci']=$config_ini['Kontodaten']['ci'];                 											//Organisation SEPA_ID (Gläubiger-ID Bundesdbank)
$zempf['iban']=$config_ini['Kontodaten']['iban'];														//SEPA  Zahlungsempfänger IBAN	
$zempf['bic']=$config_ini['Kontodaten']['bic'];															//SEPA  Zahlungsempfänger BIC
$zempf['orig_cdtr_name']=$config_ini['Kontodaten']['origcreditor'];  									//ursprünglicher Creditor
$zempf['orig_cdtr_id']=$config_ini['Kontodaten']['origci'];  											//ursprüngliche Mandats-ID

if (isset($_POST['xml_datei']))
{

	/******************************************************************************
 	* Schreibt Lastschriften in einen XML-String
 	*****************************************************************************/
  	$xmlfile="";
  	$xmlfile.="<?xml version='1.0' encoding='UTF-8'?>\n";

  	// DFÜ-Abkommen Version 2.7
  	// Pain 008.003.002
  	// für COR1 und IBAN only Unterstützung notwendig
  	$xmlfile.="<Document xmlns='urn:iso:std:iso:20022:tech:xsd:pain.008.003.02'
          xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'
          xsi:schemaLocation='urn:iso:std:iso:20022:tech:xsd:pain.008.003.02 pain.008.003.02.xsd'>\n";
  	
  	// DFÜ-Abkommen Version 2.6
  	// Pain 008.002.002
  	//$xmlfile.="<Document xmlns='urn:iso:std:iso:20022:tech:xsd:pain.008.002.02'
    //      xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'
    //      xsi:schemaLocation='urn:iso:std:iso:20022:tech:xsd:pain.008.002.02 pain.008.002.02.xsd'>\n";
  	
  		// ########## Customer Direct Debit Initiation ###########
  		$xmlfile.="<CstmrDrctDbtInitn>\n";                                      	

    	// ########## Group-Header ###########
    	$xmlfile.="<GrpHdr>\n";
    		$xmlfile.="<MsgId>$message_id</MsgId>\n";                       //MessageIdentification
    		$xmlfile.="<CreDtTm>$message_datum</CreDtTm>\n";          		//Datum & Zeit
    		$xmlfile.="<NbOfTxs>$lst_num</NbOfTxs>\n";                      //NumberOfTransactions
    		$xmlfile.="<InitgPty>\n";
    			$xmlfile.="<Nm>$message_initiator_name</Nm>\n";
    		$xmlfile.="</InitgPty>\n";
    	$xmlfile.="</GrpHdr>\n";

    	// ########## Payment Information ##############
    	$xmlfile.="<PmtInf>\n";
    		$xmlfile.="<PmtInfId>$payment_id</PmtInfId>\n";                 //Payment-ID
    		$xmlfile.="<PmtMtd>DD</PmtMtd>\n";                              //Payment-Methode, Lastschrift: DD
    		$xmlfile.="<BtchBookg>true</BtchBookg>\n";                      //BatchBooking, Sammelbuchung (true) oder eine Einzelbuchung handelt (false)																	
    		$xmlfile.="<NbOfTxs>$lst_num</NbOfTxs>\n";                      //Number of Transactions
    		$xmlfile.="<CtrlSum>$lst_euro_sum</CtrlSum>\n";                 //Control Summe
    		$xmlfile.="<PmtTpInf>\n";                                       //PaymentTypeIn-formation
    			$xmlfile.="<SvcLvl>\n";                                     //ServiceLevel
    				$xmlfile.="<Cd>SEPA</Cd>\n";                            //Code, immer SEPA
    			$xmlfile.="</SvcLvl>\n";
    			$xmlfile.="<LclInstrm>\n";                                  //LocalInstrument, Lastschriftart
    			if($postCOR1Marker)
    			{
    				$xmlfile.="<Cd>COR1</Cd>\n";                            //COR1 (Eil-Lastschrift)                                                            		
    			}
    			else 
    			{
    				$xmlfile.="<Cd>CORE</Cd>\n";                            //CORE (Basislastschrift oder B2B (Firmenlastschrift)                                                           		
    			}
    			$xmlfile.="</LclInstrm>\n";
    			$xmlfile.="<SeqTp>$payment_seqtp</SeqTp>\n";				//SequenceType
                      														//Der SequenceType gibt an, ob es sich um eine Erst-, Folge-,
                      														//Einmal- oder letztmalige Lastschrift handelt.
                      														//Zulässige Werte: FRST, RCUR, OOFF, FNAL
                      														//Wenn <OrgnlDbtrAgt> = SMNDA und <Amdmnt-Ind> = true
                      														//dann muss dieses Feld mit FRST belegt sein.
   			$xmlfile.="</PmtTpInf>\n";
    		$xmlfile.="<ReqdColltnDt>$payment_datum</ReqdColltnDt>\n";      //RequestedCollectionDate, Fälligkeitsdatum der Lastschrift                                                             		
    		$xmlfile.="<Cdtr>\n";                                           //Creditor, Kreditor
    			$xmlfile.="<Nm>".$zempf['name']."</Nm>\n";                  //Name, max. 70 Zeichen
    		$xmlfile.="</Cdtr>\n";
    		$xmlfile.="<CdtrAcct>\n";                                       //CreditorAccount, Creditor-Konto
    			$xmlfile.="<Id>\n";
    				$xmlfile.="<IBAN>".$zempf['iban']."</IBAN>\n";
    			$xmlfile.="</Id>\n";
    		$xmlfile.="</CdtrAcct>\n";
    		$xmlfile.="<CdtrAgt>\n";                                       	//CreditorAgent, Creditor-Bank
    			$xmlfile.="<FinInstnId>\n";                                 //FinancialInstitutionIdentification
    				$xmlfile.="<BIC>".$zempf['bic']."</BIC>\n";             //Business Identifier Code
    			$xmlfile.="</FinInstnId>\n";
    		$xmlfile.="</CdtrAgt>\n";
    		$xmlfile.="<ChrgBr>SLEV</ChrgBr>\n";                           	//ChargeBearer, Entgeltverrechnungsart, immer SLEV

    		// ########## CREDITOR, Zahlungsempfänger ##############//
    		$xmlfile.="<CdtrSchmeId>\n";           							//CreditorSchemeIdentification, Identifikation des Zahlungsempfängers
    			$xmlfile.="<Id>\n";                  						//Eindeutiges Identifizierungmerkmal einer Organisation oder Person
    				$xmlfile.="<PrvtId>\n";            						//PrivateIdentification, Personenidentifikation
    					$xmlfile.="<Othr>\n";            					//OtherIdentification
    						$xmlfile.="<Id>".$zempf['ci']."</Id>\n";		//Eindeutiges Identifizierungsmerkmal des Gläubigers
    						$xmlfile.="<SchmeNm>\n";       					//SchemeName, Name des Identifikationsschemas
    							$xmlfile.="<Prtry>SEPA</Prtry>\n";          //Proprietary, immer SEPA
    						$xmlfile.="</SchmeNm>\n";
    					$xmlfile.="</Othr>\n";
    				$xmlfile.="</PrvtId>\n";
    			$xmlfile.="</Id>\n";
    		$xmlfile.="</CdtrSchmeId>\n";

    		// ######### DEBTOR Transaction Information Lastschriften ##############
    		foreach ($zpflgt as $dummy => $zpflgtdata)
			{
				$xmlfile.="<DrctDbtTxInf>\n";        						//DirectDebitTransactionInformation
        			$xmlfile.="<PmtId>\n";             						//PaymentIdentification, Referenzierung einer einzelnen Transaktion
          				//$xmlfile.="<EndToEndId>$payment_end2end_id</EndToEndId>\n";   //EndToEndIdentification
          				$xmlfile.="<EndToEndId>".$zpflgtdata['end2end_id']."</EndToEndId>\n";   //EndToEndIdentification
            							//eindeutige Referenz des Zahlers (Auftraggebers). Diese Referenz
            							//wird unverändert durch die gesamte Kette bis zum Zahlungsempfänger
            							//geleitet (Ende-zu-Ende-Referenz). Ist keine Referenz vorhanden
            							//muss die Konstante NOTPROVIDED benutzt werden.
        			$xmlfile.="</PmtId>\n";
        			$xmlfile.="<InstdAmt Ccy=\"EUR\">".$zpflgtdata['betrag']."</InstdAmt>\n";   //InstructedAmount (Dezimalpunkt)
        			$xmlfile.="<DrctDbtTx>\n";         						//DirectDebitTransaction, Angaben zum Lastschriftmandat
          				$xmlfile.="<MndtRltdInf>\n";     					//MandateRelated-Information, mandatsbezogene Informationen
            				$xmlfile.="<MndtId>".$zpflgtdata['mandat_id']."</MndtId>\n";            //eindeutige Mandatsreferenz
            				$xmlfile.="<DtOfSgntr>".$zpflgtdata['mandat_datum']."</DtOfSgntr>\n";   //Datum, zu dem das Mandat unterschrieben wurde

            				if(	   (strlen($zempf['orig_cdtr_name'])<>0) 
            					|| (strlen($zempf['orig_cdtr_id'])<>0) 
            					|| (strlen($zpflgtdata['orig_mandat_id'])<>0) 
            					|| (strlen($zpflgtdata['orig_iban'])<>0) 
            					|| (strlen($zpflgtdata['orig_dbtr_agent'])<>0) )	//Kennzeichnet, ob das Mandat verändert wurde,
            				{
            					$xmlfile.="<AmdmntInd>true</AmdmntInd>\n";  //AmendmentIndicator "true"
            					$xmlfile.="<AmdmntInfDtls>\n";            	//AmendmentInformationDetails, Pflichtfeld, falls <AmdmntInd>=true

            					if(strlen($zpflgtdata['orig_mandat_id'])<>0) 		//Kennzeichnet, ob das Mandat verändert wurde,
            					{ 
            						$xmlfile.="<OrgnlMndtId>".$zpflgtdata['orig_mandat_id']."</OrgnlMndtId>\n";
            					}
            					
            					if((strlen($zempf['orig_cdtr_name'])<>0) || (strlen($zempf['orig_cdtr_id'])<>0) )				//Kennzeichnet, ob das Mandat verändert wurde,
            					{ 
            						$xmlfile.="<OrgnlCdtrSchmeId>\n";       //Identifikation des Zahlungsempfängers
            						if(strlen($zempf['orig_cdtr_name'])<>0) //Kennzeichnet, ob das Mandat verändert wurde,
            						{ 
            							$xmlfile.="<Nm>".$zempf['orig_cdtr_name']."</Nm>\n";
            						}
            						if(strlen($zempf['orig_cdtr_id'])<>0)  
            						{
										$xmlfile.="<Id>\n";
                  							$xmlfile.="<PrvtId>\n";
                    							$xmlfile.="<Othr>\n";
                      								$xmlfile.="<Id>".$zempf['orig_cdtr_id']."</Id>\n";
                      								$xmlfile.="<SchmeNm>\n";
                        								$xmlfile.="<Prtry>SEPA</Prtry>\n";
                      								$xmlfile.="</SchmeNm>\n";
                    							$xmlfile.="</Othr>\n";
                  							$xmlfile.="</PrvtId>\n";
                						$xmlfile.="</Id>\n";            							
            						}
            						$xmlfile.="</OrgnlCdtrSchmeId>\n";						
            					}						
            						
            				    if(strlen($zpflgtdata['orig_iban'])<>0) 			//Kennzeichnet, ob das Mandat verändert wurde,
            					{ 
            						$xmlfile.="<OrgnlDbtrAcct>\n";
                  						$xmlfile.="<Id>\n";
            								$xmlfile.="<IBAN>".$zpflgtdata['orig_iban']."</IBAN>\n";
            							$xmlfile.="</Id>\n";
                  					$xmlfile.="</OrgnlDbtrAcct>\n";
            					}
            					              			 				
            				    if(strlen($zpflgtdata['orig_dbtr_agent'])<>0) 		//Kennzeichnet, ob das Mandat verändert wurde,
            					{ 
            						$xmlfile.="<OrgnlDbtrAgt>\n";
                  						$xmlfile.="<FinInstnId>\n";
                  							$xmlfile.="<Othr>\n";
            									$xmlfile.="<Id>".$zpflgtdata['orig_dbtr_agent']."</Id>\n";
            								$xmlfile.="</Othr>\n";
            							$xmlfile.="</FinInstnId>\n";
                  					$xmlfile.="</OrgnlDbtrAgt>\n";
            					}                      							
              						
            					$xmlfile.="</AmdmntInfDtls>\n";
            				}
 							else
 							{
            					$xmlfile.="<AmdmntInd>false</AmdmntInd>\n"; 	//AmendmentIndicator "false"
  							}                                                   
          				$xmlfile.="</MndtRltdInf>\n";
        			$xmlfile.="</DrctDbtTx>\n";
        					
        			//## Kreditinstitut des Zahlers (Zahlungspflichtigen)
        			// BIC ist Pflicht bis Feb 2014!
        				$xmlfile.="<DbtrAgt>\n";                         		//DebtorAgent, Kreditinstitut des Zahlers (Zahlungspflichtigen)
          					$xmlfile.="<FinInstnId>\n"; 						//FinancialInstitutionIdentification 		
          					if(strlen($zpflgtdata['bic'])<>0) 		//ist ein BIC vorhanden?
            				{ 
            					$xmlfile.="<BIC>".$zpflgtdata['bic']."</BIC>\n";
            				}
            				else 
            				{
            					$xmlfile.="<Othr>\n";
            						$xmlfile.="<Id>NOTPROVIDED</Id>\n";
            					$xmlfile.="</Othr>\n";
            				}	
          					$xmlfile.="</FinInstnId>\n";
        				$xmlfile.="</DbtrAgt>\n";					
			
        			$xmlfile.="<Dbtr>\n";                         				//Zahlungspflichtiger
          				$xmlfile.="<Nm>".$zpflgtdata['name']."</Nm>\n";     	//Name (70)
        			$xmlfile.="</Dbtr>\n";
        			$xmlfile.="<DbtrAcct>\n";
          				$xmlfile.="<Id>\n";
            				$xmlfile.="<IBAN>".$zpflgtdata['iban']."</IBAN>\n";
          				$xmlfile.="</Id>\n";
        			$xmlfile.="</DbtrAcct>\n";		
					if(strlen($zpflgtdata['alt_name'])>0)
					{
        				$xmlfile.="<UltmtDbtr>\n";                       		//UltimateDebtor
          					$xmlfile.="<Nm>".$zpflgtdata['alt_name']."</Nm>\n";
        				$xmlfile.="</UltmtDbtr>\n";		
					}	
        			$xmlfile.="<RmtInf>\n";                              		// Remittance Information, Verwendungszweck
          				$xmlfile.="<Ustrd>".$zpflgtdata['text']."</Ustrd>\n";   //Unstructured, unstrukturierter Verwendungszweck(max. 140 Zeichen))
        			$xmlfile.="</RmtInf>\n";
      			$xmlfile.="</DrctDbtTxInf>\n";
			}
		
    	// ########## Ende Payment Information ##############
    	$xmlfile.="</PmtInf>\n";
    
    // ######## Ende der Payment Information ############
    $xmlfile.="</CstmrDrctDbtInitn>\n";
		
    //Ende Customer Debit Transfer Initiation
	$xmlfile.="</Document>\n";

	/******************************************************************************
 	* Schreibt XML-Datei
 	*****************************************************************************/

	header("content-type: text/xml");
	header('Cache-Control: private');// noetig fuer IE, da ansonsten der Download mit SSL nicht funktioniert
	header("Content-Transfer-Encoding: binary");// Im Grunde ueberfluessig, hat sich anscheinend bewährt
	header("Cache-Control: post-check=0, pre-check=0"); // Zwischenspeichern auf Proxies verhindern
	header('Content-Disposition: attachment; filename="'.$config_ini['SEPA']['dateiname'].'-'.($postCOR1Marker ?'COR1-' :'').$postDueDate.'-'.$postSepaType.'.xml"');
	
	echo $xmlfile;
	die();
}
elseif (isset($_POST['xml_kontroll_datei']))
{
	// Dateityp, der immer abgespeichert wird
	header("Content-Type: application/octet-stream");

	// noetig fuer IE, da ansonsten der Download mit SSL nicht funktioniert
	header('Cache-Control: private');

	// Im Grunde ueberfluessig, hat sich anscheinend bewährt
	header("Content-Transfer-Encoding: binary");

	// Zwischenspeichern auf Proxies verhindern
	header("Cache-Control: post-check=0, pre-check=0");
	header('Content-Disposition: attachment; filename="'.$config_ini['SEPA']['kontroll_dateiname'].'-'.($postCOR1Marker ?'COR1-' :'').$postDueDate.'-'.$postSepaType.'.csv"');

	$datumtemp = new DateTimeExtended($payment_datum, 'Y-m-d', 'date');
	
	echo "SEPA-".$gL10n->get('PMB_CONTROL_FILE')."\n\n"
        .$gL10n->get('PMB_CONTROL_FILE_NAME').";".$config_ini['SEPA']['kontroll_dateiname'].'-'.($postCOR1Marker ?'COR1-' :'').$postDueDate.'-'.$postSepaType.'.csv'."\n"
        ."\n"
        .$gL10n->get('PMB_MESSAGE_ID').";".utf8_decode($message_id)."\n"
        .$gL10n->get('PMB_MESSAGE_DATE').";".utf8_decode($message_datum)."\n"
        .$gL10n->get('PMB_MESSAGE_INITIATOR_NAME').";".utf8_decode($message_initiator_name)."\n"
        .$gL10n->get('PMB_NUMBER_TRANSACTIONS').";".utf8_decode($lst_num)."\n"
        .$gL10n->get('PMB_CONTROL_SUM').";".utf8_decode($lst_euro_sum)."\n"
        ."\n"
        .$gL10n->get('PMB_PAYMENT_ID').";".utf8_decode($payment_id)."\n"
        .$gL10n->get('PMB_DUEDATE').";".$datumtemp->format($gPreferences['system_date'])."\n"
        .$gL10n->get('PMB_SEQUENCETYPE').";".utf8_decode($payment_seqtp)."\n"
        ."\n"
        .$gL10n->get('PMB_CREDITOR').";".utf8_decode($zempf['name'])."\n"
		.$gL10n->get('PMB_CI').";".utf8_decode($zempf['ci'] )."\n"
        .$gL10n->get('PMB_IBAN').";".utf8_decode($zempf['iban'])."\n"
        .$gL10n->get('PMB_BIC').";".utf8_decode($zempf['bic'])."\n"  
        ."\n"
		.$gL10n->get('PMB_ORIG_CI').";".utf8_decode($zempf['orig_cdtr_id'] )."\n"
        .$gL10n->get('PMB_ORIG_CREDITOR').";".utf8_decode($zempf['orig_cdtr_name'])."\n\n" ;  	
        	
	echo($gL10n->get('PMB_SERIAL_NUMBER').";"
		.$gL10n->get('PMB_ACCOUNT_HOLDER').";"            
		.$gL10n->get('PMB_IBAN').";"
		.$gL10n->get('PMB_BIC').";"
		.$gL10n->get('PMB_FEE').";"
		.$gL10n->get('PMB_CONTRIBUTORY_TEXT').";"
		.$gL10n->get('PMB_MANDATEID').";"
		.$gL10n->get('PMB_MANDATEDATE').";"
		.$gL10n->get('PMB_ULTIMATE_DEBTOR').";"
		.$gL10n->get('PMB_ORIG_MANDATEID').";"
		.$gL10n->get('PMB_ORIG_IBAN').";"
		.$gL10n->get('PMB_ORIG_DEBTOR_AGENT')."\n");
	
	$nr = 1;
	foreach ($zpflgt as $dummy => $zpflgtdata)
	{
        $datumtemp = new DateTimeExtended($zpflgtdata['mandat_datum'], 'Y-m-d', 'date');
                
		echo
         	utf8_decode($nr).";"
        	.utf8_decode($zpflgtdata['name']).";"
        	.utf8_decode($zpflgtdata['iban']).";"
        	.utf8_decode($zpflgtdata['bic']).";"
        	.utf8_decode($zpflgtdata['betrag']).";"
        	.utf8_decode($zpflgtdata['text']).";"
        	.utf8_decode($zpflgtdata['mandat_id']).";"
        	.$datumtemp->format($gPreferences['system_date']).";"
			.utf8_decode($zpflgtdata['alt_name']).";"
			.utf8_decode($zpflgtdata['orig_mandat_id']).";"
        	.utf8_decode($zpflgtdata['orig_iban']).";"
        	.utf8_decode($zpflgtdata['orig_dbtr_agent'])        	
        	."\n";
    	$nr += 1;        	  	
	}       
	exit;  
}
elseif (isset($_POST['xml_begleitzettel']))    
{
    header('Content-type: text/html; charset=utf-8');
 	$datumtemp = new DateTimeExtended($payment_datum, 'Y-m-d', 'date'); 
 	      
    echo '
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="de" xml:lang="de">
    <head>
        <!-- (c) 2004 - 2011 The Admidio Team - http://www.admidio.org -->
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <title> - Liste - </title>
        <style type="text/css">
                @page { size:landscape; }
        </style>
    </head>
    <body class="bodyPrint" >
        <table border="0"   >
            <tbody valign="bottom" align = "left">
                <tr >
                    <td colspan = "2"><h2>'.$gL10n->get('PMB_ESCORT_NOTEPAPER').'</h2></td>
                </tr>
                <tr >
                    <td colspan = "2"><h3>'.$gL10n->get('PMB_PAPERLESS_DATA_EXCHANGE').'</h3></td>
                </tr>
                <tr >
                    <td colspan = "2" height = "40">'.$gL10n->get('PMB_COLLECTION_ORDER').'</td>
                </tr>
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_MESSAGE_ID').':</td>
                    <td>'.utf8_decode($message_id).'</td>
                </tr>
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_MESSAGE_DATE').':</td>
                    <td>'.utf8_decode($message_datum).'</td>
                </tr>                
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_MESSAGE_INITIATOR_NAME').':</td>
                    <td>'.utf8_decode($message_initiator_name).'</td>
                </tr>  
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_NUMBER_TRANSACTIONS').':</td>
                    <td>'.utf8_decode($lst_num).'</td>
                </tr> 
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_CONTROL_SUM').':</td>
                    <td>'.utf8_decode($lst_euro_sum).'</td>
                </tr>                 
        		<tr height = "60">
                    <td>'.$gL10n->get('PMB_PAYMENT_ID').':</td>
                    <td>'.utf8_decode($payment_id).'</td>
                </tr>                 
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_DUEDATE').':</td>
                    <td>'.$datumtemp->format($gPreferences['system_date']).'</td>
                </tr>                                    
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_SEQUENCETYPE').':</td>
                    <td>'.utf8_decode($payment_seqtp).'</td>
                </tr>                  
        		<tr height = "60">
                    <td>'.$gL10n->get('PMB_CREDITOR').':</td>
                    <td>'.utf8_decode($zempf['name']).'</td>
                </tr>                  
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_CI').':</td>
                    <td>'.utf8_decode($zempf['ci'] ).'</td>
                </tr>                                       
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_IBAN').':</td>
                    <td>'.utf8_decode($zempf['iban']).'</td>
                </tr>                 
        		<tr height = "40">
                    <td>'.$gL10n->get('PMB_BIC').':</td>
                    <td>'.utf8_decode($zempf['bic']).'</td>
                </tr>                 
                <tr height = "80" valign = "bottom">
                    <td>_______________________________________________</td>
                    <td>&#160;</td>
                </tr>
                <tr>
                    <td colspan = "2">Ort, Datum, Unterschrift</td>
                </tr>
                <tr height = "40" valign = "bottom">
                    <td colspan = "2">Auftragsdatei: '.$config_ini['SEPA']['dateiname'].'-'.$postDueDate.'-'.$postSepaType.'.xml</td>
                </tr>
            </tbody>
        </table>
    </body> ';
    exit;   
}
?>