<?php
/******************************************************************************
 * 
 * zahlungen_get.php
 *   
 * Setzen eines Bezahlt-Datums fuer das Admidio-Plugin Mitgliedsbeitrag
 *    Unterprogramm zum Einlesen den Mitglieder
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Hinweis: zahlungen_get.php ist eine modifizierte members_get.php
 * 
 * Parameters:
 *
 * mem_show_all : 				1 - alle Benutzer anzeigen
 *                				0 - (ein anderer mem_show... ist aktiv)
 * mem_show_with : 				1 - nur Benutzer anzeigen, die ein Bezahlt-Datum besitzen
 *                				0 - (ein anderer mem_show... ist aktiv)
 * mem_show_without : 			1 - nur Benutzer anzeigen, die kein Bezahlt-Datum besitzen
 *                				0 - (ein anderer mem_show... ist aktiv)
 * Hinweis: nur ein mem_show-Schalter kann immer aktiv gesetzt sein      
 *                                              
 * mem_search   : Suchstring nach dem Mitglieder angezeigt werden sollen
 *
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

require_once(dirname(__FILE__).'/common_function.php');

// Initialize and check the parameters
$postMembersShowAll 		= admFuncVariableIsValid($_POST, 'mem_show_all', 'string', 'off');
$postMembersShowWith 		= admFuncVariableIsValid($_POST, 'mem_show_with', 'string', 'off');
$postMembersShowWithout 	= admFuncVariableIsValid($_POST, 'mem_show_without', 'string', 'off');
$postMembersSearch  		= admFuncVariableIsValid($_POST, 'mem_search', 'string');
$postOrderByDateAsc			= admFuncVariableIsValid($_POST, 'order_by_date_asc', 'string', 'off');
$postOrderByDateDesc		= admFuncVariableIsValid($_POST, 'order_by_date_desc', 'string', 'off');

$rolesString = '';
$getTeilStringLength	= admFuncVariableIsValid($_GET, 'teilStringLength', 'numeric');
for ($i=1;$i<=$getTeilStringLength;$i++)
{
	$rolesString .= admFuncVariableIsValid($_GET, 'teilString'.$i, 'string');
}

$limit = '';

// Filter zusammensetzen
$member_condition = ' EXISTS 
	(SELECT 1
	FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES.  ','. TBL_USER_DATA. '	
	WHERE mem_usr_id = usr_id
	AND mem_rol_id = rol_id
	AND mem_begin <= \''.DATE_NOW.'\'
	AND mem_end    > \''.DATE_NOW.'\'
	AND rol_valid  = 1
	AND rol_id IN ('.$rolesString.')
	AND rol_cat_id = cat_id
	AND (  cat_org_id = '. $gCurrentOrganization->getValue('org_id'). '
		OR cat_org_id IS NULL ) ';

if($postMembersShowWith == 'on')
{
	$member_condition .= ' AND usd_usr_id = usr_id
		AND usd_usf_id = '. $gProfileFields->getProperty('BEZAHLT'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). '
    	AND usd_value IS NOT NULL )';
}
else 
{
	$member_condition .= ' AND usd_usr_id = usr_id
		AND usd_usf_id = '. $gProfileFields->getProperty('BEITRAG'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). '
		AND usd_value IS NOT NULL )';
}

if ($postOrderByDateAsc =='on')
{
	$orderByDate = 'bezahlt ASC, ';
}
elseif ($postOrderByDateDesc =='on')
{
	$orderByDate = 'bezahlt DESC, ';
}
else
{
	$orderByDate = '';
}

//Suchstring zerlegen
if(strlen($postMembersSearch) > 0)
{
    $postMembersSearch = str_replace('%', ' ', $postMembersSearch);
    $search_therms = explode(' ', $postMembersSearch);
    
    if(count($search_therms)>0)
    {
    	//in Condition einbinden
	    foreach($search_therms as $search_therm)
	    {
	    	$member_condition .= ' AND (  (UPPER(last_name.usd_value)  LIKE UPPER(\''.$search_therm.'%\')) 
									   OR (UPPER(first_name.usd_value) LIKE UPPER(\''.$search_therm.'%\'))) ';
	    }
    }
    //Ergebnissmenge Limitieren
    $limit .= ' LIMIT 30 ';
}

 // SQL-Statement zusammensetzen
$sql = 'SELECT DISTINCT usr_id, last_name.usd_value as last_name, first_name.usd_value as first_name, birthday.usd_value as birthday,
               city.usd_value as city, address.usd_value as address, zip_code.usd_value as zip_code, country.usd_value as country,
               bezahlt.usd_value as bezahlt,beitrag.usd_value as beitrag,lastschrifttyp.usd_value as lastschrifttyp,
               debtor.usd_value as debtor, debtoraddress.usd_value as debtoraddress,
               debtorpostcode.usd_value as debtorpostcode, debtorcity.usd_value as debtorcity, debtoremail.usd_value as debtoremail,
               email.usd_value as email
        FROM '. TBL_USERS. '
        LEFT JOIN '. TBL_USER_DATA. ' as last_name
          ON last_name.usd_usr_id = usr_id
         AND last_name.usd_usf_id = '. $gProfileFields->getProperty('LAST_NAME', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as first_name
          ON first_name.usd_usr_id = usr_id
         AND first_name.usd_usf_id = '. $gProfileFields->getProperty('FIRST_NAME', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as birthday
          ON birthday.usd_usr_id = usr_id
         AND birthday.usd_usf_id = '. $gProfileFields->getProperty('BIRTHDAY', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as city
          ON city.usd_usr_id = usr_id
         AND city.usd_usf_id = '. $gProfileFields->getProperty('CITY', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as address
          ON address.usd_usr_id = usr_id
         AND address.usd_usf_id = '. $gProfileFields->getProperty('ADDRESS', 'usf_id'). '
       	LEFT JOIN '. TBL_USER_DATA. ' as bezahlt
          ON bezahlt.usd_usr_id = usr_id
         AND bezahlt.usd_usf_id = '. $gProfileFields->getProperty('BEZAHLT'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). ' 
        LEFT JOIN '. TBL_USER_DATA. ' as beitrag
          ON beitrag.usd_usr_id = usr_id
         AND beitrag.usd_usf_id = '. $gProfileFields->getProperty('BEITRAG'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). ' 
        LEFT JOIN '. TBL_USER_DATA. ' as lastschrifttyp
          ON lastschrifttyp.usd_usr_id = usr_id
         AND lastschrifttyp.usd_usf_id = '. $gProfileFields->getProperty('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'), 'usf_id'). ' 
         LEFT JOIN '. TBL_USER_DATA. ' as zip_code
          ON zip_code.usd_usr_id = usr_id
         AND zip_code.usd_usf_id = '. $gProfileFields->getProperty('POSTCODE', 'usf_id'). '
        LEFT JOIN '. TBL_USER_DATA. ' as debtor
          ON debtor.usd_usr_id = usr_id
         AND debtor.usd_usf_id = '. $gProfileFields->getProperty('KONTOINHABER', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as debtoraddress
          ON debtoraddress.usd_usr_id = usr_id
         AND debtoraddress.usd_usf_id = '. $gProfileFields->getProperty('DEBTORADDRESS', 'usf_id'). '    
		LEFT JOIN '. TBL_USER_DATA. ' as debtoremail
          ON debtoremail.usd_usr_id = usr_id
         AND debtoremail.usd_usf_id = '. $gProfileFields->getProperty('DEBTOREMAIL', 'usf_id'). '    
 		LEFT JOIN '. TBL_USER_DATA. ' as email
          ON email.usd_usr_id = usr_id
         AND email.usd_usf_id = '. $gProfileFields->getProperty('EMAIL', 'usf_id'). '      
         LEFT JOIN '. TBL_USER_DATA. ' as debtorpostcode
          ON debtorpostcode.usd_usr_id = usr_id
         AND debtorpostcode.usd_usf_id = '. $gProfileFields->getProperty('DEBTORPOSTCODE', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as debtorcity
          ON debtorcity.usd_usr_id = usr_id
         AND debtorcity.usd_usf_id = '. $gProfileFields->getProperty('DEBTORCITY', 'usf_id'). '    
        LEFT JOIN '. TBL_USER_DATA. ' as country
          ON country.usd_usr_id = usr_id
         AND country.usd_usf_id = '. $gProfileFields->getProperty('COUNTRY', 'usf_id'). '
       
        LEFT JOIN '. TBL_MEMBERS. ' mem
          ON  mem.mem_begin  <= \''.DATE_NOW.'\'
         AND mem.mem_end     > \''.DATE_NOW.'\'
         AND mem.mem_usr_id  = usr_id
        WHERE  '. $member_condition. '
        ORDER BY '.$orderByDate.' last_name, first_name '.$limit;

// das array durchlaufen und prüfen, ob es, wenn "ohne Bezahlt" gewählt wurde, wenigstens ein Mitglied gibt, das noch nicht bezahlt hat
// ist für die Anzeige -Es wurden keine Einträge gefunden- nötig
$datum_vorhanden = false; 
if($postMembersShowWithout == 'on')
{
	$datum_vorhanden = true ;
	$result_user = $gDb->query($sql);
	while($user = $gDb->fetch_array($result_user))
    {
    	if((strlen($user['beitrag'])>0) && (strlen($user['bezahlt'])==0) )
		{
			$datum_vorhanden = false ;
			break;
		}
    }
}   
    
$result_user = $gDb->query($sql);    
if(($gDb->num_rows($result_user)>0) && !$datum_vorhanden)
{
    //Buchstaben Navigation bei mehr als 50 personen
    if($gDb->num_rows($result_user) >= 50)
    {
        echo '<div class="pageNavigation">
            <a href="#" letter="all" class="pageNavigationLink">'.$gL10n->get('SYS_ALL').'</a>&nbsp;&nbsp;';
        
            // Nun alle Buchstaben mit evtl. vorhandenen Links im Buchstabenmenue anzeigen
            $letter_menu = 'A';
            
            for($i = 0; $i < 26;$i++)
            {
                // pruefen, ob es Mitglieder zum Buchstaben gibt
                // dieses SQL muss fuer jeden Buchstaben ausgefuehrt werden, ansonsten werden Sonderzeichen nicht immer richtig eingeordnet
                $sql = 'SELECT COUNT(1) as count
                          FROM '. TBL_USERS. ', '. TBL_USER_FIELDS. ', '. TBL_USER_DATA. '
                         WHERE usr_valid  = 1
                           AND usf_name_intern = \'LAST_NAME\'
                           AND usd_usf_id = usf_id
                           AND usd_usr_id = usr_id
                           AND usd_value LIKE \''.$letter_menu.'%\'
                           AND '.$member_condition.'
                         GROUP BY UPPER(SUBSTRING(usd_value, 1, 1))';
                $result      = $gDb->query($sql);
                $letter_row  = $gDb->fetch_array($result);

                if($letter_row['count'] > 0)
                {
                    echo '<a href="#" letter="'.$letter_menu.'" class="pageNavigationLink">'.$letter_menu.'</a>';
                }
                else
                {
                    echo $letter_menu;
                }
        
                echo '&nbsp;&nbsp;';
        
                $letter_menu = strNextLetter($letter_menu);
            }
        echo '</div>';    
    }
    
    //Tabelle anlegen
    echo '
    <table class="tableList" cellspacing="0">
        <thead>
            <tr>
                <th style="text-align: center;">'.$gL10n->get('PMB_PAID').'</th>
                <th>'.$gL10n->get('PMB_PAID_ON').'</th>
                <th><img class="iconDirectDEbitType" src="'. THEME_PATH. '/icons/comments.png" 
                    alt="'.$gL10n->get('PMB_DITRCTDEBITTYPE').'" title="'.$gL10n->get('PMB_SEQUENCETYPE_DESC').'" /></th>
                <th>'.$gL10n->get('PMB_FEE').'</th>
                <th>'.$gL10n->get('SYS_LASTNAME').'</th>
                <th>'.$gL10n->get('SYS_FIRSTNAME').'</th>
                <th><img class="iconInformation" src="'. THEME_PATH. '/icons/map.png" 
                    alt="'.$gL10n->get('SYS_ADDRESS').'" title="'.$gL10n->get('SYS_ADDRESS').'" /></th>
                <th><img class="iconInformation" src="'. THEME_PATH. '/icons/info.png" 
                    alt="'.$gL10n->get('PMB_DEBTOR').'" title="'.$gL10n->get('PMB_DEBTOR').'" /></th>
                <th><img class="iconInformation"
                    src="'. THEME_PATH. '/icons/email.png" alt="'.$gL10n->get('SYS_EMAIL').'" title="'.$gL10n->get('SYS_EMAIL').'" /></th> 
                <th style="text-align: right;">'.$gL10n->get('SYS_BIRTHDAY').'</th>                          
            </tr>
        </thead>';
        
    $letter_merker = '';
    $this_letter   = '';
    
    function convSpecialChar($specialChar)
    {
        $convTable = array('Ä' => 'A', 'É' => 'E', 'È' => 'E', 'Ö' => 'O', 'Ü' => 'U');
        
        if(array_key_exists($specialChar, $convTable))
        {
            return admstrtoupper($convTable[$specialChar]);
        }
        return $specialChar;
    }

    //Zeilen ausgeben
    while($user = $gDb->fetch_array($result_user))
    {
    	
    	if(($postMembersShowWithout == 'on') && (strlen($user['beitrag'])>0) && (strlen($user['bezahlt'])>0) )
		{
			continue;
		}
    	
    	if($gDb->num_rows($result_user) >= 50)
    	{
            // Buchstaben auslesen
            $this_letter = admstrtoupper(substr($user['last_name'], 0, 1));
            
            if(ord($this_letter) < 65 || ord($this_letter) > 90)
            {
                $this_letter = convSpecialChar(substr($user['last_name'], 0, 2));
            }
            
            if($this_letter != $letter_merker)
            {
                if(mb_strlen($letter_merker) > 0)
                {
                    echo '</tbody>';
                }

                // Ueberschrift fuer neuen Buchstaben
                echo '<tbody block_head_id="'.$this_letter.'" class="letterBlockHead">
                    <tr>
                        <td class="tableSubHeader" colspan="10">
                            '.$this_letter.'
                        </td>
                    </tr>
                </tbody>
                <tbody block_body_id="'.$this_letter.'" class="letterBlockBody">';

                // aktuellen Buchstaben merken
                $letter_merker = $this_letter;
            }
        }

        //Datensatz ausgeben
        $user_text = '';
        if(strlen($user['address']) > 0)
        {
            $user_text = $user['address'];
        }
        if(strlen($user['zip_code']) > 0 || strlen($user['city']) > 0)
        {
            $user_text = $user_text. ' - '. $user['zip_code']. ' '. $user['city'];
        }
        if(strlen($user['country']) > 0)
        {
            $user_text = $user_text. ' - '. $user['country'];
        }
        
        //Datensatz für Zahlungspflichtigen zusammensetzen
        $debtor_text = '';
        if(strlen($user['debtor']) > 0)
        {
            $debtor_text = $user['debtor'];
        }
        if(strlen($user['debtoraddress']) > 0)
        {
            $debtor_text = $debtor_text. ' - '. $user['debtoraddress'];
        }
        if(strlen($user['debtorpostcode']) > 0 || strlen($user['debtorcity']) > 0)
        {
            $debtor_text = $debtor_text. ' - '. $user['debtorpostcode']. ' '. $user['debtorcity'];
        }
        
        //Datensatz für E-Mail-Adresse zusammensetzen
        $email = '';
        if(strlen($user['debtor']) > 0)
        {
			if(strlen($user['debtoremail']) > 0)
			{
				$email = $user['debtoremail'];				
			}         	
        }
        else 
        {
			if(strlen($user['email']) > 0)
			{
				$email = $user['email'];				
			}         	
        }
        
        echo '
        <tr class="tableMouseOver" user_id="'.$user['usr_id'].'">
            <td style="text-align: center;">';
                //Haekchen setzen ob jemand bezahlt hat oder nicht
                if(strlen($user['bezahlt']) > 0)
                {
                    echo '<input type="checkbox" id="member_'.$user['usr_id'].'" name="member_'.$user['usr_id'].'" checked="checked" class="memlist_checkbox" checkboxtype="member" />';
                }
                else
                {
                    echo '<input type="checkbox" id="member_'.$user['usr_id'].'" name="member_'.$user['usr_id'].'" class="memlist_checkbox" checkboxtype="member"/>';
                }
            echo'<td>';
                //Bezahlt-Datum ausgeben
                $bezahltDate = new DateTimeExtended($user['bezahlt'], 'Y-m-d', 'date');
                // über div class gehen, da ansonsten jquery die id nicht auslesen kann
                echo '<div class="text_'.$user['usr_id'].'"><label for="bezahlt"  />'.((strlen($user['bezahlt']) > 0)? $bezahltDate->format($gPreferences['system_date']):"").'</label></div>';
            echo '</td>'; 
    		switch($user['lastschrifttyp'])
        	{
        		case 'RCUR':
        			$lastschrifttyp_short = 'R';
        		break;
        		case 'FNAL':
        			$lastschrifttyp_short = 'F';
        		break;
        		case 'OOFF':
        			$lastschrifttyp_short = 'O';
        		break;
        		default:
        			$lastschrifttyp_short = ' ';
        		break;
        	}
            echo'<td>';
            	//Lastschrifttyp ausgeben
            	// über div class gehen, da ansonsten jquery die id nicht auslesen kann
            	echo '<div class="typ_'.$user['usr_id'].'"><label for="lastschrifttyp"  />'.$lastschrifttyp_short.'</label></div>';
            echo '</td>'; 
            echo '<td style="text-align: right;">'.$user['beitrag'].' '.$gPreferences['system_currency'].'</td>'; 
            echo '<td><a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $user['usr_id']. '">'.$user['last_name']. '</a></td>
            <td>'.$user['first_name'].'</td>
            <td>';
            	if(strlen($user_text) > 0)
                {
                    echo '<img class="iconInformation" src="'. THEME_PATH.'/icons/map.png" alt="'.$user_text.'" title="'.$user_text.'" />';
                }
                else
                {
                    echo '&nbsp';
                }
            echo '</td>
            <td>';
            	if(strlen($debtor_text) > 0)
                {
                    echo '<img class="iconInformation" src="'. THEME_PATH.'/icons/info.png" alt="'.$debtor_text.'" title="'.$debtor_text.'" />';
                }
                else
                {
                    echo '&nbsp';
                }
            echo '</td>
            <td>';
				if(strlen($email) > 0)
				{
					if($gPreferences['enable_mail_module'] != 1)
					{
						$mail_link = 'mailto:'. $email;
					}
					else
					{
						$mail_link = $g_root_path.'/adm_plugins/'.$plugin_folder.'/common_mail.php?usr_id='. $user['usr_id'];			
					}
					echo '<a class="iconLink" href="'.$mail_link.'"><img src="'. THEME_PATH. '/icons/email.png"
							alt="'.$gL10n->get('SYS_SEND_EMAIL_TO', $email).'" title="'.$gL10n->get('SYS_SEND_EMAIL_TO', $email).'" /></a>';
				}
    			else
                {
                    echo '&nbsp';
                }
			echo '</td>            
            <td style="text-align: right;">';
                //Geburtstag nur ausgeben wenn bekannt
                if(strlen($user['birthday']) > 0)
                {
                    $birthdayDate = new DateTimeExtended($user['birthday'], 'Y-m-d', 'date');
                    echo $birthdayDate->format($gPreferences['system_date']);
                }
            echo '</td>
        </tr>';
    }//End While

    echo '</table>
    <p>'.$gL10n->get('SYS_CHECKBOX_AUTOSAVE').'</p>';
    
    //Hilfe nachladen
    echo '<script type="text/javascript">$("a[rel=\'colorboxHelp\']").colorbox({preloading:true,photo:false,speed:300,rel:\'nofollow\'})</script>';
}
else
{
	echo '<p>'.$gL10n->get('SYS_NO_ENTRIES_FOUND').'</p>';
}
?>