<?php
/******************************************************************************
 * 
 * zahlungen_save.php
 *   
 * Funktion um das Bezahlt-Datum fuer das Admidio-Plugin Mitgliedsbeitrag zu setzen oder zu loeschen 
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Parameters:
 *
 * usr_id       	: ID des Mitglieds desssen Bezahlt-Markierung geändert werden soll
 * datum_neu 		: das neue Bezahlt-Datum
 * mem_show_all 	:	1 - alle Benutzer anzeigen (default)
 *                	  	0 - (ein anderer mem_show... ist aktiv)
 * mem_show_with 	: 	1 - nur Benutzer anzeigen, die ein Bezahlt-Datum besitzen
 *                	  	0 - (ein anderer mem_show... ist aktiv)
 * mem_show_without : 	1 - nur Benutzer anzeigen, die kein Bezahlt-Datum besitzen
 *                		0 - (ein anderer mem_show... ist aktiv)
 * Hinweis: 1. wird ein mem_show-Schalter übergeben, dann ist immer einer (und nur einer) aktiv gesetzt  
 * 			2. abhängig vom aufrufenden Link wird entweder usr_id übergeben oder die mem_schow-Schalter
 * 			   usr_id wenn nur ein User gewählt wurde, bei "alle ändern" wird keine usr_id übergeben,
 * 			   sondern nur die mem_show-Schalter (datum_neu wird immer übergeben)  
 *
 * teilStringX		: Strings mit rol_ids (teilString1, teilString2 usw)
 * teilStringLength	: Anzahl der Strings (mit rol_ids)
 * 
 ****************************************************************************/
  
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');
require_once(dirname(__FILE__).'/common_function.php');

$getUserId 				= admFuncVariableIsValid($_GET, 'usr_id', 'numeric', 0);
$getDatumNeu 			= admFuncVariableIsValid($_GET, 'datum_neu', 'date');
$getMembersShowAll 		= admFuncVariableIsValid($_GET, 'mem_show_all', 'boolean', 'false');
$getMembersShowWith 	= admFuncVariableIsValid($_GET, 'mem_show_with', 'boolean', 'false');
$getMembersShowWithout 	= admFuncVariableIsValid($_GET, 'mem_show_without', 'boolean', 'false');

if($getUserId<>0)			// Bezahlt-Datum nur für einen einigen User ändern
{
	$members = array($getUserId => 'dummy');
	$getMembersShowAll = true;	
}
else 						// "alle ändern" wurde gewählt
{
	$rolesString = '';
	$getTeilStringLength	= admFuncVariableIsValid($_GET, 'teilStringLength', 'numeric');
	for ($i=1;$i<=$getTeilStringLength;$i++)
	{
		$rolesString .= admFuncVariableIsValid($_GET, 'teilString'.$i, 'string');
	}
	$rols_array = explode ( ',', $rolesString );

	$select_array = array();
	foreach ($rols_array as $rol_ID)
	{
		$role = new TableRoles($gDb, $rol_ID);
		$select_array[$role->getValue('rol_name')] = 0;
	}
	
	// alle Mitglieder einlesen, aber nur die in den gewählten Rollen
	$members = list_members(array('BEITRAG'.$gCurrentOrganization->getValue('org_id')), $select_array);

	$ret = 'multi_change';
}

foreach ($members as $key => $data)
{
	$user = new User($gDb, $gProfileFields, $key);
	
	// Filter ist gesetzt auf nur die, die bezahlt haben
	// --> nur die bearbeiten, bei denen BEZAHLT nicht NULL ist und hier den Eintrag löschen
	// oder Filter ist gesetzt auf alle Benutzer anzeigen, dann auch abarbeiten
   	if( strlen($user->getValue('BEZAHLT'.$gCurrentOrganization->getValue('org_id')))<>0 
   		&&  strlen($user->getValue('BEITRAG'.$gCurrentOrganization->getValue('org_id')))<>0
   		&&  ( $getMembersShowWith=='true' || $getMembersShowAll=='true') )
   	{ 
        $user->setValue('BEZAHLT'.$gCurrentOrganization->getValue('org_id'), '');
   		
        //Rückgabewert setzen
        if($getUserId<>0)
		{
			$ret= 'single_delete';
		}	
   	}

   	// Filter ist gesetzt auf nur die, die nicht bezahlt haben
	// --> nur die bearbeiten, bei denen BEZAHLT NULL ist und hier einen Eintrag setzen
	// oder Filter ist gesetzt auf alle Benutzer anzeigen, dann auch abarbeiten
	else if( strlen($user->getValue('BEZAHLT'.$gCurrentOrganization->getValue('org_id')))==0 
		&&  strlen($user->getValue('BEITRAG'.$gCurrentOrganization->getValue('org_id')))<>0
   		&&  ( $getMembersShowWithout=='true' || $getMembersShowAll=='true') )
   	{ 
   		//Rückgabewert setzen
   		if($getUserId<>0)
		{
			$ret= 'single_set';
		}
		
   		$user->setValue('BEZAHLT'.$gCurrentOrganization->getValue('org_id'), $getDatumNeu);	
   		
   		// wenn Lastschrifttyp noch nicht gesetzt ist: als Folgelastschrift kennzeichnen
		// BEZAHLT bedeutet, es hat bereits eine Zahlung stattgefunden
		// die nächste Zahlung kann nur eine Folgelastschrift sein
		//Lastschrifttyp darf aber nur geändert werden, wenn der Einzug per SEPA stattfand, also ein Fälligkeitsdatum vorhanden ist
		if ( strlen($user->getValue('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'))) == 0  && strlen($user->getValue('DUEDATE'.$gCurrentOrganization->getValue('org_id'))) <> 0 )
		{
			$user->setValue('SEQUENCETYPE'.$gCurrentOrganization->getValue('org_id'), 'RCUR');

			//Rückgabewert überschreiben, inkl. SeqTypeÄnderung
	        if($getUserId<>0)
			{
				$ret= 'single_set_seqtypeset';
			}	
		}
		
   		//falls Daten von einer Mandatsänderung vorhanden sind, diese löschen
		if (strlen($user->getValue('ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'))) <> 0 )
		{
			$user->setValue('ORIGMANDATEID'.$gCurrentOrganization->getValue('org_id'), '');	
		}
		if (strlen($user->getValue('ORIGIBAN')) <> 0 )
		{
			$user->setValue('ORIGIBAN', '');	
		}
		if (strlen($user->getValue('ORIGDEBTORAGENT')) <> 0 )
		{
			$user->setValue('ORIGDEBTORAGENT', '');	
		}
		
		//das Fälligkeitsdatum löschen (wird nicht mehr gebraucht, da ja bezahlt)
		if (strlen($user->getValue('DUEDATE'.$gCurrentOrganization->getValue('org_id'))) <> 0 )
		{
			$user->setValue('DUEDATE'.$gCurrentOrganization->getValue('org_id'), '');	
		}			
   	}
   	$user->save();
}

echo $ret;  


?>