<?php
/******************************************************************************
 * Installationsskript für das Statistik-Plugin
 *
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 *
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.htm
 *
 * Parameters:
 *
 * install-state =  1 : (Default) Initialisierung des Installationsvorgangs
 *                  2 : Prüfung auf vorhandene Installationen
 *                  3 : Backup vorhandener Daten
 *                  4 : Installationsvorgang
 *                  5 : Recovery vorhandener Daten
 *                  6 : Abschluss der Installation
 *
 * backup        =  ja    :   es wurde ein Backup gewünscht, Recovery ausführen
 *                  sonst :   es wurde kein Backup gewünscht, Recovery überspringen
 *
 *****************************************************************************/
//Import benötigter Skripts
require_once('../includes.php');
require_once(SERVER_PATH. '/config.php');
require_once(SERVER_PATH. '/adm_program/system/overall_header.php');
require_once(STATISTICS_PATH.'/statistic_objects/statistic.php');
require_once(STATISTICS_PATH.'/utils/db_access.php');

echo '<h1 class="formHead">Statistik-Plugin Installation</h1>';

//Überprüfen, ob der Benutzer Zugriff auf die Seite hat
$hasAccess = false;
foreach ($plgAllowInstall AS $i)
{
    if($i == 'Benutzer'
        && $gValidLogin == true)
    {
        $hasAccess = true;
    }
    elseif($i == 'Rollenverwalter'
        && $gCurrentUser->assignRoles())
    {
        $hasAccess = true;
    }
    elseif($i == 'Listenberechtigte'
        && $gCurrentUser->viewAllLists())
    {
        $hasAccess = true;
    }
    elseif(hasRole($i))
    {
        $hasAccess = true;
    }
}

if($hasAccess == true) {
    //Übergabevariablen prüfen
    if (isset($_POST['install-state']) && is_numeric($_POST['install-state'])){
        $installState = $_POST['install-state'];
    }else{
        $installState = 1;
    }

    if (isset($_POST['backup']) && $_POST['backup'] == "ja"){
        $backupDesired = true;
    }else{
        $backupDesired = false;
    }


    // Aufrufen der Entsprechenden Installationsschrittes
    if ($installState == 1){
        echo "<p>Willkommen zur Installation des Admidio-Statistik-Plugin</p>";
        askInstallationStart();
    }elseif ($installState == 2){
        echo "<p>Es wird jetzt geprüft, ob bereits eine Version des Statistik-Plugins installiert ist:</p>";
        if (checkPreviousInstallations()) {
            echo "<p style='color:orangered;'>Es ist bereits eine Version des Plugin installiert. <br/> Bitte das Plugin zuerst deinstallieren.</p>";
            showActionButton('home');
        } else {
            echo "<p>Es wurde keine installierte Version gefunden.</p>";
            showActionButton('install');
        }
    }elseif ($installState == 3){
        echo "<p>Es ist bereits eine Version des Statistik-Plugins installiert, bitte geben sie an, ob vorhandene Statistik-Definitionen beibehalten werden sollen.</p>";
    }elseif ($installState == 4){
        if (checkPreviousInstallations()) {
            echo "<p style=':orangered;'>Es ist bereits eine Version des Plugin installiert. Bitte diese zuerst deinstallieren.</p>";
            showActionButton('home');
        } else {
            echo "<p style='color:green;'>Das Plugin wurde installiert.</p>";
            startInstallation();
            showActionButton('config');
        }
    }elseif ($installState == 5){
        if (checkPreviousInstallations()) {
            echo "<p style='color:red;'>Mit diesem Vorgang wird das Plugin entfernt und alle gespeicherten Statistik-Konfigurationen gelöscht!</p>";
            showActionButton('uninstall');
        } else {
            echo "<p style='font-weight: bold;'>Es wurde keine installierte Version gefunden.</p>";
            showActionButton('home');
        }
    }elseif ($installState == 6){
        //echo "Installation abgeschlossen!";
        echo "<p style='color:green;'>Deinstallation erfolgreich.</p>";
        deleteOldTables();
        showActionButton('home');
    }else{
        echo "<p>Ungültiger Installations-Status</p>";
    }
} else {
    if ($gValidLogin) {
        echo '<p>Sie haben keine Berechtigung, diese Seite anzuzeigen.</p>';
    } else {
        require_once(SERVER_PATH.'/adm_program/system/login_valid.php');
    }
}

//Fragen ob die Installation gestartet werden soll.
function askInstallationStart(){
	echo "  <form action='install.php' method='post'  >
			<select name='install-state' size='1'>
				<option value='2'>Installieren</option>
				<option value='5'>Deinstallieren</option>
			</select>
			<input type='submit' name='instStart' value='Aktion ausführen'>
		</form>
	";
}


function showActionButton ($type='home') {
    switch ($type) {
        case 'home':
            $value = 1;
            $text = 'Zurück zum Start';
            $link = 'install.php';
            break;
        case 'install':
            $value = 4;
            $text = 'Plugin jetzt installieren';
            $link = 'install.php';
            break;
        case 'askUninstall':
            $value = 5;
            $text = 'Zur Deinstallation';
            $link = 'install.php';
            break;
        case 'uninstall':
            $value = 6;
            $text = 'Plugin jetzt deinstallieren';
            $link = 'install.php';
            break;
        case 'config':
            $value = 1;
            $text = 'Zum Statistikeditor';
            $link = '../gui/editor.php';
            break;
    }

    echo '<p><form action="'. $link . '" method="post"  >
                <input type="hidden" name="install-state" value="' . $value . '">
                <input type="submit" name="action" value="' . $text . '">
            </form>
           </p>
    ';
}

//Prüfung auf bereits vorhandene Tabellen in der Datenbank
function checkPreviousInstallations(){
    global $gDb;

    $sql = 'SELECT * FROM ' . TBL_STATISTICS;
    $result = $gDb->query($sql,false);
    if ($result) {
        return TRUE;
    } else {
        return FALSE;
    }
}

//Backup bereits vorhandener Statistikdefinitionen
function saveOldDefinitionData(){


}

//Installation des Plugins
function startInstallation(){
    executeSQLSktipt('db_statistic_install.sql');
    echo '<ul>';
    echo "<li>Die Tabellen für das Plugin wurden in der Admidio-Datenbank angelegt.</li>";
    addStatisticTemplates();
    echo "<li>Beispielstatistiken wurden hinzugefügt.</li>";
    echo "</ul>";
}

function addStatisticTemplates() {
    global $gCurrentOrganization;
    $currentOrgID = $gCurrentOrganization->getValue('org_id','');;


    //Leere Statistik, die für die temporäre Bearbeitung einer Statistik reserviert ist
    $statistic0 = new Statistic(null,$currentOrgID, 'TEMPORARY STATISTIC',null,null, null);

    //Altersstatistik
    $statistic1 = new Statistic(null,$currentOrgID, 'Altersstatistik ','Altersstatistik' ,'Jahr ' . date('Y'), 2);
    $tbl1 = new StatisticTable('Nach Altergsgruppen', null,'Altersgruppen');
    $tbl1->addRow(new StatisticTableRow('0-6 Jahre',new StatisticCondition('>=0j AND <=6j',10)));
    $tbl1->addRow(new StatisticTableRow('7-14 Jahre',new StatisticCondition('>=6j AND <=14j',10)));
    $tbl1->addRow(new StatisticTableRow('15-18 Jahre',new StatisticCondition('>=14j AND <=18j',10)));
    $tbl1->addRow(new StatisticTableRow('19-26 Jahre',new StatisticCondition('>=18j AND <=26j',10)));
    $tbl1->addRow(new StatisticTableRow('27-40 Jahre',new StatisticCondition('>=26j AND <=40j',10)));
    $tbl1->addRow(new StatisticTableRow('41-60 Jahre',new StatisticCondition('>=40j AND <=60j',10)));
    $tbl1->addRow(new StatisticTableRow('ab 61 Jahre',new StatisticCondition('>=61j',10)));
    $tbl1->addRow(new StatisticTableRow('Keine Angabe',new StatisticCondition('FEHLT',10)));
    $tbl1->addColumn(new StatisticTableColumn('Männlich',new StatisticCondition('Männlich',11),new StatisticFunction('#',''),'sum'));
    $tbl1->addColumn(new StatisticTableColumn('Weiblich',new StatisticCondition('Weiblich',11),new StatisticFunction('#',''),'sum'));
    $tbl1->addColumn(new StatisticTableColumn('Keine Angabe',new StatisticCondition('FEHLT',11),new StatisticFunction('#',''),'sum'));
    $tbl1->addColumn(new StatisticTableColumn('Gesamt',new StatisticCondition(null,null),new StatisticFunction('#',''),'sum'));
    $statistic1->addTable($tbl1);

    //Statistik über die Vollständigkeit der Profile
    $statistic2 = new Statistic(null,$currentOrgID, 'Profilvollständigkeit','Vollständigkeit der Profilangaben ' ,'', 2);
    $tbl6 = new StatisticTable('Nach Vollständigkeit', null,'Profilfeld');
    $tbl6->addRow(new StatisticTableRow('Name',new StatisticCondition('VORHANDEN',1)));
    $tbl6->addRow(new StatisticTableRow('Vorname',new StatisticCondition('VORHANDEN',2)));
    $tbl6->addRow(new StatisticTableRow('Adresse',new StatisticCondition('VORHANDEN',3)));
    $tbl6->addRow(new StatisticTableRow('PLZ',new StatisticCondition('VORHANDEN',4)));
    $tbl6->addRow(new StatisticTableRow('Ort',new StatisticCondition('VORHANDEN',5)));
    $tbl6->addRow(new StatisticTableRow('Land',new StatisticCondition('VORHANDEN',6)));
    $tbl6->addRow(new StatisticTableRow('Telefonnummer',new StatisticCondition('VORHANDEN',7)));
    $tbl6->addRow(new StatisticTableRow('Mögliche Angaben',new StatisticCondition('',0)));
    $tbl6->addColumn(new StatisticTableColumn('Anzahl',new StatisticCondition(null,null),new StatisticFunction('#',''),''));
    $tbl6->addColumn(new StatisticTableColumn('Prozent',new StatisticCondition(null,null),new StatisticFunction('%',''),''));
    $statistic2->addTable($tbl6);

    $tbl7 = new StatisticTable('Nach fehlenden Angaben', null,'Profilfeld');
    $tbl7->addRow(new StatisticTableRow('Name',new StatisticCondition('FEHLT',1)));
    $tbl7->addRow(new StatisticTableRow('Vorname',new StatisticCondition('FEHLT',2)));
    $tbl7->addRow(new StatisticTableRow('Adresse',new StatisticCondition('FEHLT',3)));
    $tbl7->addRow(new StatisticTableRow('PLZ',new StatisticCondition('FEHLT',4)));
    $tbl7->addRow(new StatisticTableRow('Ort',new StatisticCondition('FEHLT',5)));
    $tbl7->addRow(new StatisticTableRow('Land',new StatisticCondition('FEHLT',6)));
    $tbl7->addRow(new StatisticTableRow('Telefonnummer',new StatisticCondition('FEHLT',7)));
    $tbl7->addRow(new StatisticTableRow('Mögliche Angaben',new StatisticCondition('',0)));
    $tbl7->addColumn(new StatisticTableColumn('Anzahl',new StatisticCondition(null,null),new StatisticFunction('#',''),''));
    $tbl7->addColumn(new StatisticTableColumn('Prozent',new StatisticCondition(null,null),new StatisticFunction('%',''),''));
    $statistic2->addTable($tbl7);

    //Templates in DB speichern
    $staDB = new DBAccess();
    $staDB->saveStatistic($statistic0);
    $staDB->saveStatistic($statistic1);
    $staDB->saveStatistic($statistic2);
}


//Ausführen von angegebenen SQL-Skripts
function executeSQLSktipt($skriptPath){
    global $gDb;
    global $g_tbl_praefix;

    $filename = $skriptPath;
    $file     = fopen($filename, 'r');
    $content  = fread($file, filesize($filename));
    $sql_arr  = explode(';', $content);
    fclose($file);

    foreach($sql_arr as $sql)
    {
        if(strlen(trim($sql)) > 0)
        {
            // Prefix fuer die Tabellen einsetzen und SQL-Statement ausfuehren
            $sql = str_replace('%PREFIX%', $g_tbl_praefix, $sql);
            //echo "<b>Folgende Query wuerde jetzt abgesetzt:</b><br /><br />";
            //echo $sql;
            //echo "<br /><br />";
            $gDb->query($sql);
            //echo $result;
        }
    }
}

//Recovery der Daten
function restoreOldDefinitionData(){


}

//Abschluss der Installation
function deleteOldTables(){
    executeSQLSktipt('db_statistic_delete.sql');
    echo "<ul><li>Die Tabellen des Plugins, welche nicht mehr benötigt werden, wurden aus der Admidio-Datenbank entfernt.</li></ul>";
}

echo '
        <ul class="iconTextLinkList">
            <li>
                <span class="iconTextLink">
                    <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                    src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                    <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
                </span>
            </li>
        </ul>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');
?>