<?php
/******************************************************************************
 * Zeigt eine Uebersicht aller Statistiken , die sich der User anzeigen lassen kann.
 *
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.orgl
 *
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.htm
 *
 * Parameters:
 *
 *****************************************************************************/


require_once('../includes.php');
require_once(SERVER_PATH.'/adm_program/system/login_valid.php');
require_once(SERVER_PATH.'/adm_program/system/classes/table_roles.php');
require_once(STATISTICS_PATH.'/utils/db_access.php');
global $gNavigation;


// Url fuer die Zuruecknavigation merken
$gNavigation->addUrl(CURRENT_URL);

// Html-Kopf wird geschrieben
$gLayout['title']    = 'Statistik';
$gLayout['includes'] = true;
$gLayout['header']   = "
            <style type=\"text/css\">

                #statisticTitle {
                    margin-bottom:      0px;
                }

                #statisticSubtitle {
                    margin:             10px auto 50px auto;
                    padding:            0px;
                }


                .tableStatisticTitle {
                    padding:            0px;
                    margin-bottom:      5px;
                }

                .tableStatistic {
                    font-size:          10pt;
                    border:             1px solid #7d7d7d;
                    /*margin:           20px 0 50px 0;*/
                    /*margin:           auto;    */
					width:				250px;
                }

                .tableStatistic th, .tableStatistic td {
                    color:              black;
                    font-weight:        normal;
                }

                .tableStatistic th {
                    padding:            3px;
                    text-align:         right;
                    background-repeat:  repeat-x;
                    background-image:   url(../../../adm_themes/modern/images/stripe.png);
                }

                .tableStatistic th.first {
                    text-align:         left;
                }

                .tableStatistic td {
                    text-align:         left;
                    vertical-align:     top;
                    padding:            3px;
                }

                .tableStatistic td.first {
                    text-align:         left;
                }

            </style>";

require(SERVER_PATH. '/adm_program/system/overall_header.php');


//DB-Hilfsklasse instanzieren
$staDBHandler = new DBAccess();

//Überprüfen, ob das Plugin installiert ist
$pluginInstalled = $staDBHandler->getPluginInstalled();

//Überprüfen, ob der Benutzer Zugriff auf die Seite hat
    $hasAccess = false;
    foreach ($plgAllowShow AS $i)
    {
        if($i == 'Benutzer'
            && $gValidLogin == true)
        {
            $hasAccess = true;
        }
        elseif($i == 'Rollenverwalter'
            && $gCurrentUser->assignRoles())
        {
            $hasAccess = true;
        }
        elseif($i == 'Listenberechtigte'
            && $gCurrentUser->viewAllLists())
        {
            $hasAccess = true;
        }
        elseif(hasRole($i))
        {
            $hasAccess = true;
        }
    }

if ($pluginInstalled) {
    if($hasAccess == true) {
        echo '<h1 class="formHead">Statistik-Übersicht</h1>';

        $class_table = 'tableStatistic';

        $staDB = new DBAccess();
        global $gCurrentOrganization;
        $staIDs = $staDB->getStatisticIDs($gCurrentOrganization->getValue('org_id',''));

        if (count($staIDs) == 0){
            echo "Es konnten keine Statistik-Definitionen gefunden werden<br>\n";
        } else {
            echo "Es wurden <b>" . count($staIDs) . "</b> Statistik-Definitionen gefunden:<br>\n";
            echo "<p>W&auml;hlen Sie eine Statistik aus, welche angezeigt werden soll:</p>";
            echo '<table class="'.$class_table. '" cellspacing="0">';
            echo '<tr><th class="first">Name der Statistik</th></tr>';
            foreach($staIDs as $id) {
                echo '<tr><td><a href="./show.php?sta_id='. $id . '">' .$staDB->getStatisticName($id) . '</a></td></tr>';
            }
         }

        echo "</table>";
    } else {
        if ($gValidLogin) {
            echo '<p>Sie haben keine Berechtigung, diese Seite anzuzeigen.</p>';
        }
    }
} else {
        echo '<p>Das Plugin ist nicht installiert, bitte zuerst installieren.</p>';
        $text = 'Zur Installation';
        $link = '../install/install.php';
        echo '<p><form action="'. $link . '" method="post"  >
                    <input type="submit" name="action" value="' . $text . '" />
                </form>
               </p>';
}

echo '
        <ul class="iconTextLinkList">
            <li>
                <span class="iconTextLink">
                    <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                    src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                    <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
                </span>
            </li>
        </ul>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>

