<?php
/******************************************************************************
 * Template für Skript zur Auslesung und Darstellung von Statistiken
 *
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 *
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.htm
 *
 * Parameters:
 *
 * def          : Name der Definitionsdatei, die ausgelesen werden soll
 *
 *****************************************************************************/

require_once('../includes.php');
require_once(SERVER_PATH.'/adm_program/system/classes/table_roles.php');
require_once(STATISTICS_PATH.'/statistic_objects/statistic.php');
require_once(STATISTICS_PATH.'/utils/db_access.php');
require_once(STATISTICS_PATH.'/utils/evaluator.php');
global $gNavigation;

// Url fuer die Zuruecknavigation merken
$gNavigation->addUrl(CURRENT_URL);

//Überprüfen, ob der Benutzer Zugriff auf die Seite hat
$hasAccess = false;
foreach ($plgAllowShow AS $i)
{
    if($i == 'Benutzer'
        && $gValidLogin == true)
    {
        $hasAccess = true;
    }
    elseif($i == 'Rollenverwalter'
        && $gCurrentUser->assignRoles())
    {
        $hasAccess = true;
    }
    elseif($i == 'Listenberechtigte'
        && $gCurrentUser->viewAllLists())
    {
        $hasAccess = true;
    }
    elseif(hasRole($i))
    {
        $hasAccess = true;
    }
}

if($hasAccess == true) {
    // Html-Kopf wird geschrieben
        $gLayout['title']    = 'Statistik';
        $gLayout['includes'] = false;
        $gLayout['header']   = '
            <style type="text/css">
                body {
                    margin: 20px;
                }

                #statisticMetadata {
                    margin-bottom:      50px;
                }

                #date {
                    font-size:          10pt;
                }

                #statisticTitle {
                    margin-bottom:      0px;
                }

                #statisticSubtitle {
                    margin:             5px auto 10px auto;
                    padding:            0px;
                }


                .tableStatisticTitle {
                    padding:            0px;
                    margin:             0 0 5px 0;
                }

                .tableStatistic caption {
                    margin-bottom:      10px;
                }


                .tableStatistic {
                    font-size:          10pt;
                    color:              #555555;
                    border:             1px solid #7d7d7d;
                    margin:             0 auto 100px auto;
                }


                .tableStatistic th {
                    padding:            3px;
                    text-align:         right;
                    background-repeat:  repeat-x;
                    background-image:   url(../../../adm_themes/modern/images/stripe.png);
                    min-width:          100px;
                    text-align:         right;
                }

                .tableStatistic th, .tableStatistic td {
                    color:              black;
                    font-weight:        normal;
                    /* Verhindert Zeilenumbruch bei langem Text */
                    white-space:        nowrap;
                }

                .tableStatistic th.first {
                    text-align:         left;
                    min-width           200px;
                }

                .tableStatistic td {
                    text-align:         right;
                    vertical-align:     top;
                    padding:            3px;
                    color:              black;
                    width:              50px;
                }

                .tableStatistic td.first {
                    text-align:         left;
                }

            </style>';
        require(SERVER_PATH. '/adm_program/system/overall_header.php');



    if (isset($_GET['sta_id'])) {
        $staID = admFuncVariableIsValid($_GET, 'sta_id','numeric',null);
        $staDB = new DBAccess();
        $statisticDefinition = $staDB->getStatistic($staID);
        $staCalc = new Evaluator();
        $statistic = $staCalc->calculateStatistic($statisticDefinition);
    } else {
        echo 'Keine Statistikdefinition angegeben';
        exit;
    }

    echo '<div id="statisticMetadata">';
    //Hauptitel
    echo '<h1 id="statisticTitle">'. ($statistic->getTitle() == '' ? '': $statistic->getTitle()) . '</h1>';

    //Untertitel
    echo '<h2 id="statisticSubtitle">'.  ($statistic->getSubtitle() == '' ? '': $statistic->getSubtitle()) .'</h2>';
    echo '<span id="date">Stand: ' . date('d.m.Y') .'</span>';
    echo '</div>';

    //In dieser Schleife werden alle Tabellen der Statistik berechnet und angezeigt
    $tables = $statistic->getTables();
    foreach ($tables as $table) {

        echo '<h3 class="tableStatisticTitle">' . ($table->getTitle() == '' ? '&nbsp;': $table->getTitle()) . '</h3>';

        if (($table->getRoleID() != $statistic->getStandardRoleID() && $table->getRoleID() != '')) {
            $tableRole = $table->getRoleID();
        } else {
            $tableRole = $statistic->getStandardRoleID();
        }


        echo '<table class="tableStatistic" cellspacing="0">';

        echo '<caption>Rolle ' . $staCalc->getRoleNameFromID($tableRole) . ', ' . $staCalc->getUserCountFromRoleId($tableRole) .' Einträge' . '</caption>';

        echo '<thead>
                <tr>';
                    echo '<th class="first">'. ($table->getFirstColumnLabel() == '' ? '&nbsp;' : $table->getFirstColumnLabel()) . '</th>';
                    $columns = $table->getColumns();
                    for ($c= 0;$c < count($columns); $c++) {
                        echo '<th>'. ($columns[$c]->getLabel() == '' ? '&nbsp;':$columns[$c]->getLabel()) . '</th>';
                     }

            echo '</tr>
            </thead>
            <tbody>';
                    $rows = $table->getRows();
                    for ($r = 0; $r < count($rows); $r++) {
                        echo '<tr>';
                        echo '<td class="first" style="width:100px">'. ($rows[$r]->getLabel() == ' ' ? '&nbsp;':$rows[$r]->getLabel()) .'</td>';
                        for ($c= 0;$c < count($columns); $c++) {
                            $currentCell = $table->getCell($c,$r);
                            echo '<td style="">'. $currentCell->getValue() .'</td>';
                        }
                        echo '</tr>';
                    }
        echo '</tbody></table>';
    }
} else {
    if ($gValidLogin) {
        echo '<p>Sie haben keine Berechtigung, diese Seite anzuzeigen.</p>';
    } else {
        require_once(SERVER_PATH.'/adm_program/system/login_valid.php');
    }
}


    echo '
        <ul class="iconTextLinkList">
            <li>
                <span class="iconTextLink">
                    <a href="'.$g_root_path.'/adm_program/system/back.php"><img
                    src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                    <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
                </span>
            </li>
        </ul>';

    require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>