<?php
/******************************************************************************
 * Statistiken
 *
 * Beta Version
 *
 * Dieses Plugin ermöglicht das Erstellen von Statistiken aus den Profildaten
 * der angemeldeten Benutzer. Konfigurierte Statistiken können gespeichert,
 * geladen und angezeigt werden.
 *
 *  
 * Copyright    : (c) 2004 - 2013 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * 
 *****************************************************************************/

require_once('includes.php');

define('LINK_TEXT_INSTALLATION','Installation / Deinstallation');
define('LINK_TEXT_OVERWIEW','Statistiken');
define('LINK_TEXT_CONFIG', 'Statistikeditor');

$showOverview = false;

foreach ($plgAllowShow AS $i)
{
    if($i == 'Benutzer'
        && $gValidLogin == true)
    {
        $showOverview = true;
    }
    elseif($i == 'Rollenverwalter'
        && $gCurrentUser->assignRoles())
    {
        $showOverview = true;
    }
    elseif($i == 'Listenberechtigte'
        && $gCurrentUser->viewAllLists())
    {
        $hasAccess = true;
    }
    elseif(hasRole($i))
    {
        $showOverview = true;
    }
}

$showConfig = false;

foreach ($plgAllowConfig AS $i)
{
    if($i == 'Benutzer'
        && $gValidLogin == true)
    {
        $showPlugin = true;
    }
    elseif($i == 'Rollenverwalter'
        && $gCurrentUser->assignRoles())
    {
        $showConfig = true;
    }
    elseif($i == 'Listenberechtigte'
        && $gCurrentUser->viewAllLists())
    {
        $hasAccess = true;
    }
    elseif(hasRole($i))
    {
        $showConfig = true;
    }
}

$showInstall = false;

foreach ($plgAllowInstall AS $i)
{
    if($i == 'Benutzer'
        && $gValidLogin == true)
    {
        $showInstall = true;
    }
    elseif($i == 'Rollenverwalter'
        && $gCurrentUser->assignRoles())
    {
        $showInstall = true;
    }
    elseif($i == 'Listenberechtigte'
        && $gCurrentUser->viewAllLists())
    {
        $hasAccess = true;
    }
    elseif(hasRole($i))
    {
        $showInstall = true;
    }
}

    if ($showOverview || $showConfig || $showInstall) {
        echo '<div id="plugin_'. $plugin_folder_name.  '" class="admPluginContent">
            <div class="admPluginHeader"><h3>Statistiken</h3></div>
                <div class="admPluginBody">';

		if ($showOverview) {
            echo ' <span class="menu">
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/gui/overview.php"><img
                        style="vertical-align: middle;" src="'. THEME_PATH. '/icons/lists.png" alt="'. LINK_TEXT_OVERWIEW . '" title="'. LINK_TEXT_OVERWIEW . '" /></a>
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/gui/overview.php">'. LINK_TEXT_OVERWIEW . '</a>
                </span>';
        }

        if ($showConfig) {
            echo ' <span class="menu">
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/gui/editor.php"><img
                        style="vertical-align: middle;" src="'. THEME_PATH. '/icons/options.png" alt="'. LINK_TEXT_CONFIG . '" title="'. LINK_TEXT_CONFIG . '" /></a>
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/gui/editor.php">'. LINK_TEXT_CONFIG . '</a>
                </span>';
        }

        if ($showInstall) {
            echo ' <span class="menu">
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/install/install.php"><img
                        style="vertical-align: middle;" src="'. THEME_PATH. '/icons/backup.png" alt="'. LINK_TEXT_INSTALLATION . '" title="'. LINK_TEXT_INSTALLATION . '" /></a>
                    <a href="'. $g_root_path. '/adm_plugins/' . $plugin_folder_name . '/install/install.php">'. LINK_TEXT_INSTALLATION . '</a>
                </span>';
        }

        echo
            '</div>
        </div>';
    }




