<?php
/******************************************************************************
 * 
 * common_function.php
 *   
 * Gemeinsame Funktionen fuer das Admidio-Plugin Geburtstagsliste
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);
 
require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_category.php');

// Funktion prueft, ob ein User die uebergebene Rolle besitzt
// $role_id   - ID der zu pruefenden Rolle
// $user_id   - ID des Users, fuer den die Mitgliedschaft geprueft werden soll
function hasRole_IDPGL($role_id, $user_id = 0)
{
    global $gCurrentUser, $gDb, $gCurrentOrganization;

    if($user_id == 0)
    {
        $user_id = $gCurrentUser->getValue('usr_id');
    }
    elseif(is_numeric($user_id) == false)
    {
        return -1;
    }

    $sql    = 'SELECT mem_id
                FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                WHERE mem_usr_id = '.$user_id.'
                AND mem_begin <= \''.DATE_NOW.'\'
                AND mem_end    > \''.DATE_NOW.'\'
                AND mem_rol_id = rol_id
                AND rol_id   = \''.$role_id.'\'
                AND rol_valid  = 1 
                AND rol_cat_id = cat_id
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
    $result = $gDb->query($sql);

    $user_found = $gDb->num_rows($result);

    if($user_found == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Funktion prueft, ob ein User Angehoeriger einer Kategorie ist
// $cat_id    - ID der zu pruefenden Kategorie
// $user_id   - ID des Users, fuer den die Mitgliedschaft geprueft werden soll
function hasCategorie_IDPGL($cat_id, $user_id = 0)
{
    global $gCurrentUser, $gDb, $gCurrentOrganization;

    if($user_id == 0)
    {
        $user_id = $gCurrentUser->getValue('usr_id');
    }
    elseif(is_numeric($user_id) == false)
    {
        return -1;
    }

    $sql    = 'SELECT mem_id
                FROM '. TBL_MEMBERS. ', '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                WHERE mem_usr_id = '.$user_id.'
                AND mem_begin <= \''.DATE_NOW.'\'
                AND mem_end    > \''.DATE_NOW.'\'
                AND mem_rol_id = rol_id
                AND cat_id   = \''.$cat_id.'\'
                AND rol_valid  = 1 
                AND rol_cat_id = cat_id
                AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                OR cat_org_id IS NULL ) ';
                
    $result = $gDb->query($sql);

    $user_found = $gDb->num_rows($result);

    if($user_found == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

// Funktion liest die Role-ID einer Rolle aus
// $role_name - Name der zu pruefenden Rolle
function getRole_IDPGL($role_name)
{
    global $gDb, $gCurrentOrganization;
	
    $sql    = 'SELECT rol_id
                 FROM '. TBL_ROLES. ', '. TBL_CATEGORIES. '
                 WHERE rol_name   = \''.$role_name.'\'
                 AND rol_valid  = 1 
                 AND rol_cat_id = cat_id
                 AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR cat_org_id IS NULL ) ';
                      
    $result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    return $row->rol_id ;
}

// Funktion prueft, ob der Nutzer, aufgrund seiner Rollenzugehoerigkeiten berechtigt ist, das Plugin aufzurufen
// Parameter: Array mit Rollen-IDs
function check_showpluginPGL($array)
{
    $showPlugin = false;

    foreach ($array AS $i)
    {
        if(hasRole_IDPGL($i))
        {
            $showPlugin = true;
        } 
    } 
    return $showPlugin;
}

// Funktion überprüft den übergebenen Namen, ob er gemaess den Namenskonventionen für
// Profilfelder und Kategorien zum Uebersetzen durch eine Sprachdatei geeignet ist
// Bsp: SYS_COMMON --> Rueckgabe true
// Bsp: Mitgliedsbeitrag --> Rueckgabe false
function check_languagePGL($field_name)
{
    $ret = false;
 
    //prüfen, ob die ersten 3 Zeichen von $field_name Grußbuchstaben sind
    //prüfen, ob das vierte Zeichen von $field_name ein _ ist
    //prüfen, ob die restlichen Zeichen von $field_name Grußbuchstaben sind
    if ((ctype_upper(substr($field_name,0,3))) && ((substr($field_name,3,1))=='_')  && (ctype_upper(substr($field_name,4)))   )
    {
    	$ret = true;
    }
    return $ret;
}

// Funktion erzeugt die Anzeigeliste
function erzeuge_listePGL($art, $vorschau, $sort )
{
	global $config_ini;

	$members = array();
	
	// nachfolgende IF-Schleife ist nur wg PHP >= 5.4 notwendig
	// Prüfung auf nicht definierte Variablen
	if (strlen($sort)>0 && strlen($config_ini['Spaltenkonfiguration']['col_desc'][0])>0 && strlen($config_ini['Spaltenkonfiguration']['col_sel'][0])>0)
	{
		// die zum gewählten Fokus ($sort) passende Konfiguration bestimmen
		$i = get_focus($sort);
		
  		// die Mitglieder einlesen
		$members = read_members();
	
		// standardmäßig wird die Geburtstagsliste immer ab dem aktuellen Datum angezeigt
		// aufgrund eines Wunsches im Forum kann der Beginn der Anzeige auf den 1. Januar gesetzt werden (Kalenderjahr)
		//if($config_ini['Optionen']['calendar_year'])
		if($config_ini['Spaltenkonfiguration']['calendar_year'][$i])
		{
			if ($vorschau >= 0)
			{
				$date_min = date("U",strtotime(date("Y")."-01-01"));
				$date_max = date("U",strtotime(($vorschau)." day",strtotime(date("Y")."-01-01")));
			}
			else 
			{
				$date_min = date("U",strtotime(($vorschau)." day",strtotime(date("Y")."-01-01")));				
				$date_max = date("U",strtotime(date("Y")."-01-01"));
			}
		}
		else
		{
			if ($vorschau >= 0)
			{
				$date_min = date("U",strtotime('-1 day'));
				$date_max = date("U",strtotime(($vorschau)." day"));				
			}
			else 
			{
				$date_min = date("U",strtotime(($vorschau-1)." day"));			
				$date_max = date("U");
			}			
		}

		// Schleife ueber alle Mitglieder
 		foreach ($members as $member => $memberdata)
		{ 
   			$members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i]] = '';
   			$members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i].'datumneu'] = '';

   			// col_sel ist immer ein Profilfeld mit einem Datumswert (DATE), Beitritt, Geburtsdatum usw
   			// zu diesem Datum den neuen innnerhalb des nächsten Jahres bestimmen (z.B. 10.02.2012 --> 10.02.2013)
			$mon = date("m",strtotime($members[$member][$config_ini['Spaltenkonfiguration']['col_sel'][$i]]));
			$tag = date("d",strtotime($members[$member][$config_ini['Spaltenkonfiguration']['col_sel'][$i]]));
			$jahr = date("Y",$date_min);
		
			// der Datumswert liegt vor dem Beginn des Zeitfensters ($date_min)
			if ((date("U",strtotime($jahr."-".$mon."-".$tag)))<($date_min))
			{
            	//das Jahr um eins erhöhen
            	$datum_neu = date('Y',mktime(0,0,0,$mon,$tag,$jahr+1))."-".$mon."-".$tag;	
       		}
			else
			{
            	$datum_neu = $jahr."-".$mon."-".$tag;     
        	}  
   		
        	$members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i].'datumneu'] = $datum_neu;
        	
   			// wieviele Jahre sind zwischen col_sel und datum_neu?
   			$age = (date("Y",strtotime($datum_neu)) - date("Y",strtotime($members[$member][$config_ini['Spaltenkonfiguration']['col_sel'][$i]])));
   			
   			// die Werte für die runden Geburtstage, Jubilaeen usw einlesen
   			$arr = explode(',',$config_ini['Spaltenkonfiguration']['col_values'][$i]);
   			
   			// falls konfiguriert: Tag und Monat ersetzen
   			$suffix=str_replace('#Day#', $tag, $config_ini['Spaltenkonfiguration']['col_suffix'][$i]);
   			$suffix=str_replace('#Month#', $mon, $suffix);
   			
   			//ist col_values leer? (würde alle bedeuten) und im Originalfeld muss was eingetragen sein
   			if(($arr[0]=='') && ($members[$member][$config_ini['Spaltenkonfiguration']['col_sel'][$i]]<>''))
   			{
   				$members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i]]=$age.$suffix;	
   			}
   			else 
   			{
   				if(in_array($age, $arr))
   				{
   					$members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i]]=$age.$suffix;
   				}	
   			}
        
   			// prüfen, ob Rollen- oder Kategorieeinschränkungen bestehen
        	$rolecatmarker = true;
        	if (!empty($config_ini['Spaltenkonfiguration']['selection_role'][$i]))
        	{
        		$rolecatmarker = false;	
        		foreach (explode(',',$config_ini['Spaltenkonfiguration']['selection_role'][$i]) as $rol)
        		{
        			if (hasRole_IDPGL($rol, $member))
        			{
        				$rolecatmarker = true;
        			}
        		}
        	}
        	if (!empty($config_ini['Spaltenkonfiguration']['selection_cat'][$i]))
        	{
        		$rolecatmarker = false;	
				foreach (explode(',',$config_ini['Spaltenkonfiguration']['selection_cat'][$i]) as $cat)
        		{
        			if (hasCategorie_IDPGL($cat, $member))
        			{
        				$rolecatmarker = true;
        			}
        		}
        	} 
              
			//nicht passende Einträge im $members löschen
        	if (($members[$member][$sort] == '') || !$rolecatmarker)
        	{
        		// wenn ja: Datensatz im Array löschen und zum Beginn der Foreach-Schleife springen
            	unset($members[$member]); 
           		continue;
        	}
		}

    	// nachdem alle dasselbe Jahresdatum haben kann sortiert werden
    	// ansonsten würde z.B. der 25.02.1978 vor dem 24.02.1990 kommen 
    	g_arr_dimsort($members,$sort.'datumneu');

		//alle Mitglieder durchlaufen und filtern
    	foreach ($members as $member => $memberdata)
		{ 
        	//Tag und Monat des Datums sind erforderlich 
			$mon = date("m",strtotime($members[$member][$sort.'datumneu']));
			$tag = date("d",strtotime($members[$member][$sort.'datumneu']));
	
        	//wenn das Datum außerhalb des Definitionszeitraumes liegt: Mitglied im array löschen         
	    	if ((((date("U",strtotime($members[$member][$sort.'datumneu'])))<($date_min))  || ((date("U",strtotime($members[$member][$sort.'datumneu']))) > ($date_max))) && ($art == 'tage') )
        	{
            	unset($members[$member]);
			}
			// wenn der Monat nicht dem ausgewählten Monat entspricht: Mitglied im array löschen
			elseif (($mon != $vorschau) && ($art == 'monat'))
			{
            	unset($members[$member]);
			}		
    	}	
	
		// die Spalte datumneu wurde nur zum Sortieren verwendet und muss wieder geloescht werden
		// sie wuerde ansonsten unter Einstellungen-Spalten in der Spaltenauswahl erscheinen
		foreach ($members as $member => $memberdata)
		{
			// alle über die Spaltenkonfiguration definierten Spalten durchlaufen und die Daten einlesen
			for($i=0; $i < count($config_ini['Spaltenkonfiguration']['col_desc']); $i++)
   			{
   				unset ($members[$member][$config_ini['Spaltenkonfiguration']['col_desc'][$i].'datumneu']);
   			}
		}
	}
    return $members;
}

// Compare function used when sorting arrays
// aus dem Web
function arr_dimsort_cmp($a,$b)
{
	global $G_ARR_STYPE, $G_ARR_SDIM;

  	/* -- Sort numbers? */

  	if ($G_ARR_STYPE == 'NUMBER') 
  	{
      	if ((float)$a[$G_ARR_SDIM] == (float)$b[$G_ARR_SDIM]) return 0;

      	return (floatval($a[$G_ARR_SDIM]) > floatval($b[$G_ARR_SDIM])) ? 1: -1;
  	}
  	/* -- Sort strings? */

  	if ($G_ARR_STYPE == 'STRING') return strcmp($a[$G_ARR_SDIM],$b[$G_ARR_SDIM]);

  	/* -- First time: get the right data type */

  	$G_ARR_STYPE = is_string($a[$G_ARR_SDIM])? 'STRING' : 'NUMBER';

  	return arr_dimsort_cmp($a,$b);
}

// Sort an array by a given dimension
// aus dem Web
function g_arr_dimsort(&$arr,$dim,$type = '',$keepkey = false)
{
  	global $G_ARR_SDIM, $G_ARR_STYPE;

  	$G_ARR_SDIM = $dim; $G_ARR_STYPE = $type;

  	if ($keepkey) uasort($arr,'arr_dimsort_cmp');
  	else
      	usort($arr,'arr_dimsort_cmp');
}

// erzeugt eine Liste mit Tagen für das Pulldown-Menue 'Anzahl der Tage wählen...'
function erzeuge_vorschau_liste()
{
	global $config_ini;
	
    $ret_str = "";
    foreach ($config_ini['Optionen']['vorschau_liste'] as $item)
    {
		$ret_str = $ret_str.'<option value='.sprintf ("%02d", $item).'>'.$item.'</option>';		
	}
    return $ret_str;
}

// erzeugt eine Listen mit Monaten für das Pulldown-Menue 'Monat wählen...'
function erzeuge_monats_liste($monate)
{ 
    $ret_str = "";
    foreach ($monate as $item )
    {
			$ret_str = $ret_str.'<option value='.$item[0].'>'.$item[1].'</option>';		
	}
    return $ret_str;
}

// erzeugt eine Listen mit Werten für das Pulldown-Menue 'Fokus wählen...'
function erzeuge_sortieren_liste()
{ 
	global $members, $config_ini;
    $ret_str = "";     

   // alle über die Spaltenkonfiguration definierten Spalten durchlaufen und die Daten einlesen
	for($i=0; $i < count($config_ini['Spaltenkonfiguration']['col_desc']); $i++)
   	{
    	$ret_str = $ret_str.'<option value="'.$config_ini['Spaltenkonfiguration']['col_desc'][$i].'">'.$config_ini['Spaltenkonfiguration']['col_desc'][$i].'</option>';
    }

    return $ret_str;
}

//Diese Funktion überprüft die Länge von $tmpString für die Anzeige in Select-Boxen
//Autor: guenter47
//$tmpString = zu überprüfender String
//$maxStrLength = maximale Länge, die noch in die Selectbox passt
//Beispiel: Das ist ein sehr langer Text
//Rückgabe: Das ist ein se ... Text
function checkStringLengthPGL($tmpString, $maxStrLength)
{
	// Mindestlaenge vorgeben, ansonsten gibt es Ueberlappungen im neuen String 
	if ($maxStrLength<20)
	{
		$maxStrLength=20;
	}
    if(strlen($tmpString)>$maxStrLength)
    {
        $strPart1=substr($tmpString,0,$maxStrLength-20);
        $strPart2=substr($tmpString,strlen($tmpString)-15);
        $newString=$strPart1."...".$strPart2;
    }
    else
    {
        $newString=$tmpString;
    }
    return $newString;
}

// prüft, ob die Konfigurationstabelle existiert und legt sie ggf. an
function initConfigTablePGL()
{
	global $gL10n, $gDb, $gCurrentOrganization, $g_tbl_praefix;
	
	$config_ini =array();
	$table_name = $g_tbl_praefix.'_plugin_preferences';
	
	// pruefen, ob es die Tabelle bereits gibt
	$sql = 'SHOW TABLES LIKE \''.$table_name.'\' ';
    $result = $gDb->query($sql);
    
    // Tabelle anlegen, wenn es sie noch nicht gibt
    if (!$gDb->num_rows($result))
    {
    	// Tabelle ist nicht vorhanden --> anlegen
        $sql = 'CREATE TABLE '.$table_name.' (
            plp_id 		integer     unsigned not null AUTO_INCREMENT,
            plp_org_id 	integer   	unsigned not null,
    		plp_name 	varchar(255) not null,
            plp_value  	text, 
            primary key (plp_id) )
            engine = InnoDB
         	auto_increment = 1
          	default character set = utf8
         	collate = utf8_unicode_ci';
    	$gDb->query($sql);
    } 
    
    // Konfiguration einlesen
	$config_ini = readConfigTablePGL();

	// mit der Version 1.3.5 des Plugins wurde die globale Option Kalenderjahr gestrichen
	// Die Option Kalenderjahr kann zukünftig in jeder Konfiguration gesetzt werden
	// Die nachfolgende Routine löscht jetzt überflüssige Einträge in der DB
	// (kann im nächsten Update wieder entfernt werden)
	if (isset($config_ini['Optionen']['calendar_year']))
	{
		unset($config_ini['Optionen']['calendar_year']);

		$table_name = $g_tbl_praefix.'_plugin_preferences';
		$sql = 'DELETE FROM '.$table_name.'
        		WHERE plp_name = \'PGL__Optionen__calendar_year\'
        		AND plp_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
		$gDb->query($sql);
	}
	// Ende Updateroutine
	
	
	// überprüfen, ob bereits Konfigurationsdaten gesetzt sind, wenn nicht: vorbelegen
    if (!isset($config_ini['Pluginfreigabe']['freigabe']))
    {
		$config_ini['Pluginfreigabe']['freigabe'] = array(getRole_IDPGL($gL10n->get('SYS_WEBMASTER')),getRole_IDPGL($gL10n->get('SYS_MEMBER')));    		
    }
    if (!isset($config_ini['Pluginfreigabe']['freigabe_config']))
    {
		$config_ini['Pluginfreigabe']['freigabe_config'] = array(getRole_IDPGL($gL10n->get('SYS_WEBMASTER')),getRole_IDPGL($gL10n->get('SYS_MEMBER')));
    }        
    if (!isset($config_ini['Spalten']['freigabe']))
    {
		$config_ini['Spalten']['freigabe'] = array($gL10n->get('SYS_FIRSTNAME'),$gL10n->get('SYS_LASTNAME'));    		
    } 
    
    // Optionen       
    if (!isset($config_ini['Optionen']['select_maxlength']))
    {
   		$config_ini['Optionen']['select_maxlength'] = 30;    		
    }        
    if (!isset($config_ini['Optionen']['vorschau_tage_default']))
    {
	   	$config_ini['Optionen']['vorschau_tage_default'] = 365;    		
    } 
    if (!isset($config_ini['Optionen']['vorschau_liste']))
    {
		$config_ini['Optionen']['vorschau_liste'] = array(10,20,30,365);    		
    } 
    if (!isset($config_ini['Optionen']['spaltenanzahl']))
    {
		$config_ini['Optionen']['spaltenanzahl'] = 1;    		
    } 
    if (!isset($config_ini['Optionen']['dbtoken']))
    {
		$config_ini['Optionen']['dbtoken'] = '#_#';    		
    } 		
    if (!isset($config_ini['Optionen']['focus_default']))
    {  
		$config_ini['Optionen']['focus_default'] = $gL10n->get('PGL_PATTERN');   		
    }    		    
    if (!isset($config_ini['Optionen']['export_feldtrenner']))
    {
		$config_ini['Optionen']['export_feldtrenner'] = ';';    		
    } 
    if (!isset($config_ini['Optionen']['export_dateiendung']))
    {
		$config_ini['Optionen']['export_dateiendung'] = 'csv';    		
    }  
    if (!isset($config_ini['Optionen']['export_zeichensatz']))
    {
		$config_ini['Optionen']['export_zeichensatz'] = 'ISO-8859-1';    		
    }           
        
    //Konfigurationen
    if (!isset($config_ini['Spaltenkonfiguration']))
    {
    	$config_ini['Spaltenkonfiguration'] = array();
    }	
	if (!isset($config_ini['Spaltenkonfiguration']['col_desc']))
    {
    	$config_ini['Spaltenkonfiguration']['col_desc'] = array($gL10n->get('PGL_PATTERN'));
    }	
	if (!isset($config_ini['Spaltenkonfiguration']['col_sel']))
    {
    	$config_ini['Spaltenkonfiguration']['col_sel'] = array($gL10n->get('SYS_BIRTHDAY'));
    }    	
	if (!isset($config_ini['Spaltenkonfiguration']['col_values']))
    {
    	$config_ini['Spaltenkonfiguration']['col_values'] = array('');
    }    	
	if (!isset($config_ini['Spaltenkonfiguration']['col_suffix']))
    {
    	$config_ini['Spaltenkonfiguration']['col_suffix'] = array('');
    }  
	if (!isset($config_ini['Spaltenkonfiguration']['calendar_year']))
    {
    	$config_ini['Spaltenkonfiguration']['calendar_year'] = array('');
    } 
	if (!isset($config_ini['Spaltenkonfiguration']['selection_role']))
    {
    	$config_ini['Spaltenkonfiguration']['selection_role'] = array('');
    }
	if (!isset($config_ini['Spaltenkonfiguration']['selection_cat']))
    {
    	$config_ini['Spaltenkonfiguration']['selection_cat'] = array('');
    } 		

   	// $config_ini in die Tabelle schreiben
  	writeConfigTablePGL($config_ini);
   			 
    return;
}

// Funktion schreibt die $config_ini in die Datenbank
function writeConfigTablePGL($config_ini)
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
    
     foreach($config_ini as $section => $sectiondata)
    {
        foreach($sectiondata as $key => $value)
        {
            if (is_array($value))
            {
                // um diesen Datensatz in der Datenbank als Array zu kennzeichnen, wird er von Doppelklammern eingeschlossen 
            	$value = '(('.implode($config_ini['Optionen']['dbtoken'],$value).'))';
            } 
            
  			$plp_name = 'PGL__'.$section.'__'.$key;
          
            $sql = ' SELECT plp_id 
            		FROM '.$table_name.' 
            		WHERE plp_name = \''.$plp_name.'\' 
            		AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
            $result = $gDb->query($sql);
            $row = $gDb->fetch_object($result);

            // Gibt es den Datensatz bereits?
            // wenn ja: UPDATE des bestehende Datensatzes  
            if(isset($row->plp_id) && (strlen($row->plp_id) > 0))
            {
                $sql = 'UPDATE '.$table_name.' 
                		SET plp_value = \''.$value.'\' 
                		WHERE plp_id = '.$row->plp_id;   
                    
                $gDb->query($sql);           
            }
            // wenn nicht: INSERT eines neuen Datensatzes 
            else
            {
  				$sql = 'INSERT INTO '.$table_name.' (plp_org_id, plp_name, plp_value) 
  						VALUES (\''.$gCurrentOrganization->getValue('org_id').'\' ,\'PGL__'.$section.'__'.$key.'\' ,\''.$value.'\')'; 
            	$gDb->query($sql); 
            }   
        } 
    }
    return ;
}

// Funktion liest die Konfigurationsdaten aus der Datenbank
function readConfigTablePGL()
{
    global $gL10n, $gDb, $g_tbl_praefix, $gCurrentOrganization;
  
    $config_ini =array();
 	$table_name = $g_tbl_praefix.'_plugin_preferences';
 	
 	// im ersten Schritt das Token einlesen
 	$sql = ' SELECT plp_value
             FROM '.$table_name.'
             WHERE plp_name LIKE \'PGL__Optionen__dbtoken\'
             AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 OR plp_org_id IS NULL ) ';
 	$result = $gDb->query($sql);
    $row = $gDb->fetch_object($result);

    //beim ersten Aufruf des Plugins gibt es noch keinen Eintrag von 'PGL__Optionen__dbtoken'
    //mit isset überprüfen, da ansonsten eine Fehlermeldung auftreten kann
    if (isset($row->plp_value))
    {
    	$dbtoken =  $row->plp_value ;
     
		$sql = ' SELECT plp_id, plp_name, plp_value
             	FROM '.$table_name.'
             	WHERE plp_name LIKE \'PGL__%\'
             	AND (  plp_org_id = '.$gCurrentOrganization->getValue('org_id').'
                 	OR plp_org_id IS NULL ) ';
		$result = $gDb->query($sql);
	
		while($row = $gDb->fetch_array($result))
		{
			$array = explode('__',$row['plp_name']);
		
			// wenn plp_value von ((  )) eingeschlossen ist, dann ist es als Array einzulesen
			if ((substr($row['plp_value'],0,2)=='((' ) && (substr($row['plp_value'],-2)=='))' ))
        	{
        		$row['plp_value'] = substr($row['plp_value'],2,-2);
        		$config_ini[$array[1]] [$array[2]] = explode($dbtoken,$row['plp_value']); 
        	}
        	else 
			{
            	$config_ini[$array[1]] [$array[2]] = $row['plp_value'];
        	}
		}
    }
    return $config_ini;
}

// Funktion liest alle Members ein
function read_members()
{
	global $gDb, $gProfileFields, $gCurrentOrganization;

	$members = array();
	
	// alle Mitglieder der aktuellen Organisation einlesen
	$sql = ' SELECT mem.mem_usr_id, mem.mem_begin
    	FROM '.TBL_MEMBERS.' as mem, '.TBL_ROLES.' as rol, '. TBL_CATEGORIES. ' as cat
        WHERE mem.mem_rol_id = rol.rol_id
        AND rol.rol_valid  = 1   
        AND rol.rol_cat_id = cat.cat_id
        AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
           OR cat.cat_org_id IS NULL )
        AND mem.mem_end = \'9999-12-31\' ';
	$result = $gDb->query($sql);

	while($row = $gDb->fetch_array($result))
	{
		$members[$row['mem_usr_id']] = array();
		// die usr_id wird für den Link zum User benoetigt ($members[$row['mem_usr_id']] wird beim Sortieren ueberschrieben)
		$members[$row['mem_usr_id']]['User_ID'] = $row['mem_usr_id'];
	}

	// Schleife ueber alle Mitglieder
 	foreach ($members as $member => $memberdata)
	{ 
		// Die Profildaten jedes Mitglieds einlesen
		$user = new User($gDb, $gProfileFields, $member);
		
		foreach($gProfileFields->mProfileFields as $field)
        {	
        	//falls ein Profilfeld öfters vorhanden ist, den Kategorienamen in Klammern anfügen
    		if (array_key_exists($field->getValue('usf_name'),$members[$member]))
    		{
    			$members[$member][$field->getValue('usf_name').' ('.$field->getValue('cat_name').')'] = $user->getValue($field->getValue('usf_name_intern'));
    		}
    		else 
    		{
    			$members[$member][$field->getValue('usf_name')] = $user->getValue($field->getValue('usf_name_intern'));
    		}
        }
	}	
	
	return $members;
}

// Funktion bestimmt den Index des gewählten Fokus'
function get_focus($focus)
{
	global $config_ini;
	$i_arr = array_keys($config_ini['Spaltenkonfiguration']['col_desc'],$focus);
	$i = $i_arr[0];
	return $i;

}
?>