<?php
/******************************************************************************
 * E-Mails versenden aus dem Plugin Geburtstagsliste
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * common_mail.php ist eine modifizierte mail.php
 *
 * Parameters:
 *
 * usr_id    - E-Mail an den entsprechenden Benutzer schreiben
 * focustext - Text der Fokusspalte
 * focus	 - Beschriebung der Fokusspalte
 *
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/email.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once(dirname(__FILE__).'/common_function.php');

if($gValidLogin == true && $gPreferences['mail_html_registered_users'] == 1)
{
	// create an object of ckeditor and replace textarea-element
	//require_once('../../system/classes/ckeditor_special.php');
	require_once(SERVER_PATH. '/adm_program/system/classes/ckeditor_special.php');	
	$ckEditor = new CKEditorSpecial();
}

$getUserId      = admFuncVariableIsValid($_GET, 'usr_id', 'numeric', 0);
$getFocusText   = admFuncVariableIsValid($_GET, 'focustext', 'string');
$getFocus       = admFuncVariableIsValid($_GET, 'focus', 'string');

$getSubject = '';
$getBody = '';
$getCarbonCopy = 1;
$getDeliveryConfirmation = 0;
$getShowMembers = 0;

// falls durch einen Fehler keine UserId übergeben wurde: Abbruch
if ($getUserId == 0)
{
	$gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}
 
// Konfiguration einlesen
$config_ini = readConfigTablePGL();

// die ID zum gewählten Fokus bestimmen
$mail_arr = array_keys($config_ini['Spaltenkonfiguration']['col_desc'],$getFocus);
$mail = $mail_arr[0];

// Pruefungen, ob die Seite regulaer aufgerufen wurde
if ($gPreferences['enable_mail_module'] != 1)
{
    // es duerfen oder koennen keine Mails ueber den Server verschickt werden
    $gMessage->show($gL10n->get('SYS_MODULE_DISABLED'));
}

if ($gValidLogin && strlen($gCurrentUser->getValue('EMAIL')) == 0)
{
    // der eingeloggte Benutzer hat in seinem Profil keine Mailadresse hinterlegt,
    // die als Absender genutzt werden kann...
    $gMessage->show($gL10n->get('SYS_CURRENT_USER_NO_EMAIL', '<a href="'.$g_root_path.'/adm_program/modules/profile/profile.php">', '</a>'));
}

if (!$gValidLogin)
{
	//in ausgeloggtem Zustand duerfen nie direkt usr_ids uebergeben werden...
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

//usr_id wurde uebergeben, dann Kontaktdaten des Users aus der DB fischen
$user = new User($gDb, $gProfileFields, $getUserId);

// darf auf die User-Id zugegriffen werden    
if((  $gCurrentUser->editUsers() == false
       && isMember($user->getValue('usr_id')) == false)
    || strlen($user->getValue('usr_id')) == 0 )
{
    $gMessage->show($gL10n->get('SYS_USER_ID_NOT_FOUND'));
}

// Subject und Body erzeugen
$text = new TableText($gDb);

$text->readDataByColumns(array('txt_name' => 'PGLMAIL_NOTIFICATION'.$mail, 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));

$mailSrcText = $text->getValue('txt_text');

// now replace all parameters in email text
$mailSrcText = preg_replace ('/%user_first_name%/', $user->getValue('FIRST_NAME'),  $mailSrcText);
$mailSrcText = preg_replace ('/%user_last_name%/',  $user->getValue('LAST_NAME'), $mailSrcText);
$mailSrcText = preg_replace ('/%organization_long_name%/', $gCurrentOrganization->getValue('org_longname'), $mailSrcText);
$mailSrcText = preg_replace ('/%focus%/', $getFocusText,  $mailSrcText);

     
// Betreff und Inhalt anhand von Kennzeichnungen splitten oder ggf. Default-Inhalte nehmen
if(strpos($mailSrcText, '#subject#') !== false)
{
	$getSubject = trim(substr($mailSrcText, strpos($mailSrcText, '#subject#') + 9, strpos($mailSrcText, '#content#') - 9));
}
else
{
	$getSubject = 'Nachricht von '. $gCurrentOrganization->getValue('org_longname');
}
        
if(strpos($mailSrcText, '#content#') !== false)
{
	$getBody   = trim(substr($mailSrcText, strpos($mailSrcText, '#content#') + 9));
}
else
{
	$getBody   = $mailSrcText;
}  

$getBody = preg_replace ('/\r\n/', '<BR>', $getBody);
        
//Datensatz für E-Mail-Adresse zusammensetzen
if(strlen($user->getValue('EMAIL')) > 0)
{
	$userEmail = $user->getValue('EMAIL');				
}         	  
    
// Wenn die letzte URL in der Zuruecknavigation die des Scriptes mail_send.php ist,
// dann soll das Formular gefuellt werden mit den Werten aus der Session
if (strpos($gNavigation->getUrl(),'common_mail_send.php') > 0 && isset($_SESSION['mail_request']))
{
    // Das Formular wurde also schon einmal ausgefüllt,
    // da der User hier wieder gelandet ist nach der Mailversand-Seite
    $form_values = strStripSlashesDeep($_SESSION['mail_request']);
    unset($_SESSION['mail_request']);
    $gNavigation->deleteLastUrl();
}
else
{
    $form_values['name']         = '';
    $form_values['mailfrom']     = '';
    $form_values['subject']      = $getSubject;
    $form_values['mail_body']    = $getBody;
    $form_values['rol_id']       = 0;
    $form_values['carbon_copy']  = $getCarbonCopy;
    $form_values['delivery_confirmation']  = $getDeliveryConfirmation;
    $form_values['show_members'] = $getShowMembers;
}

// Seiten fuer Zuruecknavigation merken
$gNavigation->addUrl(CURRENT_URL);

$focusField = 'subject';

// Html-Kopf ausgeben
if (strlen($getSubject) > 0)
{
    $gLayout['title'] = $getSubject;
}
else
{
    $gLayout['title'] = $gL10n->get('MAI_SEND_EMAIL');
}

$gLayout['header'] =  '
<script type="text/javascript"><!--
    $(document).ready(function() {
        $("#'.$focusField.'").focus();
		$(".admLinkAddAttachment").css("cursor", "pointer");
		
		// add new line to add new attachment to this mail
		$(".admLinkAddAttachment").click(function () {
			newAttachment = document.createElement("input");
			$(newAttachment).attr("type", "file");
			$(newAttachment).attr("name", "userfile[]");
			$(newAttachment).css("display", "block");
			$(newAttachment).css("width", "90%");
			$(newAttachment).css("margin-bottom", "5px");
			$(newAttachment).hide();
			$("#admAddAttachment").before(newAttachment);
			$(newAttachment).show("slow");
		});
 	}); 	
//--></script>';

require(SERVER_PATH. '/adm_program/system/overall_header.php');
echo '
<form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/common_mail_send.php?';
	echo 'usr_id='.$getUserId.'&';
    
	if (strlen($getSubject) > 0)
	{
		echo 'subject='.$getSubject.'&';
	}
    echo '" method="post" enctype="multipart/form-data">

    <div class="formLayout" id="write_mail_form">
        <div class="formHead">'. $gLayout['title']. '</div>
        <div class="formBody">
			<div class="groupBox" id="admMailContactDetails">
				<div class="groupBoxHeadline" id="admMailContactDetailsHead">
					<a class="iconShowHide" href="javascript:showHideBlock(\'admMailContactDetailsBody\', \''.$gL10n->get('SYS_FADE_IN').'\', \''.$gL10n->get('SYS_HIDE').'\')"><img
					id="admMailContactDetailsBodyImage" src="'. THEME_PATH. '/icons/triangle_open.gif" alt="'.$gL10n->get('SYS_HIDE').'" title="'.$gL10n->get('SYS_HIDE').'" /></a>'.$gL10n->get('SYS_CONTACT_DETAILS').'
				</div>

				<div class="groupBoxBody" id="admMailContactDetailsBody">
					<ul class="formFieldList">
						<li>
							<dl>
								<dt><label for="rol_id">'.$gL10n->get('SYS_TO').':</label></dt>
								<dd>';
									
									// usr_id wurde uebergeben, dann E-Mail direkt an den User schreiben
									echo '<input type="text" disabled="disabled" id="mailto" name="mailto" style="width: 90%;" maxlength="50" value="'.$userEmail.'" />
									<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>';
									echo'
								</dd>
							</dl>
						</li>
						<li>
							<hr />
						</li>
						<li>
							<dl>
								<dt><label for="name">'.$gL10n->get('MAI_YOUR_NAME').':</label></dt>
								<dd>';
									echo '<input type="text" id="name" name="name" disabled="disabled" style="width: 90%;" maxlength="50" value="'. $gCurrentUser->getValue('FIRST_NAME'). ' '. $gCurrentUser->getValue('LAST_NAME'). '" />';
								echo '</dd>
							</dl>
						</li>
						<li>
							<dl>
								<dt><label for="mailfrom">'.$gL10n->get('MAI_YOUR_EMAIL').':</label></dt>
								<dd>';
									if ($gCurrentUser->getValue('usr_id') > 0)
									{
									   echo '<input type="text" id="mailfrom" name="mailfrom" disabled="disabled" style="width: 90%;" maxlength="50" value="'. $gCurrentUser->getValue('EMAIL'). '" />';
									}
								echo '</dd>
							</dl>
						</li>
						<li>
							<dl>
								<dt>&nbsp;</dt>
								<dd>
									<input type="checkbox" id="carbon_copy" name="carbon_copy" value="1" ';
									if (isset($form_values['carbon_copy']) && $form_values['carbon_copy'] == 1)
									{
										echo ' checked="checked" ';
									}
									echo ' /> <label for="carbon_copy">'.$gL10n->get('MAI_SEND_COPY').'</label>
								</dd>
							</dl>
						</li>
    					<li>
                        	<dl>
                            	<dt>&nbsp;</dt>
                                <dd>
                                    <input type="checkbox" id="delivery_confirmation" name="delivery_confirmation" value="1" ';
                                    if (isset($form_values['delivery_confirmation']) && $form_values['delivery_confirmation'] == 1)
                                    {
                                        echo ' checked="checked" ';
                                    }
                                    echo ' /> <label for="delivery_confirmation">'.$gL10n->get('MAI_DELIVERY_CONFIRMATION').'</label>
                                </dd>
                        	</dl>
                    	</li>
					</ul>
				</div>
			</div>
				
			<div class="groupBox" id="admMailMessage">
				<div class="groupBoxHeadline" id="admMailMessageHead">
					<a class="iconShowHide" href="javascript:showHideBlock(\'admMailMessageBody\', \''.$gL10n->get('SYS_FADE_IN').'\', \''.$gL10n->get('SYS_HIDE').'\')"><img
					id="admMailMessageBodyImage" src="'. THEME_PATH. '/icons/triangle_open.gif" alt="'.$gL10n->get('SYS_HIDE').'" title="'.$gL10n->get('SYS_HIDE').'" /></a>'.$gL10n->get('SYS_MESSAGE').'
				</div>

				<div class="groupBoxBody" id="admMailMessageBody">
					<ul class="formFieldList">
						<li>
							<dl>
								<dt><label for="subject">'.$gL10n->get('MAI_SUBJECT').':</label></dt>
								<dd><input type="text" id="subject" name="subject" style="width: 90%;" maxlength="77" value="'. $form_values['subject']. '" />
									<span class="mandatoryFieldMarker" title="'.$gL10n->get('SYS_MANDATORY_FIELD').'">*</span>
								</dd>
							</dl>
						</li>';

						// Nur eingeloggte User duerfen Attachments anhaengen...
						if (($gValidLogin) && ($gPreferences['max_email_attachment_size'] > 0) && (ini_get('file_uploads') == '1'))
						{
							echo '
							<li>
								<dl>
									<dt><label for="admAddAttachment">'.$gL10n->get('MAI_ATTACHEMENT').'</label></dt>
									<dd id="attachments">
										<input type="hidden" name="MAX_FILE_SIZE" value="' . ($gPreferences['max_email_attachment_size'] * 1024) . '" />
										<span id="admAddAttachment" class="iconTextLink" style="display: block;">
											<a class="admLinkAddAttachment"><img
											src="'. THEME_PATH. '/icons/add.png" alt="'.$gL10n->get('MAI_ADD_ATTACHEMENT').'" /></a>
											<a class="admLinkAddAttachment">'.$gL10n->get('MAI_ADD_ATTACHEMENT').'</a>
											<a rel="colorboxHelp" href="'. $g_root_path. '/adm_program/system/msg_window.php?message_id=MAI_MAX_ATTACHMENT_SIZE&amp;message_var1='. Email::getMaxAttachementSize('mb').'&amp;inline=true"><img 
												onmouseover="ajax_showTooltip(event,\''.$g_root_path.'/adm_program/system/msg_window.php?message_id=MAI_MAX_ATTACHMENT_SIZE&amp;message_var1='. Email::getMaxAttachementSize('mb').'\',this)" onmouseout="ajax_hideTooltip()"
												class="iconHelpLink" src="'. THEME_PATH. '/icons/help.png" alt="Help" title="" /></a>
										</span>
									</dd>
								</dl>
							</li>';
						}

						echo '
						<li>
							<div>';
									if($gValidLogin == true && $gPreferences['mail_html_registered_users'] == 1)
									{
										echo $ckEditor->createEditor('mail_body', $form_values['mail_body']);
									}
									else
									{
									   echo '<textarea id="mail_body" name="mail_body" style="width: 99%;" rows="10" cols="45">'. $form_values['mail_body']. '</textarea>';
									}
							echo '</div>
						</li>
					</ul>
				</div>
			</div>
			<div class="formSubmit">
                <button id="btnSend" type="submit"><img src="'. THEME_PATH. '/icons/email.png" alt="'.$gL10n->get('SYS_SEND').'" />&nbsp;'.$gL10n->get('SYS_SEND').'</button>
            </div>
        </div>
    </div>
</form>
<ul class="iconTextLinkList">
    <li>
        <span class="iconTextLink">
            <a href="'.$g_root_path.'/adm_program/system/back.php"><img 
            src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
            <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
        </span>
    </li>
</ul>';

require(SERVER_PATH. '/adm_program/system/overall_footer.php');

?>