<?php
/******************************************************************************
 * Check email form and send email
 *
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 *
 * common_mail_send.php ist eine modifizierte mail_send.php
 *
 * Parameters:
 *
 * usr_id  - Send email to this user
 * subject - set email subject independent of the form
 *
 *****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/classes/email.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_roles.php');

//Stop if mail module is disabled
if($gPreferences['enable_mail_module'] != 1)
{
    $gMessage->show($gL10n->get('SYS_MODULE_DISABLED'));
}

// Initialize and check the parameters
$getUserId  = admFuncVariableIsValid($_GET, 'usr_id', 'numeric', 0);

// Check form values
$postSubject     = admFuncVariableIsValid($_POST, 'subject', 'string', '');
$postName        = admFuncVariableIsValid($_POST, 'name', 'string', '');
$postFrom        = admFuncVariableIsValid($_POST, 'mailfrom', 'string', '');
$postTo          = admFuncVariableIsValid($_POST, 'mailto', 'string', '');
$postBody        = admFuncVariableIsValid($_POST, 'mail_body', 'html', '');
$postCarbonCopy  = admFuncVariableIsValid($_POST, 'carbon_copy', 'boolean', 0);
$postDeliveryConfirmation  = admFuncVariableIsValid($_POST, 'delivery_confirmation', 'boolean', 0);
$postShowMembers = admFuncVariableIsValid($_POST, 'show_members', 'numeric', 0);

$postName = $gCurrentUser->getValue('FIRST_NAME'). ' '. $gCurrentUser->getValue('LAST_NAME');
$postFrom = $gCurrentUser->getValue('EMAIL');
$postRoleId = '';
$empfaenger = '';

//put values into SESSION
$_SESSION['mail_request'] = array(
    'name'          => $postName,
    'mailfrom'      => $postFrom,
    'subject'       => $postSubject,
    'mail_body'     => $postBody,
    'rol_id'        => $postRoleId,
    'carbon_copy'   => $postCarbonCopy,
    'delivery_confirmation' => $postDeliveryConfirmation,
    'show_members' => $postShowMembers);

// if User ID is delivered
if ($getUserId > 0)
{
    // Falls eine Usr_id uebergeben wurde, muss geprueft werden ob der User ueberhaupt
    // auf diese zugreifen darf oder ob die UsrId ueberhaupt eine gueltige Mailadresse hat...
    if (!$gValidLogin)
    {
        //in ausgeloggtem Zustand duerfen nie direkt usr_ids uebergeben werden...
        $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
    }

    //usr_id wurde uebergeben, dann Kontaktdaten des Users aus der DB fischen
    $user = new User($gDb, $gProfileFields, $getUserId);

    // darf auf die User-Id zugegriffen werden    
    if(($gCurrentUser->editUsers() == false && isMember($user->getValue('usr_id')) == false)|| strlen($user->getValue('usr_id')) == 0 )
    {
        $gMessage->show($gL10n->get('SYS_USER_ID_NOT_FOUND'));
    }
   
	//Datensatz für E-Mail-Adresse zusammensetzen
	if(strlen($user->getValue('EMAIL')) > 0)
	{
		$postTo = $user->getValue('EMAIL');	
		$empfaenger	= $user->getValue('FIRST_NAME').' '.$user->getValue('LAST_NAME');		
	}         	  
}

// aktuelle Seite im NaviObjekt speichern. Dann kann in der Vorgaengerseite geprueft werden, ob das
// Formular mit den in der Session gespeicherten Werten ausgefuellt werden soll...
$gNavigation->addUrl(CURRENT_URL);

// Falls Attachmentgroesse die max_post_size aus der php.ini uebertrifft, ist $_POST komplett leer.
// Deswegen muss dies ueberprueft werden...
if (empty($_POST))
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

//Erst mal ein neues Emailobjekt erstellen...
$email = new Email();

// und ein Dummy Rollenobjekt dazu
$role = new TableRoles($gDb);

//Nun der Mail die Absenderangaben,den Betreff und das Attachment hinzufuegen...
if(strlen($postName) == 0)
{
    $gMessage->show($gL10n->get('SYS_FIELD_EMPTY', $gL10n->get('SYS_NAME')));
}

//Absenderangaben checken falls der User eingeloggt ist, damit ein paar schlaue User nicht einfach die Felder aendern koennen...
if ( $gValidLogin 
&& (  $postFrom != $gCurrentUser->getValue('EMAIL') 
   || $postName != $gCurrentUser->getValue('FIRST_NAME').' '.$gCurrentUser->getValue('LAST_NAME')) )
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

//Absenderangaben setzen
if ($email->setSender($postFrom,$postName))
{
    //Betreff setzen
    if ($email->setSubject($postSubject))
    {
        //Pruefen ob moeglicher Weise ein Attachment vorliegt
        if (isset($_FILES['userfile']))
        {
            //noch mal schnell pruefen ob der User wirklich eingelogt ist...
            if (!$gValidLogin)
            {
                $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
            }
            $attachment_size = 0;
            // Nun jedes Attachment
            for($act_attachment_nr = 0; isset($_FILES['userfile']['name'][$act_attachment_nr]) == true; $act_attachment_nr++)
            {
                //Pruefen ob ein Fehler beim Upload vorliegt
                if (($_FILES['userfile']['error'][$act_attachment_nr] != 0) &&  ($_FILES['userfile']['error'][$act_attachment_nr] != 4))
                {
                    $gMessage->show($gL10n->get('MAI_ATTACHMENT_TO_LARGE'));
                }
                //Wenn ein Attachment vorliegt dieses der Mail hinzufuegen
                if ($_FILES['userfile']['error'][$act_attachment_nr] == 0)
                {
                    // pruefen, ob die Anhanggroesse groesser als die zulaessige Groesse ist
                    $attachment_size = $attachment_size + $_FILES['userfile']['size'][$act_attachment_nr];
                    if($attachment_size > $email->getMaxAttachementSize("b"))
                    {
                        $gMessage->show($gL10n->get('MAI_ATTACHMENT_TO_LARGE'));
                    }
                    
                    //Falls der Dateityp nicht bestimmt ist auf Standard setzen
                    if (strlen($_FILES['userfile']['type'][$act_attachment_nr]) <= 0)
                    {
                        $_FILES['userfile']['type'][$act_attachment_nr] = 'application/octet-stream';                        
                    }
                    
                    //Datei anhängen
                    try
                    {
                        $email->AddAttachment($_FILES['userfile']['tmp_name'][$act_attachment_nr], $_FILES['userfile']['name'][$act_attachment_nr], $encoding = 'base64', $_FILES['userfile']['type'][$act_attachment_nr]);
                    }
                    catch (phpmailerException $e)
                    {
                        $gMessage->show($e->errorMessage());
                    }                  
                }
            }
        }
    }
    else
    {
        $gMessage->show($gL10n->get('SYS_FIELD_EMPTY', $gL10n->get('MAI_SUBJECT')));
    }
}
else
{
    $gMessage->show($gL10n->get('SYS_EMAIL_INVALID', $gL10n->get('SYS_EMAIL')));
}

// if possible send html mail
if($gValidLogin == true && $gPreferences['mail_html_registered_users'] == 1)
{
    $email->sendDataAsHtml();
}

// Falls eine Kopie benoetigt wird, das entsprechende Flag im Mailobjekt setzen
if (isset($postCarbonCopy) && $postCarbonCopy == true)
{
    $email->setCopyToSenderFlag();
}

//Nun die Empfaenger zusammensuchen und an das Mailobjekt uebergeben
if ($getUserId > 0)
{
    //den gefundenen User dem Mailobjekt hinzufuegen...
  	$email->addRecipient($postTo, $empfaenger);
    
}

// Falls eine Lesebestätigung angefordert wurde
if($postDeliveryConfirmation == 1)
{
    $email->ConfirmReadingTo = $gCurrentUser->getValue('EMAIL');
}

// prepare body of email with note of sender and homepage
$email->setSenderInText($postName, $postFrom, $role->getValue('rol_name'), $postShowMembers);

//set Text
$email->setText($postBody);

//Nun kann die Mail endgueltig versendet werden...
$sendMailResult = $email->sendEmail();
if ($sendMailResult === TRUE)
{
    // Bei erfolgreichem Versenden wird aus dem NaviObjekt die am Anfang hinzugefuegte URL wieder geloescht...
    $gNavigation->deleteLastUrl();
    // dann auch noch die mail.php entfernen
    $gNavigation->deleteLastUrl();

    // Meldung ueber erfolgreichen Versand und danach weiterleiten
    if($gNavigation->count() > 0)
    {
        $gMessage->setForwardUrl($gNavigation->getUrl());
    }
    else
    {
        $gMessage->setForwardUrl($gHomepage);
    }
    
    $gMessage->show($gL10n->get('SYS_EMAIL_SEND', $postTo));

}
else
{
    $gMessage->show($sendMailResult.'<br />'.$gL10n->get('SYS_EMAIL_NOT_SEND', $postTo, $sendMailResult));
}
?>