<?php
/******************************************************************************
* 
* einstellungen.php
*   
* Erzeugt das Menue Einstellungen fuer das Admidio-Plugin Geburtstagsliste
* 
* Copyright    : (c) 2004 - 2014 The Admidio Team
* Homepage     : http://www.admidio.org
* License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
*
****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/form_elements.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once($plugin_path. '/'.$plugin_folder.'/common_function.php');
require_once($plugin_path. '/'.$plugin_folder.'/version.php');

// Konfiguration einlesen
$config_ini = readConfigTablePGL();

// überprüfen, ob der angemeldete User berechtigt ist das Plugin aufzurufen
$showPlugin = check_showpluginPGL($config_ini['Pluginfreigabe']['freigabe_config']);

// weiter nur, wenn der User berechtigt ist
if($showPlugin)
{
    // DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
    $gDb->setCurrentDB();
    
    // Navigation faengt hier im Modul an
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);

    $html_icon_warning = '<img class="iconHelpLink" src="'.THEME_PATH.'/icons/warning.png" alt="'.$gL10n->get('SYS_WARNING').'" />';
    $textpgl = array();
    
    //die Members einlesen (werden für die Überschriften der Spalten benötigt)
	$members = read_members();
	
    // zusaetzliche Daten fuer den Html-Kopf setzen
    $gLayout['title']  = $gL10n->get('PGL_BIRTHDAY_LIST');
    $gLayout['header'] =  '
        <script type="text/javascript" src="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/einstellungen.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.core.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.widget.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.tabs.js" ></script>		
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.accordion.js" ></script>
        <script type="text/javascript" src="'.$g_root_path.'/adm_program/libs/jquery/jquery.ui.scrollTo.js" ></script>
        
        <script type="text/javascript"><!--
        var einstellungenJS = new einstellungenClass();
        $(document).ready(function()
            {einstellungenJS.init();
        });
        //--></script>
        <link rel="stylesheet" type="text/css" href="'.THEME_PATH.'/css/jquery.css">';

    // Html-Kopf ausgeben
    require(SERVER_PATH. '/adm_program/system/overall_header.php');

    echo '<h1 class="moduleHeadline">'.$gL10n->get('PGL_BIRTHDAY_LIST').'</h1>

    <div class="formLayout" id="admOrganizationMenu">
        <div class="formBody">
            <form action="'.$g_root_path.'/adm_plugins/'.$plugin_folder.'/menue_function.php" method="post">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-setup">'.$gL10n->get('PGL_SETTINGS').'</a></li>
                    </ul>
                    <div id="tabs-setup">
                        <div id="accordion-setup">';

                            /**************************************************************************************/
                            // Spalten
                            /**************************************************************************************/

                            echo '<h3 id="Spalten" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Spalten" title="'.$gL10n->get('PGL_COLUMNS').'" /></a>
                                <a href="#">'.$gL10n->get('PGL_COLUMNS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                            <dt><label>'.$gL10n->get('PGL_COLUMN_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="spalten_freigabe[]" size="10" multiple>';
													$freigegebene_spalten = array();
													
													//die Überschriften einlesen          
													foreach($members as $member => $memberdata) 
													{
    													foreach($memberdata as $key => $data) 
    													{
                  											echo '<option value="'.$key.'"';
                  											if(in_array($key,$config_ini['Spalten']['freigabe']))
                                                        	{
                                                            	echo ' selected="selected"';	
                                                            	$freigegebene_spalten[] = $key; 
                                                        	} 
                  											echo '>'.checkStringLengthPGL($key,$config_ini['Optionen']['select_maxlength']).'</option>';
    													} 
    													break;
													}               
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_COLUMN_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PGL_COLUMN_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="5">';
                                        			foreach ($freigegebene_spalten as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="spalten"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
	                                        	
                            /**************************************************************************************/
                            // Konfigurationen (alt: Spaltenkonfiguration)
                            /**************************************************************************************/

                            echo '<h3 id="Spaltenkonfiguration" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Spaltenkonfiguration" title="'.$gL10n->get('PGL_COLUMN_CONFIG').'" /></a>
                                <a href="#">'.$gL10n->get('PGL_COLUMN_CONFIG').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <div style="width:100%; height:200px; overflow:auto; border:0px;"> 
                                	<ul class="formFieldList">	
                                		<li>'.$gL10n->get('PGL_COLUMN_CONFIG_HEADER').'</li>
                                		<BR>
                                		<li class="smallFontSize">'.$gL10n->get('PGL_COLUMN_CONFIG_DESC').'</li>
                                		<BR>
                                		<li>'.$gL10n->get('PGL_NOTIFICATION_MAIL_TEXT_DESC').'</li>
                                		<BR>
                                		<li class="smallFontSize">
                        					<strong>%user_first_name%</strong> - '.$gL10n->get('PGL_VARIABLE_FIRST_NAME').'<br />
                        					<strong>%user_last_name%</strong> - '.$gL10n->get('PGL_VARIABLE_LAST_NAME').'<br />
											<strong>%organization_long_name%</strong> - '.$gL10n->get('ORG_VARIABLE_NAME_ORGANIZATION').'<br />
											<strong>%focus%</strong> - '.$gL10n->get('PGL_VARIABLE_FOCUS').'<br />
                    					</li>
                    				</ul>
                    			</div>
                    			<HR>
                    			<div style="width:100%; height:650px; overflow:auto; border:0px;">';
                            
                                    for ($i=1;$i<$config_ini['Optionen']['spaltenanzahl']+1;$i++)
									{
							        	echo'<ul class="formFieldList">
							        	<li class="smallFontSize">'.$i.'. '.$gL10n->get('PGL_COL').'</li>
                                   	 	<li>
                                        	<dl>
                                            	<dt><label for="col_desc">'.$gL10n->get('PGL_COL_DESC').':</label></dt>
                                            	<dd><input type="text" id="col_desc[]" name="col_desc[]" style="width: 200px;" maxlength="500" value="'. (isset($config_ini['Spaltenkonfiguration']['col_desc'][$i-1]) ? $config_ini['Spaltenkonfiguration']['col_desc'][$i-1] : '' ). '" /></dd>
                                        	</dl>                                                                                                                                                              
                                    	</li>
                                    	<li>
                                        	<dl>
                                            	<dt><label>'.$gL10n->get('PGL_COL_SEL').':</label></dt>
                                            	<dd>
                                                	<select name="col_sel[]" size="1">';
														foreach($gProfileFields->mProfileFields as $field )
    													{   
    														if ($field->getValue('usf_type')=='DATE')
    														{
    															echo '<option value="'.$field->getValue('usf_name').'"';
                  												if(isset($config_ini['Spaltenkonfiguration']['col_desc'][$i-1]) && $field->getValue('usf_name')==$config_ini['Spaltenkonfiguration']['col_sel'][$i-1] )
                                                        		{
                                                            		echo ' selected="selected"';	
                                                        		}
                  													echo '>'.$field->getValue('usf_name').'</option>';
    														} 
    													} 
    												echo '</select>   
                                            	</dd>
                                        	</dl>
                                    	</li>
                                  		<li>
                                        	<dl>
                                            	<dt><label for="col_values">'.$gL10n->get('PGL_COL_VALUES').':</label></dt>
                                            	<dd><input type="text" id="col_values[]" name="col_values[]" style="width: 200px;" maxlength="500" value="'. $config_ini['Spaltenkonfiguration']['col_values'][$i-1]. '" /></dd>
                                        	</dl>
                                    	</li>
                                    	<li>
                                        	<dl>
                                            	<dt><label for="col_suffix">'.$gL10n->get('PGL_COL_SUFFIX').':</label></dt>
                                            	<dd><input type="text" id="col_suffix[]" name="col_suffix[]" style="width: 200px;" maxlength="500" value="'. $config_ini['Spaltenkonfiguration']['col_suffix'][$i-1]. '" /></dd>
                                        	</dl>
                                    	</li>
                                    	<li>
                                        	<dl>
                                            	<dt><label>'.$gL10n->get('PGL_ROLE_SELECTION').':</label></dt>
                                            	<dd>
                                                	<select name="selection_role[]" size="5" multiple>';                     
                                                    	$rollen = array();
                                                    	$sql = 'SELECT rol_name, rol_id
                                                        	FROM '.TBL_CATEGORIES.' , '.TBL_ROLES.' 
                                                        	WHERE cat_id = rol_cat_id
                                                        	AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        	OR cat_org_id IS NULL )';
                                                    	$result = $gDb->query($sql);
                                                    
                                                    	while ($row = $gDb->fetch_array($result))
                                                    	{
                                                        	$rols[$row['rol_id']] = $row['rol_name'];
                                                    	}
                                                    
                                                    	foreach($rols as $key => $data)
                                                    	{
                                                        	echo '<option value='.($i-1).'-'.$key;
                                                        	if(isset($config_ini['Spaltenkonfiguration']['selection_role'][$i-1]) && in_array($key,explode(',',$config_ini['Spaltenkonfiguration']['selection_role'][$i-1])))
                                                        	{
                                                            	echo ' selected="selected"';	
                                                        	} 
                                                        	echo '>'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                    	}
                                                	echo '</select>              
                                            	</dd>
                                        	</dl>
                                    	</li>                                   	
                						<li>
                                        	<dl>
                                            	<dt><label>'.$gL10n->get('PGL_CAT_SELECTION').':</label></dt>
                                            	<dd>
                                                	<select name="selection_cat[]" size="5" multiple>';                     
                                                    	$rollen = array();
                                                    	$sql = 'SELECT cat_name, cat_id
                                                        	FROM '.TBL_CATEGORIES.' , '.TBL_ROLES.' 
                                                        	WHERE cat_id = rol_cat_id
                                                        	AND (  cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        	OR cat_org_id IS NULL )';
                                                    	$result = $gDb->query($sql);
                                                    
                                                    	while ($row = $gDb->fetch_array($result))
                                                    	{
                                                        	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        													if(check_languagePGL($row['cat_name']))
        													{
        														$row['cat_name'] = $gL10n->get($row['cat_name']);
        													}
                                                        	$cats[$row['cat_id']] = $row['cat_name'];
                                                    	}
                                                    
                                                    	foreach($cats as $key => $data)
                                                    	{
                                                        	echo '<option value='.($i-1).'-'.$key;
                                                        	if(isset($config_ini['Spaltenkonfiguration']['selection_cat'][$i-1]) && in_array($key,explode(',',$config_ini['Spaltenkonfiguration']['selection_cat'][$i-1])))
                                                        	{
                                                            	echo ' selected="selected"';	
                                                        	} 
                                                        	echo '>'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                    	}
                                                	echo '</select>              
                                            	</dd>
                                        	</dl>
                                    	</li>
                                    	<li>'.$gL10n->get('PGL_NOTIFICATION_MAIL_TEXT').':</li>';
										$textpgl[$i-1] = new TableText($gDb);
                    					$textpgl[$i-1]->readDataByColumns(array('txt_name' => 'PGLMAIL_NOTIFICATION'.($i-1), 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));

                    					//wenn noch nichts drin steht, dann vorbelegen
                    					if ($textpgl[$i-1]->getValue('txt_text')=='')
                    					{
        									// convert <br /> to a normal line feed
        									$value = preg_replace('/<br[[:space:]]*\/?[[:space:]]*>/',chr(13).chr(10),$gL10n->get('PGL_PGLMAIL_NOTIFICATION'));
                    			
            								$textpgl[$i-1]->setValue('txt_text', $value);
            								$textpgl[$i-1]->save();
            								$textpgl[$i-1]->readDataByColumns(array('txt_name' => 'PGLMAIL_NOTIFICATION'.($i-1), 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));
                    					}
                    					echo '<li>
                    						<textarea id="col_mail[]" name="col_mail[]" style="width: 100%;" rows="7" cols="40" >'. $textpgl[$i-1]->getValue('txt_text'). '</textarea>
                        				</li>
                        				<li>
                                        	<dl>
                                            	<dt><label for="calendar_year">'.$gL10n->get('PGL_SHOW_CALENDAR_YEAR').':</label></dt>
                                            	<dd>
                                                	<input type="checkbox" id="calendar_year[]" name="calendar_year[]" ';
													if(isset($config_ini['Spaltenkonfiguration']['calendar_year'][$i-1]) && $config_ini['Spaltenkonfiguration']['calendar_year'][$i-1]==1 )
                                                    {
                                                    	echo ' checked="checked" ';
                                                    }
                                                	echo ' value='.($i-1).' />
                                            	</dd>
                                        	</dl>
                                    	</li>
                                    	<li class="smallFontSize">'.$gL10n->get('PGL_SHOW_CALENDAR_YEAR_DESC').'</li>
                        				<HR>';
										}
                                	echo '</ul>
                                </div>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="spaltenkonfiguration"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
	                                        	
                            /**************************************************************************************/
                            // Optionen
                            /**************************************************************************************/

                            echo '<h3 id="Optionen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/options.png" alt="Optionen" title="'.$gL10n->get('PGL_OPTIONS').'" /></a>
                                <a href="#">'.$gL10n->get('PGL_OPTIONS').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">
                                	<li>
                                        <dl>
                                            <dt><label for="maxlength">'.$gL10n->get('PGL_SELECT_MAXLENGTH').':</label></dt>
                                            <dd>
                                            	<input type="text" id="select__max_length" name="select_max_length" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['select_maxlength']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_SELECT_MAXLENGTH_DESC').'</li>
                                    <li>
                                        <dl>
                                            <dt><label for="spaltenanzahl">'.$gL10n->get('PGL_COLUMN_NUMBER').':</label></dt>
                                            <dd>
                                            	'. $config_ini['Optionen']['spaltenanzahl'].' + <input type="text" id="spaltenanzahl" name="spaltenanzahl" style="width: 40px;" maxlength="40" value="0" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_COLUMN_NUMBER_DESC').'</li>
                                 	<li>
                                        <dl>
                                            <dt><label for="vorschau_tage_default">'.$gL10n->get('PGL_PREVIEW_DAYS').':</label></dt>
                                            <dd>
                                            	<input type="text" id="vorschau_tage_default" name="vorschau_tage_default" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['vorschau_tage_default']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_PREVIEW_DAYS_DESC').'</li>                                    
             						<li>
                                    	<dl>
                                            <dt><label for="focus_label_default">'.$gL10n->get('PGL_FOCUS').':</label></dt>
                                            <dd>
                                                 <select name="focus_default" size="'.count($config_ini['Spaltenkonfiguration']['col_desc']).'">';                                                      
                                                    foreach ($config_ini['Spaltenkonfiguration']['col_desc'] as $data)  
                                                    {
                                                        echo '<option value="'.$data.'"';
                                                        if(($data == $config_ini['Optionen']['focus_default'])      )
                                                        {
                                                            echo ' selected="selected" ';	
                                                        }
                                                        echo '>'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>'; 	
                                                    }  
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_FOCUS_DEFAULT_DESC').'</li>                                       
                                    <li>
                                        <dl>
                                            <dt><label for="vorschau_liste">'.$gL10n->get('PGL_PREVIEW_LIST').':</label></dt>
                                            <dd>
                                            	<input type="text" id="vorschau_liste" name="vorschau_liste" style="width: 200px;" maxlength="500" value="'. implode(',',$config_ini['Optionen']['vorschau_liste']). '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_PREVIEW_LIST_DESC').'</li>                       
                                    <BR>
                                    <li>
                                        <dl>
                                            <dt><label for="dbtoken">'.$gL10n->get('PGL_DBTOKEN').':</label></dt>
                                            <dd>
                                            	<input type="text" id="dbtoken" name="dbtoken" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['dbtoken']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_DBTOKEN_DESC').'</li>
 									<br>
 									<li>
                                        <dl>
                                            <dt><label for="fieldseparator">'.$gL10n->get('PGL_EXPORT_FIELDSEPARATOR').':</label></dt>
                                            <dd>
                                            	<input type="text" id="export_field_separator" name="export_field_separator" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['export_feldtrenner']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_EXPORT_FIELDSEPARATOR_DESC').'</li>
                                    <BR>
                                	<li>
                                        <dl>
                                            <dt><label for="fileextension">'.$gL10n->get('PGL_EXPORT_FILEEXTENSION').':</label></dt>
                                            <dd>
                                            	<input type="text" id="export_file_extension" name="export_file_extension" style="width: 40px;" maxlength="40" value="'. $config_ini['Optionen']['export_dateiendung']. '" />
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_EXPORT_FILEEXTENSION_DESC').'</li>
                                    <BR>
                                	<li>
                                        <dl>
                                            <dt><label for="charset">'.$gL10n->get('PGL_EXPORT_CHARSET').':</label></dt>
           									<dd>
                                                <select name="export_charset" size="1">';                     
                                                    $token = array('ISO-8859-1','UTF-8' );
                                                    foreach ($token as $data)  
                                                    {
                                                        echo '<option value='.$data;
                                                        if(($data == $config_ini['Optionen']['export_zeichensatz'])      )
                                                        {
                                                            echo ' selected="selected" ';	
                                                        } 
                                                        echo '>'.$data.'</option>';		
                                                    }  
                                                echo '</select>              
                                            </dd>                                            
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_EXPORT_CHARSET_DESC').'</li>
                                    <BR>									
 								</ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="optionen"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';
                            
                            /**************************************************************************************/
                            // Pluginfreigabe
                            /**************************************************************************************/

                            echo '<h3 id="Pluginfreigabe" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/lock.png" alt="Pluginfreigabe" title="'.$gL10n->get('PGL_PLUGIN_CONTROL').'" /></a>
                                <a href="#">'.$gL10n->get('PGL_PLUGIN_CONTROL').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">  
                                    <li>
                                        <dl>
                                        	<dt><label><strong>'.$gL10n->get('PGL_BIRTHDAY_LIST').'</strong></label></dt>
                                        	<BR>
                                        	<BR>
                                            <dt><label>'.$gL10n->get('PGL_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePGL($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array('cat' => $row['cat_name'],'rol' => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {
                                                            echo '<option value="" disabled="disabled">'.checkStringLengthPGL($gL10n->get('SYS_CATEGORY').' '.$data['cat'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPGL($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_ROLE_SELECTION_DESC').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PGL_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                    <HR>
                                    <li>
                                        <dl>
                                        	<dt><label><strong>'.$gL10n->get('PGL_SETTINGS').'</strong></label></dt>
                                        	<BR>
                                        	<BR>
                                            <dt><label>'.$gL10n->get('PGL_ROLE_SELECTION').':</label></dt>
                                            <dd>
                                                <select name="freigabe_config[]" size="10" multiple>';                     
                                                    $rollen = array();
                                                    $sql = 'SELECT rol.rol_name, rol.rol_id, cat.cat_name
                                                        FROM '.TBL_CATEGORIES.' as cat, '.TBL_ROLES.' as rol
                                                        WHERE cat.cat_id = rol.rol_cat_id
                                                        AND (  cat.cat_org_id = '.$gCurrentOrganization->getValue('org_id').'
                                                        OR cat.cat_org_id IS NULL )';
                                                    $result = $gDb->query($sql);
                                                    
                                                    while ($row = $gDb->fetch_array($result))
                                                    {
                                                    	// ueberprüfen, ob der Kategoriename mittels der Sprachdatei übersetzt werden kann
        												if(check_languagePGL($row['cat_name']))
        												{
        													$row['cat_name'] = $gL10n->get($row['cat_name']);
        												}
                                                        $rollen[$row['rol_id']] = array('cat' => $row['cat_name'],'rol' => $row['rol_name']);
                                                    }

                                                    $cat_old = '';
                                                    $freigegebene_rollen = array();
                                                    foreach($rollen as $key => $data)
                                                    {
                                                        if ($cat_old != $data['cat'])
                                                        {
                                                            echo '<option value="" disabled="disabled">'.checkStringLengthPGL($gL10n->get('SYS_CATEGORY').' '.$data['cat'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        }
                                                        echo '<option value='.$key;

                                                        if(in_array($key,$config_ini['Pluginfreigabe']['freigabe_config']))
                                                        {
                                                            echo ' selected="selected"';	
                                                            $freigegebene_rollen[] = $data['rol']; 
                                                        } 
                                                        echo '>'.checkStringLengthPGL($data['rol'],$config_ini['Optionen']['select_maxlength']).'</option>';	
                                                        $cat_old = $data['cat'];
                                                    }
                                                echo '</select>              
                                            </dd>
                                        </dl>
                                    </li>
                                    <li class="smallFontSize">'.$gL10n->get('PGL_ROLE_SELECTION_DESC2').'</li>
                                    <li class="smallFontSize">
                                    	<dl>
                                            <dt><label>'.$gL10n->get('PGL_ROLE_SELECTION_ACTIV').':</label></dt>
                                            <dd>
                                                <select name="anzeige[]" size="3">';
                                        			foreach ($freigegebene_rollen as $data )
                                        			{
         	                                            echo '<option value="" disabled="disabled">'.checkStringLengthPGL($data,$config_ini['Optionen']['select_maxlength']).'</option>';	
                                        			}
	                                        	echo '</select>              
	                                        </dd>
                                        </dl>
                                    </li>
                                </ul>
                                <div class="formSubmit">	
                                    <button id="btnSave" type="submit" name="pluginfreigabe"><img src="'. THEME_PATH. '/icons/disk.png" alt="'.$gL10n->get('SYS_SAVE').'" />&nbsp;'.$gL10n->get('SYS_SAVE').'</button>
                                </div>
                            </div>';

                            /**************************************************************************************/
                            // Plugininformationen
                            /**************************************************************************************/

                            echo '<h3 id="Plugininformationen" class="iconTextLink" >
                                <a href="#"><img src="'.THEME_PATH.'/icons/info.png" alt="Plugininformationen" title="'.$gL10n->get('PGL_PLUGIN_INFORMATION').'" /></a>
                                <a href="#">'.$gL10n->get('PGL_PLUGIN_INFORMATION').'</a>
                            </h3>
                            <div class="groupBoxBody" style="display: none;">
                                <ul class="formFieldList">         
                                    <li>
                                        <dl>
                                            <dt><label for="Name des Plugins">'.$gL10n->get('PGL_PLUGIN_NAME').':</label></dt>
                                            <dd><label for="">'.$gL10n->get('PGL_BIRTHDAY_LIST').'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Version">'.$gL10n->get('PGL_PLUGIN_VERSION').':</label></dt>
                                            <dd><label for="">'.$plugin_gl_version.'</label></dd>
                                        </dl>
                                    </li>
                                    <li>
                                        <dl>
                                            <dt><label for="Stand">'.$gL10n->get('PGL_PLUGIN_DATE').':</label></dt>
                                            <dd><label for="">'.$plugin_gl_stand.'</label></dd>
                                        </dl>
                                    </li>
                                </ul>
                                <br>
                            </div>';

                        // ENDE accordion-modules
                        echo'</div>
                    </div>
                </div>
            </form>
        </div>
    </div>';

    require(SERVER_PATH. '/adm_program/system/overall_footer.php');
}
?>