<?php
 /******************************************************************************
 * 
 * Hauptprogramm für das Admidio-Plugin Geburtstagsliste
 *  
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 * Uebergaben:
 * 
 * mode    : Ausgabeart   (html, print, csv)
 * start   : Angabe, ab welchem Datensatz Mitglieder angezeigt werden sollen
 * art     : Angabe, ob ein bestimmter Monat oder Tage gewählt wurden (monat,tage)    
 * vorschau: Angabe, für wie viele Tage die Geburtstagsliste erstellt werden soll 
 *           oder für welchen Monat    
 * sort	   : Sortierung (spaltenueberschriften)
 *****************************************************************************/

// Pfad des Plugins ermitteln
$plugin_folder_pos = strpos(__FILE__, 'adm_plugins') + 11;
$plugin_file_pos   = strpos(__FILE__, basename(__FILE__));
$plugin_path       = substr(__FILE__, 0, $plugin_folder_pos);
$plugin_folder     = substr(__FILE__, $plugin_folder_pos+1, $plugin_file_pos-$plugin_folder_pos-2);

require_once($plugin_path. '/../adm_program/system/common.php');
require_once($plugin_path. '/../adm_program/system/classes/list_configuration.php');
require_once($plugin_path. '/../adm_program/system/classes/table_roles.php');
require_once($plugin_path. '/'.$plugin_folder.'/common_function.php');  

// DB auf Admidio setzen, da evtl. noch andere DBs beim User laufen
$gDb->setCurrentDB();

// Konfiguration einlesen
$config_ini = readConfigTablePGL();

// wenn der angemeldete User nicht berechtigt ist, das Plugin aufzurufen, dann Fehler ausgeben
if(check_showpluginPGL($config_ini['Pluginfreigabe']['freigabe']) == false)
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

// wurde 1. die Konfiguration, die die Fokus-Default-Einstellung bestimmt, gelöscht?
// oder wurden 2. evtl. ALLE Konfigurationen gelöscht?
if ((strlen($config_ini['Spaltenkonfiguration']['col_desc'][0])==0) || !(in_array($config_ini['Optionen']['focus_default'],$config_ini['Spaltenkonfiguration']['col_desc'])) )
{
	$gMessage->show($gL10n->get('PGL_MISSING_CONFIG'));
}	

// lokale Variablen der Uebergabevariablen initialisieren
$arr_mode   = array('csv', 'html', 'print');
$arr_art    = array('monat', 'tage');
$req_start  = 0;
$req_vorschau = 0;
$req_sort = '';
$charset    = '';
$ueberschrift = '';
$align = 'left';

// enthaelt spaeter die komplette CSV-Datei als String
$str_csv   = '';   

$monate = array(
        array('01',$gL10n->get('SYS_JANUARY')),
        array('02',$gL10n->get('SYS_FEBRUARY')),
        array('03',$gL10n->get('SYS_MARCH')),
        array('04',$gL10n->get('SYS_APRIL')),
        array('05',$gL10n->get('SYS_MAY')),
        array('06',$gL10n->get('SYS_JUNE')),
        array('07',$gL10n->get('SYS_JULY')),
        array('08',$gL10n->get('SYS_AUGUST')),
        array('09',$gL10n->get('SYS_SEPTEMBER')),
        array('10',$gL10n->get('SYS_OCTOBER')),
        array('11',$gL10n->get('SYS_NOVEMBER')),
        array('12',$gL10n->get('SYS_DECEMBER')));
        
// Uebergabevariablen pruefen und ggf. Default-Werte setzen
if(isset($_GET['mode']))
{
	$req_mode   = strStripTags($_GET['mode']);
	if(in_array($req_mode, $arr_mode) == false)
	{
    	$gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
	} 
}
else 
{
	$req_mode   = 'html';
}        
        
if(isset($_GET['art']))
{
	$req_art   = strStripTags($_GET['art']);
	if(in_array($req_art, $arr_art) == false)
	{
    	$gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
	}
}
else 
{
	$req_art   = 'tage';
}        

if(isset($_GET['start']))
{
    if(is_numeric($_GET['start']) == false)
    {
        $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
    }
    $req_start = $_GET['start'];
}

if(isset($_GET['vorschau']))
{
    $req_vorschau = (int) $_GET['vorschau'];  
}
else 
{
	$req_vorschau = $config_ini['Optionen']['vorschau_tage_default'];
}

if(isset($_GET['sort']))
{
    $req_sort = $_GET['sort'];  
}
else
{
	$req_sort = $config_ini['Optionen']['focus_default'];		
}
        
if($req_mode == 'csv')
{
    $separator    = $config_ini['Optionen']['export_feldtrenner'];
    $fileextension= $config_ini['Optionen']['export_dateiendung'];
	$charset      = $config_ini['Optionen']['export_zeichensatz'];
}
else if($req_mode == 'html')
{
    $class_table           = 'tableList';
    $class_sub_header      = 'tableSubHeader';
    $class_sub_header_font = 'tableSubHeaderFont';
}
elseif($req_mode == 'print')
{
    $class_table           = 'tableListPrint';
    $class_sub_header      = 'tableSubHeaderPrint';
    $class_sub_header_font = 'tableSubHeaderFontPrint';
}

// die zum gewählten Fokus ($req_sort) passende Konfiguration bestimmen
$focus = get_focus($req_sort);
  		
// standardmäßig wird die Geburtstagsliste immer ab dem aktuellen Datum angezeigt
// aufgrund eines Wunsches im Forum kann der Beginn der Anzeige auf den 1. Januar gesetzt werden (Kalenderjahr)
if($config_ini['Spaltenkonfiguration']['calendar_year'][$focus])
{
	if ($req_vorschau >= 0)
	{
		$date_min = date("d.m.Y",strtotime(date("Y")."-01-01"));
		$date_max = date("d.m.Y",strtotime(($req_vorschau)." day",strtotime(date("Y")."-01-01")));
	}
	else
	{
		$date_min = date("d.m.Y",strtotime(($req_vorschau)." day",strtotime(date("Y")."-01-01")));
		$date_max = date("d.m.Y",strtotime(date("Y")."-01-01"));
	}
}
else
{
	if ($req_vorschau >= 0)
	{
		$date_min = date("d.m.Y");
		$date_max = date("d.m.Y",strtotime(($req_vorschau)." day"));				
	}
	else
	{
		$date_min = date("d.m.Y",strtotime(($req_vorschau)." day"));
		$date_max = date("d.m.Y");						
	}
}

//die Geburtstagsliste erzeugen und in ein Array einlesen
$members = erzeuge_listePGL($req_art, $req_vorschau, $req_sort);

$num_members = count($members);

if($num_members == 0)
{
    //es wurde kein Benutzer gefunden, der den gewaehlten Kriterien entspricht
    // --> das Array $members mit Pseudodaten befuellen
    $members = array(array($req_sort => $gL10n->get('LST_NO_USER_FOUND')));
}

if($num_members < $req_start)
{
    $gMessage->show($gL10n->get('SYS_INVALID_PAGE_VIEW'));
}

if($req_mode == 'html' && $req_start == 0)
{
    // Url fuer die Zuruecknavigation merken, aber nur in der Html-Ansicht
	// Navigation faengt hier im Modul an
    $gNavigation->clear();
    $gNavigation->addUrl(CURRENT_URL);
}

if($req_mode != 'csv')
{
    // Html-Kopf wird geschrieben
    if($req_mode == 'print')
    {
    	header('Content-type: text/html; charset=utf-8');
        echo '
        <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
        <html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" lang="de" xml:lang="de">
        <head>
            <!-- (c) 2004 - 2011 The Admidio Team - http://www.admidio.org -->
            
            <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        
            <title>'. $gCurrentOrganization->getValue('org_longname'). '</title>
            
            <link rel="stylesheet" type="text/css" href="'. THEME_PATH. '/css/print.css" />
            <script type="text/javascript" src="'. $g_root_path. '/adm_program/system/js/common_functions.js"></script>

            <style type="text/css">
                @page { size:landscape; }
            </style>
        </head>
        <body class="bodyPrint">';
    }
    else            
    {
        $gLayout['title']    = $gL10n->get('LST_LIST');
        $gLayout['includes'] = false;
        $gLayout['header']   = '
            <style type="text/css">
                body 
                {
                    margin: 20px;
                }
            </style>
            <script type="text/javascript"><!--
                function vorschauList(element)
                {
                    var sel_list = element.value;
                    if(sel_list.length > 1)
                    {
                        self.location.href = "'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?" +
                            "mode=html&art=tage&sort='.$req_sort.'&vorschau=" + sel_list;
                    }
                }
                function monthList(element)
                {
                    var sel_list = element.value;
                    if(sel_list.length > 1)
                    {
                        self.location.href = "'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?" +
                            "mode=html&art=monat&sort='.$req_sort.'&vorschau=" + sel_list;
                    }
                }
                function sortList(element)
                {
                    var sel_list = element.value;
                    if(sel_list.length > 1)
                    {
                        self.location.href = "'. $g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?" +
                            "mode=html&art='.$req_art.'&vorschau='.$req_vorschau.'&sort=" + sel_list;
                    }
                }
            //--></script>';    
        require(SERVER_PATH. '/adm_program/system/overall_header.php');
    }
 
    echo '<h1 class="moduleHeadline">'.$gL10n->get('PGL_BIRTHDAY_LIST').'</h1><h3>';
    if($req_sort <> '')
    {
    	if($req_art == 'monat')
    	{
        	echo $gL10n->get('PGL_FOR_THE_MONTH').' '.$monate[$req_vorschau-1][1].'';
    	}
    	else
    	{
 	  		echo $gL10n->get('PGL_FOR_THE_PERIOD',$date_min,$date_max,$req_vorschau );
    	}
        echo ' - '.$gL10n->get('PGL_FOCUS').': '.$req_sort;
    }
    else
	{
        echo $gL10n->get('PGL_NO_FOCUS_SET');
    } 
  	echo '</h3>';
  	
    if($req_mode == 'html')
    {
        echo '<ul class="iconTextLinkList"> 
        	<li>
                <span class="iconTextLink">
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?&amp;mode=print&amp;sort='.$req_sort.'&amp;art='.$req_art.'&amp;vorschau='.$req_vorschau.'\', \'_blank\')"><img
                    	src="'. THEME_PATH. '/icons/print.png" alt="'.$gL10n->get('LST_PRINT_PREVIEW').'" title="'.$gL10n->get('LST_PRINT_PREVIEW').'" /></a>
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?&amp;mode=print&amp;sort='.$req_sort.'&amp;art='.$req_art.'&amp;vorschau='.$req_vorschau.'\', \'_blank\')">'.$gL10n->get('LST_PRINT_PREVIEW').'</a>
                </span>
            </li> 
            <li>
                <span class="iconTextLink">
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?&amp;mode=csv&amp;sort='.$req_sort.'&amp;art='.$req_art.'&amp;vorschau='.$req_vorschau.'\', \'_blank\')"><img
                    	src="'. THEME_PATH. '/icons/database_out.png" alt="'.$gL10n->get('PGL_EXPORT').'" title="'.$gL10n->get('PGL_EXPORT').'" /></a>
                    <a href="#" onclick="window.open(\''.$g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?&amp;mode=csv&amp;sort='.$req_sort.'&amp;art='.$req_art.'&amp;vorschau='.$req_vorschau.'\', \'_blank\')">'.$gL10n->get('PGL_EXPORT').'</a>
                </span>
            </li> 
            <li>
                <span class="iconTextLink">
                    <img src="'. THEME_PATH. '/icons/dates.png" alt="'.$gL10n->get('PGL_SELECT_NUMBER_OF_DAYS').'" />
                    <select size="1" name="export_mode" onchange="vorschauList(this)">
                        <option value="" selected="selected">'.$gL10n->get('PGL_SELECT_NUMBER_OF_DAYS').' ...</option>
                        '.erzeuge_vorschau_liste().'                    
                    </select>
                </span>
            </li>   
            <li>
                <span class="iconTextLink">
                    <img src="'. THEME_PATH. '/icons/dates.png" alt="'.$gL10n->get('PGL_SELECT_MONTH').'" />
                    <select size="1" name="export_mode" onchange="monthList(this)">
                        <option value="" selected="selected">'.$gL10n->get('PGL_SELECT_MONTH').' ...</option>
                        '.erzeuge_monats_liste($monate).'                    
                    </select>
                </span>
            </li>
            <li>
                <span class="iconTextLink">
                    <img src="'. THEME_PATH. '/icons/key.png" alt="'.$gL10n->get('PGL_SELECT_FOCUS').'" />
                    <select size="1" name="export_mode" onchange="sortList(this)">
                        <option value="" selected="selected">'.$gL10n->get('PGL_SELECT_FOCUS').' ...</option>
                        '.erzeuge_sortieren_liste().'                    
                    </select>
                </span>
            </li>      
        </ul>';
    }
    // Tabellenkopf schreiben
    echo '<table class="'.$class_table.'" style="width: 95%;" cellspacing="0">
    <thead><tr>'; 
       
    // die laufende Nummer noch davorsetzen
    echo '<th style="text-align: '.$align.';">'.$gL10n->get('SYS_ABR_NO').'</th>'; 
}
else
{ 
	// die laufende Nummer noch davorsetzen
    $str_csv = $str_csv. $gL10n->get('SYS_ABR_NO');	
}

//die Ueberschriften einlesen                 
foreach($members as $member => $memberdata) 
{
	foreach($memberdata as $key => $data) 
    {
       	if(in_array($key,$config_ini['Spalten']['freigabe'])||$key==$req_sort)
        {     
            if($req_mode == 'csv')
            {            
                $str_csv = $str_csv. $separator. $key;
            }
            else
            {                            
                echo '<th nowrap style="text-align: '.$align.';">'.$key.'</th>';
            }
        }
    }
    break; 
}

if($req_mode == 'csv')
{
    $str_csv = $str_csv. "\n";
}
else
{
    echo '</tr></thead><tbody>';
}

if($req_mode == 'html' && $gPreferences['lists_members_per_page'] > 0)
{
    // Anzahl der Mitglieder, die auf einer Seite angezeigt werden
    $members_per_page = $gPreferences['lists_members_per_page'];     
}
else
{
    $members_per_page = $num_members;
}

$j = 0;
$k = 0;
$irow = $req_start + 1;  // Zaehler fuer die jeweilige Zeile

if($req_mode != 'csv')
{
	foreach($members as $member => $memberdata) 
	{
    	if($j > $req_start-1 && $k < $members_per_page)
    	{   
        	echo '<td style="text-align: '.$align.';">'.$irow.'</td>'; 

			foreach($memberdata as $key => $data) 
        	{
        		if(in_array($key,$config_ini['Spalten']['freigabe'])||$key==$req_sort)
        		{
        			// Nachnamen mit einem Link versehen
        		    if($key ==$gL10n->get('SYS_LASTNAME') AND $data != '') 
        		    {
                		echo '<td style="text-align: '.$align.';"><a href="'.$g_root_path.'/adm_program/modules/profile/profile.php?user_id='. $memberdata['User_ID']. '">'.$data.'</a></td>';
        		    }
        	
        			// E-Mail-Adressen mit einem Link versehen
        		    elseif($key ==$gL10n->get('SYS_EMAIL') AND $data != '') // Mod DieterB
        		    {
						if($gPreferences['enable_mail_module'] != 1)
						{
							$mail_link = 'mailto:'. $data;
						}
						else
						{
							$mail_link = $g_root_path.'/adm_plugins/'.$plugin_folder.'/common_mail.php?usr_id='. $memberdata['User_ID'].'&focus='. $req_sort.'&focustext='.$memberdata[$req_sort];			
						}
                		echo '<td style="text-align: '.$align.';"><a href="'.$mail_link.'">'.$data.'</a></td>';
        		    }
        		    else
        		    {
                	   echo '<td style="text-align: '.$align.';">'.$data.'</td>';
        		   	}
        		}
         	} 
            echo '</tr>';
        	$k++;   
        	$irow++;
    	}
    	$j++;
	}
}

if($req_mode == 'csv')
{
    $irow = 1;
    //jetzt die Daten einlesen, aber nur bei csv
    foreach($members as $member => $memberdata) 
    {
        $str_csv = $str_csv. $irow;
            
		foreach($memberdata as $key => $data) 
        {
        	if(in_array($key,$config_ini['Spalten']['freigabe'])||$key==$req_sort)
        	{               
            	$str_csv = $str_csv. $separator.$data;
        	}
        } 
        $str_csv = $str_csv. "\n";
        $irow++;
    }
	
    // nun die erstellte CSV-Datei an den User schicken
    $filename = $g_organization. '-'.$gL10n->get('PGL_BIRTHDAY_LIST').'.'.$fileextension;
    header('Content-Type: text/comma-separated-values; charset='.$charset);
    header('Content-Disposition: attachment; filename="'.$filename.'"');
	if($charset == 'iso-8859-1')
	{
		echo utf8_decode($str_csv);
	}
	else
	{
		echo $str_csv;
	}
}
else
{
    echo '</tbody></table>';

    if($req_mode != 'print')
    {
        $base_url = $g_root_path. '/adm_plugins/'.$plugin_folder.'/geburtstagsliste_show.php?mode='.$req_mode.'&art='.$req_art.'&sort='.$req_sort.'&vorschau='.$req_vorschau;
        
        // Navigation mit Vor- und Zurueck-Buttons 
        echo admFuncGeneratePagination($base_url, $num_members, $members_per_page, $req_start, TRUE);
    }

    if($req_mode == 'print')
    {
        echo '</body></html>';
    }
    else
    {    
        echo '
        <ul class="iconTextLinkList">
            <li>
                <span class="iconTextLink">
                    <a href="'.$g_root_path.'/adm_program/system/back.php"><img 
                    src="'. THEME_PATH. '/icons/back.png" alt="'.$gL10n->get('SYS_BACK').'" /></a>
                    <a href="'.$g_root_path.'/adm_program/system/back.php">'.$gL10n->get('SYS_BACK').'</a>
                </span>
            </li>
        </ul>';
    
        require(SERVER_PATH. '/adm_program/system/overall_footer.php');
    }
}

?>