<?php
/******************************************************************************
 * 
 * menue_function.php
 *   
 * Menuefunktionen fuer das Admidio-Plugin Geburtstagsliste
 * 
 * Copyright    : (c) 2004 - 2014 The Admidio Team
 * Homepage     : http://www.admidio.org
 * License      : GNU Public License 2 http://www.gnu.org/licenses/gpl-2.0.html
 * 
 ****************************************************************************/

require_once(substr(__FILE__, 0,strpos(__FILE__, 'adm_plugins')-1).'/adm_program/system/common.php');
require_once(SERVER_PATH. '/adm_program/system/login_valid.php');
require_once(SERVER_PATH. '/adm_program/system/classes/table_text.php');

require_once(dirname(__FILE__).'/common_function.php');

// Konfiguration einlesen
$config_ini = readConfigTablePGL();

$_SESSION['organization_request'] = $_REQUEST;

// *******************************************************************************
// Setup: Optionen
// *******************************************************************************

if( isset($_POST['optionen']))
{    
	if (!empty($_POST['export_field_separator']))	
    {
    	$config_ini['Optionen']['export_feldtrenner'] = $_POST['export_field_separator'];	
    }
	if (!empty($_POST['export_file_extension']))	
    {
    	$config_ini['Optionen']['export_dateiendung'] = $_POST['export_file_extension'];	
    }
    $config_ini['Optionen']['export_zeichensatz'] = $_POST['export_charset'];
    $config_ini['Optionen']['select_maxlength'] = (($_POST['select_max_length']<20) ? 20 : $_POST['select_max_length']) ;
    $config_ini['Optionen']['spaltenanzahl'] += intval($_POST['spaltenanzahl']>0) ? intval($_POST['spaltenanzahl']) : 0;
    $config_ini['Optionen']['vorschau_tage_default'] = intval($_POST['vorschau_tage_default']>0) ? intval($_POST['vorschau_tage_default']) : 365;
    $config_ini['Optionen']['vorschau_liste'] = explode(',',trim(preg_replace('![^0-9,-]!', '', $_POST['vorschau_liste']),','));
	
    if (!empty($_POST['dbtoken']))	
    {
    	$config_ini['Optionen']['dbtoken'] = $_POST['dbtoken'];	
    }
	
    if( isset($_POST['focus_default']))
	{
		$config_ini['Optionen']['focus_default'] = $_POST['focus_default'];	
	}    
    
  	writeConfigTablePGL($config_ini); 
}

// *******************************************************************************
// Setup: Spalten
// *******************************************************************************

if( isset($_POST['spalten']) && isset($_POST['spalten_freigabe']))
{
    unset($config_ini['Spalten']);
    $config_ini['Spalten']['freigabe'] = $_POST['spalten_freigabe'];
    writeConfigTablePGL($config_ini);
}

// *******************************************************************************
// Setup: Spaltenkonfiguration  !!! neue Bezeichnung im Menü: Konfigurationen
// *******************************************************************************

if( isset($_POST['spaltenkonfiguration']) && $config_ini['Optionen']['spaltenanzahl']>0)
{
	$pglmailtemp = array();
	
    unset($config_ini['Spaltenkonfiguration']);
    $config_ini['Spaltenkonfiguration']['col_desc'] = $_POST['col_desc'];
    $config_ini['Spaltenkonfiguration']['col_sel'] = $_POST['col_sel'];
    $config_ini['Spaltenkonfiguration']['col_values'] = $_POST['col_values'];
    $config_ini['Spaltenkonfiguration']['col_suffix'] = $_POST['col_suffix']; 
    
    // Die Werte für calendar_year werden über Checkboxen übergeben, Checkboxen unterscheiden 
    // sich aber bei der Übergabe der Werte, da nur gesetzte Checkboxen übergeben werden
    // Es wird deshalb der key der Checkbox übergeben und ausgewertet
    foreach($config_ini['Spaltenkonfiguration']['col_desc'] as $key => $data)
    {
    	$config_ini['Spaltenkonfiguration']['calendar_year'][$key] = (isset($_POST['calendar_year']) ? (in_array($key,$_POST['calendar_year']) ? 1 : 0) : 0);
    }
    
    // die übergebene Spaltenanzahl zwischenspeichern
    $spaltenanzahl = count($config_ini['Spaltenkonfiguration']['col_desc']);
    
    // alle Konfigurationen durchlaufen
	foreach($config_ini['Spaltenkonfiguration']['col_desc'] as $key => $data)
    {
	   	// wenn Beschreibung leer ist, alle weiteren Werte im Array löschen
    	if (empty($data))	
    	{
    		unset($config_ini['Spaltenkonfiguration']['col_desc'][$key]);
    		unset($config_ini['Spaltenkonfiguration']['col_sel'][$key]);
    		unset($config_ini['Spaltenkonfiguration']['col_values'][$key]);
    		unset($config_ini['Spaltenkonfiguration']['col_suffix'][$key]); 
    		unset($config_ini['Spaltenkonfiguration']['calendar_year'][$key]);           	
    	}
    	// wenn nicht leer: Leerzeichen, fuehrende und nachfolgende Kommata in Values entfernen
    	else
		{
    		$config_ini['Spaltenkonfiguration']['col_values'][$key] = trim(preg_replace('![^0-9,]!', '', $config_ini['Spaltenkonfiguration']['col_values'][$key]),',');

    		//Beschreibung und Feldauswahl duerfen nicht genau gleich sein
    		//Bsp.: bei Feld "Geburtstag" darf Beschreibung nicht auch "Geburtstag" lauten
    		if ($config_ini['Spaltenkonfiguration']['col_desc'][$key]==$config_ini['Spaltenkonfiguration']['col_sel'][$key])
    		{
    			$config_ini['Spaltenkonfiguration']['col_desc'][$key] .= '-'.$gL10n->get('PGL_FOCUS');	
    		} 
    		
    		if( isset($_POST['selection_role']))
			{
	    		// jetzt selection_role durchlaufen
	    		$config_ini['Spaltenkonfiguration']['selection_role'][$key] = '';
	    		foreach($_POST['selection_role'] as $selroledata)
	    		{
	    			if (strstr($selroledata,$key.'-'))
	    			{
 	   					$config_ini['Spaltenkonfiguration']['selection_role'][$key] .= ','.substr(strstr($selroledata,$key.'-'),2);
	    			}
    			}
    			//das erste ',' wieder entfernen 
    			$config_ini['Spaltenkonfiguration']['selection_role'][$key] = substr($config_ini['Spaltenkonfiguration']['selection_role'][$key],1);
			}
			else
			{
				$config_ini['Spaltenkonfiguration']['selection_role'][$key] = '';
			}
			
			if( isset($_POST['selection_cat']))
			{
				// jetzt selection_cat durchlaufen
    			$config_ini['Spaltenkonfiguration']['selection_cat'][$key] = '';
    			foreach($_POST['selection_cat'] as $selcatdata)
    			{
    				if (strstr($selcatdata,$key.'-'))
    				{
    					$config_ini['Spaltenkonfiguration']['selection_cat'][$key] .= ','.substr(strstr($selcatdata,$key.'-'),2);
    				}
    			
    			}
    			//das erste ',' wieder entfernen 
    			$config_ini['Spaltenkonfiguration']['selection_cat'][$key] = substr($config_ini['Spaltenkonfiguration']['selection_cat'][$key],1);
			}
			else
			{
				$config_ini['Spaltenkonfiguration']['selection_cat'][$key] = '';
			}
			//nur wenn Beschreibung nicht leer ist, dann den E-Mail-Text in ein
			//neues, numerisch indiziertes Array schreiben
			$pglmailtemp[] = $_POST['col_mail'][$key];
		}
		
    }
    $config_ini['Optionen']['spaltenanzahl'] = count($config_ini['Spaltenkonfiguration']['col_desc']); 
    writeConfigTablePGL($config_ini);  

    // den E-Mail-Text speichern und ggf. nicht mehr benötigte in der DB löschen (ansonsten bleiben Leichen!!)
    for ($i=0;$i<$spaltenanzahl;$i++)
	{
		if($i<count($pglmailtemp))
		{
			$textpgl = new TableText($gDb);
    		$textpgl->readDataByColumns(array('txt_name' => 'PGLMAIL_NOTIFICATION'.$i, 'txt_org_id' => $gCurrentOrganization->getValue('org_id')));
			$textpgl->setValue('txt_text', $pglmailtemp[$i]);
            $textpgl->save();
		}
		else 
		{
        	$sql = 'DELETE FROM '.TBL_TEXTS.'
            		WHERE txt_name = \'PGLMAIL_NOTIFICATION'. $i. '\'
            		AND txt_org_id = '.$gCurrentOrganization->getValue('org_id').' ';
    		$gDb->query($sql);
		}								
	}
}

// *******************************************************************************
// Setup: Pluginfreigabe
// *******************************************************************************
if( isset($_POST['freigabe']) && isset($_POST['freigabe_config']) && isset($_POST['pluginfreigabe']))
{
    unset($config_ini['Pluginfreigabe']);
    
    $config_ini['Pluginfreigabe']['freigabe'] = $_POST['freigabe'];
    $config_ini['Pluginfreigabe']['freigabe_config'] = $_POST['freigabe_config'];
    writeConfigTablePGL($config_ini);
}

// *******************************************************************************

// zur Ausgangsseite zurueck
$gMessage->setForwardUrl($gNavigation->getUrl(), 2000);
$gMessage->show($gL10n->get('SYS_SAVE_DATA'));	

?>=